
#include <swilib.h>
#include "FormBuilder/EForm.h"
#include "trafic.h"
#include "LangPack.h"


extern LangPack *lgp;
int input_traf=0, output_traf=0;
EForm *traf;
extern char temp[];


void TraficBuldForm(EForm *ef)
{
   sprintf(temp, "%s:", lgp->lang[Send]);
   ef->AddFormElement(temp, EForm::NormalText, 256);
   sprintf(temp, "%d b", output_traf);
   ef->AddFormElement(temp, EForm :: ReadOnly, 2*1024);

   sprintf(temp, "%s:", lgp->lang[Received]);
   ef->AddFormElement(temp, EForm::NormalText, 256);
   sprintf(temp, "%d b", input_traf);
   ef->AddFormElement(temp, EForm :: ReadOnly, 2*1024);

   sprintf(temp, "%s:", lgp->lang[AllTrafic]);
   ef->AddFormElement(temp, EForm::NormalText, 256);
   sprintf(temp, "%d b", output_traf+input_traf);
   ef->AddFormElement(temp, EForm :: ReadOnly, 2*1024);
}

void closeTrafGUI()
{
   traf->close();
}

void AllocTrafic()
{
   extern char dir[];
   traf = new EForm ();
   sprintf(temp, "%sRes\\traf.PNG", dir);
   traf->SetHeader(temp, (int)lgp->lang[Trafic]);
   traf->SetHookFormBuilder(TraficBuldForm);
   traf->ReallocEws(2*1024);
   traf->SetLeftSoft((int)lgp->lang[Back], (void*)closeTrafGUI);
   traf->SetRightSoft((int)lgp->lang[Back]);
}


void FreeTrafic()
{
   delete traf;
}
