
#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include "Siemens.h"





char red[4] = {0xFF,0x00,0x00,0x64};
char green[4] = {0x00,0xFF,0x00,0x64};
char blue[4] = {0x00,0x00,0xFF,0x64};
char white[4] = {0xff,0xff,0xff,0x64};
char dark[4] = {0x00,0x00,0x00,0x64};
char yelow[4] = {0xff,0xff,0x00,0x64};



int sl::char2int(char*buf)//    
{
  if(buf<=0) return -1;
  int ret=-1;
  sscanf(buf, "%d", &ret);
  return ret;
}

/*===================  ================*/
void sl::DrwImg(int x, int y, IMGHDR *img)
{
   if(!img) return;
   if(!img->bitmap) return;
   RECT rc;
   DRWOBJ drwobj;
   StoreXYWHtoRECT(&rc,x,y,img->w,img->h);
   SetPropTo_Obj5(&drwobj,&rc,0,img);
   SetColor(&drwobj,0,0);
   DrawObject(&drwobj);
}

void sl::FreeIMGHDR(IMGHDR *img)
{
   if(img!=0)
   {
     mfree(img->bitmap);
     mfree(img);
   }
}


unsigned int char8to16(int c)
{
  if (c==0xA8) c=0x401;
  if (c==0xAA) c=0x404;
  if (c==0xAF) c=0x407;
  if (c==0xB8) c=0x451;
  if (c==0xBA) c=0x454;
  if (c==0xBF) c=0x457;
  if (c==0xB2) c=0x406;
  if (c==0xB3) c=0x456;
  if ((c==0xC0)&&(c==0x100)) c+=0x350;
  return c;
}


void sl::ascii2ws(char *s, WSHDR *ws, int len)
{
  int c;
  int lpp=0;
  while ((c=*s++) && lpp<=len)
  {
    wsAppendChar(ws,char8to16(c));
    lpp++;
  }
}


int sl::_memcmp(char*s,char*d)
{
  if(!s) return 0;
  int p=0;
  int l = strlen(d);
  while(*s++==*d++ && p<l)p++;
  if(p==l)
    return 0;
  else
  return 1;
}


char* sl::getDirFromPatch(char *exename)//  
{
  char ret[256];
  strcpy(ret, exename);
  for(int i=strlen(ret);ret[i]!='\\';i--)
  ret[i]=0;
  return ret;
}


char* sl::getFileNameFromPatch(char *buf) //  
{
   int i=strlen(buf);
   if(i>0&&buf[0])
   while(buf[i]!='\\' && i>= 0)
   {
      i--;
   }
   char *ret = new char[strlen(buf)-i+2];
   zeromem(ret, strlen(buf)-i+2);
   memcpy(ret,buf+i+1,strlen(buf)-i-1);
   return ret;
}


int sl::GetFileSize(const char *file)
{
  FSTATS fs;
  GetFileStats(file,&fs,0);
  return fs.size;
}


int sl::IsFileExist(char *file)
{
    int fpn=0;
    fpn = open(file, A_ReadOnly+A_BIN,P_READ,0);
    if(fpn==-1){ close(fpn,0); return 0;}
    else { close(fpn,0); return 1;}
}


char* sl::strToLower(char *st)
{
   unsigned int len = strlen(st);
   for(int i=0;i<len;i++)
   {
     char sym = *(st+i);
     if(sym<0x80)
     {
       if(st[i]>='A' && st[i]<='Z') st[i] += ('a' - 'A');
       continue;
     }
     if(sym<0xe0)
     {
       i++;
       if(st[i] >= 0x90 && st[i]<=0xAF) st[i]+= (0xB0 - 0x90);
     }
   }
   return st;
}


void sl::MSG(int type,int typemsg,char *buf,...)// 
{
   va_list args;
   va_start(args, buf);

   char *tmpstr = (char*)malloc(128);
   memset(tmpstr,0,128);
   vsprintf(tmpstr, buf, args);
   if(!type)ShowMSG(typemsg,(int)tmpstr);
   else MsgBoxError(typemsg,(int)tmpstr);
   va_end(args);
   mfree(tmpstr);
}
