
#include <swilib.h>
#include "LangPack.h"


/*    3  ?      C++ */


int _memcmp(const char *s, const char *d)
{
    if(!s) return 0;
    int p=0;
    int l = strlen(d);
    while( *s++ == *d++ && p<l)p++;
    if(p==l)
        return 0;
    else
        return 1;
}

char * LangPack :: ParseLangId(char *s, int id)
{
    //char *to = *too;
    char *st =0;
    while(*s++!='=');
    while(*s++!='"');
    st = s;
    while(*s++!='"');
    s--;
    lang[id] = new char[s-st+1];
    memcpy(lang[id], st, s-st);
    lang[id][s-st]=0;

    return s;
}

LangPack :: LangPack(char *langpatch)
{
    zeromem(lang, sizeof(lang));
    //parse

    FSTATS fstat;
    GetFileStats(langpatch, &fstat, 0);
    int fsize = fstat.size;
    int fp = _open(langpatch, A_ReadOnly+A_BIN, P_READ, 0);
    if(fp==-1)
    {
        SetDefaultLang();
        return;
    }

    char *buffer = new char [fsize+2];
    _read(fp, buffer, fsize, 0);
    _close(fp, 0);
    char *s = buffer;


    /* -  , AStyle   _ */
    do
    {
        if(!_memcmp(s, "TranslateLang"))
        {
            s = ParseLangId(s, TranslateLang);
            //debug("TranslateLang: %s", lang[TranslateLang]);
        }
        else

            if(!_memcmp(s, "EnterText"))
            {
                s = ParseLangId(s, EnterText);
                //debug("EnterText: %s", lang[EnterText]);
            }
            else

                if(!_memcmp(s, "Translate"))
                {
                    s = ParseLangId(s, Translate);
                    //debug("Translate: %s", lang[Translate]);
                }
                else

                    if(!_memcmp(s, "Options"))
                    {
                        s = ParseLangId(s, Options);
                        //debug("Options: %s", lang[Options]);
                    }
                    else

                        if(!_memcmp(s, "Clean"))
                        {
                            s = ParseLangId(s, Clean);
                            //debug("Clean: %s", lang[Clean]);
                        }
                        else

                            if(!_memcmp(s, "Empty"))
                            {
                                s = ParseLangId(s, Empty);
                                //debug("Empty: %s", lang[Empty]);
                            }
                            else

                                if(!_memcmp(s, "DoTranslate"))
                                {
                                    s = ParseLangId(s, DoTranslate);
                                    //debug("DoTranslate: %s", lang[DoTranslate]);
                                }
                                else

                                    if(!_memcmp(s, "OriginalLang"))
                                    {
                                        s = ParseLangId(s, OriginalLang);
                                        //debug("OriginalLang: %s", lang[OriginalLang]);
                                    }
                                    else


                                        if(!_memcmp(s, "Trafic"))
                                        {
                                            s = ParseLangId(s, Trafic);
                                            //debug("Trafic: %s", lang[Trafic]);
                                        }
                                        else

                                            if(!_memcmp(s, "AccountingTraffic"))
                                            {
                                                s = ParseLangId(s, AccountingTraffic);
                                                //debug("AccountingTraffic: %s", lang[AccountingTraffic]);
                                            }
                                            else

                                                if(!_memcmp(s, "About"))
                                                {
                                                    s = ParseLangId(s, Aboute);
                                                    //debug("About: %s", lang[Aboute]);
                                                }
                                                else

                                                    if(!_memcmp(s, "Exit"))
                                                    {
                                                        s = ParseLangId(s, Exit);
                                                        //debug("Exit: %s", lang[Exit]);
                                                    }
                                                    else

                                                        if(!_memcmp(s, "Completion"))
                                                        {
                                                            s = ParseLangId(s, Completion);
                                                            //debug("Completion: %s", lang[Completion]);
                                                        }
                                                        else

                                                            if(!_memcmp(s, "PleaseEnterText"))
                                                            {
                                                                s = ParseLangId(s, PleaseEnterText);
                                                                //debug("PleaseEnterText: %s", lang[PleaseEnterText]);
                                                            }
                                                            else

                                                                if(!_memcmp(s, "Translating"))
                                                                {
                                                                    s = ParseLangId(s, Translating);
                                                                    //debug("Translating: %s", lang[Translating]);
                                                                }
                                                                else

                                                                    if(!_memcmp(s, "Clear"))
                                                                    {
                                                                        s = ParseLangId(s, Clear);
                                                                        //debug("Clear: %s", lang[Clear]);
                                                                    }
                                                                    else

                                                                        if(!_memcmp(s, "Back"))
                                                                        {
                                                                            s = ParseLangId(s, Back);
                                                                            //debug("Back: %s", lang[Back]);
                                                                        }
                                                                        else

                                                                            if(!_memcmp(s, "FirstEnableGPRS"))
                                                                            {
                                                                                s = ParseLangId(s, FirstEnableGPRS);
                                                                                //debug("FirstEnableGPRS: %s", lang[FirstEnableGPRS]);
                                                                            }
                                                                            else

                                                                                if(!_memcmp(s, "ErrorConnecting"))
                                                                                {
                                                                                    s = ParseLangId(s, ErrorConnecting);
                                                                                    //debug("ErrorConnecting: %s", lang[ErrorConnecting]);
                                                                                }
                                                                                else

                                                                                    if(!_memcmp(s, "Error"))
                                                                                    {
                                                                                        s = ParseLangId(s, Error);
                                                                                        //debug("Error: %s", lang[Error]);
                                                                                    }
                                                                                    else

                                                                                        if(!_memcmp(s, "Send"))
                                                                                        {
                                                                                            s = ParseLangId(s, Send);
                                                                                            //debug("Send: %s", lang[Send]);
                                                                                        }
                                                                                        else

                                                                                            if(!_memcmp(s, "Received"))
                                                                                            {
                                                                                                s = ParseLangId(s, Received);
                                                                                                //debug("Received: %s", lang[Received]);
                                                                                            }
                                                                                            else

                                                                                                if(!_memcmp(s, "AllTrafic"))
                                                                                                {
                                                                                                    s = ParseLangId(s, AllTrafic);
                                                                                                    //debug("AllTrafic: %s", lang[AllTrafic]);
                                                                                                }
                                                                                                else

                                                                                                    if(!_memcmp(s, "SelectOriginalLang"))
                                                                                                    {
                                                                                                        s = ParseLangId(s, SelectOriginalLang);
                                                                                                        //debug("SelectOriginalLang: %s", lang[SelectOriginalLang]);
                                                                                                    }
                                                                                                    else

                                                                                                        if(!_memcmp(s, "SelectTranslateLang"))
                                                                                                        {
                                                                                                            s = ParseLangId(s, SelectTranslateLang);
                                                                                                            //debug("SelectTranslateLang: %s", lang[SelectTranslateLang]);
                                                                                                        }

    }
    while(*s++);


    delete buffer;
}


LangPack :: ~LangPack()
{
    for(int i=0; i<30; i++)
        if(lang[i]) delete lang[i];
}


void LangPack :: SetDefaultLang()
{
    lang[EnterText] = new char[strlen(" ")+1];
    strcpy(lang[EnterText], " ");

    lang[Translate] = new char[strlen("")+1];
    strcpy(lang[Translate], "");

    lang[Options] = new char[strlen("")+1];
    strcpy(lang[Options], "");

    lang[Clean] = new char[strlen("")+1];
    strcpy(lang[Clean], "");

    lang[Empty] = new char[strlen("")+1];
    strcpy(lang[Empty], "");

    lang[DoTranslate] = new char[strlen("")+1];
    strcpy(lang[DoTranslate], "");

    lang[OriginalLang] = new char[strlen(" ")+1];
    strcpy(lang[OriginalLang], " ");

    lang[TranslateLang] = new char[strlen(" ")+1];
    strcpy(lang[TranslateLang], " ");

    lang[Trafic] = new char[strlen("")+1];
    strcpy(lang[Trafic], "");

    lang[AccountingTraffic] = new char[strlen(" ")+1];
    strcpy(lang[AccountingTraffic], " ");

    lang[Aboute] = new char[strlen(" ")+1];
    strcpy(lang[Aboute], " ");

    lang[Exit] = new char[strlen("")+1];
    strcpy(lang[Exit], "");

    lang[Completion] = new char[strlen("")+1];
    strcpy(lang[Completion], "");

    lang[PleaseEnterText] = new char[strlen("  !")+1];
    strcpy(lang[PleaseEnterText], "  !");

    lang[Translating] = new char[strlen("...")+1];
    strcpy(lang[Translating], "...");

    lang[Clear] = new char[strlen("")+1];
    strcpy(lang[Clear], "");

    lang[Back] = new char[strlen("")+1];
    strcpy(lang[Back], "");

    lang[FirstEnableGPRS] = new char[strlen("  GPRS")+1];
    strcpy(lang[FirstEnableGPRS], "  GPRS");

    lang[ErrorConnecting] = new char[strlen(" ")+1];
    strcpy(lang[ErrorConnecting], " ");

    lang[Error] = new char[strlen("")+1];
    strcpy(lang[Error], "");

    lang[Send] = new char[strlen("")+1];
    strcpy(lang[Send], "");

    lang[Received] = new char[strlen("")+1];
    strcpy(lang[Received], "");

    lang[AllTrafic] = new char[strlen("")+1];
    strcpy(lang[AllTrafic], "");

    lang[SelectOriginalLang] = new char[strlen("  ")+1];
    strcpy(lang[SelectOriginalLang], "  ");

    lang[SelectTranslateLang] = new char[strlen("  ")+1];
    strcpy(lang[SelectTranslateLang], "  ");

}
