
#ifndef __PROCESS_H__
#define __PROCESS_H__


#include <NuAPI/ExtendedNuTask.h>
#include <stdio.h>


typedef void (*function)(void);
#define NUM_ATEXIT	32



static inline void libc_collect_args(int argc, char **argv){
    --argc;
    if(argc < 0) return;
    do
    {
        if(argv[argc])
           _free(argv[argc]);
    }while(argc-- > 0);
    _free(argv);
}


typedef struct
{
    ExtTask task;
    int (*main)(int argc, char **argv);
    void (*init)(void *task);
    void (*fini)(void *task);
    void *ex;
    int argc;
    char **argv;
    char *dir;
    int process_return;

    FILE *stdin, *stdout, *stderr;

    function atexitlist[NUM_ATEXIT];
    int atexit_counter;

}LibcTask;

LibcTask * libc_get_task();
char *generate_full_patch(LibcTask *task, const char *mypatch);

LibcTask *___libc_start(void *__ex, int (*main)(int argc, char **argv), void (*init)(void *), void (*fini)(void *),
                  const char *exe, char **params);

#endif
