
#ifndef __THREAD_H__
#define __THREAD_H__

#include "ExtendedNuTask.h"


typedef struct
{
    ExtTask task;
}Thread;


ExtTask *thread_parent_task(Thread *task);

int thread_create7v(Thread *thread, void (*func_ptr)(int, void *),
                       void *stack, uint32_t stack_size, int argc, void *argv, int prio);
int thread_create5v(Thread *thread, void (*func_ptr)(int, void *), int argc, void *argv, int prio);

int thread_release(Thread *thread);


int thread_suspend(Thread *thread);
int thread_resume(Thread *thread);
int thread_is_suspended(Thread *thread);

int thread_is_finished(Thread *thread);
void *thread_return_value(Thread *thread);

void thread_set_preinit_func(Thread *thread, void (*f)());
void thread_set_finished_func(Thread *thread, void (*f)());

#endif
