
#ifndef __EXTENDED_NU_TASK_H__
#define __EXTENDED_NU_TASK_H__


#ifdef __cplusplus
extern "C" {
#endif

#include <swilib.h>
#include <nu_swilib.h>
#include <NuAPI/ExtQueue.h>
#include <NuAPI/ExtList.h>


#define DEFAULT_STACK_SIZE 0x3000

#define TASK_NULL_STATE 0
#define TASK_WORKING    1
#define TASK_FINISHED   2

struct IOCtl_system_handle;
void printout(const char *, ...);

typedef struct ExtTask
{
    NU_TASK task;                   //  
    uint8_t istask;                 // /
    void *first_parent;             //   ( )
    struct ExtTask *parent;         // ExtTask.   
    ExtList *childs;                // ExtTask.    
    char *task_name;

    struct {
        char *base;                 // 
        uint32_t size;              //  
        char own_allocation;        //   
    }stack;

    struct {
        struct IOCtl_system_handle **list;                // task resource control
        int count;
    }trc_list;

    ExtList *memctl_queue;          //   
    ExtList *finalizators;          // -.    
    void (*on_exit)(void *);
    void *userdata;
    void *libc_process_ponter;      // Used by LibcTask
    void *(*task_proc)(int argc, void *argv);
    void *t_return;
    void (*task_runing)();
    void (*task_finishing)();
    char status;
    int reserved[2];
}ExtTask;


#define IS_TASK(tsk) (((ExtTask *)tsk)->istask)

int exttask_create_base(ExtTask *task, void *kill_elf_func_ptr, const char *name, void *stack, size_t stack_size,
                        char no_free_stack, char no_kill_by_db, void *(*func_ptr)(int, void *),
                        int argc, void *argv, int prio, int stay, char add_in_parent_task);

int exttask_create7v(ExtTask *task, void *kill_elf_func_ptr, const char *name,
                   void *(*func_ptr)(int, void *), int argc, void *argv, int prio);

int exttask_create8v(ExtTask *task, void *kill_elf_func_ptr, const char *name,
                   void *(*func_ptr)(int, void *), int argc, void *argv, int prio, int stay);

int exttask_create9v(ExtTask *task, void *kill_elf_func_ptr, const char *name, void *stack, uint32_t stack_size,
                   void *(*func_ptr)(int, void *), int argc, void *argv, int prio);

int exttask_create9vs(ExtTask *task, void *kill_elf_func_ptr, const char *name,
                     void *(*func_ptr)(int, void *), int argc, void *argv, int prio,
                     int start, char add_to_parent);

int exttask_release(ExtTask *task);

/*   ,       -     */
ExtTask *exttask_current();

int exttask_suspend(ExtTask *task);
int exttask_resume(ExtTask *task);
int exttask_is_suspended(ExtTask *task);

int exttask_finalizator_add(ExtTask *task, void *func_ptr, void *arg);
int exttask_finalizator_del(ExtTask *task, void *func_ptr, void *arg);
void exttask_finalizators_run(ExtTask *task);
void exttask_release_childs(ExtTask *task);
struct IOCtl_system_handle *exttask_get_trc_by_id(ExtTask *task, int id);


char exttask_is_finished(ExtTask *task);
void *exttask_return_value(ExtTask *task);

/*      */
ExtTask *CurrentProcessTask();

void exttask_set_preinit_func(ExtTask *task, void (*f)());
void exttask_set_finished_func(ExtTask *task, void (*f)());

#ifdef __cplusplus
}
#endif

#endif
