#include <swilib.h>
#include "main.h"
#include "jabber.h"
#include "clist_util.h"
#include "jabber_util.h"
#include "string_util.h"
#include "history.h"
#include "transports_icons.h"

unsigned int conference=0x18C;

unsigned int noauth=0x185;
unsigned int ask=0x185;

unsigned int message=0x24C;//0x22E;
unsigned int system=0x24C;

unsigned int online=0x22C;//0x22D;
unsigned int unavailable=0x306;
unsigned int error=0x185;
unsigned int chat=0x18C;//0x22B;
unsigned int away=0x22F;
unsigned int xa=0x17A;
unsigned int dnd=0x231;
unsigned int invisible=0x306;

extern const char* PRESENCES[PRES_COUNT];
extern const char PATH_TO_PIC[];

#ifdef USE_PNG_EXT

char * Roster_getIconByStatus(char * path_to_pic, char status) //     
{
  if (!path_to_pic)
    path_to_pic = malloc(256);
  strcpy(path_to_pic, PATH_TO_PIC);

  //    
  if(status < PRESENCE_INVISIBLE) //   
    strcat(path_to_pic, PRESENCES[status]);
  else
    if( status == 50)
      strcat(path_to_pic, "message");
    else
      strcat(path_to_pic, PRESENCES[PRESENCE_OFFLINE]); //   
  strcat(path_to_pic, ".png");
  return path_to_pic;
}
#else
int Roster_getIconByStatus(char status) //    
{
  int img_num=0;

  switch (status) {
  case PRESENCE_ONLINE:
    img_num=online;
    break;
  case PRESENCE_OFFLINE:
    img_num=unavailable;
    break;
    //case PRESENCE_ERROR: //-  
    //  img_num=error;
    //  break;
  case PRESENCE_CHAT:
    img_num=chat;
    break;
  case PRESENCE_AWAY:
    img_num=away;
    break;
  case PRESENCE_XA:
    img_num=xa;
    break;
  case PRESENCE_DND:
    img_num=dnd;
    break;
  case PRESENCE_INVISIBLE:
    img_num=invisible;
    break;
  case PRESENCE_UNSUBSCRIBED:
    img_num=noauth;
    break;
  case PRESENCE_SUBSCRIBE:
    img_num=ask;
    break;
  case 50: //  ,       ,    
    img_num=message;
    break;
  }
  return img_num;
}
#endif

#ifdef USE_PNG_EXT
void Roster_getIcon(char * path_to_pic, CLIST* ClEx, TRESOURCE* resEx)
{
  strcpy(path_to_pic, PATH_TO_PIC);

  //   
  if(resEx->entry_type == T_CONF_ROOT && !resEx->has_unread_msg)
  {
    strcat(path_to_pic, ClEx->IsVisible?"conference_on":"conference_off");
    goto L_DONE;
  }
  
  //       ,    \ 
  if((resEx->compos)&&(!resEx->has_unread_msg)&&((resEx->entry_type == T_NORMAL)||(resEx->entry_type == T_CONF_NODE))) //   ...
  {
    strcat(path_to_pic, "composing");
    goto L_DONE;
  }
  
  //       
  if(resEx->entry_type == T_CONF_NODE && !resEx->has_unread_msg && resEx->status<=PRESENCE_INVISIBLE)
  {
    GetTransportIconsPath(path_to_pic, resEx);
    if(resEx->status==PRESENCE_ONLINE)
    {
      if(resEx->muc_privs.role==ROLE_VISITOR)strcat(path_to_pic, "vis_");
      if(resEx->muc_privs.role==ROLE_PARTICIPANT && resEx->muc_privs.aff==AFFILIATION_NONE)strcat(path_to_pic, "part_");
      if(resEx->muc_privs.role==ROLE_MODERATOR)strcat(path_to_pic, "admin_");
    }
    else
    { //    ,  
      if(resEx->muc_privs.role==ROLE_MODERATOR)
      {
        strcat(path_to_pic, "admin_");
      }
      else if(resEx->muc_privs.aff==AFFILIATION_NONE) strcat(path_to_pic, "vis_part_");
    }

    strcat(path_to_pic, PRESENCES[resEx->status]); 
    goto L_DONE;
  }

  
  //   
  if(resEx->entry_type == T_GROUP)
  {
    ClEx->IsVisible==1 ? strcat(path_to_pic, "groupon") : strcat(path_to_pic, "groupoff");
    goto L_DONE;
  }

  //           
  if(((ClEx->subscription== SUB_FROM) || (ClEx->subscription== SUB_NONE))&& !resEx->has_unread_msg)
  {
    GetTransportIconsPath(path_to_pic, resEx);
    strcat(path_to_pic, "noauth"); //  " "
    goto L_DONE;
  }

  //     
  if(ClEx->wants_subscription)
  {
    GetTransportIconsPath(path_to_pic, resEx);
    strcat(path_to_pic, "ask");
    goto L_DONE;
  }

  //       
  if(resEx->has_unread_msg)
  {
    //         
    if(resEx->status<=PRESENCE_INVISIBLE)
    {
      strcat(path_to_pic, "message");
    }
    else
    {
      strcat(path_to_pic, "system");      //    -   
    }
  }
  else
  {
    if(resEx->status < PRESENCE_ERROR)
      GetTransportIconsPath(path_to_pic, resEx);
    //     
    if(resEx->status<=PRESENCE_ERROR) //   
    {
      strcat(path_to_pic, PRESENCES[resEx->status]);
    }
    else
    {
      strcat(path_to_pic, PRESENCES[PRESENCE_OFFLINE]); //   
    }
  }
L_DONE:
  strcat(path_to_pic, ".png");
}
#else
int Roster_getIcon(CLIST* ClEx, TRESOURCE* resEx) {
  unsigned int img_num=0;

  //   
  if(resEx->entry_type == T_CONF_ROOT && !resEx->has_unread_msg)
    img_num=conference;

  //           
  if(((ClEx->subscription== SUB_FROM) || (ClEx->subscription== SUB_NONE))&& !resEx->has_unread_msg)
    img_num=noauth;

  //     
  if(ClEx->wants_subscription)
    img_num=ask;

  //       
  if(resEx->has_unread_msg)
  {
    //         
    if(resEx->status<=PRESENCE_OFFLINE)
      img_num=message;
    else
      img_num=system;      //    -   
  }
  else
  {
    //     
    img_num=Roster_getIconByStatus(resEx->status);
  }
  return img_num;
}
#endif

void Roster_DrawIcon(unsigned short x, unsigned short y, unsigned int img_num)
{
  DrawImg(x, y, img_num);
}

int Roster_getIconWidth(char *path_to_pic)
{
  return GetImgWidth((int)path_to_pic);
}

int Roster_getIconHeight(char *path_to_pic)
{
  return GetImgHeight((int)path_to_pic);
}
