/*
 * File:   main.cpp
 * Author: vova7890
 *
 * Created on 28  2010 ., 3:58
 */


#include <swilib.h>
#include "strlib.h"
//using namespace std;


typedef unsigned chartype;
char *
strnstr (const char *phaystack, const char *pneedle)
{
  register const unsigned char *haystack, *needle;
  register chartype b, c;

  haystack = (const unsigned char *) phaystack;
  needle = (const unsigned char *) pneedle;

  b = *needle;
  if (b != '\0')
    {
      haystack--;                               /* possible ANSI violation */
      do
        {
          c = *++haystack;
          if (c == '\0')
            goto ret0;
        }
      while (c != b);

      c = *++needle;
      if (c == '\0')
        goto foundneedle;
      ++needle;
      goto jin;

      for (;;)
        {
          register chartype a;
          register const unsigned char *rhaystack, *rneedle;

          do
            {
              a = *++haystack;
              if (a == '\0')
                goto ret0;
              if (a == b)
                break;
              a = *++haystack;
              if (a == '\0')
                goto ret0;
shloop:;    }
          while (a != b);

jin:      a = *++haystack;
          if (a == '\0')
            goto ret0;

          if (a != c)
            goto shloop;

          rhaystack = haystack-- + 1;
          rneedle = needle;
          a = *rneedle;

          if (*rhaystack == a)
            do
              {
                if (a == '\0')
                  goto foundneedle;
                ++rhaystack;
                a = *++needle;
                if (*rhaystack != a)
                  break;
                if (a == '\0')
                  goto foundneedle;
                ++rhaystack;
                a = *++needle;
              }
            while (*rhaystack == a);

          needle = rneedle;                /* took the register-poor approach */

          if (a == '\0')
            break;
        }
    }
foundneedle:
  return (char*) haystack;
ret0:
  return 0;
}


char *resize(char *c, int size)
{
    char *s = new char[size+1];
    memcpy(s, c, size);
    s[size] = 0;
    return s;
}

// remove chars from str
char *remove(char *c, int pos, int len)
{
    if(pos<0 || !len || !c) return 0;

    // len of data str
    int size = strlen(c);
    // check for memory errors
    if( pos+len > size) return 0;

    // move mem to position
    memmove(c + pos, c + pos + len, (size - pos - len + 1));
    c[size-len]=0;
    return c;
}


char *insert(char *c, int pos, const char *i, int s)
{
    if(!c || pos<0 || !i || s<1) return 0;
    int size = strlen(c);
    c = resize(c, size+s+1);
    memmove(c+pos+s, c+pos, size-pos);
    memcpy(c+pos, i, s);
    c[size+s] = 0;
    return c;
}

char *replace(char *fin, int from, const char *rch, const char *ron)
{
    if(!fin || !rch || !ron) return 0;
    char *in = fin+from;

    char *s=0;

    int lfin = strlen(fin);
    int lrch = strlen(rch);
    int lron = strlen(ron);

    do
    {
        s=strnstr(fin, rch);

        if(s)
        {
            fin = remove(fin, s-fin, lrch);
            fin = insert(fin, s-fin, ron, lron);
            if(!fin) return 0;
        }else
        {
            break;
        }

    }while(s);

    return fin;
}



