/***************************************************************************
 *   Copyright © 2005-2009 by Gabriele Svelto                              *
 *   gabriele.svelto@gmail.com                                             *
 *                                                                         *
 *   This file is part of Jelatine.                                        *
 *                                                                         *
 *   Jelatine is free software: you can redistribute it and/or modify      *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation, either version 3 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   Jelatine is distributed in the hope that it will be useful,           *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with Jelatine.  If not, see <http://www.gnu.org/licenses/>.     *
 ***************************************************************************/

package javax.microedition.io;

import java.io.IOException;

/**
 * This exceptions represents errors due to a connection target which cannot be
 * found, or an unsupported protocol type.
 */

public class ConnectionNotFoundException extends IOException
{
    /**
     * Create an exception without a descriptive error message.
     */
    public ConnectionNotFoundException()
    {

    }

    /**
     * Create an exception with a descriptive error message.
     *
     * @param message the descriptive error message
     */
    public ConnectionNotFoundException(String message)
    {
        super(message);
    }
} // class ConnectionNotFoundException
