/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

public final class Integer {
    public static final int MIN_VALUE = -2147483648;
    public static final int MAX_VALUE = 0x7FFFFFFF;
    private final int value;
    private static final char[] digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};

    public Integer(int n) {
        this.value = n;
    }

    public static String toString(int n, int n2) {
        if (n2 < 2 || n2 > 36) {
            n2 = 10;
        }
        char[] cArray = new char[33];
        int n3 = 33;
        boolean bl = false;
        if (n < 0) {
            bl = true;
            if ((n = -n) < 0) {
                cArray[--n3] = digits[-(n + n2) % n2];
                n = -(n / n2);
            }
        }
        do {
            cArray[--n3] = digits[n % n2];
        } while ((n /= n2) > 0);
        if (bl) {
            cArray[--n3] = 45;
        }
        return new String(cArray, n3, 33 - n3, false);
    }

    public static String toHexString(int n) {
        return Integer.toUnsignedString(n, 4);
    }

    public static String toOctalString(int n) {
        return Integer.toUnsignedString(n, 3);
    }

    public static String toBinaryString(int n) {
        return Integer.toUnsignedString(n, 1);
    }

    public static String toString(int n) {
        return String.valueOf(n);
    }

    public static int parseInt(String string, int n) throws NumberFormatException {
        return Integer.parseIntInternal(string, n);
    }

    public static int parseInt(String string) throws NumberFormatException {
        return Integer.parseIntInternal(string, 10);
    }

    public static Integer valueOf(String string, int n) {
        return new Integer(Integer.parseIntInternal(string, n));
    }

    public static Integer valueOf(String string) {
        return new Integer(Integer.parseIntInternal(string, 10));
    }

    public byte byteValue() {
        return (byte)this.value;
    }

    public short shortValue() {
        return (short)this.value;
    }

    public int intValue() {
        return this.value;
    }

    public long longValue() {
        return this.value;
    }

    public float floatValue() {
        return this.value;
    }

    public double doubleValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public int hashCode() {
        return this.value;
    }

    public boolean equals(Object object) {
        return object instanceof Integer && this.value == ((Integer)object).value;
    }

    static String toUnsignedString(int n, int n2) {
        int n3 = (1 << n2) - 1;
        char[] cArray = new char[32];
        int n4 = 32;
        do {
            cArray[--n4] = digits[n & n3];
        } while ((n >>>= n2) != 0);
        return new String(cArray, n4, 32 - n4, true);
    }

    static int parseIntInternal(String string, int n) {
        int n2 = 0;
        int n3 = string.length();
        boolean bl = false;
        if (n3 == 0) {
            throw new NumberFormatException("string length is null");
        }
        int n4 = string.charAt(n2);
        if (n4 == 45) {
            if (n3 == 1) {
                throw new NumberFormatException("pure '-'");
            }
            bl = true;
            n4 = string.charAt(++n2);
        }
        if (n2 == n3) {
            throw new NumberFormatException("non terminated number: " + string);
        }
        int n5 = Integer.MAX_VALUE / n;
        if (bl && Integer.MAX_VALUE % n == n - 1) {
            ++n5;
        }
        int n6 = 0;
        while (n2 < n3) {
            if (n6 < 0 || n6 > n5) {
                throw new NumberFormatException("number overflow (pos=" + n2 + ") : " + string);
            }
            n4 = Character.digit(string.charAt(n2++), n);
            n6 = n6 * n + n4;
            if (n4 >= 0 && (n6 >= 0 || bl && n6 == Integer.MIN_VALUE)) continue;
            throw new NumberFormatException("invalid character at position " + n2 + " in " + string);
        }
        return bl ? -n6 : n6;
    }
}

