/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.Enumeration;
import java.util.NoSuchElementException;

public class Hashtable {
    private static final int DEFAULT_CAPACITY = 11;
    static final int KEYS = 0;
    static final int VALUES = 1;
    static final int ENTRIES = 2;
    private int threshold;
    private static final float loadFactor = 0.75f;
    HashEntry[] buckets;
    int size;

    public Hashtable() {
        this(11);
    }

    public Hashtable(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + n);
        }
        if (n == 0) {
            n = 1;
        }
        this.buckets = new HashEntry[n];
        this.threshold = (int)((float)n * 0.75f);
        this.size = 0;
    }

    public synchronized int size() {
        return this.size;
    }

    public synchronized boolean isEmpty() {
        return this.size == 0;
    }

    public Enumeration keys() {
        return new Enumerator(0);
    }

    public Enumeration elements() {
        return new Enumerator(1);
    }

    public synchronized boolean contains(Object object) {
        for (int i = this.buckets.length - 1; i >= 0; --i) {
            HashEntry hashEntry = this.buckets[i];
            while (hashEntry != null) {
                if (object.equals(hashEntry.value)) {
                    return true;
                }
                hashEntry = hashEntry.next;
            }
        }
        if (object == null) {
            throw new NullPointerException();
        }
        return false;
    }

    public synchronized boolean containsKey(Object object) {
        int n = this.hash(object);
        HashEntry hashEntry = this.buckets[n];
        while (hashEntry != null) {
            if (object.equals(hashEntry.key)) {
                return true;
            }
            hashEntry = hashEntry.next;
        }
        return false;
    }

    public synchronized Object get(Object object) {
        int n = this.hash(object);
        HashEntry hashEntry = this.buckets[n];
        while (hashEntry != null) {
            if (object.equals(hashEntry.key)) {
                return hashEntry.value;
            }
            hashEntry = hashEntry.next;
        }
        return null;
    }

    protected void rehash() {
        HashEntry[] hashEntryArray = this.buckets;
        int n = this.buckets.length * 2 + 1;
        this.threshold = (int)((float)n * 0.75f);
        this.buckets = new HashEntry[n];
        for (int i = hashEntryArray.length - 1; i >= 0; --i) {
            HashEntry hashEntry = hashEntryArray[i];
            while (hashEntry != null) {
                int n2 = this.hash(hashEntry.key);
                HashEntry hashEntry2 = this.buckets[n2];
                if (hashEntry2 != null) {
                    while (hashEntry2.next != null) {
                        hashEntry2 = hashEntry2.next;
                    }
                    hashEntry2.next = hashEntry;
                } else {
                    this.buckets[n2] = hashEntry;
                }
                HashEntry hashEntry3 = hashEntry.next;
                hashEntry.next = null;
                hashEntry = hashEntry3;
            }
        }
    }

    public synchronized Object put(Object object, Object object2) {
        int n = this.hash(object);
        HashEntry hashEntry = this.buckets[n];
        if (object2 == null) {
            throw new NullPointerException();
        }
        while (hashEntry != null) {
            if (object.equals(hashEntry.key)) {
                Object object3 = hashEntry.value;
                hashEntry.value = object2;
                return object3;
            }
            hashEntry = hashEntry.next;
        }
        if (++this.size > this.threshold) {
            this.rehash();
            n = this.hash(object);
        }
        hashEntry = new HashEntry(object, object2);
        hashEntry.next = this.buckets[n];
        this.buckets[n] = hashEntry;
        return null;
    }

    public synchronized Object remove(Object object) {
        int n = this.hash(object);
        HashEntry hashEntry = this.buckets[n];
        HashEntry hashEntry2 = null;
        while (hashEntry != null) {
            if (object.equals(hashEntry.key)) {
                if (hashEntry2 == null) {
                    this.buckets[n] = hashEntry.next;
                } else {
                    hashEntry2.next = hashEntry.next;
                }
                --this.size;
                return hashEntry.value;
            }
            hashEntry2 = hashEntry;
            hashEntry = hashEntry.next;
        }
        return null;
    }

    public synchronized void clear() {
        if (this.size > 0) {
            for (int i = 0; i < this.buckets.length; ++i) {
                this.buckets[i] = null;
            }
            this.size = 0;
        }
    }

    public synchronized String toString() {
        Enumerator enumerator = new Enumerator(2);
        StringBuffer stringBuffer = new StringBuffer("{");
        for (int i = this.size; i > 0; --i) {
            stringBuffer.append(enumerator.nextElement());
            if (i <= 1) continue;
            stringBuffer.append(", ");
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    private int hash(Object object) {
        int n = object.hashCode() % this.buckets.length;
        return n < 0 ? -n : n;
    }

    private final class Enumerator
    implements Enumeration {
        final int type;
        int count;
        int idx;
        HashEntry next;

        Enumerator(int n) {
            this.count = Hashtable.this.size;
            this.idx = Hashtable.this.buckets.length;
            this.type = n;
        }

        public boolean hasMoreElements() {
            return this.count > 0;
        }

        public Object nextElement() {
            if (this.count == 0) {
                throw new NoSuchElementException("Hashtable Enumerator");
            }
            --this.count;
            HashEntry hashEntry = this.next;
            while (hashEntry == null) {
                hashEntry = Hashtable.this.buckets[--this.idx];
            }
            this.next = hashEntry.next;
            return this.type == 1 ? hashEntry.value : hashEntry.key;
        }
    }

    private static final class HashEntry {
        Object key;
        Object value;
        HashEntry next;

        HashEntry(Object object, Object object2) {
            this.key = object;
            this.value = object2;
        }

        public Object setValue(Object object) {
            if (object == null) {
                throw new NullPointerException();
            }
            Object object2 = this.value;
            this.value = object;
            return object2;
        }
    }
}

