/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;
import java.io.InputStream;

public class ByteArrayInputStream
extends InputStream {
    protected byte[] buf;
    protected int count;
    protected int mark;
    protected int pos;

    public ByteArrayInputStream(byte[] byArray) {
        this(byArray, 0, byArray.length);
    }

    public ByteArrayInputStream(byte[] byArray, int n, int n2) {
        if (n < 0 || n2 < 0 || n > byArray.length) {
            throw new IllegalArgumentException();
        }
        this.buf = byArray;
        this.count = n + n2;
        if (this.count > this.buf.length) {
            this.count = this.buf.length;
        }
        this.mark = this.pos = n;
    }

    public synchronized int read() {
        if (this.pos < this.count) {
            return this.buf[this.pos++] & 0xFF;
        }
        return -1;
    }

    public synchronized int read(byte[] byArray, int n, int n2) {
        if (this.pos >= this.count) {
            return -1;
        }
        int n3 = Math.min(this.count - this.pos, n2);
        System.arraycopy(this.buf, this.pos, byArray, n, n3);
        this.pos += n3;
        return n3;
    }

    public synchronized long skip(long l) {
        long l2 = Math.min((long)(this.count - this.pos), l < 0L ? 0L : l);
        this.pos = (int)((long)this.pos + l2);
        return l2;
    }

    public synchronized int available() {
        return this.count - this.pos;
    }

    public boolean markSupported() {
        return true;
    }

    public synchronized void mark(int n) {
        this.mark = this.pos;
    }

    public synchronized void reset() {
        this.pos = this.mark;
    }

    public synchronized void close() throws IOException {
    }
}

