/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.DataOutput;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UTFDataFormatException;

public class DataOutputStream
extends OutputStream
implements DataOutput {
    protected OutputStream out;

    public DataOutputStream(OutputStream outputStream) {
        this.out = outputStream;
    }

    public synchronized void write(int n) throws IOException {
        this.out.write(n);
    }

    public synchronized void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public synchronized void write(byte[] byArray, int n, int n2) throws IOException {
        this.out.write(byArray, n, n2);
    }

    public void flush() throws IOException {
        this.out.flush();
    }

    public void close() throws IOException {
        this.out.close();
    }

    public final void writeBoolean(boolean bl) throws IOException {
        this.out.write(bl ? 1 : 0);
    }

    public final void writeByte(int n) throws IOException {
        this.out.write(n & 0xFF);
    }

    public final synchronized void writeShort(int n) throws IOException {
        this.out.write((byte)(0xFF & n >> 8));
        this.out.write((byte)(0xFF & n));
    }

    public final synchronized void writeChar(int n) throws IOException {
        this.out.write((byte)(0xFF & n >> 8));
        this.out.write((byte)(0xFF & n));
    }

    public final synchronized void writeInt(int n) throws IOException {
        this.out.write((byte)(0xFF & n >> 24));
        this.out.write((byte)(0xFF & n >> 16));
        this.out.write((byte)(0xFF & n >> 8));
        this.out.write((byte)(0xFF & n));
    }

    public final synchronized void writeLong(long l) throws IOException {
        this.out.write((byte)(0xFFL & l >> 56));
        this.out.write((byte)(0xFFL & l >> 48));
        this.out.write((byte)(0xFFL & l >> 40));
        this.out.write((byte)(0xFFL & l >> 32));
        this.out.write((byte)(0xFFL & l >> 24));
        this.out.write((byte)(0xFFL & l >> 16));
        this.out.write((byte)(0xFFL & l >> 8));
        this.out.write((byte)(0xFFL & l));
    }

    public final void writeFloat(float f) throws IOException {
        this.writeInt(Float.floatToIntBits(f));
    }

    public final void writeDouble(double d) throws IOException {
        this.writeLong(Double.doubleToLongBits(d));
    }

    public final void writeChars(String string) throws IOException {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            this.writeChar(string.charAt(i));
        }
    }

    public final synchronized void writeUTF(String string) throws IOException {
        int n;
        int n2 = string.length();
        int n3 = 0;
        for (n = 0; n < n2 && n3 <= 65535; ++n) {
            char c = string.charAt(n);
            if (c >= '\u0001' && c <= '\u007f') {
                ++n3;
                continue;
            }
            if (c == '\u0000' || c >= '\u0080' && c <= '\u07ff') {
                n3 += 2;
                continue;
            }
            n3 += 3;
        }
        if (n3 > 65535) {
            throw new UTFDataFormatException();
        }
        n = 0;
        byte[] byArray = new byte[n3];
        for (int i = 0; i < n2; ++i) {
            char c = string.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                byArray[n++] = (byte)c;
                continue;
            }
            if (c == '\u0000' || c >= '\u0080' && c <= '\u07ff') {
                byArray[n++] = (byte)(0xC0 | 0x1F & c >> 6);
                byArray[n++] = (byte)(0x80 | 0x3F & c);
                continue;
            }
            byArray[n++] = (byte)(0xE0 | 0xF & c >> 12);
            byArray[n++] = (byte)(0x80 | 0x3F & c >> 6);
            byArray[n++] = (byte)(0x80 | 0x3F & c);
        }
        this.writeShort(n3);
        this.write(byArray, 0, n3);
    }
}

