/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import jelatine.VMPointer;

public class Thread
implements Runnable {
    public static final int MIN_PRIORITY = 1;
    public static final int NORM_PRIORITY = 5;
    public static final int MAX_PRIORITY = 10;
    final Runnable runnable;
    volatile String name;
    volatile VMPointer vmThread;
    volatile int priority;
    private static int numAnonymousThreadsCreated = 0;

    public Thread() {
        this(null, Thread.createAnonymousThreadName());
    }

    public Thread(Runnable runnable) {
        this(runnable, Thread.createAnonymousThreadName());
    }

    public Thread(String string) {
        this(null, string);
    }

    public Thread(Runnable runnable, String string) {
        Thread thread = Thread.currentThread();
        this.name = string.toString();
        this.runnable = runnable;
        this.priority = thread.priority;
    }

    private static synchronized String createAnonymousThreadName() {
        return "Thread-" + ++numAnonymousThreadsCreated;
    }

    public static native Thread currentThread();

    public static native void yield();

    public static native void sleep(long var0) throws InterruptedException;

    public synchronized native void start();

    public void run() {
        if (this.runnable != null) {
            this.runnable.run();
        }
    }

    public synchronized native void interrupt();

    public final synchronized boolean isAlive() {
        return this.vmThread != null;
    }

    public final synchronized void setPriority(int n) {
        if (n < 1 || n > 10) {
            throw new IllegalArgumentException();
        }
        this.priority = n;
    }

    public final synchronized int getPriority() {
        return this.priority;
    }

    public final String getName() {
        return this.name;
    }

    public static native int activeCount();

    public final native void join() throws InterruptedException;

    public String toString() {
        return "Thread[" + this.name + "," + this.priority + "]";
    }
}

