/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;
import java.io.OutputStream;

public class PrintStream
extends OutputStream {
    private OutputStream out;
    private String encoding;
    private boolean error_occurred = false;
    private static final char[] line_separator = System.getProperty("line.separator").toCharArray();

    public PrintStream(OutputStream outputStream) {
        this.out = outputStream;
        this.encoding = "ISO8859_1";
    }

    public void flush() {
        try {
            this.out.flush();
        }
        catch (IOException iOException) {
            this.setError();
        }
    }

    public void close() {
        try {
            this.flush();
            this.out.close();
        }
        catch (IOException iOException) {
            this.setError();
        }
    }

    public boolean checkError() {
        this.flush();
        return this.error_occurred;
    }

    protected void setError() {
        this.error_occurred = true;
    }

    public void write(int n) {
        try {
            this.out.write(n & 0xFF);
        }
        catch (IOException iOException) {
            this.setError();
        }
    }

    public void write(byte[] byArray, int n, int n2) {
        try {
            this.out.write(byArray, n, n2);
        }
        catch (IOException iOException) {
            this.setError();
        }
    }

    public void print(boolean bl) {
        this.print(String.valueOf(bl), false);
    }

    public synchronized void print(char c) {
        this.print(new char[]{c}, 0, 1, false);
    }

    public void print(int n) {
        this.print(String.valueOf(n), false);
    }

    public void print(long l) {
        this.print(String.valueOf(l), false);
    }

    public void print(float f) {
        this.print(String.valueOf(f), false);
    }

    public void print(double d) {
        this.print(String.valueOf(d), false);
    }

    public void print(char[] cArray) {
        this.print(cArray, 0, cArray.length, false);
    }

    public void print(String string) {
        this.print(string == null ? "null" : string, false);
    }

    public void print(Object object) {
        this.print(object == null ? "null" : object.toString(), false);
    }

    public void println() {
        this.print(line_separator, 0, line_separator.length, false);
    }

    public void println(boolean bl) {
        this.print(String.valueOf(bl), true);
    }

    public synchronized void println(char c) {
        this.print(new char[]{c}, 0, 1, true);
    }

    public void println(int n) {
        this.print(String.valueOf(n), true);
    }

    public void println(long l) {
        this.print(String.valueOf(l), true);
    }

    public void println(float f) {
        this.print(String.valueOf(f), true);
    }

    public void println(double d) {
        this.print(String.valueOf(d), true);
    }

    public void println(char[] cArray) {
        this.print(cArray, 0, cArray.length, true);
    }

    public void println(String string) {
        this.print(string == null ? "null" : string, true);
    }

    public void println(Object object) {
        this.print(object == null ? "null" : object.toString(), true);
    }

    private synchronized void print(String string, boolean bl) {
        try {
            this.writeChars(string, 0, string.length());
            if (bl) {
                this.writeChars(line_separator, 0, line_separator.length);
            }
        }
        catch (IOException iOException) {
            this.setError();
        }
    }

    private synchronized void print(char[] cArray, int n, int n2, boolean bl) {
        try {
            this.writeChars(cArray, n, n2);
            if (bl) {
                this.writeChars(line_separator, 0, line_separator.length);
            }
        }
        catch (IOException iOException) {
            this.setError();
        }
    }

    private void writeChars(char[] cArray, int n, int n2) throws IOException {
        byte[] byArray = new String(cArray, n, n2).getBytes(this.encoding);
        this.out.write(byArray, 0, byArray.length);
    }

    private void writeChars(String string, int n, int n2) throws IOException {
        byte[] byArray = string.substring(n, n + n2).getBytes(this.encoding);
        this.out.write(byArray, 0, byArray.length);
    }
}

