/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;

public class InputStreamReader
extends Reader {
    private InputStream in;

    public InputStreamReader(InputStream inputStream) {
        this.in = inputStream;
    }

    public InputStreamReader(InputStream inputStream, String string) throws UnsupportedEncodingException {
        if (string != "ISO8859_1" && string != "US_ASCII") {
            throw new UnsupportedEncodingException();
        }
        this.in = inputStream;
    }

    public int read() throws IOException {
        char[] cArray = new char[1];
        int n = this.read(cArray, 0, 1);
        return n > 0 ? cArray[0] : -1;
    }

    public int read(char[] cArray, int n, int n2) throws IOException {
        if (this.in == null) {
            throw new IOException("Reader has been closed");
        }
        byte[] byArray = new byte[n2];
        int n3 = this.in.read(byArray);
        for (int i = 0; i < n3; ++i) {
            cArray[n + i] = (char)(byArray[i] & 0xFF);
        }
        return n3;
    }

    public long skip(long l) throws IOException {
        if (this.in == null) {
            throw new IOException();
        }
        if (l < 0L) {
            throw new IllegalArgumentException();
        }
        return super.skip(l);
    }

    public boolean ready() throws IOException {
        if (this.in == null) {
            throw new IOException();
        }
        return this.in.available() != 0;
    }

    public void mark(int n) throws IOException {
        this.checkMarkReset();
        this.in.mark(n);
    }

    public void reset() throws IOException {
        this.checkMarkReset();
        this.in.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.in != null) {
                this.in.close();
            }
            this.in = null;
        }
    }

    private void checkMarkReset() throws IOException {
        if (this.in == null) {
            throw new IOException();
        }
        if (!this.in.markSupported()) {
            throw new IOException();
        }
    }
}

