/*
 * Decompiled with CFR 0.152.
 */
package jelatine.cldc.io.socket;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.microedition.io.Connection;
import javax.microedition.io.StreamConnection;
import jelatine.cldc.io.Protocol;
import jelatine.cldc.io.URL;

public class ProtocolImpl
implements Protocol,
StreamConnection {
    private String host;
    private int port;
    private int socketId;

    private native int open(String var1, int var2, boolean var3);

    private native int read(int var1);

    private native int readBuf(int var1, byte[] var2, int var3, int var4);

    private native int write(int var1, int var2);

    private native int writeBuf(int var1, byte[] var2, int var3, int var4);

    private native int close(int var1);

    public Connection open(URL uRL, int n, boolean bl) throws IllegalArgumentException, IOException {
        String string = uRL.getTarget();
        int n2 = string.indexOf(58);
        if (!string.startsWith("//") || n2 == -1) {
            throw new IllegalArgumentException("Malformed URL");
        }
        this.host = string.substring(2, n2);
        try {
            this.port = Integer.parseInt(string.substring(n2 + 1));
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Malformed URL: bad port");
        }
        this.socketId = this.open(this.host, this.port, bl);
        return this;
    }

    public DataInputStream openDataInputStream() throws IOException {
        return new DataInputStream(new SocketInputStream());
    }

    public InputStream openInputStream() throws IOException {
        return new SocketInputStream();
    }

    public DataOutputStream openDataOutputStream() throws IOException {
        return new DataOutputStream(new SocketOutputStream());
    }

    public OutputStream openOutputStream() throws IOException {
        return new SocketOutputStream();
    }

    public void close() throws IOException {
        this.close(this.socketId);
    }

    class SocketOutputStream
    extends OutputStream {
        SocketOutputStream() {
        }

        public void write(int n) throws IOException {
            ProtocolImpl.this.write(ProtocolImpl.this.socketId, n);
        }

        public void write(byte[] byArray) throws IOException {
            this.write(byArray, 0, byArray.length);
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            ProtocolImpl.this.writeBuf(ProtocolImpl.this.socketId, byArray, n, n2);
        }
    }

    class SocketInputStream
    extends InputStream {
        SocketInputStream() {
        }

        public int read() throws IOException {
            return ProtocolImpl.this.read(ProtocolImpl.this.socketId);
        }

        public int read(byte[] byArray) throws IOException {
            return this.read(byArray, 0, byArray.length);
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            return ProtocolImpl.this.readBuf(ProtocolImpl.this.socketId, byArray, n, n2);
        }
    }
}

