/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.io;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.microedition.io.Connection;
import javax.microedition.io.ConnectionNotFoundException;
import javax.microedition.io.InputConnection;
import javax.microedition.io.OutputConnection;
import jelatine.cldc.io.Protocol;
import jelatine.cldc.io.URL;

public class Connector {
    public static final int READ = 1;
    public static final int WRITE = 2;
    public static final int READ_WRITE = 3;
    private static final String PROTOCOL_PATH_KEY = "javax.microedition.io.Connector.protocolpath";
    private static final String DEFAULT_PROTOCOL_PATH = "jelatine.cldc.io";

    private Connector() {
    }

    public static Connection open(String string) throws IllegalArgumentException, ConnectionNotFoundException, IOException, SecurityException {
        Connection connection = Connector.open(string, 3);
        return connection;
    }

    public static Connection open(String string, int n) throws IllegalArgumentException, ConnectionNotFoundException, IOException, SecurityException {
        return Connector.open(string, n, false);
    }

    public static Connection open(String string, int n, boolean bl) throws IllegalArgumentException, ConnectionNotFoundException, IOException, SecurityException {
        Object object;
        if (string == null || n < 1 || n > 3) {
            throw new IllegalArgumentException();
        }
        URL uRL = new URL(string);
        String string2 = System.getProperty(PROTOCOL_PATH_KEY);
        if (string2 == null) {
            string2 = DEFAULT_PROTOCOL_PATH;
        }
        String string3 = string2 + "." + uRL.getScheme() + ".ProtocolImpl";
        Protocol protocol = null;
        try {
            object = Class.forName(string3);
            protocol = (Protocol)((Class)object).newInstance();
        }
        catch (Exception exception) {
            throw new ConnectionNotFoundException("Unknown Protocol: " + uRL.getScheme());
        }
        object = protocol.open(uRL, n, bl);
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DataInputStream openDataInputStream(String string) throws IllegalArgumentException, ConnectionNotFoundException, IOException, SecurityException {
        InputConnection inputConnection = (InputConnection)Connector.open(string, 1);
        try {
            DataInputStream dataInputStream;
            DataInputStream dataInputStream2 = dataInputStream = inputConnection.openDataInputStream();
            return dataInputStream2;
        }
        finally {
            inputConnection.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DataOutputStream openDataOutputStream(String string) throws IllegalArgumentException, ConnectionNotFoundException, IOException, SecurityException {
        OutputConnection outputConnection = (OutputConnection)Connector.open(string, 2);
        try {
            DataOutputStream dataOutputStream;
            DataOutputStream dataOutputStream2 = dataOutputStream = outputConnection.openDataOutputStream();
            return dataOutputStream2;
        }
        finally {
            outputConnection.close();
        }
    }

    public static InputStream openInputStream(String string) throws IllegalArgumentException, ConnectionNotFoundException, IOException, SecurityException {
        return Connector.openDataInputStream(string);
    }

    public static OutputStream openOutputStream(String string) throws IllegalArgumentException, ConnectionNotFoundException, IOException, SecurityException {
        return Connector.openDataOutputStream(string);
    }
}

