/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;
import java.io.OutputStream;

public class ByteArrayOutputStream
extends OutputStream {
    protected byte[] buf;
    protected int count;
    private boolean closed;
    private static final int DEFAULT_INITIAL_BUFFER_SIZE = 32;

    public ByteArrayOutputStream() {
        this(32);
    }

    public ByteArrayOutputStream(int n) throws IllegalArgumentException {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        this.buf = new byte[n];
        this.count = 0;
        this.closed = false;
    }

    public synchronized void write(int n) throws IOException {
        if (this.closed) {
            throw new IOException();
        }
        this.resize(1);
        this.buf[this.count++] = (byte)n;
    }

    public synchronized void write(byte[] byArray, int n, int n2) throws IOException {
        if (this.closed) {
            throw new IOException();
        }
        if (n2 >= 0) {
            this.resize(n2);
        }
        System.arraycopy(byArray, n, this.buf, this.count, n2);
        this.count += n2;
    }

    public synchronized void reset() {
        if (this.closed) {
            throw new RuntimeException();
        }
        this.count = 0;
    }

    public synchronized byte[] toByteArray() {
        if (!this.closed) {
            byte[] byArray = new byte[this.count];
            System.arraycopy(this.buf, 0, byArray, 0, this.count);
            return byArray;
        }
        return this.buf;
    }

    public int size() {
        return this.count;
    }

    public String toString() {
        return new String(this.buf, 0, this.count);
    }

    public synchronized void close() throws IOException {
        this.closed = true;
    }

    private void resize(int n) {
        if (this.count + n > this.buf.length) {
            int n2 = this.buf.length * 2;
            if (this.count + n > n2) {
                n2 = this.count + n;
            }
            byte[] byArray = new byte[n2];
            System.arraycopy(this.buf, 0, byArray, 0, this.count);
            this.buf = byArray;
        }
    }
}

