/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.Enumeration;
import java.util.NoSuchElementException;

public class Vector {
    protected Object[] elementData;
    protected int elementCount;
    protected int capacityIncrement;

    public Vector() {
        this(10, 0);
    }

    public Vector(int n) {
        this(n, 0);
    }

    public Vector(int n, int n2) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        this.elementData = new Object[n];
        this.capacityIncrement = n2;
    }

    public synchronized void copyInto(Object[] objectArray) {
        System.arraycopy(this.elementData, 0, objectArray, 0, this.elementCount);
    }

    public synchronized void trimToSize() {
        Object[] objectArray = new Object[this.elementCount];
        System.arraycopy(this.elementData, 0, objectArray, 0, this.elementCount);
        this.elementData = objectArray;
    }

    public synchronized void ensureCapacity(int n) {
        if (this.elementData.length >= n) {
            return;
        }
        int n2 = this.capacityIncrement <= 0 ? this.elementData.length * 2 : this.elementData.length + this.capacityIncrement;
        Object[] objectArray = new Object[Math.max(n2, n)];
        System.arraycopy(this.elementData, 0, objectArray, 0, this.elementCount);
        this.elementData = objectArray;
    }

    public synchronized void setSize(int n) {
        this.ensureCapacity(n);
        if (n < this.elementCount) {
            for (int i = n; i < this.elementCount; ++i) {
                this.elementData[i] = null;
            }
        }
        this.elementCount = n;
    }

    public synchronized int capacity() {
        return this.elementData.length;
    }

    public synchronized int size() {
        return this.elementCount;
    }

    public synchronized boolean isEmpty() {
        return this.elementCount == 0;
    }

    public Enumeration elements() {
        return new Enumeration(){
            private int i = 0;

            public boolean hasMoreElements() {
                return this.i < Vector.this.elementCount;
            }

            public Object nextElement() {
                if (this.i >= Vector.this.elementCount) {
                    throw new NoSuchElementException();
                }
                return Vector.this.elementData[this.i++];
            }
        };
    }

    public boolean contains(Object object) {
        return this.indexOf(object, 0) >= 0;
    }

    public int indexOf(Object object) {
        return this.indexOf(object, 0);
    }

    public synchronized int indexOf(Object object, int n) {
        for (int i = n; i < this.elementCount; ++i) {
            if (!object.equals(this.elementData[i])) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(Object object) {
        return this.lastIndexOf(object, this.elementCount - 1);
    }

    public synchronized int lastIndexOf(Object object, int n) throws IndexOutOfBoundsException {
        this.checkBoundExclusive(n);
        for (int i = n; i >= 0; --i) {
            if (!object.equals(this.elementData[i])) continue;
            return i;
        }
        return -1;
    }

    public synchronized Object elementAt(int n) throws ArrayIndexOutOfBoundsException {
        this.checkBoundExclusive(n);
        return this.elementData[n];
    }

    public synchronized Object firstElement() {
        if (this.elementCount == 0) {
            throw new NoSuchElementException();
        }
        return this.elementData[0];
    }

    public synchronized Object lastElement() {
        if (this.elementCount == 0) {
            throw new NoSuchElementException();
        }
        return this.elementData[this.elementCount - 1];
    }

    public void setElementAt(Object object, int n) {
        this.set(n, object);
    }

    public void removeElementAt(int n) {
        this.remove(n);
    }

    public synchronized void insertElementAt(Object object, int n) {
        this.checkBoundInclusive(n);
        if (this.elementCount == this.elementData.length) {
            this.ensureCapacity(this.elementCount + 1);
        }
        System.arraycopy(this.elementData, n, this.elementData, n + 1, this.elementCount - n);
        ++this.elementCount;
        this.elementData[n] = object;
    }

    public synchronized void addElement(Object object) {
        if (this.elementCount == this.elementData.length) {
            this.ensureCapacity(this.elementCount + 1);
        }
        this.elementData[this.elementCount++] = object;
    }

    public synchronized boolean removeElement(Object object) {
        int n = this.indexOf(object, 0);
        if (n >= 0) {
            this.remove(n);
            return true;
        }
        return false;
    }

    public synchronized void removeAllElements() {
        if (this.elementCount == 0) {
            return;
        }
        for (int i = 0; i < this.elementCount; ++i) {
            this.elementData[i] = null;
        }
        this.elementCount = 0;
    }

    private synchronized Object set(int n, Object object) {
        this.checkBoundExclusive(n);
        Object object2 = this.elementData[n];
        this.elementData[n] = object;
        return object2;
    }

    private synchronized Object remove(int n) {
        this.checkBoundExclusive(n);
        Object object = this.elementData[n];
        --this.elementCount;
        if (n < this.elementCount) {
            System.arraycopy(this.elementData, n + 1, this.elementData, n, this.elementCount - n);
        }
        this.elementData[this.elementCount] = null;
        return object;
    }

    public synchronized String toString() {
        return super.toString();
    }

    private void checkBoundInclusive(int n) {
        if (n > this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(n + " > " + this.elementCount);
        }
    }

    private void checkBoundExclusive(int n) {
        if (n >= this.elementCount) {
            throw new ArrayIndexOutOfBoundsException(n + " >= " + this.elementCount);
        }
    }
}

