/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.DataInput;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UTFDataFormatException;

public class DataInputStream
extends InputStream
implements DataInput {
    private byte[] buf = new byte[8];
    protected InputStream in;

    public DataInputStream(InputStream inputStream) {
        this.in = inputStream;
    }

    public int read() throws IOException {
        return this.in.read();
    }

    public final int read(byte[] byArray) throws IOException {
        return this.in.read(byArray, 0, byArray.length);
    }

    public final int read(byte[] byArray, int n, int n2) throws IOException {
        return this.in.read(byArray, n, n2);
    }

    public final void readFully(byte[] byArray) throws EOFException, IOException {
        this.readFully(byArray, 0, byArray.length);
    }

    public final void readFully(byte[] byArray, int n, int n2) throws EOFException, IOException {
        if (n2 < 0) {
            throw new IndexOutOfBoundsException("Negative length: " + n2);
        }
        while (n2 > 0) {
            int n3 = this.in.read(byArray, n, n2);
            if (n3 < 0) {
                throw new EOFException();
            }
            n2 -= n3;
            n += n3;
        }
    }

    public int skipBytes(int n) throws IOException {
        if (n <= 0) {
            return 0;
        }
        try {
            return (int)this.in.skip(n);
        }
        catch (EOFException eOFException) {
            return n;
        }
    }

    public final boolean readBoolean() throws IOException {
        return DataInputStream.convertToBoolean(this.in.read());
    }

    public final byte readByte() throws IOException {
        return DataInputStream.convertToByte(this.in.read());
    }

    public final int readUnsignedByte() throws IOException {
        return DataInputStream.convertToUnsignedByte(this.in.read());
    }

    public final short readShort() throws IOException {
        this.readFully(this.buf, 0, 2);
        return DataInputStream.convertToShort(this.buf);
    }

    public final int readUnsignedShort() throws IOException {
        this.readFully(this.buf, 0, 2);
        return DataInputStream.convertToUnsignedShort(this.buf);
    }

    public final char readChar() throws IOException {
        this.readFully(this.buf, 0, 2);
        return DataInputStream.convertToChar(this.buf);
    }

    public final int readInt() throws IOException {
        this.readFully(this.buf, 0, 4);
        return DataInputStream.convertToInt(this.buf);
    }

    public final long readLong() throws IOException {
        this.readFully(this.buf, 0, 8);
        return DataInputStream.convertToLong(this.buf);
    }

    public final float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    public final double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    public final String readUTF() throws IOException {
        return DataInputStream.readUTF(this);
    }

    public static final String readUTF(DataInput dataInput) throws IOException {
        int n = dataInput.readUnsignedShort();
        byte[] byArray = new byte[n];
        dataInput.readFully(byArray, 0, n);
        return DataInputStream.convertFromUTF(byArray);
    }

    public long skip(long l) throws IOException {
        return this.in.skip(l);
    }

    public int available() throws IOException {
        return this.in.available();
    }

    public void close() throws IOException {
        this.in.close();
    }

    public synchronized void mark(int n) {
        this.in.mark(n);
    }

    public synchronized void reset() throws IOException {
        this.in.reset();
    }

    public boolean markSupported() {
        return this.in.markSupported();
    }

    private static byte convertToByte(int n) throws IOException {
        if (n < 0) {
            throw new IOException();
        }
        return (byte)n;
    }

    private static boolean convertToBoolean(int n) throws IOException {
        if (n < 0) {
            throw new IOException();
        }
        return n != 0;
    }

    private static int convertToUnsignedByte(int n) throws IOException {
        if (n < 0) {
            throw new IOException();
        }
        return n & 0xFF;
    }

    private static short convertToShort(byte[] byArray) {
        return (short)(byArray[0] << 8 | byArray[1] & 0xFF);
    }

    private static int convertToUnsignedShort(byte[] byArray) {
        return (byArray[0] & 0xFF) << 8 | byArray[1] & 0xFF;
    }

    private static char convertToChar(byte[] byArray) {
        return (char)(byArray[0] << 8 | byArray[1] & 0xFF);
    }

    private static int convertToInt(byte[] byArray) {
        return (byArray[0] & 0xFF) << 24 | (byArray[1] & 0xFF) << 16 | (byArray[2] & 0xFF) << 8 | byArray[3] & 0xFF;
    }

    private static long convertToLong(byte[] byArray) {
        return (long)(byArray[0] & 0xFF) << 56 | (long)(byArray[1] & 0xFF) << 48 | (long)(byArray[2] & 0xFF) << 40 | (long)(byArray[3] & 0xFF) << 32 | (long)(byArray[4] & 0xFF) << 24 | (long)(byArray[5] & 0xFF) << 16 | (long)(byArray[6] & 0xFF) << 8 | (long)(byArray[7] & 0xFF);
    }

    private static String convertFromUTF(byte[] byArray) throws EOFException, UTFDataFormatException {
        StringBuffer stringBuffer = new StringBuffer(byArray.length / 2 + 2);
        int n = 0;
        while (n < byArray.length) {
            if ((byArray[n] & 0x80) == 0) {
                stringBuffer.append((char)(byArray[n++] & 0xFF));
                continue;
            }
            if ((byArray[n] & 0xE0) == 192) {
                if (n + 1 >= byArray.length || (byArray[n + 1] & 0xC0) != 128) {
                    throw new UTFDataFormatException();
                }
                stringBuffer.append((char)((byArray[n++] & 0x1F) << 6 | byArray[n++] & 0x3F));
                continue;
            }
            if ((byArray[n] & 0xF0) == 224) {
                if (n + 2 >= byArray.length || (byArray[n + 1] & 0xC0) != 128 || (byArray[n + 2] & 0xC0) != 128) {
                    throw new UTFDataFormatException();
                }
                stringBuffer.append((char)((byArray[n++] & 0xF) << 12 | (byArray[n++] & 0x3F) << 6 | byArray[n++] & 0x3F));
                continue;
            }
            throw new UTFDataFormatException();
        }
        return stringBuffer.toString();
    }
}

