/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.Date;
import java.util.TimeZone;
import jelatine.VMCalendar;

public abstract class Calendar {
    public static final int YEAR = 1;
    public static final int MONTH = 2;
    public static final int DATE = 5;
    public static final int DAY_OF_MONTH = 5;
    public static final int DAY_OF_WEEK = 7;
    public static final int AM_PM = 9;
    public static final int HOUR = 10;
    public static final int HOUR_OF_DAY = 11;
    public static final int MINUTE = 12;
    public static final int SECOND = 13;
    public static final int MILLISECOND = 14;
    public static final int SUNDAY = 1;
    public static final int MONDAY = 2;
    public static final int TUESDAY = 3;
    public static final int WEDNESDAY = 4;
    public static final int THURSDAY = 5;
    public static final int FRIDAY = 6;
    public static final int SATURDAY = 7;
    public static final int JANUARY = 0;
    public static final int FEBRUARY = 1;
    public static final int MARCH = 2;
    public static final int APRIL = 3;
    public static final int MAY = 4;
    public static final int JUNE = 5;
    public static final int JULY = 6;
    public static final int AUGUST = 7;
    public static final int SEPTEMBER = 8;
    public static final int OCTOBER = 9;
    public static final int NOVEMBER = 10;
    public static final int DECEMBER = 11;
    public static final int AM = 0;
    public static final int PM = 1;
    public static final int FIELD_COUNT = 15;
    protected int[] fields = new int[15];
    protected boolean[] isSet = new boolean[15];
    protected long time;
    protected boolean isTimeSet;
    protected boolean areFieldsSet;
    private TimeZone zone = TimeZone.getDefault();

    protected Calendar() {
        this.clear();
    }

    public final Date getTime() {
        if (!this.isTimeSet) {
            this.computeTime();
        }
        return new Date(this.time);
    }

    public final void setTime(Date date) {
        this.setTimeInMillis(date.getTime());
    }

    public static synchronized Calendar getInstance() {
        return new VMCalendar();
    }

    public static synchronized Calendar getInstance(TimeZone timeZone) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeZone(timeZone);
        return calendar;
    }

    public long getTimeInMillis() {
        if (!this.isTimeSet) {
            this.computeTime();
            this.isTimeSet = true;
        }
        return this.time;
    }

    public void setTimeInMillis(long l) {
        this.clear();
        this.time = l;
        this.isTimeSet = true;
        this.computeFields();
    }

    public final int get(int n) throws ArrayIndexOutOfBoundsException {
        if (!this.isSet[n]) {
            this.areFieldsSet = false;
        }
        this.complete();
        return this.fields[n];
    }

    public void set(int n, int n2) throws ArrayIndexOutOfBoundsException {
        if (this.isTimeSet) {
            for (int i = 0; i < 15; ++i) {
                this.isSet[i] = false;
            }
        }
        this.isTimeSet = false;
        this.fields[n] = n2;
        this.isSet[n] = true;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Calendar)) {
            return false;
        }
        Calendar calendar = (Calendar)object;
        if (this.getTimeInMillis() == ((Calendar)object).getTimeInMillis()) {
            TimeZone timeZone = this.getTimeZone();
            TimeZone timeZone2 = calendar.getTimeZone();
            return timeZone == null ? timeZone2 == null : timeZone.equals(timeZone2);
        }
        return false;
    }

    public boolean before(Object object) {
        if (object instanceof Calendar) {
            return this.getTimeInMillis() < ((Calendar)object).getTimeInMillis();
        }
        return false;
    }

    public boolean after(Object object) {
        if (object instanceof Calendar) {
            return this.getTimeInMillis() > ((Calendar)object).getTimeInMillis();
        }
        return false;
    }

    public void setTimeZone(TimeZone timeZone) {
        this.zone = timeZone;
    }

    public TimeZone getTimeZone() {
        return this.zone;
    }

    protected void complete() {
        if (!this.isTimeSet) {
            this.computeTime();
        }
        if (!this.areFieldsSet) {
            this.computeFields();
        }
    }

    protected abstract void computeTime();

    protected abstract void computeFields();

    public final void clear() {
        this.isTimeSet = false;
        this.areFieldsSet = false;
        int n = this.zone.getRawOffset();
        int[] nArray = new int[]{1, 1970, 0, 1, 1, 1, 1, 5, 1, 0, 0, 0, 0, 0, 0, n, 0};
        this.fields = nArray;
        for (int i = 0; i < 15; ++i) {
            this.isSet[i] = false;
        }
    }
}

