/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.UnsupportedEncodingException;
import jelatine.VMPointer;

public final class String {
    private VMPointer next;
    final char[] value;
    final int count;
    private int cachedHashCode;
    final int offset;

    public String() {
        this.value = "".value;
        this.offset = 0;
        this.count = 0;
    }

    public String(String string) {
        this.value = string.value;
        this.offset = string.offset;
        this.count = string.count;
        this.cachedHashCode = string.cachedHashCode;
    }

    public String(char[] cArray) {
        this(cArray, 0, cArray.length, false);
    }

    public String(char[] cArray, int n, int n2) {
        this(cArray, n, n2, false);
    }

    public String(byte[] byArray, int n, int n2, String string) throws UnsupportedEncodingException {
        if (n < 0) {
            throw new StringIndexOutOfBoundsException("offset: " + n);
        }
        if (n2 < 0) {
            throw new StringIndexOutOfBoundsException("count: " + n2);
        }
        if (byArray.length - n < n2) {
            throw new StringIndexOutOfBoundsException("offset + count: " + (n + n2));
        }
        if (!string.equals("ISO8859_1") && !string.equals("US_ASCII")) {
            throw new UnsupportedEncodingException();
        }
        this.value = new char[n2];
        for (int i = 0; i < n2; ++i) {
            this.value[i] = (char)(byArray[i + n] & 0xFF);
        }
        this.offset = 0;
        this.count = n2;
    }

    public String(byte[] byArray, String string) throws UnsupportedEncodingException {
        this(byArray, 0, byArray.length, string);
    }

    public String(byte[] byArray, int n, int n2) {
        if (n < 0) {
            throw new StringIndexOutOfBoundsException("offset: " + n);
        }
        if (n2 < 0) {
            throw new StringIndexOutOfBoundsException("count: " + n2);
        }
        if (byArray.length - n < n2) {
            throw new StringIndexOutOfBoundsException("offset + count: " + (n + n2));
        }
        this.value = new char[n2];
        for (int i = 0; i < n2; ++i) {
            this.value[i] = (char)(byArray[i + n] & 0xFF);
        }
        this.offset = 0;
        this.count = n2;
    }

    public String(byte[] byArray) {
        this(byArray, 0, byArray.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String(StringBuffer stringBuffer) {
        StringBuffer stringBuffer2 = stringBuffer;
        synchronized (stringBuffer2) {
            this.offset = 0;
            this.count = stringBuffer.count;
            if (this.count << 2 < stringBuffer.value.length) {
                this.value = new char[this.count];
                System.arraycopy(stringBuffer.value, 0, this.value, 0, this.count);
            } else {
                stringBuffer.shared = true;
                this.value = stringBuffer.value;
            }
        }
    }

    String(char[] cArray, int n, int n2, boolean bl) {
        if (n < 0) {
            throw new StringIndexOutOfBoundsException("offset: " + n);
        }
        if (n2 < 0) {
            throw new StringIndexOutOfBoundsException("count: " + n2);
        }
        if (cArray.length - n < n2) {
            throw new StringIndexOutOfBoundsException("offset + count: " + (n + n2));
        }
        if (bl) {
            this.value = cArray;
            this.offset = n;
        } else {
            this.value = new char[n2];
            System.arraycopy(cArray, n, this.value, 0, n2);
            this.offset = 0;
        }
        this.count = n2;
    }

    public int length() {
        return this.count;
    }

    public char charAt(int n) {
        if (n < 0 || n >= this.count) {
            throw new StringIndexOutOfBoundsException();
        }
        return this.value[this.offset + n];
    }

    public void getChars(int n, int n2, char[] cArray, int n3) {
        if (n < 0 || n > n2 || n2 > this.count) {
            throw new StringIndexOutOfBoundsException();
        }
        System.arraycopy(this.value, n + this.offset, cArray, n3, n2 - n);
    }

    public byte[] getBytes(String string) throws UnsupportedEncodingException {
        if (!string.equals("ISO8859_1") && !string.equals("US_ASCII")) {
            throw new UnsupportedEncodingException();
        }
        byte[] byArray = new byte[this.count];
        for (int i = 0; i < this.count; ++i) {
            byArray[i] = (byte)this.value[i + this.offset];
        }
        return byArray;
    }

    public byte[] getBytes() {
        byte[] byArray = new byte[this.count];
        for (int i = 0; i < this.count; ++i) {
            byArray[i] = (byte)(this.value[this.offset + i] <= '\u00ff' ? this.value[this.offset + i] : 63);
        }
        return byArray;
    }

    public boolean equals(Object object) {
        if (!(object instanceof String)) {
            return false;
        }
        String string = (String)object;
        if (this.count != string.count) {
            return false;
        }
        if (this.value == string.value && this.offset == string.offset) {
            return true;
        }
        int n = this.count;
        int n2 = this.offset;
        int n3 = string.offset;
        for (n = 0; n < this.count; ++n) {
            if (this.value[n2] != string.value[n3]) {
                return false;
            }
            ++n2;
            ++n3;
        }
        return true;
    }

    public boolean equalsIgnoreCase(String string) {
        if (string == null || this.count != string.count) {
            return false;
        }
        int n = this.count;
        int n2 = this.offset;
        int n3 = string.offset;
        while (--n >= 0) {
            char c;
            char c2;
            if ((c2 = this.value[n2++]) == (c = string.value[n3++]) || Character.toUpperCase(c2) == Character.toUpperCase(c) || Character.toLowerCase(c2) == Character.toLowerCase(c)) continue;
            return false;
        }
        return true;
    }

    public int compareTo(String string) {
        int n = Math.min(this.count, string.count);
        int n2 = this.offset;
        int n3 = string.offset;
        while (--n >= 0) {
            int n4;
            if ((n4 = this.value[n2++] - string.value[n3++]) == 0) continue;
            return n4;
        }
        return this.count - string.count;
    }

    public boolean regionMatches(boolean bl, int n, String string, int n2, int n3) {
        if (n < 0 || n2 < 0 || n + n3 > this.count || n2 + n3 > string.count) {
            return false;
        }
        n += this.offset;
        n2 += string.offset;
        while (--n3 >= 0) {
            char c;
            char c2;
            if ((c2 = this.value[n++]) == (c = string.value[n2++]) || bl && (Character.toLowerCase(c2) == Character.toLowerCase(c) || Character.toUpperCase(c2) == Character.toUpperCase(c))) continue;
            return false;
        }
        return true;
    }

    public boolean startsWith(String string, int n) {
        return this.regionMatches(false, n, string, 0, string.count);
    }

    public boolean startsWith(String string) {
        return this.regionMatches(false, 0, string, 0, string.count);
    }

    public boolean endsWith(String string) {
        return this.regionMatches(false, this.count - string.count, string, 0, string.count);
    }

    public int hashCode() {
        if (this.cachedHashCode != 0) {
            return this.cachedHashCode;
        }
        int n = 0;
        int n2 = this.count + this.offset;
        for (int i = this.offset; i < n2; ++i) {
            n = n * 31 + this.value[i];
        }
        this.cachedHashCode = n;
        return this.cachedHashCode;
    }

    public int indexOf(int n) {
        return this.indexOf(n, 0);
    }

    public int indexOf(int n, int n2) {
        if ((char)n != n) {
            return -1;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        int n3 = n2 + this.offset;
        while (n2 < this.count) {
            if (this.value[n3++] == n) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public int lastIndexOf(int n) {
        return this.lastIndexOf(n, this.count - 1);
    }

    public int lastIndexOf(int n, int n2) {
        if ((char)n != n) {
            return -1;
        }
        if (n2 >= this.count) {
            n2 = this.count - 1;
        }
        int n3 = n2 + this.offset;
        while (n2 >= 0) {
            if (this.value[n3--] == n) {
                return n2;
            }
            --n2;
        }
        return -1;
    }

    public int indexOf(String string) {
        return this.indexOf(string, 0);
    }

    public int indexOf(String string, int n) {
        if (n < 0) {
            n = 0;
        }
        int n2 = this.count - string.count;
        while (n <= n2) {
            boolean bl = true;
            for (int i = 0; i < string.count; ++i) {
                if (string.value[i] == this.value[n + i]) continue;
                bl = false;
            }
            if (bl) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public String substring(int n) {
        return this.substring(n, this.count);
    }

    public String substring(int n, int n2) {
        int n3;
        if (n < 0 || n2 > this.count || n > n2) {
            throw new StringIndexOutOfBoundsException();
        }
        if (n == 0 && n2 == this.count) {
            return this;
        }
        return new String(this.value, n + this.offset, n3, (n3 = n2 - n) << 2 >= this.value.length);
    }

    public String concat(String string) {
        if (string.count == 0) {
            return this;
        }
        if (this.count == 0) {
            return string;
        }
        char[] cArray = new char[this.count + string.count];
        System.arraycopy(this.value, this.offset, cArray, 0, this.count);
        System.arraycopy(string.value, string.offset, cArray, this.count, string.count);
        return new String(cArray, 0, cArray.length, true);
    }

    public String replace(char c, char c2) {
        if (c == c2) {
            return this;
        }
        int n = this.count;
        int n2 = this.offset - 1;
        while (--n >= 0 && this.value[++n2] != c) {
        }
        if (n < 0) {
            return this;
        }
        char[] cArray = new char[this.value.length];
        System.arraycopy(this.value, 0, cArray, 0, this.value.length);
        cArray[n2] = c2;
        while (--n >= 0) {
            if (this.value[++n2] != c) continue;
            cArray[n2] = c2;
        }
        return new String(cArray, this.offset, this.count, true);
    }

    public String toLowerCase() {
        char c;
        int n = this.count;
        int n2 = this.offset - 1;
        while (--n >= 0 && (c = this.value[++n2]) == Character.toLowerCase(c)) {
        }
        if (n < 0) {
            return this;
        }
        char[] cArray = new char[this.value.length];
        System.arraycopy(this.value, 0, cArray, 0, this.value.length);
        do {
            char c2 = this.value[n2];
            cArray[n2++] = Character.toLowerCase(c2);
        } while (--n >= 0);
        return new String(cArray, this.offset, this.count, true);
    }

    public String toUpperCase() {
        char c;
        int n = this.count;
        int n2 = this.offset - 1;
        while (--n >= 0 && (c = this.value[++n2]) == Character.toUpperCase(c)) {
        }
        if (n < 0) {
            return this;
        }
        char[] cArray = new char[this.value.length];
        System.arraycopy(this.value, 0, cArray, 0, this.value.length);
        do {
            char c2 = this.value[n2];
            cArray[n2++] = Character.toUpperCase(c2);
        } while (--n >= 0);
        return new String(cArray, this.offset, this.count, true);
    }

    public String trim() {
        int n = this.count + this.offset;
        if (this.count == 0 || this.value[this.offset] > ' ' && this.value[n - 1] > ' ') {
            return this;
        }
        int n2 = this.offset;
        do {
            if (n2 != n) continue;
            return "";
        } while (this.value[n2++] <= ' ');
        int n3 = n;
        while (this.value[--n3] <= ' ') {
        }
        return this.substring(n2 - this.offset - 1, n3 - this.offset + 1);
    }

    public String toString() {
        return this;
    }

    public char[] toCharArray() {
        char[] cArray = new char[this.count];
        System.arraycopy(this.value, this.offset, cArray, 0, this.count);
        return cArray;
    }

    public static String valueOf(Object object) {
        return object == null ? "null" : object.toString();
    }

    public static String valueOf(char[] cArray) {
        return String.valueOf(cArray, 0, cArray.length);
    }

    public static String valueOf(char[] cArray, int n, int n2) {
        return new String(cArray, n, n2, false);
    }

    public static String valueOf(boolean bl) {
        return bl ? "true" : "false";
    }

    public static String valueOf(char c) {
        return new String(new char[]{c}, 0, 1, true);
    }

    public static String valueOf(int n) {
        return Integer.toString(n, 10);
    }

    public static String valueOf(long l) {
        return Long.toString(l);
    }

    public static String valueOf(float f) {
        return Float.toString(f);
    }

    public static String valueOf(double d) {
        return Double.toString(d);
    }

    public native String intern();
}

