/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;

public class OutputStreamWriter
extends Writer {
    private OutputStream out;

    public OutputStreamWriter(OutputStream outputStream, String string) throws UnsupportedEncodingException {
        this.out = outputStream;
        if (string != "ISO8859_1" && string != "US_ASCII") {
            throw new UnsupportedEncodingException();
        }
    }

    public OutputStreamWriter(OutputStream outputStream) {
        this.out = outputStream;
    }

    public void write(int n) throws IOException {
        this.write(new char[]{(char)n}, 0, 1);
    }

    public void write(char[] cArray, int n, int n2) throws IOException {
        if (cArray == null) {
            throw new IOException();
        }
        byte[] byArray = new byte[n2];
        for (int i = 0; i < n2; ++i) {
            byArray[i] = (byte)(cArray[n + i] <= '\u00ff' ? cArray[n + i] : 63);
        }
        this.out.write(byArray);
    }

    public void write(String string, int n, int n2) throws IOException {
        if (string == null) {
            throw new IOException();
        }
        this.write(string.toCharArray(), n, n2);
    }

    public void flush() throws IOException {
        if (this.out != null) {
            this.out.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.out == null) {
                return;
            }
            this.flush();
            this.out.close();
            this.out = null;
        }
    }
}

