#ifndef __CAPABILITIES_H
#define __CAPABILITIES_H

#include "iconpack.h"

//capability name

// client -   
//    
static const char capSieICQ[]    = {'S', 'i', 'e', 'I', 'C', 'Q', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
static const char capNatICQ[]    = {'N', 'a', 't', 'I', 'C', 'Q', 'S', 'i', 'e', 0, 0, 0, 0, 0, 0, 0};

static const char capQutIM[]     = {'q', 'u', 't', 'i', 'm', 0x00, 0x00,  0x00,  0x00,  0x00,  0x00, 0x00, 0x00, 0x00, 0x00, 0x00 };
static const char capPidgin[]    = {'P', 'i', 'd', 'g', 'i', 'n', '/', 'A', 'd', 'i', 'u', 'm', 'X', 0,0,0};
static const char capSim[]       = {'S', 'I', 'M', ' ', 'c', 'l', 'i', 'e', 'n', 't', ' ', ' ', 0, 0, 0, 0};
static const char capSimOld[]    = {0x97, 0xb1, 0x27, 0x51, 0x24, 0x3c, 0x43, 0x34, 0xad, 0x22, 0xd6, 0xab, 0xf7, 0x3f, 0x14, 0x00};
static const char capLicq[]      = {'L', 'i', 'c', 'q', ' ', 'c', 'l', 'i', 'e', 'n', 't', ' ', 0, 0, 0, 0};
static const char capKopete[]    = {'K', 'o', 'p', 'e', 't', 'e', ' ', 'I', 'C', 'Q', ' ', ' ', 0, 0, 0, 0};

static const char capMirandaIm[]      = {'M', 'i', 'r', 'a', 'n', 'd', 'a', 'M', 0, 0, 0, 0, 0, 0, 0, 0};
static const char capMirandaMobile[]  = {'M', 'i', 'r', 'a', 'n', 'd', 'a', 'M', 'o', 'b', 'i', 'l', 'e', 0, 0, 0}; //port by Nullbie

static const char capMimPack[]   = {'M', 'I', 'M', '/', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
static const char capIcqJen[]    = {'e', 'n', 'q', 'j', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}; // eternity mod
static const char capIcqJs7[]    = {'i', 'c', 'q', 'j', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
static const char capIcqJp[]     = {'i', 'c', 'q', 'p', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
static const char capIcqJs7s[]	 = {'i', 'c', 'q', 'j', 0, 'S', 'e', 'c', 'u', 'r', 'e', 0, 'I', 'M', 0, 0};
static const char capIcqJs7old[] = {0x69, 0x63, 0x71, 0x6a, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
static const char capIcqJSin[]	 = {'s', 'i', 'n', 'j',  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}; // Miranda ICQJ S!N
static const char capAimOscar[]  = {'M', 'i', 'r', 'a', 'n', 'd', 'a', 'A', 0, 0, 0, 0, 0, 0, 0, 0};
static const char capTrillian[]  = {0x97, 0xb1, 0x27, 0x51, 0x24, 0x3c, 0x43, 0x34, 0xad, 0x22, 0xd6, 0xab, 0xf7, 0x3f, 0x14, 0x09};
static const char capTrilCrypt[] = {0xf2, 0xe7, 0xc7, 0xf4, 0xfe, 0xad, 0x4d, 0xfb, 0xb2, 0x35, 0x36, 0x79, 0x8b, 0xdf, 0x00, 0x00};
static const char capmIcq[]      = {'m', 'I', 'C', 'Q', ' ', 0xA9, ' ', 'R', '.', 'K', '.', ' ', 0, 0, 0, 0};
static const char capClimm[]     = {'c', 'l', 'i', 'm', 'm', 0xA9, ' ', 'R', '.', 'K', '.', ' ', 0, 0, 0, 0};
static const char capAndRQ[]     = {'&', 'R', 'Q', 'i', 'n', 's', 'i', 'd', 'e', 0, 0, 0, 0, 0, 0, 0};
static const char capRAndQ[]     = {'R', '&', 'Q', 'i', 'n', 's', 'i', 'd', 'e', 0, 0, 0, 0, 0, 0, 0};
static const char capmChat[]     = {'m', 'C', 'h', 'a', 't', ' ', 'i', 'c', 'q', ' ', 0, 0, 0, 0, 0, 0};
static const char capJimm[]      = {'J', 'i', 'm', 'm', ' ', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
static const char capCorePager[] = {'C', 'O', 'R', 'E', ' ', 'P', 'a', 'g', 'e', 'r', 0, 0, 0, 0, 0, 0};
static const char capDiChat[]    = {'D', '[', 'i', ']', 'C', 'h', 'a', 't', ' ', 0, 0, 0, 0, 0, 0, 0};
static const char capNaim[]      = {0xFF, 0xFF, 0xFF, 0xFF, 'n', 'a', 'i', 'm', 0, 0, 0, 0, 0, 0, 0, 0};
static const char capAnastasia[] = {0x44, 0xE5, 0xBF, 0xCE, 0xB0, 0x96, 0xE5, 0x47, 0xBD, 0x65, 0xEF, 0xD6, 0xA3, 0x7E, 0x36, 0x02};
static const char capQip[]       = {0x56, 0x3F, 0xC8, 0x09, 0x0B, 0x6F, 0x41, 'Q', 'I', 'P', ' ', '2', '0', '0', '5', 'a'};
static const char capQipPDA[]    = {0x56, 0x3F, 0xC8, 0x09, 0x0B, 0x6F, 0x41, 'Q', 'I', 'P', ' ', ' ', ' ', ' ', ' ', '!'};
static const char capQipMobile[] = {0x56, 0x3F, 0xC8, 0x09, 0x0B, 0x6F, 0x41, 'Q', 'I', 'P', ' ', ' ', ' ', ' ', ' ', '"'};
static const char capQipInfium[] = {0x7C, 0x73, 0x75, 0x02, 0xC3, 0xBE, 0x4F, 0x3E, 0xA6, 0x9F, 0x01, 0x53, 0x13, 0x43, 0x1E, 0x1A};
static const char capQipPlugins[]= {0x7c, 0x53, 0x3f, 0xfa, 0x68, 0x00, 0x4f, 0x21, 0xbc, 0xfb, 0xc7, 0xd2, 0x43, 0x9a, 0xad, 0x31}; //QIP Plugins
static const char capQip_1[]     = {0xd3, 0xd4, 0x53, 0x19, 0x8b, 0x32, 0x40, 0x3b, 0xac, 0xc7, 0xd1, 0xa9, 0xe2, 0xb5, 0x81, 0x3e}; // QIP-ProtectMsg (now use for fake id only)
static const char capQipSymbian[]= {0x51, 0xad, 0xd1, 0x90, 0x72, 0x04, 0x47, 0x3d, 0xa1, 0xa1, 0x49, 0xf4, 0xa3, 0x97, 0xa4, 0x1f};
static const char capVmICQ[]	 = {0x56, 0x6d, 0x49, 0x43, 0x51, 0x20, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
static const char capSmapeR[]    = {'S', 'm', 'a', 'p', 'e', 'r', ' ', 0, 0, 0, 0, 0, 0, 0, 0, 0};
static const char capPigeon[]    = {0x50, 0x49, 0x47, 0x45, 0x4f, 0x4e, 0x21, 0, 0, 0, 0, 0, 0, 0, 0, 0};
static const char capIMPlus[]	 = {0x8e, 0xcd, 0x90, 0xe7, 0x4f, 0x18, 0x28, 0xf8, 0x02, 0xec, 0xd6, 0x18, 0xa4, 0xe9, 0xde, 0x68};
static const char capYapp[]	 = {0x59, 0x61, 0x70, 0x70, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}; // Yapp
static const char capIm2[]       = {0x74, 0xED, 0xC3, 0x36, 0x44, 0xDF, 0x48, 0x5B, 0x8B, 0x1C, 0x67, 0x1A, 0x1F, 0x86, 0x09, 0x9F}; // IM2 Ext Msg
static const char capMacIcq[]    = {0xdd, 0x16, 0xf2, 0x02, 0x84, 0xe6, 0x11, 0xd4, 0x90, 0xdb, 0x00, 0x10, 0x4b, 0x9b, 0x4b, 0x7d};
static const char capIs2001[]    = {0x2e, 0x7a, 0x64, 0x75, 0xfa, 0xdf, 0x4d, 0xc8, 0x88, 0x6f, 0xea, 0x35, 0x95, 0xfd, 0xb6, 0xdf};
static const char capIs2002[]    = {0x10, 0xcf, 0x40, 0xd1, 0x4c, 0x7f, 0x11, 0xd1, 0x82, 0x22, 0x44, 0x45, 0x53, 0x54, 0x00, 0x00};
static const char capComm20012[] = {0xa0, 0xe9, 0x3f, 0x37, 0x4c, 0x7f, 0x11, 0xd1, 0x82, 0x22, 0x44, 0x45, 0x53, 0x54, 0x00, 0x00};
static const char capStrIcq[]    = {0xa0, 0xe9, 0x3f, 0x37, 0x4f, 0xe9, 0xd3, 0x11, 0xbc, 0xd2, 0x00, 0x04, 0xac, 0x96, 0xdd, 0x96};
//static const char capAimIcon[] = {0x09, 0x46, 0x13, 0x46, 0x4c, 0x7f, 0x11, 0xd1, 0x82, 0x22, 0x44, 0x45, 0x53, 0x54, 0x00, 0x00}; // CAP_AIM_BUDDYICON
//static const char capAimDirect = {0x09, 0x46, 0x13, 0x45, 0x4c, 0x7f, 0x11, 0xd1, 0x82, 0x22, 0x44, 0x45, 0x53, 0x54, 0x00, 0x00}; // CAP_AIM_DIRECTIM
//static const char capAimFileShare[] = {0x09, 0x46, 0x13, 0x48, 0x4c, 0x7f, 0x11, 0xd1, 0x82, 0x22, 0x44, 0x45, 0x53, 0x54, 0x00, 0x00}; // CAP_AIM_FILE_SHARE
static const char capIcqLite[]   = {0x17, 0x8C, 0x2D, 0x9B, 0xDA, 0xA5, 0x45, 0xBB, 0x8D, 0xDB, 0xF3, 0xBD, 0xBD, 0x53, 0xA1, 0x0A};
static const char capAimChat[]   = {0x74, 0x8F, 0x24, 0x20, 0x62, 0x87, 0x11, 0xD1, 0x82, 0x22, 0x44, 0x45, 0x53, 0x54, 0x00, 0x00};
static const char capUim[]       = {0xA7, 0xE4, 0x0A, 0x96, 0xB3, 0xA0, 0x47, 0x9A, 0xB8, 0x45, 0xC9, 0xE4, 0x67, 0xC5, 0x6B, 0x1F};
static const char capRambler[]   = {0x7E, 0x11, 0xB7, 0x78, 0xA3, 0x53, 0x49, 0x26, 0xA8, 0x02, 0x44, 0x73, 0x52, 0x08, 0xC4, 0x2A};
static const char capAbv[]       = {0x00, 0xE7, 0xE0, 0xDF, 0xA9, 0xD0, 0x4F, 0xe1, 0x91, 0x62, 0xC8, 0x90, 0x9A, 0x13, 0x2A, 0x1B};
static const char capNetvigator[]= {0x4C, 0x6B, 0x90, 0xA3, 0x3D, 0x2D, 0x48, 0x0E, 0x89, 0xD6, 0x2E, 0x4B, 0x2C, 0x10, 0xD9, 0x9F};
static const char captZers[]     = {0xb2, 0xec, 0x8f, 0x16, 0x7c, 0x6f, 0x45, 0x1b, 0xbd, 0x79, 0xdc, 0x58, 0x49, 0x78, 0x88, 0xb9}; // CAP_TZERS
static const char capHtmlMsgs[]  = {0x01, 0x38, 0xca, 0x7b, 0x76, 0x9a, 0x49, 0x15, 0x88, 0xf2, 0x13, 0xfc, 0x00, 0x97, 0x9e, 0xa8}; // icq6 html msgs
static const char capLiveVideo[] = {0x09, 0x46, 0x01, 0x01, 0x4c, 0x7f, 0x11, 0xd1, 0x82, 0x22, 0x44, 0x45, 0x53, 0x54, 0x00, 0x00}; // icq6 live video
static const char capSimpLite[]  = {0x53, 0x49, 0x4D, 0x50, 0x53, 0x49, 0x4D, 0x50, 0x53, 0x49, 0x4D, 0x50, 0x53, 0x49, 0x4D, 0x50};
static const char capSimpPro[]   = {0x53, 0x49, 0x4D, 0x50, 0x5F, 0x50, 0x52, 0x4F, 0x53, 0x49, 0x4D, 0x50, 0x5F, 0x50, 0x52, 0x4F};
static const char capIMsecure[]  = {'I', 'M', 's', 'e', 'c', 'u', 'r', 'e', 'C', 'p', 'h', 'r', 0x00, 0x00, 0x06, 0x01}; // ZoneLabs
static const char capMsgType2[]  = {0x09, 0x49, 0x13, 0x49, 0x4c, 0x7f, 0x11, 0xd1, 0x82, 0x22, 0x44, 0x45, 0x53, 0x54, 0x00, 0x00};
static const char capAimIcq[]	 = {0x09, 0x46, 0x13, 0x4D, 0x4C, 0x7F, 0x11, 0xD1, 0x82, 0x22, 0x44, 0x45, 0x53, 0x54, 0x00, 0x00};
static const char capAimVoice[]  = {0x09, 0x46, 0x13, 0x41, 0x4c, 0x7f, 0x11, 0xd1, 0x82, 0x22, 0x44, 0x45, 0x53, 0x54, 0x00, 0x00};
static const char capAimAudio[]  = {0x09, 0x46, 0x01, 0x04, 0x4c, 0x7f, 0x11, 0xd1, 0x82, 0x22, 0x44, 0x45, 0x53, 0x54, 0x00, 0x00}; //added to ICQ 6 & AIM 6
static const char capPalmJicq[]  = {'J', 'I', 'C', 'Q', 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
static const char capInluxMsgr[] = {0xA7, 0xE4, 0x0A, 0x96, 0xB3, 0xA0, 0x47, 0x9A, 0xB8, 0x45, 0xC9, 0xE4, 0x67, 0xC5, 0x6B, 0x1F};
static const char capMipClient[] = {0x4D, 0x49, 0x50, 0x20, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
static const char capIMadering[] = {'I', 'M', 'a', 'd', 'e', 'r', 'i', 'n', 'g', ' ', 'C', 'l', 'i', 'e', 'n', 't'};
static const char capDigsbyBeta[]= {0x09, 0x46, 0x01, 0x05, 0x4c, 0x7f, 0x11, 0xd1, 0x82, 0x22, 0x44, 0x45, 0x45, 0x53, 0x54, 0x00};
static const char capJapp[]      = {0x6a, 0x61, 0x70, 0x70, 0xa9, 0x20, 0x62, 0x79, 0x20, 0x53, 0x65, 0x72, 0x67, 0x6f, 0x00, 0x00};
static const char capQutIm[]     = {'q', 'u', 't', 'i', 'm', 0x30, 0x2e, 0x31, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};
static const char capJabberJIT[] = {'J', 'I', 'T', ' ', 0x76, 0x2E, 0x31, 0x2E, 0x78, 0x2E, 0x78, 0x00, 0x00, 0x00, 0x00, 0x00};

static const char capAimAddins[] = {0x09, 0x46, 0x13, 0x47, 0x4c, 0x7f, 0x11, 0xd1, 0x82, 0x22, 0x44, 0x45, 0x53, 0x54, 0x00, 0x00};
static const char capAimContactSnd[]= {0x09, 0x46, 0x13, 0x4b, 0x4c, 0x7f, 0x11, 0xd1, 0x82, 0x22, 0x44, 0x45, 0x53, 0x54, 0x00, 0x00};
static const char capAimUnk2[]   = {0x09, 0x46, 0x01, 0x02, 0x4c, 0x7f, 0x11, 0xd1, 0x82, 0x22, 0x44, 0x45, 0x53, 0x54, 0x00, 0x00};
static const char capAimSendbuddylist[] = {0x09, 0x46, 0x00, 0x00, 0x4c, 0x7f, 0x11, 0xd1, 0x82, 0x22, 0x44, 0x45, 0x53, 0x54, 0x13, 0x4B};

static const char capIMSecKey1[] = {1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}; // ZoneLabs
static const char capIMSecKey2[] = {2, 2, 2, 2, 2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}; // ZoneLabs


typedef struct tagSTDCAPINFO
{
	const char *name;
	int img;
	const char *caps;
	int capSize;
} STDCAPINFO;

//    
static STDCAPINFO clientDB[] = {
	{"SieICQ",			        IMG_SIEICQ,	capSieICQ,	        6},
	{"NatICQ",			        IMG_NATICQ,	capNatICQ,	        6},
	{"QuitIm",			        IMG_QUTIM,	capQutIM,	        5},
	{"Pidgin",			        IMG_PIDGIN,	capPidgin,	        13},
	{"Miranda IM",			        IMG_MIRANDA,	capMirandaIm,		8},
	{"Miranda IM Mobile",		        IMG_MIRANDA,	capMirandaMobile,	13},
	{"Miranda IM Custom Pack",	        IMG_MIRANDA,	capMimPack,		4},
	{"Miranda ICQJ eternity/PlusPlus++",    IMG_MIRANDA,	capIcqJen,         	4},
	{"Miranda ICQJ S7&SSS OLD",	        IMG_MIRANDA,	capIcqJs7old,		16},
	{"Miranda ICQJ S7&SSS + SecureIM",      IMG_MIRANDA,	capIcqJs7s,		16},
	{"Miranda ICQJ S7&SSS",		        IMG_MIRANDA,	capIcqJs7,		4},
	{"Miranda ICQJ Plus",			IMG_MIRANDA,	capIcqJp,		4},
	{"Miranda ICQJ S!N",			IMG_MIRANDA,	capIcqJSin,		4},
	{"AIM Oscar",				IMG_ICQ,	capAimOscar,		8},
	{"IMadering Client",			IMG_UNKNOW,	capIMadering,       	0x10},
	{"Trillian",				IMG_TRILLIAN,	capTrillian,		16},
	{"Trillian Crypt",			IMG_TRILLIAN,	capTrilCrypt,		16},
	{"SIM",					IMG_SIM,	capSim,			0xC},
	{"SIM (old)",				IMG_SIM,	capSimOld,		0xF},
	{"Licq",				IMG_UNKNOW,	capLicq,		0xC},
	{"Kopete",				IMG_KOPETE,	capKopete,		0xC},
	{"mICQ",				IMG_UNKNOW,	capmIcq,		0xC},
	{"&RQ",					IMG_UNKNOW,	capAndRQ,		9},
	{"R&Q",					IMG_UNKNOW,	capRAndQ,		9},
	{"mChat",				IMG_UNKNOW,	capmChat,		0xA},
	{"Jimm",				IMG_JIMM,	capJimm,		5},
	{"Yapp",				IMG_UNKNOW,	capYapp,		4},
	{"Naim",				IMG_UNKNOW,	capNaim,		8},
	{"Anastacia",				IMG_UNKNOW,	capAnastasia,		16},
	{"JICQ",				IMG_UNKNOW,	capPalmJicq,		16},
	{"Inlux Messenger",			IMG_UNKNOW,	capInluxMsgr,		16},
	{"MIP Client",				IMG_UNKNOW,	capMipClient,		0xC},
	{"QIP 2005a",				IMG_QIP,	capQip,			16},
	{"QIP Infium",				IMG_QIP_INFINUM,capQipInfium,		16},
	{"QIP Infium Plugins",			IMG_QIP_INFINUM,capQipPlugins, 		16},
	{"QIP PDA",				IMG_QIP,	capQipPDA,		16},
	{"QIP Mobile (Java)",			IMG_QIP,	capQipMobile,		16},
	{"QIP Mobile (Symbian)",		IMG_QIP,	capQipSymbian,		16},
	{"VmICQ (Symbian)",			IMG_UNKNOW,	capVmICQ,		6},
	{"QIP ProtectMsg",			IMG_UNKNOW,	capQip_1,		16},
	{"IM2",					IMG_UNKNOW,	capIm2,			16},
	{"ICQ for Mac",				IMG_ICQ,	capMacIcq,		16},
	{"ICQ 2001",				IMG_ICQ,	capIs2001,		16},
	{"ICQ 2002",				IMG_ICQ,	capIs2002,		16},
	{"Comm20012",				IMG_UNKNOW,	capComm20012,		16},
	{"StrICQ",				IMG_UNKNOW,	capStrIcq,		16},
	{"ICQ Lite",				IMG_ICQ,	capIcqLite,		16},
	{"AIM Chat",				IMG_UNKNOW,	capAimChat,		16},
	{"UIM",					IMG_UNKNOW,	capUim,			16},
	{"Rambler ICQ",				IMG_RAMBLER_ICQ,capRambler,		16},
	{"ABV ICQ",				IMG_UNKNOW,	capAbv,			16},
	{"Netvigator ICQ",			IMG_UNKNOW,	capNetvigator,		16},
	{"ICQ 6 (HTML)",			IMG_ICQ,	capHtmlMsgs,		16}, // icq6
	{"Live Video",				IMG_UNKNOW,	capLiveVideo,		16},
	{"Simp Lite",				IMG_UNKNOW,	capSimpLite,		16},
	{"Simp Pro",				IMG_UNKNOW,	capSimpPro,		16},
	{"IMsecure (ZoneLabs)",			IMG_UNKNOW,	capIMsecure,		16}, // ZoneLabs
	{"Messages Type 2 support",		IMG_UNKNOW,	capMsgType2,		16},
	{"Aim Voice Chat",			IMG_UNKNOW,	capAimVoice,		16},
	{"Live Audio (new VoiceChat)",		IMG_UNKNOW,	capAimAudio,		16},
	{"climm Client",			IMG_UNKNOW,	capClimm,		0xC},
	{"IM+ Client",				IMG_UNKNOW,	capIMPlus,		16},
	{"mChct Client",                        IMG_UNKNOW,	capmChat,       	0xA},
	{"SmapeR Client",			IMG_UNKNOW,	capSmapeR,		0x07},
	{"CORE Pager Client",			IMG_UNKNOW,	capCorePager,		0xA},
	{"Zone Alarm IMsecure Key 1",		IMG_UNKNOW,	capIMSecKey1,		5},
	{"Zone Alarm IMsecure Key 2",		IMG_UNKNOW,	capIMSecKey2,		5}
};

/*
   -    
{// IconName                Mask                	Icon caption          	NULL  ICON_RESOURCE_ID

{"client_AgileMessenger",  	"Agile Messenger*",     "Agile Messenger",      NULL, IDI_CLIENTAGILE,0xFF,4},
	{"client-Anastasia",        "*Anastasia*",          "Anastasia",            NULL, IDI_CLIENTANASTASIA, 0xFF,4},
	{"client_Bombus",           "*Bombus*",             "Bombus",               NULL, IDI_CLIENTBOMBUS, 0xFF,4},
	{"client_Colibry",          "Colibry*",             "Colibry",              NULL, IDI_CLIENTCOLIBRY,0xFF,4},
	{"client_GTalkBlackBerry",	"ICS*",             	"GTalk on BlackBerry",  NULL, IDI_CLIENTGTBB,0xFF,4},
	{"client_Jimm",             "Jimm*",                "Jimm",                 NULL, IDI_CLIENTJIMM,0xFF,4},
	{"client_JICQ",             "JICQ*",                "JICQ",                 NULL, IDI_CLIENTJICQ,0xFF,4},
	{"client_Icq4pocket PC",    "ICQ*pocket*",          "ICQ 4 pocket PC",      NULL, IDI_CLIENTICQ4POCKET, 0xFF,4},
	{"client_IMPLUS",           "|IMPLUS*|IM+*",        "IM+",                  NULL, IDI_CLIENTIMPLUS,0xFF,4},
	{"client_Inlux_Messenger",  "Inlux Messenger*",     "Inlux Messenger",      NULL, IDI_CLIENTINLUX, 0xFF,4},
	{"client_mChat",            "mChat*",               "mChat",                NULL, IDI_CLIENTMCHAT, 0xFF,4},
	{"client_mip",            	"MIP*",               	"MIP",                	NULL, IDI_CLIENTMIP, 0xFF,4},
        {"client_PocketWeb",        "*Pocket Web*",       	"Pocket Web 1&1",       NULL, IDI_CLIENTPOCKETWEB,0xFF,4},
	{"client_PreludeICQ",       "PreludeICQ*",          "PreludeICQ",           NULL, IDI_CLIENTPRELUDEICQ, 0xFF,4},
	{"client_Sticq",            "stICQ*",               "stICQ",                NULL, IDI_CLIENTSTICQ,0xFF,4},
	{"client_uIM",              "uIM*",                 "uIM",                  NULL, IDI_CLIENTUIM,0xFF,4},
	{"client_YAMIGO",           "YAMIGO*",              "YamiGO",               NULL, IDI_CLIENTYAMIGO,0xFF,4},
	{"client-wmIRC",            "*wmIRC*",              "wmIRC",                NULL, IDI_CLIENTWMIRC, 0xFF,4},

	{"client_Adium X",          "Adium*",               "Adium X",              NULL, IDI_CLIENTADIUMX,0xFF,5},
	{"client_Auttm",            "Auttm*",               "Auttm",                NULL, IDI_CLIENTAUTTM,0xFF,5},
	{"client_BitlBee",          "*BitlBee",             "BitlBee",              NULL, IDI_CLIENTBITLBEE,0xFF,5},
	{"client_CenterICQ",        "*Centericq*",          "CenterICQ",            NULL, IDI_CLIENTCENTERICQ,0xFF,5},
	{"client_eBuddy",           "*eMessenger*",         "eBuddy",               NULL, IDI_CLIENTEBUDDY,0xFF,5},
	{"client_Easy message",     "Easy Message*",        "Easy Message",         NULL, IDI_EASY_MESSAGE,0xFF,5},
	{"client_Fire",             "Fire*",                "Fire",                 NULL, IDI_CLIENTFIRE,0xFF,5},
	{"client_Gaim",             "|*gaim*|*pidgin*",     "Gaim/Pidgin",          NULL, IDI_CLIENTPIDGIN,0xFF,5},
	{"client_GnomeICU",         "GnomeICU*",            "GnomeICU",             NULL, IDI_CLIENTGNOMEICU,0xFF,5},
	{"client_iChat",            "*iChat*",              "iChat",                NULL, IDI_CLIENTICHAT,0xFF,5},
	{"client_IM2",              "IM2*",                 "IM2",                  NULL, IDI_CLIENTIM2,0xFF,5},
	{"client_Instan-t",         "Instan-t*",            "Instan-t",             NULL, IDI_CLIENTINSTAN_T,0xFF,5},
	{"client_Kopete",           "Kopete*",              "Kopete",               NULL, IDI_CLIENTKOPETE,0xFF,5},
	{"client_Licq",             "Licq*",                "Licq",                 NULL, IDI_CLIENTLICQ,0xFF,5},
	{"client_MaxxIM",           "*Maxx*",             	"MaxxIM",               NULL, IDI_CLIENTMAXXIM,0xFF,5},
	{"client_Meebome",          "Meebome*",             "Meebome",              NULL, IDI_CLIENTMEEBOME,0xFF,5},
	{"client_Meebo",            "Meebo*",               "Meebo",                NULL, IDI_CLIENTMEEBO,0xFF,5},
	{"client_Proteus",          "Proteus*",             "Proteus",              NULL, IDI_CLIENTPROTEUS,0xFF,5},
	{"client_Qnext",            "QNext*",               "QNext",                NULL, IDI_CLIENTQNEXT,0xFF,5},
	{"client_SIM",              "SIM*",                 "SIM",                  NULL, IDI_CLIENTSIM,0xFF,5},
	{"client_spam bot",         "*Spam Bot*",           "Spam Bot",             NULL, IDI_CLIENTSPAMBOT,0xFF,5},
	{"client_Trillian Astra",   "Trillian*Astra*",      "Trillian Astra",       NULL, IDI_CLIENTTRILLIANASTRA,0xFF,5},
	{"client_Trillian pro",     "Trillian*Pro*",        "Trillian Pro",         NULL, IDI_CLIENTTRILLIANPRO,0xFF,5},
	{"client_Trillian",         "Trillian*",            "Trillian",             NULL, IDI_CLIENTTRILLIAN,0xFF,5},
	{"client_Virus",            "*Virus*",              "virus Win32-Stration", NULL, IDI_CLIENTVIRUS,0xFF,5},
    
	{"client_&RQ",              "&RQ*",                 "&RQ",                  NULL, IDI_CLIENTRQ,0xFF,1},
	{"client_alicq",            "Alicq*",               "alicq",                NULL, IDI_CLIENTALICQ,0xFF,1},
	{"client_ICat",             "IC@*",                 "IC@",                  NULL, IDI_CLIENTICAT, 0xFF,1},
	{"client_ICQ 2X",           "ICQ 2.x*",             "ICQ 2.X",              NULL, IDI_CLIENTICQ2X,0xFF,1},
	{"client_IMadering",        "IMadering*",           "IMadering",            NULL, IDI_CLIENTIMADERING,0xFF,1},
	{"client_KXicq2",           "KXicq2*",              "KXicq2",               NULL, IDI_CLIENTKXICQ2,0xFF,1},
	{"client_libicq2000",       "libicq*",              "LibICQ/JIT",           NULL, IDI_CLIENTLIBICQ2000,0xFF,1},
	{"client_mICQ",             "mICQ*",                "mICQ",                 NULL, IDI_CLIENTMICQ,0xFF,1},
	{"client_NanoICQ",          "NanoICQ*",             "NanoICQ",              NULL, IDI_CLIENTNANOICQ,0xFF,1},
	{"client_NICQ",             "NICQ*",                "NICQ",                 NULL, IDI_CLIENTNICQ,0xFF,1},
        {"client_PyICQ",            "|^*t*|PyICQ*",       	"PyICQ",                NULL, IDI_CLIENTPYICQ,0xFF,1},
	{"client_QIP_Infium",       "QIP Infium*",          "QIP Infium",           NULL, IDI_CLIENTQIPINFIUM,0xFF,1},
	{"client_QIP",              "QIP*",                 "QIP",                  NULL, IDI_CLIENTQIP,0xFF,1},
	{"client_R_and_Q",          "R&Q*",                 "R&Q",                  NULL, IDI_CLIENTR_and_Q, 0xFF,1},
	{"client_SmartIcq",         "SmartICQ*",            "SmartICQ",             NULL, IDI_CLIENTSMARTICQ, 0xFF,1},
	{"client_StrICQ",           "StrICQ*",              "StrICQ",               NULL, IDI_CLIENTSTRICQ,0xFF,1},
	{"client_TICQ",             "TICQ*",                "TICQ/delphi",          NULL, IDI_CLIENTTICQ, 0xFF,1},
	{"client_vICQ",             "vICQ*",                "./vICQ",               NULL, IDI_CLIENTVICQ,0xFF,1},
	{"client_YSM",              "YSM*",                 "YSM",                  NULL, IDI_CLIENTYSM,0xFF,1},
	{"client_Icq_abv",          "*Abv*",                "ICQ (ABV)",            NULL, IDI_CLIENTICQ_ABV, 0xFF,1},
	{"client_Icq_netvigator",   "*Netvigator*",         "ICQ (Netvigator)",     NULL, IDI_CLIENTICQ_NETVIGATOR, 0xFF,1},
	{"client_Icq_rambler",      "*Rambler*",            "ICQ (Rambler)",        NULL, IDI_CLIENTICQ_RAMBLER, 0xFF,1},
	{"client_WebICQ",           "WebICQ*",              "WebICQ",               NULL, IDI_CLIENTWEBICQ,0xFF,1},
 	{"client_ICQ",              "|ICQ*|PyICQ-t*|mobicq*","ICQ",     			NULL, IDI_CLIENTICQ,0xFF,1},

	{"client_MirandaD_u",       "|*Miranda IM 0.7*Unic*|*IM v0.7*", "Dev.build Unicode", NULL, IDI_CLIENTMIRANDADU,0xFF,6},
	{"client_Miranda0.6_u",     "|*Miranda IM 0.6*Unic*|*IM v0.6*", "Miranda IM 0.6.x Unicode", NULL, IDI_CLIENTMIRANDA06U,0xFF,6},
	{"client_Miranda0.5_u",     "|*Miranda IM 0.5*Unic*|*IM v0.5*", "Miranda IM 0.5.x Unicode", NULL, IDI_CLIENTMIRANDA05U,0xFF,6},
	{"client_Miranda_u",        "|*Miranda*Unic*|MIM*", "Miranda IM Unicode",   NULL, IDI_CLIENTMIRANDA06U,0xFF,6},

	{"client_Miranda_mobile",   "Miranda IM*Mobile*",    "Miranda IM Mobile",   NULL, IDI_CLIENTMIRANDAMOBILE,0xFF,6},
	{"client_MirandaD",         "|*Miranda IM 0.7*|*IM v0.7*", "Dev.build",        NULL, IDI_CLIENTMIRANDAD,0xFF,6},
	{"client_Miranda0.6",       "|*Miranda IM 0.6*|*IM v0.6*", "Miranda IM 0.6.x", NULL, IDI_CLIENTMIRANDA06,0xFF,6},
	{"client_Miranda0.5",       "|*Miranda IM 0.5*|*IM v0.5*", "Miranda IM 0.5.x", NULL, IDI_CLIENTMIRANDA05,0xFF,6},
	{"client_MirandaEvil",      "|*Miranda IM 6.6.6*|*IM v6.6.6*", "Miranda evil", NULL, IDI_CLIENTMIRANDA666,0xFF,6}, 
	{"client_Miranda0.4",       "|*Miranda IM 0.*|*IM v0.*","Miranda IM 0.4.x", NULL, IDI_CLIENTMIRANDA04,0xFF,6},
	{"client_MirandaISee",      "|*IM (ICQ*|*Miranda 0.*","Miranda ISee",		NULL, IDI_CLIENTMIRANDA06,0xFF,6},
	{"client_Miranda",          "|*Miranda*|MIM*",      "Miranda IM",           NULL, IDI_CLIENTMIRANDA06,0xFF,6},
*/



// capabilites
// 
static const char capSrvRelay[]  = {0x09, 0x46, 0x13, 0x49, 0x4c, 0x7f, 0x11, 0xd1, 0x82, 0x22, 0x44, 0x45, 0x53, 0x54, 0x00, 0x00};
static const char capUTF[]       = {0x09, 0x46, 0x13, 0x4e, 0x4c, 0x7f, 0x11, 0xd1, 0x82, 0x22, 0x44, 0x45, 0x53, 0x54, 0x00, 0x00};
static const char capRTF[]       = {0x97, 0xb1, 0x27, 0x51, 0x24, 0x3c, 0x43, 0x34, 0xad, 0x22, 0xd6, 0xab, 0xf7, 0x3f, 0x14, 0x92};
static const char capICQDirect[] = {0x09, 0x46, 0x13, 0x44, 0x4c, 0x7f, 0x11, 0xd1, 0x82, 0x22, 0x44, 0x45, 0x53, 0x54, 0x00, 0x00};
static const char capTyping[]    = {0x56, 0x3f, 0xc8, 0x09, 0x0b, 0x6f, 0x41, 0xbd, 0x9f, 0x79, 0x42, 0x26, 0x09, 0xdf, 0xa2, 0xf3};
static const char capXtraz[]     = {0x1A, 0x09, 0x3C, 0x6C, 0xD7, 0xFD, 0x4E, 0xC5, 0x9D, 0x51, 0xA6, 0x47, 0x4E, 0x34, 0xF5, 0xA0};
static const char capOscarFile[] = {0x09, 0x46, 0x13, 0x43, 0x4C, 0x7F, 0x11, 0xD1, 0x82, 0x22, 0x44, 0x45, 0x53, 0x54, 0x00, 0x00};

//    
/*
static const char capNewCap	  = {CAP_NEWCAP};
static const char capPush2Talk = {CAP_PUSH2TALK};
//// this is defined among all clients caps
////static const char capIcqLite   = {CAP_ICQ_LITE};
static const char capXtrazChat = {CAP_XTRAZ_CHAT};
static const char capVoiceChat = {CAP_VOICE_CHAT};
static const char capIcqDevil  = {CAP_ICQ_DEVIL};

const shortcapstr capAimIcon   = {0x13, 0x46}; // CAP_AIM_BUDDYICON
const shortcapstr capAimDirect = {0x13, 0x45}; // CAP_AIM_DIRECTIM
const shortcapstr capAimFileShare = {0x13, 0x48}; // CAP_AIM_FILE_SHARE
*/

// X statuses
#define XSTATUS_COUNT 37

static const char capXStatus[XSTATUS_COUNT * 0x10] = {
  0x01, 0xD8, 0xD7, 0xEE, 0xAC, 0x3B, 0x49, 0x2A, 0xA5, 0x8D, 0xD3, 0xD8, 0x77, 0xE6, 0x6B, 0x92,// XStatus(Angry)
  0x5A, 0x58, 0x1E, 0xA1, 0xE5, 0x80, 0x43, 0x0C, 0xA0, 0x6F, 0x61, 0x22, 0x98, 0xB7, 0xE4, 0xC7,// XStatus(Duck)
  0x83, 0xC9, 0xB7, 0x8E, 0x77, 0xE7, 0x43, 0x78, 0xB2, 0xC5, 0xFB, 0x6C, 0xFC, 0xC3, 0x5B, 0xEC,// XStatus(Tired)
  0xE6, 0x01, 0xE4, 0x1C, 0x33, 0x73, 0x4B, 0xD1, 0xBC, 0x06, 0x81, 0x1D, 0x6C, 0x32, 0x3D, 0x81,// XStatus(Party)
  0x8C, 0x50, 0xDB, 0xAE, 0x81, 0xED, 0x47, 0x86, 0xAC, 0xCA, 0x16, 0xCC, 0x32, 0x13, 0xC7, 0xB7,// XStatus(Beer)
  0x3F, 0xB0, 0xBD, 0x36, 0xAF, 0x3B, 0x4A, 0x60, 0x9E, 0xEF, 0xCF, 0x19, 0x0F, 0x6A, 0x5A, 0x7F,// XStatus(Thinking)
  0xF8, 0xE8, 0xD7, 0xB2, 0x82, 0xC4, 0x41, 0x42, 0x90, 0xF8, 0x10, 0xC6, 0xCE, 0x0A, 0x89, 0xA6,// XStatus(Eating)
  0x80, 0x53, 0x7D, 0xE2, 0xA4, 0x67, 0x4A, 0x76, 0xB3, 0x54, 0x6D, 0xFD, 0x07, 0x5F, 0x5E, 0xC6,// XStatus(TV)
  0xF1, 0x8A, 0xB5, 0x2E, 0xDC, 0x57, 0x49, 0x1D, 0x99, 0xDC, 0x64, 0x44, 0x50, 0x24, 0x57, 0xAF,// XStatus(Friends)
  0x1B, 0x78, 0xAE, 0x31, 0xFA, 0x0B, 0x4D, 0x38, 0x93, 0xD1, 0x99, 0x7E, 0xEE, 0xAF, 0xB2, 0x18,// XStatus(Coffee)
  0x61, 0xBE, 0xE0, 0xDD, 0x8B, 0xDD, 0x47, 0x5D, 0x8D, 0xEE, 0x5F, 0x4B, 0xAA, 0xCF, 0x19, 0xA7,// XStatus(Music)
  0x48, 0x8E, 0x14, 0x89, 0x8A, 0xCA, 0x4A, 0x08, 0x82, 0xAA, 0x77, 0xCE, 0x7A, 0x16, 0x52, 0x08,// XStatus(Business)
  0x10, 0x7A, 0x9A, 0x18, 0x12, 0x32, 0x4D, 0xA4, 0xB6, 0xCD, 0x08, 0x79, 0xDB, 0x78, 0x0F, 0x09,// XStatus(Camera)
  0x6F, 0x49, 0x30, 0x98, 0x4F, 0x7C, 0x4A, 0xFF, 0xA2, 0x76, 0x34, 0xA0, 0x3B, 0xCE, 0xAE, 0xA7,// XStatus(Funny)
  0x12, 0x92, 0xE5, 0x50, 0x1B, 0x64, 0x4F, 0x66, 0xB2, 0x06, 0xB2, 0x9A, 0xF3, 0x78, 0xE4, 0x8D,// XStatus(Phone)
  0xD4, 0xA6, 0x11, 0xD0, 0x8F, 0x01, 0x4E, 0xC0, 0x92, 0x23, 0xC5, 0xB6, 0xBE, 0xC6, 0xCC, 0xF0,// XStatus(Games)
  0x60, 0x9D, 0x52, 0xF8, 0xA2, 0x9A, 0x49, 0xA6, 0xB2, 0xA0, 0x25, 0x24, 0xC5, 0xE9, 0xD2, 0x60,// XStatus(College)
  0x63, 0x62, 0x73, 0x37, 0xA0, 0x3F, 0x49, 0xFF, 0x80, 0xE5, 0xF7, 0x09, 0xCD, 0xE0, 0xA4, 0xEE,// XStatus(Shopping)
  0x1F, 0x7A, 0x40, 0x71, 0xBF, 0x3B, 0x4E, 0x60, 0xBC, 0x32, 0x4C, 0x57, 0x87, 0xB0, 0x4C, 0xF1,// XStatus(Sick)
  0x78, 0x5E, 0x8C, 0x48, 0x40, 0xD3, 0x4C, 0x65, 0x88, 0x6F, 0x04, 0xCF, 0x3F, 0x3F, 0x43, 0xDF,// XStatus(Sleeping)
  0xA6, 0xED, 0x55, 0x7E, 0x6B, 0xF7, 0x44, 0xD4, 0xA5, 0xD4, 0xD2, 0xE7, 0xD9, 0x5C, 0xE8, 0x1F,// XStatus(Surfing)
  0x12, 0xD0, 0x7E, 0x3E, 0xF8, 0x85, 0x48, 0x9E, 0x8E, 0x97, 0xA7, 0x2A, 0x65, 0x51, 0xE5, 0x8D,// XStatus(@)
  0xBA, 0x74, 0xDB, 0x3E, 0x9E, 0x24, 0x43, 0x4B, 0x87, 0xB6, 0x2F, 0x6B, 0x8D, 0xFE, 0xE5, 0x0F,// XStatus(Engineering)
  0x63, 0x4F, 0x6B, 0xD8, 0xAD, 0xD2, 0x4A, 0xA1, 0xAA, 0xB9, 0x11, 0x5B, 0xC2, 0x6D, 0x05, 0xA1,// XStatus(Typing)
  //Netvigator (China)
  0x2C, 0xE0, 0xE4, 0xE5, 0x7C, 0x64, 0x43, 0x70, 0x9C, 0x3A, 0x7A, 0x1C, 0xE8, 0x78, 0xA7, 0xDC,// XStatus(China1)
  0x10, 0x11, 0x17, 0xC9, 0xA3, 0xB0, 0x40, 0xF9, 0x81, 0xAC, 0x49, 0xE1, 0x59, 0xFB, 0xD5, 0xD4,// XStatus(China2)
  0x16, 0x0C, 0x60, 0xBB, 0xDD, 0x44, 0x43, 0xF3, 0x91, 0x40, 0x05, 0x0F, 0x00, 0xE6, 0xC0, 0x09,// XStatus(China3)
  0x64, 0x43, 0xC6, 0xAF, 0x22, 0x60, 0x45, 0x17, 0xB5, 0x8C, 0xD7, 0xDF, 0x8E, 0x29, 0x03, 0x52,// XStatus(China4)
  0x16, 0xF5, 0xB7, 0x6F, 0xA9, 0xD2, 0x40, 0x35, 0x8C, 0xC5, 0xC0, 0x84, 0x70, 0x3C, 0x98, 0xFA,// XStatus(China5)
  //ProSieben (De)
  0x63, 0x14, 0x36, 0xff, 0x3f, 0x8a, 0x40, 0xd0, 0xa5, 0xcb, 0x7b, 0x66, 0xe0, 0x51, 0xb3, 0x64,// XStatus(De1)
  0xb7, 0x08, 0x67, 0xf5, 0x38, 0x25, 0x43, 0x27, 0xa1, 0xff, 0xcf, 0x4c, 0xc1, 0x93, 0x97, 0x97,// XStatus(De2)
  0xdd, 0xcf, 0x0e, 0xa9, 0x71, 0x95, 0x40, 0x48, 0xa9, 0xc6, 0x41, 0x32, 0x06, 0xd6, 0xf2, 0x80,// XStatus(De3)
  //Rambler (Ru)                                                                                   
  0xD4, 0xE2, 0xB0, 0xBA, 0x33, 0x4E, 0x4F, 0xA5, 0x98, 0xD0, 0x11, 0x7D, 0xBF, 0x4D, 0x3C, 0xC8,// XStatus(Ru1)
  0xCD, 0x56, 0x43, 0xA2, 0xC9, 0x4C, 0x47, 0x24, 0xB5, 0x2C, 0xDC, 0x01, 0x24, 0xA1, 0xD0, 0xCD,// XStatus(Ru2)
  0x00, 0x72, 0xD9, 0x08, 0x4A, 0xD1, 0x43, 0xDD, 0x91, 0x99, 0x6F, 0x02, 0x69, 0x66, 0x02, 0x6F,// XStatus(Ru3)
  //RnQ
  0xe6, 0x01, 0xe4, 0x1c, 0x33, 0x73, 0x4b, 0xd1, 0xbc, 0x06, 0x81, 0x1d, 0x6c, 0x32, 0x3d, 0x82,// XStatus(Smoking)
  0xd6, 0x68, 0x7f, 0x4f, 0x3d, 0xc3, 0x4b, 0xdb, 0x8a, 0x8c, 0x4c, 0x1a, 0x57, 0x27, 0x63, 0xcd};//XStatus(Sex)

static const char* nameXStatus[XSTATUS_COUNT] = {
  "Angry",
  "Taking a bath",
  "Tired",
  "Party",
  "Drinking beer",
  "Thinking",
  "Eating",
  "Watching TV",
  "Meeting",
  "Coffee",
  "Listening to music",
  "Business",
  "Shooting",
  "Having fun",
  "On the phone",
  "Gaming",
  "Studying",
  "Shopping",
  "Feeling sick",
  "Sleeping",
  "Surfing",
  "Browsing",
  "Working",
  "Typing",
  //Netvigator (China)
  "Picnic",
  "Cooking",
  "Mobile",
  "I'm high",
  "On WC",
  //ProSieben (De)
  "To be or not to be",
  "Watching pro7 on TV",
  "Love",  
  //Rambler (Ru)  
  "Searching",
  "Love",
  "Journal",
  //RnQ
  "Sex",
  "Smoking"};



int FindCapabilities(char * buf, int len, char const * cap);
int FindXStatus(char * buf, int len);

int ClientID(char * buf, int len);


#endif /* __CAPABILITIES_H */
