import javax.microedition.rms.*;
import javax.microedition.midlet.*;
import javax.microedition.lcdui.*;
import javax.microedition.io.*;
import java.io.*;
import com.siemens.mp.io.file.*;

public class SSST extends MIDlet implements CommandListener, Runnable
{
 //Ошибки при инициализации
 public final int ASPACE_RET_SUCCESS      =  1;  
 public final int ASPACE_RET_UNKNOWNERROR =  0;  
 public final int ASPACE_RET_NOZIPFILE    = -1; 
 public final int ASPACE_RET_NOZIPENTRY   = -2; 
 public final int ASPACE_RET_SIGNOFIND    = -3; 
 
 /* Найденное API для внутренних нужд бинарника */
 
 public int malloc_address          = 0; 
 public int free_address            = 0; 
 public int read_address            = 0; 
 public int write_address           = 0; 
 public int getgbsprocess_address   = 0; 
 
 
 /* HASH && ESN */
 
  public final int    hash_address        = 0xA0000238; 
  public       byte[] hash_body           = new byte[16];
  public       int    esn_key             = 0;
  public       byte[] esn_body            = new byte[4];
  public       byte[] esn_body_papuas     = new byte[4];
 /* Дополнительные данные */
 
 public final int target_cepid           = 0x4008; 
 public final int onmsghandler_offset    = 0x3C; 
 public       int target_onmsghandler    = 0; 
 public       int melfloaderbody_address = 0;   
 public       int swilib_address         = 0;
 public       int read_swinum            = 0x0B;
 public       int write_swinum           = 0x0C;
    
 /* Поиск API: Шаблоны кода ф-ий для поиска во Flash */
 
 //Переменный байт
 public final int ASSB =  -1; 
 

 //__arm void *malloc(unsigned int size)
 
 //Шаблон
 public final int[] malloc_pattern = 
  {
   /* 0x00, 0x10, 0xA0, 0xE1, */0xE1A01000,
   /* 0x02, 0x00, 0xA0, 0xE3, */0xE3A00002,
   /* ASSB, ASSB, ASSB, ASSB, */ASSB,
   /* 0x70, 0x40, 0x2D, 0xE9, */0xE92D4070,
   /* 0x00, 0x40, 0xA0, 0xE1, */0xE1A04000,
   /* 0x02, 0x00, 0xA0, 0xE3, */0xE3A00002,
   /* 0x01, 0x60, 0xA0, 0xE1, */0xE1A06001,
   /* ASSB, ASSB, ASSB, ASSB, */ASSB,
   /* 0x00, 0x50, 0xA0, 0xE1, */0xE1A05000,
   /* 0x00, 0x00, 0x54, 0xE3, */0xE3540000,
   /* 0x00, 0x00, 0x55, 0x13  */0x13550000
 };

 //Дополнительное смещение
 public final int malloc_pattern_offset = 0; 
 
 //__arm void free(void *)
 //Шаблон
 public final int[] free_pattern = 
  {
   /* 0x00, 0x00, 0x50, 0xE3, */0xE3500000,
   /* ASSB, ASSB, ASSB, ASSB, */ASSB,
   /* 0x1E, 0xFF, 0x2F, 0xE1, */0xE12FFF1E,
   /* 0x04, 0xE0, 0x2D, 0xE5, */0xE52DE004,
   /* 0x3C, 0xD0, 0x4D, 0xE2, */0xE24DD03C,
   /* 0x18, 0x30, 0x8D, 0xE2, */0xE28D3018,
   /* 0x1C, 0x20, 0x8D, 0xE2, */0xE28D201C,
   /* 0x20, 0x10, 0x8D, 0xE2, */0xE28D1020,
   /* 0x38, 0x00, 0x8D, 0xE2, */0xE28D0038,
   /* 0x0F, 0x00, 0x8D, 0xE9, */0xE98D000F
  };
 //Дополнительное смещение
 public final int free_pattern_offset = 0; 
 
 //__arm int read(int FileHandler, void *cBuffer, 
 //               int iByteCount, unsigned int *ErrorNumber)
 //Шаблон
 public final int[] read_pattern = 
  {
   /* 0xFE, 0x40, 0x2D, 0xE9, */0xE92D40FE,
   /* 0x02, 0x70, 0xA0, 0xE1, */0xE1A07002,
   /* 0x01, 0x60, 0xA0, 0xE1, */0xE1A06001,
   /* 0x03, 0x50, 0xA0, 0xE1, */0xE1A05003,
   /* 0x00, 0x40, 0xA0, 0xE1, */0xE1A04000,
   /* ASSB, ASSB, ASSB, ASSB, */ASSB,
   /* 0x00, 0x30, 0xE0, 0xE3, */0xE3E03000,
   /* 0x04, 0x30, 0x8D, 0xE5, */0xE58D3004,
   /* 0x00, 0x50, 0x8D, 0xE5, */0xE58D5000,
   /* 0x30, 0xC0, 0x90, 0xE5, */0xE590C030,
   /* 0x00, 0x00, 0xA0, 0xE3, */0xE3A00000,
   /* 0x07, 0x30, 0xA0, 0xE1, */0xE1A03007,
   /* 0x06, 0x20, 0xA0, 0xE1, */0xE1A02006,
   /* 0x04, 0x10, 0xA0, 0xE1, */0xE1A01004,
   /* 0x3C, 0xFF, 0x2F, 0xE1, */0xE12FFF3C,
   /* 0xFE, 0x80, 0xBD, 0xE8, */0xE8BD80FE
  };
 //Дополнительное смещение
 public final int read_pattern_offset = 0; 
 
 //unsigned int write(int FileHandler, char * cBuffer, 
 //                   int iByteCount, unsigned int *ErrorNumber)
 //Шаблон
 public final int[] write_pattern = 
  {
   /* 0xFE, 0x40, 0x2D, 0xE9, */0xE92D40FE,
   /* 0x02, 0x70, 0xA0, 0xE1, */0xE1A07002,
   /* 0x01, 0x60, 0xA0, 0xE1, */0xE1A06001,
   /* 0x03, 0x50, 0xA0, 0xE1, */0xE1A05003,
   /* 0x00, 0x40, 0xA0, 0xE1, */0xE1A04000,
   /* ASSB, ASSB, ASSB, ASSB, */ASSB,
   /* 0x00, 0x30, 0xE0, 0xE3, */0xE3E03000,
   /* 0x04, 0x30, 0x8D, 0xE5, */0xE58D3004,
   /* 0x00, 0x50, 0x8D, 0xE5, */0xE58D5000,
   /* 0x5C, 0xC0, 0x90, 0xE5, */0xE590C05C,
   /* 0x00, 0x00, 0xA0, 0xE3, */0xE3A00000,
   /* 0x07, 0x30, 0xA0, 0xE1, */0xE1A03007,
   /* 0x06, 0x20, 0xA0, 0xE1, */0xE1A02006,
   /* 0x04, 0x10, 0xA0, 0xE1, */0xE1A01004,
   /* 0x3C, 0xFF, 0x2F, 0xE1, */0xE12FFF3C,
   /* 0xFE, 0x80, 0xBD, 0xE8, */0xE8BD80FE
  };
 //Дополнительное смещение
 public final int write_pattern_offset = 0; 
 
 //__arm GBSPROC *GetGBSProcAddress(unsigned short)
 //Шаблон
 public final int[] getgbsprocess_pattern = 
  {
   /* 0x04, 0xE0, 0x2D, 0xE5, */0xE52DE004,
   /* 0x00, 0x20, 0xA0, 0xE1, */0xE1A02000,
   /* ASSB, ASSB, ASSB, ASSB, */ASSB,
   /* 0x00, 0x10, 0xA0, 0xE3, */0xE3A01000,
   /* 0x00, 0x00, 0x50, 0xE3, */0xE3500000,
   /* ASSB, ASSB, ASSB, ASSB, */ASSB,
   /* 0x04, 0x30, 0x90, 0xE5, */0xE5903004
  };
 //Дополнительное смещение
 public final int getgbsprocess_pattern_offset = 0; 
 
 
    
 /* Основные параметры приложения */
 
 public SSST ptc;
 public Display display;
 public ASpace  aspace;
  
 public String app_name        = "SSST";
 public String app_desc        = "Siemens SGold Service Tool";
 public String app_ver         = "1.2";
 public String app_zip_temp    = "file:///0:/ZipTemp.class";
 
 public String app_mel_path    = "/bin/melfloader.arm";
 public String app_bin_path    = "/bin/";
 public String app_def_el      = "jelfloader.elf";
 
 public String app_logo_path   = "/img/logo.png";

 
 public String app_db_rms      = "phoneapi";  
 public String app_pn_rms      = ""; 
 
 /* GUI параметры приложения */
 
 //Форма "Инициализация"
 public Form      init_form;
 public Command   init_cmd_start, init_cmd_menu, init_cmd_exit;
 
 //Список "Меню"
 public List      mainmenu_list;
 public Image     mainmenu_list_img_elfloader;
 public Image     mainmenu_list_img_esnhash;
 public Image     mainmenu_list_img_patcher;
 public Image     mainmenu_list_img_dumper;
 public Image     mainmenu_list_img_about;
 public Image     mainmenu_list_img_exit;
 public Command   mainmenu_list_cmd_select;
 public boolean   mainmenu_list_is_created;
 
 //Форма "Дампер"
 public Form      dumper_form;
 public Command   dumper_cmd_dump, dumper_cmd_cancel, dumper_cmd_back;
    
 public TextField dumper_tf_dumpfilpath,dumper_tf_dumpaddress,dumper_tf_dumpsize;
 public Gauge     dumper_gauge_progressbar;
 public byte[]    dumper_temp_buffer;
 public boolean   dumper_dumping_isactive, dumper_dumping_isend;
 
 //Форма "ELF-Загрузчик"
 public Form        elfloader_form;
 public Command     elfloader_cmd_load, elfloader_cmd_back;
 public TextField   elfloader_tf_elffile, elfloader_tf_swiblibpath;
 public ChoiceGroup elfloader_ch_patch;
 public boolean[]   elfloader_ch_patches_ena = {true, true, true};
 public boolean     elfloader_loading;
 public byte[]      elfloader_swilib;
 
 public final int   PE_ESI     = 0;
 public final int   PE_KEYHOOK = 1;
 public final int   PE_PIT     = 2;
 
  //Форма "ESN и HASH"
 public Form      esnhash_form;
 public Command   esnhash_cmd_start, esnhash_cmd_back;
 public boolean   esnhash_is_created;
 
 //Форма "Патчер"
 public Form      patcher_form;
 public Command   patcher_cmd_back;
 
 //Форма "Авторы"
 public Form      about_form;
 public Command   about_cmd_back;
 public boolean   about_is_created;
 
 
 /* Управление субпотоком */
 
 public Thread    subthread;
 public int       subthread_item           = 0;
 public final int subthread_nop            = 0;
 public final int subthread_init           = 1;
 public final int subthread_dumping        = 2;
 public final int subthread_elfloading     = 3;
 public final int subthread_esnhashreading = 4;
  
 private String GetPhoneName() 
  {
   return new String(System.getProperty("microedition.platform") + "v" +
                     System.getProperty("com.siemens.OSVersion")); 
  }
 
 private String ToHexView(byte[] b, int n) 
  {

	byte[] out = new byte[64];
        byte[] digits = { '0','1','2','3','4',
                          '5','6','7','8','9',
                          'A','B','C','D','E','F' };

	int j = 0;
	for (int i=0; i<n;) {
		int v = b[i];
		out[j++] = digits[(v >> 4) & 0xf];
		out[j++] = digits[v & 0xf];
		if (++i == n) break;
	}

	return new String(out, 0, j);

   }
 
 
 public SSST() 
  {
  	ptc = this;
	display = Display.getDisplay(this);
        aspace = new ASpace();
  }
 
 

/* RMS: Сохранение / Загрузка найденный функций API */
    
 private void api_rms_clean() 
  {  
   try 
     {
       String[] as = RecordStore.listRecordStores();
       if (as == null || as.length == 0)
         {
             return;
         }
       
    for (int i = 0; i < as.length; i++)
     {
        try 
          { 
             RecordStore.deleteRecordStore(as[i]);
          } catch (Throwable re) { }
     }
    } catch (Throwable re) { }
        
  }
 
 private int api_rms_store() 
  {  
      RecordStore rs = null;  
       try {  
           
              rs = RecordStore.openRecordStore(app_db_rms, 
                      true, RecordStore.AUTHMODE_ANY, true);
              
              ByteArrayOutputStream baos = new ByteArrayOutputStream();  
              DataOutputStream dos = new DataOutputStream(baos);  
               
              dos.writeInt(malloc_address);  
              dos.writeInt(free_address);  
              dos.writeInt(read_address);  
              dos.writeInt(write_address);  
              dos.writeInt(getgbsprocess_address);  
              dos.writeUTF(GetPhoneName());
              
 

              byte[] record = baos.toByteArray();  
              rs.addRecord(record, 0, record.length);  
              baos.close();
              rs.closeRecordStore();
              
              return 1;

          } catch (Exception e) 
             {  
              return 0;
             }  
  }
 
 private int api_rms_load() 
  {  
      RecordStore rs = null;  
       try {  
              rs = RecordStore.openRecordStore(app_db_rms, 
                      false, RecordStore.AUTHMODE_ANY, false);
              
              byte[] load_buffer = rs.getRecord(1);
              
              ByteArrayInputStream bais = new ByteArrayInputStream(load_buffer);  
              DataInputStream dis = new DataInputStream(bais);  
               
              malloc_address        = dis.readInt();  
              free_address          = dis.readInt();  
              read_address          = dis.readInt();  
              write_address         = dis.readInt();  
              getgbsprocess_address = dis.readInt();  
              app_pn_rms            = dis.readUTF();

              bais.close();
              rs.closeRecordStore();
              
              return 1;

          } catch (Exception e) 
             {  
              return 0;
             }  
 }
 
 /* Инициализация GUI  */
 
 public void GUIInit() 
  {
   init_form                 = new Form("Инициализация");
   init_cmd_start            = new Command("Далее", Command.ITEM, 1);
   init_cmd_menu             = new Command("Меню",  Command.ITEM, 1);
   init_cmd_exit             = new Command("Выход", Command.EXIT, 0);
   
   //Список "Меню"
   mainmenu_list             = new List(app_name + " Меню", Choice.IMPLICIT);
   mainmenu_list_cmd_select  = new Command("Выбор", Command.OK, 0); 
   mainmenu_list_is_created  = false;
   try {
        mainmenu_list_img_elfloader  = Image.createImage("/img/elfloader.png");
        mainmenu_list_img_esnhash    = Image.createImage("/img/esnhash.png");
        mainmenu_list_img_patcher    = Image.createImage("/img/patcher.png");
        mainmenu_list_img_dumper     = Image.createImage("/img/dumper.png");
        mainmenu_list_img_about      = Image.createImage("/img/about.png");
        mainmenu_list_img_exit       = Image.createImage("/img/exit.png");
       } catch (Exception e) 
         {
          quit(); 
         }
   
   //Форма "Дампер"
   dumper_form               = new Form(app_name + " Дампер");
   dumper_cmd_dump           = new Command("Дамп", Command.ITEM, 1); 
   dumper_cmd_cancel         = new Command("Отмена", Command.ITEM, 1);
   dumper_cmd_back           = new Command("Назад", Command.BACK, 0);
    
   dumper_tf_dumpfilpath     = new TextField("Путь к файлу", "4:/dump.bin", 256, TextField.ANY);
   dumper_tf_dumpaddress     = new TextField("Адрес", "B0000000", 8, TextField.ANY);
   dumper_tf_dumpsize        = new TextField("Размер", "02000000", 8, TextField.ANY);  
   dumper_gauge_progressbar  = new Gauge("Дампинг ...", false, 100, 0);
    
   dumper_temp_buffer        = new byte[0x40000];
   dumper_dumping_isactive   = false;
   dumper_dumping_isend      = true;
   
   //Форма "ELF Загрузчик"
   elfloader_form              = new Form(app_name + " ELF-Загрузчик");
   elfloader_cmd_load          = new Command("Запуск", Command.ITEM, 1);
   elfloader_cmd_back          = new Command("Назад", Command.BACK, 0);
   elfloader_tf_elffile        = new TextField("Имя файла загрузчика", app_def_el, 86, TextField.ANY);
   elfloader_tf_swiblibpath    = new TextField("Путь к swi.blib", "0:/Zbin/swi.blib", 256, TextField.ANY);
   elfloader_ch_patch          = new ChoiceGroup("Включить патчи", Choice.MULTIPLE);
   elfloader_swilib            = new byte[0x4000];
   elfloader_loading           = false;
   
 
    //Форма "ESN и HASH"
   esnhash_form             = new Form(app_name + " Ключи");
   esnhash_cmd_start        = new Command("Старт", Command.ITEM, 1);
   esnhash_cmd_back         = new Command("Назад", Command.BACK, 0);
   esnhash_is_created       = false;
   
   
   //Форма "Патчер"
   patcher_form              = new Form(app_name + " Патчер");
   patcher_cmd_back          = new Command("Назад", Command.BACK, 0);
   
   //Форма "Авторы"
   about_form                = new Form(app_name + " Авторы");
   about_cmd_back            = new Command("Назад", Command.BACK, 0);
   about_is_created          = false;
  }
 
 public void MainMenuInit() 
  {
    if (mainmenu_list_is_created == false)
     {
      mainmenu_list.append("ELF-Загрузчик", mainmenu_list_img_elfloader);
      mainmenu_list.append("ESN и HASH", mainmenu_list_img_esnhash);
      mainmenu_list.append("Патчер", mainmenu_list_img_patcher);
      mainmenu_list.append("Дампер", mainmenu_list_img_dumper);
      mainmenu_list.append("Авторы", mainmenu_list_img_about);
      mainmenu_list.append("Выход",  mainmenu_list_img_exit);
      
      mainmenu_list.setSelectCommand(mainmenu_list_cmd_select);
      
      mainmenu_list_is_created = true;
     }

    mainmenu_list.setCommandListener(this);
    display.getDisplay(this).setCurrent(mainmenu_list); 
   }
 
 public void ElfLoaderInit()     
  {
    elfloader_form.append(GetPhoneName() + "\n");
      
          
    elfloader_ch_patch.append("ESI", null);
    elfloader_ch_patch.append("KeyHook", null);
    elfloader_ch_patch.append("PIT", null);
    
    elfloader_form.append(elfloader_tf_elffile);
    elfloader_form.append(elfloader_tf_swiblibpath);
    
    elfloader_form.append(elfloader_ch_patch);
    
    elfloader_form.addCommand(elfloader_cmd_back);
    elfloader_form.addCommand(elfloader_cmd_load);
    
    elfloader_ch_patch.setSelectedFlags(elfloader_ch_patches_ena);
    
    elfloader_form.setCommandListener(this);
    display.getDisplay(this).setCurrent(elfloader_form);  
   }
  
 public void EsnHashInit() 
  {
    if (esnhash_is_created == false)
     {
      esnhash_form.addCommand(esnhash_cmd_start);   
      esnhash_form.addCommand(esnhash_cmd_back);  
      
      esnhash_form.append("Нажмите \"Старт\" для продолжения");
      
      esnhash_is_created = true;
     }

    esnhash_form.setCommandListener(this);
    display.getDisplay(this).setCurrent(esnhash_form); 
   }
 
 public void PatcherInit()     
  {
    patcher_form.append("Патчер\n");
    
    patcher_form.append("IMEI: "  + System.getProperty("com.siemens.IMEI") + "\n");
    patcher_form.append("PHONE: " + GetPhoneName() + "\n");
    
    
    patcher_form.append("В настоящее время патчер здесь не реализован, но вы можете использовать "
            + "эльф DPatcher, на сайте, указанном в пункте \"Авторы\".");
    
    patcher_form.addCommand(patcher_cmd_back);
    
    
    patcher_form.setCommandListener(this);
    display.getDisplay(this).setCurrent(patcher_form);
   }
  
 public void DumperInit() 
  {
    dumper_form.append(dumper_tf_dumpfilpath);
    dumper_form.append(dumper_tf_dumpaddress);
    dumper_form.append(dumper_tf_dumpsize);  
 
    dumper_form.addCommand(dumper_cmd_dump);
    dumper_form.addCommand(dumper_cmd_back);
    
    dumper_form.setCommandListener(this);
    display.getDisplay(this).setCurrent(dumper_form);
    
   }
  
 public void AboutInit() 
  {
    if (about_is_created == false)
     {
      about_form.append(
                        app_name + " (" + app_desc + ")\n"
                      + "----\n"
                      + "Dimadze (Шамаев Дамир)\n"
                      + "Интерфейс, API по работе с адресным пространством, "
                      + "ARM бинарники, Java ELF Загрузчик, Дампер\n"
                      + "----\n"
                      + "Версия: " + app_ver + "\n"
                      + "А также отдельное спасибо Chaos'у (Дмитрию Захарову) "
                      + "за разъяснение метода доступа к адресному пространству "
                      + "c Java. И спасибо товарищу Salat-Cx65 (Сергею Комлачу) за некоторую помощь по J2ME\n"
                      + "Сайт по разработкам для Siemens:\n"
                      + "http://siedevelop.xclan.ru\n"
                      + "Сайт Chaos:\n"
                      + "http://chaos.allsiemens.com\n"
              
              
              );
         
      
      about_form.addCommand(about_cmd_back);
      about_is_created = true;
     }
      
    about_form.setCommandListener(this);
    display.getDisplay(this).setCurrent(about_form);
  }
  
 
 /* Субпотоки */
 
 public void subthread_start(int item)
  {
    subthread_item = item;
    subthread      = new Thread(this);
    subthread.start();
   }
  
 public void subthread_end()
  {
     subthread_item = subthread_nop;
     subthread = null;
   }
 
 public void subthread_Init()
  {
    init_form.deleteAll();
    init_form.removeCommand(init_cmd_start);
    init_form.addCommand(init_cmd_exit);
    
    init_form.append("Инициализация\n");
    
    ZipTemp zt = new ZipTemp(app_zip_temp);
    
    try 
     {
      zt.create(); 
         
      int ret = aspace.ASpace_Init(zt.file_name, zt.entry_name); 
      switch (ret)
       {
          case ASPACE_RET_UNKNOWNERROR:
             throw new Exception("ASPACE_RET_UNKNOWNERROR"); 
          case ASPACE_RET_NOZIPFILE:
             throw new Exception("ASPACE_RET_NOZIPFILE"); 
          case ASPACE_RET_NOZIPENTRY:
             throw new Exception("ASPACE_RET_NOZIPENTRY"); 
          case ASPACE_RET_SIGNOFIND:
             throw new Exception("ASPACE_RET_SIGNOFIND"); 
          case ASPACE_RET_SUCCESS:
           {
             zt.delete();
             zt = null;  
               
             init_form.append("Доступ открыт\n");
             aspace.ASpace_InstallArmCaller(aspace.aspace_sgold_armcaller_newpointer, aspace.aspace_sgold_armcaller_bodyaddress);
             init_form.append("Установлен ArmCaller\n");
             //aspace.ASpace_DisableDataAbort();
             //init_form.append("Data Abort выключен\n");
             aspace.ASpace_SDRAMRemap();
             init_form.append("SDRAM размечена\n");
             
             api_rms_load();
             
             if (
                  (   
                     (
                       malloc_address > aspace.aspace_external_flash_address &&
                       malloc_address < (aspace.aspace_external_flash_address + aspace.aspace_external_flash22_size )
                     )  && 
                    (
                       free_address > aspace.aspace_external_flash_address &&
                       free_address < (aspace.aspace_external_flash_address + aspace.aspace_external_flash22_size )
                     )  &&
                    (
                       getgbsprocess_address > aspace.aspace_external_flash_address &&
                       getgbsprocess_address < (aspace.aspace_external_flash_address + aspace.aspace_external_flash22_size )
                     )  &&
                    (
                       read_address > aspace.aspace_external_flash_address &&
                       read_address < (aspace.aspace_external_flash_address + aspace.aspace_external_flash22_size )
                     )  &&
                    (
                       write_address > aspace.aspace_external_flash_address &&
                       write_address < (aspace.aspace_external_flash_address + aspace.aspace_external_flash22_size )
                     ) &&
                     (
                      app_pn_rms.compareTo(GetPhoneName()) == 0
                     )

                   ) == false
                )
              { 
               api_rms_clean(); 
                  
               init_form.deleteAll();
                  
               init_form.append("Поиск API ...\n");
               
               init_form.append("malloc:\n");
               malloc_address = aspace.ASpace_SearchFunctionByWords(aspace.aspace_extmirr_flash_address, aspace.aspace_extmirr_flash_address + aspace.aspace_external_flash22_size, malloc_pattern, malloc_pattern_offset);
               if (malloc_address > aspace.aspace_extmirr_flash_address && malloc_address < (aspace.aspace_extmirr_flash_address + aspace.aspace_external_flash22_size ))
                {
                 malloc_address -= aspace.aspace_flash_diffaddress; 
                 init_form.append("0x" + Integer.toHexString(malloc_address).toUpperCase() + "\n");
                } else throw new Exception("MALLOC_NO_FOUND"); 
             
               init_form.append("free:\n");
               free_address = aspace.ASpace_SearchFunctionByWords(aspace.aspace_extmirr_flash_address, aspace.aspace_extmirr_flash_address + aspace.aspace_external_flash22_size, free_pattern, free_pattern_offset);
               if (free_address > aspace.aspace_extmirr_flash_address && free_address < (aspace.aspace_extmirr_flash_address + aspace.aspace_external_flash22_size ))
                {
                 free_address -= aspace.aspace_flash_diffaddress; 
                 init_form.append("0x" + Integer.toHexString(free_address).toUpperCase() + "\n");
                } else throw new Exception("FREE_NO_FOUND"); 
             
               init_form.append("read:\n");
               read_address = aspace.ASpace_SearchFunctionByWords(aspace.aspace_extmirr_flash_address, aspace.aspace_extmirr_flash_address + aspace.aspace_external_flash22_size, read_pattern, read_pattern_offset);
               if (read_address > aspace.aspace_extmirr_flash_address && read_address < (aspace.aspace_extmirr_flash_address + aspace.aspace_external_flash22_size ))
                {
                 read_address -= aspace.aspace_flash_diffaddress; 
                 init_form.append("0x" + Integer.toHexString(read_address).toUpperCase() + "\n");
                } else throw new Exception("READ_NO_FOUND"); 

               init_form.append("write:\n");
               write_address = aspace.ASpace_SearchFunctionByWords(aspace.aspace_extmirr_flash_address, aspace.aspace_extmirr_flash_address + aspace.aspace_external_flash22_size, write_pattern, write_pattern_offset);
               if (write_address > aspace.aspace_extmirr_flash_address && write_address < (aspace.aspace_extmirr_flash_address + aspace.aspace_external_flash22_size ))
                {
                 write_address -= aspace.aspace_flash_diffaddress; 
                 init_form.append("0x" + Integer.toHexString(write_address).toUpperCase() + "\n");
                } else throw new Exception("WRITE_NO_FOUND"); 
               
               init_form.append("GetGBSProc:\n");
               getgbsprocess_address = aspace.ASpace_SearchFunctionByWords(aspace.aspace_extmirr_flash_address, aspace.aspace_extmirr_flash_address + aspace.aspace_external_flash22_size, getgbsprocess_pattern, getgbsprocess_pattern_offset);
               if (getgbsprocess_address > aspace.aspace_extmirr_flash_address && getgbsprocess_address < (aspace.aspace_extmirr_flash_address + aspace.aspace_external_flash22_size ))
                {
                 getgbsprocess_address -= aspace.aspace_flash_diffaddress; 
                 init_form.append("0x" + Integer.toHexString(getgbsprocess_address).toUpperCase() + "\n");
                } else throw new Exception("GETGBSPROC_NO_FOUND"); 
             
                api_rms_store();

              } else
                  {
                   init_form.deleteAll();  
                   
                   init_form.append("API загружено\n");
                      
                   init_form.append("malloc:\n0x" + Integer.toHexString(malloc_address).toUpperCase() + "\n");
                   init_form.append("free:\n0x" + Integer.toHexString(free_address).toUpperCase() + "\n");
                   init_form.append("read:\n0x" + Integer.toHexString(read_address).toUpperCase() + "\n");
                   init_form.append("write:\n0x" + Integer.toHexString(write_address).toUpperCase() + "\n");
                   init_form.append("GetGBSProc:\n0x" + Integer.toHexString(getgbsprocess_address).toUpperCase() + "\n");
                  }
             
             target_onmsghandler = aspace.ASpace_RunArmCode(getgbsprocess_address, target_cepid, 0, 0, 0);
             if (target_onmsghandler == 0 || target_onmsghandler == 0xFFFFFFFF)  throw new Exception("GETGBSPROC_ERROR"); 
             
             init_form.append("Замена хендлера CepID: 0x" + Integer.toHexString(target_cepid).toUpperCase() + "\n");
             
             aspace.ASpace_DeInstallArmCaller();
             init_form.append("Удалён ArmCaller\n");
             
             aspace.ASpace_InstallArmCaller(target_onmsghandler + onmsghandler_offset + aspace.aspace_flash_diffaddress, 
                                            aspace.aspace_sgold_armcaller_bodyaddress);
             init_form.append("Установлен новый ArmCaller\n");
             
             init_form.append("Инициализация пройдена\n");   
             init_form.addCommand(init_cmd_menu);
             
             return;
             
           }
          default:
             throw new Exception("ASPACE_RET_UNKNOWNERROR"); 
       }
     } catch (Exception e)
        {
         init_form.deleteAll();
         init_form.append("Ошибка!\n" + e.toString() + "!\n"                   +
                          "Ошибка при инициализации! "                         +
                          "Это скорее всего означает, что ваш телефон или "    +
                          "прошивка не поддерживается. Перезагрузите телефон " +
                          "и попробуйте ещё раз."
                      );
         zt.delete();
         zt = null;
         return;
        }
   }
  
 public void subthread_Dumping()
  {
    int daddr, dsize, dtsize, dost, dchunk;
    dumper_dumping_isend    = false;  
    dumper_dumping_isactive = true;  
    
    if (dumper_tf_dumpsize.getString().length() == 8)
     {
        daddr  = (Integer.parseInt(dumper_tf_dumpaddress.getString().substring(0,4), 16) << 16 ) & 0xFFFF0000;
        daddr |= (Integer.parseInt(dumper_tf_dumpaddress.getString().substring(4,8), 16)       ) & 0x0000FFFF;
     } else daddr   = Integer.parseInt(dumper_tf_dumpaddress.getString(), 16);

    if (dumper_tf_dumpsize.getString().length() == 8)
     {
        dsize  = (Integer.parseInt(dumper_tf_dumpsize.getString().substring(0,4), 16) << 16 ) & 0xFFFF0000;
        dsize |= (Integer.parseInt(dumper_tf_dumpsize.getString().substring(4,8), 16)       ) & 0x0000FFFF;
     } else dsize   = Integer.parseInt(dumper_tf_dumpsize.getString(), 16);

    
    dumper_form.deleteAll();
    dumper_form.append("Ожидайте ...\n");
    
    dumper_form.append(dumper_gauge_progressbar);
    int pitem = dumper_form.append("");
    
    dchunk = dumper_temp_buffer.length;
    dost   = dsize % dchunk;
    dtsize = dsize - dost;
         
    dumper_form.get(pitem).setLayout(dumper_form.get(pitem).LAYOUT_CENTER);
    dumper_gauge_progressbar.setValue(0);
    dumper_gauge_progressbar.setMaxValue(dsize);

    try 
      {
       FileConnection dump_file    = (FileConnection) Connector.open("file:///" + dumper_tf_dumpfilpath.getString());
            
       if (dump_file.exists()) dump_file.delete();
       dump_file.create();   
       
       DataOutputStream dump_file_os = dump_file.openDataOutputStream();
       
       if (dsize < dchunk) 
        {  
         if (dumper_dumping_isactive == true) 
          {
           for (int i = 0; i < dsize; i++)
           dumper_temp_buffer[i] = (byte)aspace.ASpace_readbyte(daddr + i);
          
           dump_file_os.write(dumper_temp_buffer, 0, dsize);
          
           dumper_gauge_progressbar.setValue(dsize);
           dumper_form.get(pitem).setLabel(dsize + " / " + dsize + "\n");
           subthread.sleep(10);
          }
        } else
           {
            for (int f = 0; f < dtsize; f += dchunk)
             { 
              if (dumper_dumping_isactive == false) break;
             
              for (int i = 0; i < dchunk; i++)
               dumper_temp_buffer[i] = (byte)aspace.ASpace_readbyte(daddr + f + i);
              
              dump_file_os.write(dumper_temp_buffer);
              
              dumper_gauge_progressbar.setValue(f + dchunk);
              dumper_form.get(pitem).setLabel((f + dchunk) + " / " + dsize + "\n");
              subthread.sleep(10);
             }
            
            if (dost != 0)
             {
              if (dumper_dumping_isactive == true) 
               {
                 for (int i = 0; i < dost; i++)
                   dumper_temp_buffer[i] = (byte)aspace.ASpace_readbyte(daddr + dtsize + i);
          
                 dump_file_os.write(dumper_temp_buffer, 0, dost);
          
                 dumper_gauge_progressbar.setValue(dsize);
                 dumper_form.get(pitem).setLabel(dsize + " / " + dsize + "\n");
                 subthread.sleep(10);
                }
              }
           }

      dump_file_os.flush();
      dump_file_os.close();
      dump_file.close();
           
      dumper_form.append("\nЗавершено!\n");
      dumper_dumping_isend = true;  
     } catch (Exception e) 
         { 
          dumper_form.append("\nОшибка: " + e.toString() + "\n"); 
          dumper_dumping_isend = true;  
         }
   }
  
 public void subthread_ElfLoading()
  {
    int patches_ena = 0;
    
    elfloader_ch_patch.getSelectedFlags(elfloader_ch_patches_ena);
    
    if (elfloader_ch_patches_ena[PE_ESI] == true)     
        patches_ena |= 0x00000001;
    if (elfloader_ch_patches_ena[PE_KEYHOOK] == true) 
        patches_ena |= 0x00000010;
    if (elfloader_ch_patches_ena[PE_PIT] == true) 
        patches_ena |= 0x00000100;
   
    
    elfloader_form.deleteAll();
    elfloader_form.removeCommand(elfloader_cmd_load);
    
    elfloader_loading = true;
    elfloader_form.append("Загрузка библиотеки\n");
      
    try 
      {
       if (swilib_address != 0)
           throw new Exception("ELFLOADER_HAS_BEEN_LOADED");

       FileConnection swiblib = (FileConnection) Connector.open("file:///" + elfloader_tf_swiblibpath.getString());
            
       if (swiblib.exists() == false)
           throw new Exception("SWIBLIB_NOT_FOUND"); 
       
       if (swiblib.fileSize() != 0x4000)
           throw new Exception("SWIBLIB_INVALID_SIZE"); 
       
       swilib_address = aspace.ASpace_RunArmCode(malloc_address, elfloader_swilib.length, 0, 0, 0);
       if (swilib_address == 0)
           throw new Exception("NO_MEM_FOR_SWILIB"); 
       
       DataInputStream swiblib_is = swiblib.openDataInputStream();
       swiblib_is.read(elfloader_swilib);
       swiblib_is.close();
       swiblib.close();
       
       swilib_address += aspace.aspace_flash_diffaddress;
       
       for (int i = 0; i < elfloader_swilib.length; i++)
        aspace.ASpace_writebyte(swilib_address + i, (int)elfloader_swilib[i]);
       
       //Добавляем найденные API для чтения / записи ФC в библиотеку, их там не бывает обычно
       aspace.ASpace_writeword(swilib_address + read_swinum*4, read_address);
       aspace.ASpace_writeword(swilib_address + write_swinum*4, write_address);
       
       //Разрешаем патчи
       aspace.ASpace_writeword(swilib_address + 0, patches_ena);
       
       swilib_address -= aspace.aspace_flash_diffaddress;
       
       elfloader_form.append("Запуск загрузчика\n");
       
       ElfLoader el = new ElfLoader(aspace, malloc_address, free_address, app_mel_path);
       
       if (el.CheckOnSWIHookLoaded() == true)
        {
         el = null;
         throw new Exception("SWIHOOK_IS_DETECTED"); 
        }
       int elfret = 0;
       if (el.CreateElfLoader() == 1)
         {
          if ((elfret = el.LaunchElf(app_bin_path + elfloader_tf_elffile.getString(), swilib_address)) != 0)
           {
            el.KillElfLoader();
            el = null;
            throw new Exception("ELFLOADER_NO_LAUNCHED(" + elfret +  ")"); 
           }
          el.KillElfLoader();
          
          elfloader_form.append("Запущен\n");
          el = null;
         } else
            {
             el = null;
             throw new Exception("ELFLOADER_NO_LOADED"); 
            }
       
     } catch (Exception e) 
         { 
          if (swilib_address != 0)
            aspace.ASpace_RunArmCode(free_address, swilib_address, 0, 0, 0);
          swilib_address = 0;
          elfloader_form.deleteAll();
          elfloader_form.append("Ошибка!\n" + e.toString() + "!\n"                                 +
                                "Ошибка при загрузке библиотеки ф-ий или загрузчика! "             +
                                "Проверьте наличие библиотеки по указаному пути и убедитесь, что " +
                                "её размер составляет 16 кб."
                         );
         }
      
    elfloader_loading = false;
  }
 
 public void subthread_EsnHashReading()
  { 
      esnhash_form.append("Чтение BootCore\n");
      
      for (int i = 0; i < hash_body.length; i++)
        hash_body[i] = (byte)aspace.ASpace_readbyte(hash_address + aspace.aspace_flash_diffaddress + i);

      esnhash_form.append("Чтение OTP\n");
      
      CFIRead cfi = new CFIRead(aspace);
      int  flash_id = cfi.flash_id;
      int  manuf_id = cfi.ReadManufID();
           esn_key  = cfi.ReadOTPESN();
      
      esn_body[0] = (byte)( esn_key        & 0xFF);
      esn_body[1] = (byte)((esn_key >> 8)  & 0xFF);
      esn_body[2] = (byte)((esn_key >> 16) & 0xFF);
      esn_body[3] = (byte)((esn_key >> 24) & 0xFF);
      
      esn_body_papuas[3] = (byte)( esn_key        & 0xFF);
      esn_body_papuas[2] = (byte)((esn_key >> 8)  & 0xFF);
      esn_body_papuas[1] = (byte)((esn_key >> 16) & 0xFF);
      esn_body_papuas[0] = (byte)((esn_key >> 24) & 0xFF);
      
     
      esnhash_form.deleteAll();
      
      if (flash_id != cfi.FLASHID_AMD)
       {
        esnhash_form.append("Flash: " + cfi.GetFlashName(flash_id)             + "\n");
        esnhash_form.append("HASH:\n" + ToHexView(hash_body, hash_body.length) + "\n");  
        
        esnhash_form.append("ESN (x65flasher):\n"  + ToHexView(esn_body, esn_body.length) + "\n"); 
        esnhash_form.append("ESN (x65papuas):\n"  + ToHexView(esn_body_papuas, esn_body_papuas.length) + "\n"); 
       } else
          {
           esnhash_form.append("Flash: " + cfi.GetFlashName(flash_id)             + "\n");
           esnhash_form.append("HASH:\n" + ToHexView(hash_body, hash_body.length) + "\n");   
           esnhash_form.append("ESN:\nAMD OTP Read Not Support!\n"); 
          }
      cfi = null;
      
  }

 
 
 /* Общий субпоток, пускаем через него Инициализацию / Дампинг / ELF-Загрузка */
 public void run()
  {
    switch (subthread_item)
     {
        case subthread_init:
            subthread_Init();
            break;
        case subthread_dumping:
            subthread_Dumping();
            break;
        case subthread_elfloading:
            subthread_ElfLoading();
            break;
        case subthread_esnhashreading:
            subthread_EsnHashReading();
            break;
    }
    
    subthread_item = subthread_nop;
    subthread = null;
   }
  
 /* Общий слушатель команд */
 public void commandAction(Command c, Displayable d) 
  {
         if (c == init_cmd_start)   subthread_start(subthread_init);
    else if (c == init_cmd_menu)    MainMenuInit();
    else if (c == init_cmd_exit)    quit();
    else
    if (c == mainmenu_list_cmd_select)
     {
      switch (mainmenu_list.getSelectedIndex())
       {
          case 0: 
              ElfLoaderInit();
              return;
          case 1: 
              EsnHashInit();
              return;
          case 2: 
              PatcherInit();
              return;
          case 3: 
              DumperInit();
              return;
          case 4: 
              AboutInit();
              return;
          case 5: 
              quit();
              return;
          default: 
              quit();
              return;
       }
     } else
    if (c == dumper_cmd_dump)
     {
      subthread_start(subthread_dumping);
      dumper_form.removeCommand(dumper_cmd_dump);
      dumper_form.addCommand(dumper_cmd_cancel);
     } else
    if (c == dumper_cmd_cancel)
     {
      //subthread.yield();
       
      while (dumper_dumping_isend == false)
        dumper_dumping_isactive = false;
      
      subthread_end();
         
      dumper_form.deleteAll();  
      dumper_form.removeCommand(dumper_cmd_cancel);
      
      DumperInit();
     } else
    if (c == dumper_cmd_back)
     {
      while (dumper_dumping_isend == false)
         dumper_dumping_isactive = false;
      
      subthread_end();
           
      dumper_form.deleteAll();
      dumper_form.removeCommand(dumper_cmd_dump);
      dumper_form.removeCommand(dumper_cmd_cancel);
      dumper_form.removeCommand(dumper_cmd_back);
      
      display.getDisplay(this).setCurrent(mainmenu_list);
     } else
    if (c == patcher_cmd_back)
     {   
      patcher_form.deleteAll();
      patcher_form.removeCommand(patcher_cmd_back);
      
      display.getDisplay(this).setCurrent(mainmenu_list);
     } else
    if (c == about_cmd_back)
     {   
      display.getDisplay(this).setCurrent(mainmenu_list);
     } else
    if (c == esnhash_cmd_back)
     {   
      display.getDisplay(this).setCurrent(mainmenu_list);
     } else
    if (c == esnhash_cmd_start)
     {
      esnhash_form.deleteAll();
      esnhash_form.removeCommand(esnhash_cmd_start);
      subthread_start(subthread_esnhashreading);
     } else
    if (c == elfloader_cmd_load) subthread_start(subthread_elfloading);
    else
    if (c == elfloader_cmd_back)
     {   
      while (true)
       {
        if (elfloader_loading == false) 
            break;
       }
      
      subthread_end();
      
      elfloader_ch_patch.getSelectedFlags(elfloader_ch_patches_ena);
      
      elfloader_ch_patch.deleteAll();
      elfloader_form.deleteAll();
      elfloader_form.removeCommand(elfloader_cmd_load);
      elfloader_form.removeCommand(elfloader_cmd_back);
         
      display.getDisplay(this).setCurrent(mainmenu_list);
     } 
  }

 /* Метод при старте приложения */
 public void startApp() 
  {
    GUIInit();   
    
    //Создание заставки
    Logo logo = new Logo(app_logo_path);
    display.getDisplay(this).setCurrent(logo);
    //Ждём окончания
    logo.waiter();
    logo = null;
    
    //Старт первой формы
    init_form.addCommand(init_cmd_start);
    init_form.addCommand(init_cmd_exit);
    
    init_form.append(app_name +  " - " + app_desc + ", "
            + "специальный мидлет, который имеет ряд функций, выполняемых без компьютера и кабеля:\n"
            + "[+] Дампер адресного пространства в файл.\n"
            + "[+] Генератор ESN и HASH для расчёта других сервисных ключей.\n"
            + "[+] Портативный загрузчик исполняемых файлов ELF\n"
            + "\n"
            + "Мидлет был создан для первоначальной установки "
            + "необходимых патчей для полноценной работы ELF - приложений."
            + "Важно знать, данный мидлет работает только с телефонами марки "
            + "Siemens и платформы SGold (C65,C72,SL65,CX65,CX70,M65,SK65,"
            + "S65,CF75,C75,ME75,M75,CX75 и их аналоги)."
            );
    
    init_form.setCommandListener(this);
    display.getDisplay(this).setCurrent(init_form);
    
   }
 
 /* Метод при паузе приложения */
 public void pauseApp()
  {
      
  }
  
 /* Метод при униичтожении приложения */
 public void destroyApp(boolean unconditional) 
  {
  //aspace.ASpace_EnableDataAbort();
    aspace.ASpace_DeInstallArmCaller();
   }
  
 /* Метод выхода из приложения */
 public void quit() 
  {
  //aspace.ASpace_EnableDataAbort();
    aspace.ASpace_DeInstallArmCaller();
    ptc.notifyDestroyed();
   } 
}


 
 