#include "search_pattern.h"

int SearchFunction(int search_address, int search_size, PATTERN *pattern)
{
  if (!pattern) return -1;
  
  switch (pattern->elemsize)
   {
    case 1:
      {
       if ((search_address + search_size ) <= ( search_address + (pattern->bodysize / 4) ) ) 
          return -11; 
       
       for (int i = search_address; 
            i < (search_address + search_size - (pattern->bodysize / 4)); 
            i += 1)
        {
         int b = 0, r = 0;
         for (int k = 0; k < pattern->bodysize / 4; k++)
          {
           b = pat_byte_read(i + k * 1);
           if (b != pattern->body[k])
            {
             if (pattern->skipint != pattern->body[k])  
              {
               r = 1;
               break;
              }
            }
           }
          if (r == 0) return i + pattern->offset;
         }
       return -12;
      }
      
    case 2:
      {
       if ((search_address + search_size ) <= ( search_address + pattern->bodysize / 4) ) 
          return -21; 
       for (int i = search_address; 
            i < (search_address + search_size - (pattern->bodysize / 4)); 
            i += 2)
        {
         int b = 0, r = 0;
         for (int k = 0; k < (pattern->bodysize / 4); k++)
          {
           b = pat_hwrd_read(i + k * 2);
           if (b != pattern->body[k])
            {
             if (pattern->skipint != pattern->body[k])  
              {
               r = 1;
               break;
              }
            }
           }
          if (r == 0) return i + pattern->offset;
         }
       return -22;
      }
      
    case 4:
      {
       if ((search_address + search_size ) <= ( search_address + (pattern->bodysize / 4)) ) 
          return -41; 
       for (int i = search_address; 
            i < (search_address + search_size - (pattern->bodysize / 4)); 
            i += 4)
        {
         int b = 0, r = 0;
         for (int k = 0; k < (pattern->bodysize / 4); k++)
          {
           b = pat_word_read(i + k * 4);
           if (b != pattern->body[k])
            {
             if (pattern->skipint != pattern->body[k])  
              {
               r = 1;
               break;
              }
            }
           }
          if (r == 0) return i + pattern->offset;
         }
       return -42;
       
      }
      
    default:
      return -2;
   
   }
}

