#include "../inc/swilib.h"
#include "fs32.h"
#include "swihook.h"

int (*fread_old)(int fhandle, void *buf, int size, int *err) = 0;
int (*fwrite_old)(int fhandle, void *buf, int size, int *err) = 0;


int fread_32(int fh, void *buf, int len, int *err)
{
  int clen;
  int rlen;
  int total=0;
  
  if (!fread_old) return 0; 
  
  while(len)
  {
    clen=len>=0x4000?0x4000:len;
    total+=(rlen=fread_old(fh, buf, clen, err));
    if (rlen!=clen) break;
    buf=(char *)buf+rlen;
    len-=clen;
  }
  return(total);
}


int fwrite_32(int fh, void *buf, int len, int *err)
{
  int clen;
  int wlen;
  int total=0;
  
  if (!fwrite_old) return 0; 
  
  while(len)
  {
    clen=len>=0x4000?0x4000:len;
    total+=(wlen=fwrite_old(fh, buf, clen, err));
    if (wlen!=clen) break;
    buf=(char *)buf+wlen;
    len-=clen;
  }
  return(total);
}


void __jel_fs32_install()
{
 fread_old =
   (int (*)(int, void *, int, int *) )__jel_swihook_getfunc(SWINUM_READ);
 fwrite_old =
   (int (*)(int, void *, int, int *) )__jel_swihook_getfunc(SWINUM_WRITE);
 __jel_swihook_setfunc(SWINUM_READ, (unsigned int)&fread_32);
 __jel_swihook_setfunc(SWINUM_WRITE, (unsigned int)&fwrite_32);
}


