
#include "../inc/swilib.h"
#include "elf.h"

zeromem_a(void *d, int l){zeromem(d,l);}


long elfload(char *filename, void *param1, void *param2, void *param3)
{
  Elf32_Ehdr ehdr;			//  
  Elf32_Phdr phdrs[MAX_PHNUM];	        //  
  Elf32_Word dyn[DT_BIND_NOW+1];	//   
  
  char *reloc, *base;
  unsigned long minadr=(unsigned long)-1, maxadr=0;
  int n,m;
  
  zeromem_a(dyn, sizeof(dyn));
    
  int fin;
  unsigned int iError, iError2;
  if ((fin=fopen(filename, A_ReadOnly+A_BIN, P_READ, &iError))<0) return -1; //   
  if (fread(fin, &ehdr, sizeof(Elf32_Ehdr), &iError)!=sizeof(Elf32_Ehdr))    //   
  {fclose(fin, &iError); return -2;}
  
  
  if (*((long *)ehdr.e_ident)!=0x464C457F) //       /* \x7FELF */
  {                               
    fclose(fin, &iError);
    return -3;
  }
  
  //          RAM
  if (ehdr.e_phnum>MAX_PHNUM) return -9; //    
  for(n=0;n<ehdr.e_phnum;n++)
  {
    if (lseek(fin, ehdr.e_phoff+n*ehdr.e_phentsize, S_SET, &iError, &iError2)!=ehdr.e_phoff+n*ehdr.e_phentsize)
    {fclose(fin, &iError); return -4;}				//    
    if (fread(fin, &phdrs[n], sizeof(Elf32_Phdr), &iError)!=sizeof(Elf32_Phdr))
    {fclose(fin, &iError); return -5;}				//    
    
    if (phdrs[n].p_type==PT_LOAD)
    {
      if (minadr>phdrs[n].p_vaddr) minadr=phdrs[n].p_vaddr;
      if (maxadr<(phdrs[n].p_vaddr+phdrs[n].p_memsz))
      {
	maxadr=phdrs[n].p_vaddr+phdrs[n].p_memsz;
      }
    }
  }
  
  //      
  if ((base=(char *)malloc(maxadr-minadr))==0) //      (  RAM)
  {
    fclose(fin, &iError);
    return -13;
  }
  
  //   
  zeromem_a(base,maxadr-minadr);
  
  //   
  for(n=0;n<ehdr.e_phnum;n++)
  { 
    if (lseek(fin, phdrs[n].p_offset, S_SET, &iError, &iError)!=phdrs[n].p_offset)
    {fclose(fin, &iError); mfree(base); return -6;} //    

    switch (phdrs[n].p_type)
    {
     case PT_LOAD:
       
      //       0
      if (phdrs[n].p_filesz!=0) 
       {
	if (fread(fin, &base[phdrs[n].p_vaddr-minadr], phdrs[n].p_filesz, &iError)!= phdrs[n].p_filesz)
	{fclose(fin, &iError); mfree(base); return -10;} //    
       }
        break;
     case PT_DYNAMIC:
       
      //   
      if ((reloc=(char *)malloc(phdrs[n].p_filesz))==0) //      
      {
	fclose(fin, &iError);
	mfree(base);
	return -7;
      }
      
      if (fread(fin, reloc, phdrs[n].p_filesz, &iError)!=phdrs[n].p_filesz)
      {fclose(fin, &iError); mfree(reloc); mfree (base); return -8;}	//    

      //      
      m=0;
      while (((Elf32_Dyn *)reloc)[m].d_tag!=DT_NULL)
       {
	if (((Elf32_Dyn *)reloc)[m].d_tag<=DT_BIND_NOW) 
        {
	  dyn[((Elf32_Dyn *)reloc)[m].d_tag]=((Elf32_Dyn *)reloc)[m].d_val;
	}
	m++;
       }
      m=0;
      
      //   REL
      if (dyn[DT_RELSZ]!=0)
       {
	while (m*sizeof(Elf32_Rel)<dyn[DT_RELSZ])
         {

          Elf32_Word ri=ELF32_R_TYPE(((Elf32_Rel *)(reloc+dyn[DT_REL]-phdrs[n].p_vaddr))[m].r_info);
          if (ri!=R_ARM_RBASE)
          {
            if (ri==R_ARM_RABS32)
            {
              *((long*)(base+((Elf32_Rel *)(reloc+dyn[DT_REL]-phdrs[n].p_vaddr))[m].r_offset))+=(long)base-minadr;
            }
            else
              switch(ri)
               {
                case R_ARM_NONE: break; //  
                case R_ARM_ABS32:

                *((long*)(base+((Elf32_Rel *)(reloc+dyn[DT_REL]-phdrs[n].p_vaddr))[m].r_offset-minadr))+=(long)base;
                break;
                
                case R_ARM_RELATIVE: //    minadr     
                  
                *((long*)(base+((Elf32_Rel *)(reloc+dyn[DT_REL]-phdrs[n].p_vaddr))[m].r_offset-minadr))+=(long)base-minadr;
                break;  // 
                case R_ARM_RBASE: break;
                
                default: 	//   
                  fclose(fin, &iError);
                  mfree(base);
                  mfree(reloc);
                  return -12;
               }
           }
	  m++;
	 }
       }

       mfree(reloc);
       break;
      
      default:	//    
       fclose(fin, &iError);
       mfree(base);
       return -11;
    }
  }

  fclose(fin, &iError);

  ((TElfEntry *)(base+ehdr.e_entry-minadr))(filename,param1,param2,param3);
  return 0;
}
