import javax.microedition.lcdui.*;
import javax.microedition.lcdui.Graphics;

public class Logo extends Canvas
{
    int width;
    int height;
    
    Image logo;
    int logo_w, logo_h;
    
    boolean  is_painted = false, logo_exit = false;

    public Logo(String logo_path)
     {
      setFullScreenMode(true);
         
      width  = getWidth();
      height = getHeight();
        
       try 
           {
            logo   = Image.createImage(logo_path);
            logo_w = logo.getWidth();
            logo_h = logo.getHeight();
           } catch (Exception e) {}
     }
    
    private void delay(long ms)
     {
       long cur = System.currentTimeMillis();
        while (true)
         {
          if ((System.currentTimeMillis() - cur) > ms) break;
         } 
     }
    
    public void waiter()
     {
         while (is_painted == false);
          while (logo_exit == false);
     }
    
    public void paint(Graphics g)
     {
        is_painted = true;
        
        g.setColor(0xFF, 0xFF, 0xFF);
        g.fillRect(0, 0, width, height);
        
        g.drawRegion(logo, 0, 0, 
                    logo_w, (logo_h/2), 
                    0, 
                    (width/2) - (logo_w/2), 
                    (height/2) - (logo_h/2),
                    0);
        
        
        repaint();
        
        delay(1500);

        g.drawImage(logo, (width/2) - (logo_w/2), (height/2) - (logo_h/2), 0);

        repaint();
        
        is_painted = true;
        delay(2000);
        logo_exit = true;
     }
    
    public void keyPressed(int keyCode) 
     {
      if (is_painted == true)
       {
        logo_exit = true;
       }
     }
}
