
import java.io.*;

public class CFIRead
 {
  private  final int esn0_address  = 0x102;  
  private  final int esn1_address  = 0x10C;  
  private  final int esn_xor_value = 0x03F7E532;
  
  public   final int FLASHID_AMD   = 0x01;
  public   final int FLASHID_ST    = 0x20;
  public   final int FLASHID_INTEL = 0x89;
  
  public         int flash_id = 0;
    
  private  ASpace aspace;
 
 /* unsigned short otp_readword(unsigned int address) */
 
 public final int[] otp_readword_body = 
 {
	0xF0, 0x41, 0x2D, 0xE9, 0x00, 0x40, 0xB0, 0xE1, 0xE0, 0x00, 0xA0, 0xE3, 0xF0, 0x04, 0x80, 0xE3, 
	0x00, 0x50, 0xB0, 0xE1, 0xF0, 0x04, 0x14, 0xE2, 0x00, 0x60, 0xB0, 0xE1, 0x00, 0x00, 0xA0, 0xE3, 
	0x00, 0x70, 0xB0, 0xE1, 0x00, 0x00, 0xA0, 0xE3, 0x00, 0x80, 0xB0, 0xE1, 0x00, 0x00, 0x00, 0xEF, 
	0x27, 0x00, 0x00, 0xEB, 0x00, 0x00, 0x95, 0xE5, 0x80, 0x00, 0xB0, 0xE1, 0xA0, 0x00, 0xB0, 0xE1, 
	0x00, 0x00, 0x85, 0xE5, 0xAA, 0x00, 0xA0, 0xE3, 0xA0, 0x0E, 0x80, 0xE3, 0xAA, 0x10, 0xA0, 0xE3, 
	0xB6, 0x10, 0x80, 0xE1, 0x54, 0x00, 0xA0, 0xE3, 0x50, 0x0E, 0x80, 0xE3, 0x55, 0x10, 0xA0, 0xE3, 
	0xB6, 0x10, 0x80, 0xE1, 0xAA, 0x00, 0xA0, 0xE3, 0xA0, 0x0E, 0x80, 0xE3, 0x90, 0x10, 0xA0, 0xE3, 
	0xB6, 0x10, 0x80, 0xE1, 0xB2, 0x00, 0xD6, 0xE1, 0x00, 0x80, 0xB0, 0xE1, 0x01, 0x00, 0xD4, 0xE3, 
	0xB0, 0x00, 0xD0, 0xE1, 0x00, 0x70, 0xB0, 0xE1, 0x08, 0x88, 0xA0, 0xE1, 0x28, 0x88, 0xB0, 0xE1, 
	0x01, 0x00, 0x58, 0xE3, 0x02, 0x00, 0x00, 0x1A, 0xF0, 0x00, 0xA0, 0xE3, 0xB0, 0x00, 0xC6, 0xE1, 
	0x01, 0x00, 0x00, 0xEA, 0xFF, 0x00, 0xA0, 0xE3, 0xB0, 0x00, 0xC6, 0xE1, 0x00, 0x00, 0x00, 0xEF, 
	0x03, 0x00, 0x00, 0xEB, 0x07, 0x00, 0xB0, 0xE1, 0x00, 0x08, 0xA0, 0xE1, 0x20, 0x08, 0xB0, 0xE1, 
	0xF0, 0x81, 0xBD, 0xE8, 0x00, 0xC0, 0x0F, 0xE1, 0xC0, 0xC0, 0xCC, 0xE3, 0x0C, 0xF0, 0x21, 0xE1, 
	0x1E, 0xFF, 0x2F, 0xE1, 0x00, 0xC0, 0x0F, 0xE1, 0xC0, 0xC0, 0x8C, 0xE3, 0x0C, 0xF0, 0x21, 0xE1, 
	0x00, 0xC0, 0x0F, 0xE1, 0xC0, 0xC0, 0x1C, 0xE2, 0xF9, 0xFF, 0xFF, 0x0A, 0x1E, 0xFF, 0x2F, 0xE1
};
 
 public CFIRead(ASpace as)
  {
   aspace = as;
   flash_id = ReadFlashID();
  }
    
 public String GetFlashName(int id) 
  {
   switch (id)
    {
       case FLASHID_AMD:
           return "AMD";
       case FLASHID_ST:
           return "ST";
       case FLASHID_INTEL:
           return "INTEL";
       default:
           return "UNKNOWN";
    }
  } 
 
 
 public int ReadFlashID() 
  {
   if (aspace.mainarray_startindex == 0) return 0;

   for (int i = 0; i < otp_readword_body.length; i++)
       aspace.ASpace_writebyte(aspace.aspace_sgold_workcode_bodyaddress + i, (int)otp_readword_body[i]);

   return aspace.ASpace_RunArmCode(aspace.aspace_sgold_workcode_bodyaddress, aspace.aspace_extmirr_flash_address, 0, 0, 0);
  }
 
  public int ReadManufID() 
  {
   if (aspace.mainarray_startindex == 0) return 0;
   
   for (int i = 0; i < otp_readword_body.length; i++)
       aspace.ASpace_writebyte(aspace.aspace_sgold_workcode_bodyaddress + i, (int)otp_readword_body[i]);

   return aspace.ASpace_RunArmCode(aspace.aspace_sgold_workcode_bodyaddress, aspace.aspace_extmirr_flash_address + 2, 0, 0, 0);
  }
  
 public int ReadOTPESN() 
  {
   int[] esn = new int[4];
   
   if (aspace.mainarray_startindex == 0) return 0;

   for (int i = 0; i < otp_readword_body.length; i++)
       aspace.ASpace_writebyte(aspace.aspace_sgold_workcode_bodyaddress + i, (int)otp_readword_body[i]);

   esn[0]  = aspace.ASpace_RunArmCode(aspace.aspace_sgold_workcode_bodyaddress, aspace.aspace_extmirr_flash_address + esn0_address + 0, 0, 0, 0);
   esn[0] |= ( aspace.ASpace_RunArmCode(aspace.aspace_sgold_workcode_bodyaddress, aspace.aspace_extmirr_flash_address + esn0_address + 2, 0, 0, 0)) << 16;
   esn[1]  = aspace.ASpace_RunArmCode(aspace.aspace_sgold_workcode_bodyaddress, aspace.aspace_extmirr_flash_address + esn0_address + 4, 0, 0, 0);
   esn[1] |= ( aspace.ASpace_RunArmCode(aspace.aspace_sgold_workcode_bodyaddress, aspace.aspace_extmirr_flash_address + esn0_address + 6, 0, 0, 0)) << 16;
   esn[2]  = aspace.ASpace_RunArmCode(aspace.aspace_sgold_workcode_bodyaddress, aspace.aspace_extmirr_flash_address + esn0_address + 8, 0, 0, 0);
   esn[2] |= ( aspace.ASpace_RunArmCode(aspace.aspace_sgold_workcode_bodyaddress, aspace.aspace_extmirr_flash_address + esn0_address + 10, 0, 0, 0)) << 16;
   esn[3]  = aspace.ASpace_RunArmCode(aspace.aspace_sgold_workcode_bodyaddress, aspace.aspace_extmirr_flash_address + esn1_address + 0, 0, 0, 0);
   esn[3] |= ( aspace.ASpace_RunArmCode(aspace.aspace_sgold_workcode_bodyaddress, aspace.aspace_extmirr_flash_address + esn1_address + 2, 0, 0, 0)) << 16;
  
   return  esn[3] ^ esn[0] ^ esn[1] ^ esn[2] ^ esn_xor_value ;
  }
 
 
}