import javax.microedition.io.*;
import java.io.*;
import com.siemens.mp.io.file.*;
import com.siemens.mp.util.zip.*;

/* Для Siemens SGold */

public class ASpace
{
 /* Инициализация для работы с адресным пространством
  * Все переменные должны идти с атрибутом static, кроме этих исключений:
  * */

 //Мнимый буфер для чтения ZIP архива
 public byte[]      aspace_ziparray      =  {0,0,0,0}; 
 //Главный, расширяемый до 2ГБ, массив
 public int[]       mainarray            =  {0}; 
    
 //Ошибки при инициализации
 public static final int ASPACE_RET_SUCCESS      =  1;  
 public static final int ASPACE_RET_UNKNOWNERROR =  0;  
 public static final int ASPACE_RET_NOZIPFILE    = -1; 
 public static final int ASPACE_RET_NOZIPENTRY   = -2; 
 public static final int ASPACE_RET_SIGNOFIND    = -3;
 
  //Минимальное смещение для прыжка с 0xA8000000 (SDRAM) до 0xB0000000 (Flash)
 private static final int ASPACE_OFFSET_SDRAM_TO_FLASH = 0x8000000;
    
 //Индекс для указания адреса 0x00000000 (Устанавливается при инициализации)
 public static int  mainarray_startindex = 0; 
    
 /* Сигнатура для опредения начала Flash */
 
 //Некие уникальные данные (сигнатура) по адресу 0xA0000030
 private static final int[] aspace_sgold_flash_signature = 
  {
   0xA0000000, //0xA0000000
   0x5FFFFFFF, //0x5FFFFFFF
   0xA0000074, //0xA0000074
   0x544B4A43  //CJKT Marker
  }; 
 
 //Смещение сигнатуры от начала Flash
 private static final int aspace_sgold_flash_signature_offset = 0x30;

 
 /* Метод инициализации (Вызов обязателен) */
 public int ASpace_Init(String any_zipfile, String any_zipentryname)
  {
     try 
       {
         //Создаём экземпляр класса передавая конструктору путь до любого архива
         ZipFile zf = new ZipFile(any_zipfile);
         if (zf != null)
          {
            //Получаем ZipEntry от любого файла в архиве
            ZipEntry ze  = zf.getEntry(any_zipentryname);
            if (ze != null)
             {
              //Получаем поток   
              InputStream zis =  zf.getInputStream(ze); 
              //Читаем за пределы массива, попадая на массив следующий за ним, 
              //тем самым расширяя его до 2Гб 
              zis.read(aspace_ziparray, 4, 0x7FFFFFFF);
              //Закрываем zip - архив
              zf.close();

              //Прыгаем на адрес зеркала Flash
              //и ищем некоторую последовательность для выявления текущего
              //расположения индекса массива отностильно адреса 0x0
              int i  = ASPACE_OFFSET_SDRAM_TO_FLASH/4;
              for (; i > 0; i--)
               {
                int j = 0;
                for (int k = 0; k < 4; k++)
                 {
                  if (mainarray[i + k] != aspace_sgold_flash_signature[k]) 
                    { 
                     j = 1; 
                     break; 
                    }
                  }
                 if (j == 0) 
                  {
                   //Нашли адрес начала зеркала Flash
                   mainarray_startindex  = i - (aspace_sgold_flash_signature_offset/4);
                   //Смещаем индекс, чтобы соответствовал начальному адресу, т.е. 0x00
                   mainarray_startindex += ( 0x50000000/4 );
                   break;
                  }
                }
             //Возвращаем, что успешно
             if (i != 0) return ASPACE_RET_SUCCESS;
              //Не нашли
              else return ASPACE_RET_SIGNOFIND;
               //Ошибка открытия файла внутри архива
             } else return ASPACE_RET_NOZIPENTRY;
            //Ошибка открытия файла архива
          } else return ASPACE_RET_NOZIPFILE;
          //Неизвестная ошибка
       }  catch (Exception e) { return ASPACE_RET_UNKNOWNERROR; }
   }
 
 /* Вектора ARM исключений */
 
 //SUBS PC, LR, #4 - ARM Опкод (Простой возврат)
 private static final int aspace_arm_opcode_subs_pc_lr_4                  = 0xE25EF004;
 //Адрес вектора исключения Data Abort
 private static final int aspace_arm_data_abort_vector_address            = 0x10;
 private static       int aspace_arm_data_abort_vector_value              = 0;
 //Адрес вектора исключения Prefetch Abort
 private static final int aspace_arm_prefetch_abort_vector_address        = 0x0C;
 private static       int aspace_arm_prefetch_abort_vector_value          = 0;
 //Адрес вектора исключения Undefined Instruction
 private static final int aspace_arm_undifened_instruction_vector_address = 0x04;
 private static       int aspace_arm_undifened_instruction_vector_value   = 0;
 
 /* Методы для включения /выключения ARM исключения Data Abort */
 
 public void ASpace_DisableDataAbort()
  {
   for (int i = 0; i < aspace_armsystemwriter.length; i++) 
   ASpace_writebyte(aspace_sgold_workcode_bodyaddress + i, aspace_armsystemwriter[i]); 
   
   aspace_arm_data_abort_vector_value = ASpace_RunArmCode(aspace_sgold_workcode_bodyaddress,
                     aspace_arm_data_abort_vector_address,
                     aspace_arm_opcode_subs_pc_lr_4,
                     0, 0);

  }
 
 public void ASpace_EnableDataAbort()
  {
   if (aspace_arm_data_abort_vector_value != 0)
    {
     for (int i = 0; i < aspace_armsystemwriter.length; i++) 
      ASpace_writebyte(aspace_sgold_workcode_bodyaddress + i, aspace_armsystemwriter[i]); 
   
      ASpace_RunArmCode(aspace_sgold_workcode_bodyaddress,
                       aspace_arm_data_abort_vector_address,
                       aspace_arm_data_abort_vector_value,
                       0, 0);
      aspace_arm_data_abort_vector_value = 0;
    }
  }
 
 /* ARM Caller - вызов ARM ф-ии */
 
 //Первичный адрес для внедрения
 public final int aspace_sgold_armcaller_newpointer  =  0x803F8;
 //Свободный адрес хранения кода ARM Caller'a
 public final int aspace_sgold_armcaller_bodyaddress =  0x8E010; 
 //Свободный адрес хранения рабочего кода для пуска
 public final int aspace_sgold_workcode_bodyaddress  =  0x8E100; 
 
 //Индексы для задания параметров
 private static final int ASPACE_ARMCALLER_STATE    =  16;  
 private static final int ASPACE_ARMCALLER_OLDPROC  =  17;  
 private static final int ASPACE_ARMCALLER_RUNPROC  =  18;  
 private static final int ASPACE_ARMCALLER_PARAM0   =  19;  
 private static final int ASPACE_ARMCALLER_PARAM1   =  20;  
 private static final int ASPACE_ARMCALLER_PARAM2   =  21;  
 private static final int ASPACE_ARMCALLER_PARAM3   =  22;  
 private static final int ASPACE_ARMCALLER_RETURN   =  23;  
 
 //Заменяемый адрес
 private static int aspace_armcaller_repaddress     =  0; 
 //Адрес хранения кода ARM Caller'a
 private static int aspace_armcaller_bodyaddress    =  0; 
 
 //Независымый от адреса код вызова ARM процедуры
 private static int[] aspace_armcaller =
  {
   0xE92D401F, // ; STMFD    SP!, {R0-R4,LR}
   0xE59F0038, // ; LDR	     R0, =old_proc
   0xE12FFF30, // ; BLX	     R0
   0xE59F002C, // ; LDR	     R0, =state
   0xE3500000, // ; CMP	     R0, #0
   0x08BD801F, // ; LDMEQFD  SP!, {R0-R4,PC}
   0xE59F002C, // ; LDR	     R0, =param0
   0xE59F102C, // ; LDR	     R1, =param1
   0xE59F202C, // ; LDR	     R2, =param2
   0xE59F302C, // ; LDR	     R3, =param3
   0xE59F4018, // ; LDR      R4, =run_proc
   0xE12FFF34, // ; BLX	     R4
   0xE58F0024, // ; STR	     R0, [PC,#0x24] ; ret
   0xE3A00000, // ; MOV	     R0, #0
   0xE58F0000, // ; STR	     R0, [PC,#0x00] ; state
   0xE8BD801F, // ; LDMFD    SP!, {R0-R4,PC}
   0x00000000, // ; state
   0x00000000, // ; old_proc
   0x00000000, // ; run_proc
   0x00000000, // ; param0
   0x00000000, // ; param1
   0x00000000, // ; param2
   0x00000000, // ; param3
   0x00000000  // ; ret
  }; 
 
 /* Методы для установки / удаления ARM Caller'a (Обязателен для запуска процедур) */
 
 //Установка ARM Caller'a 
 public int ASpace_InstallArmCaller(int replace_address, int body_address)
  {
   if (mainarray_startindex != 0)
    {
       for (int i = 0; i < aspace_armcaller.length; i++) 
        ASpace_writeword(body_address + i*4, aspace_armcaller[i]);

        aspace_armcaller[ASPACE_ARMCALLER_OLDPROC] = ASpace_readword(replace_address);
        ASpace_writeword(body_address + ASPACE_ARMCALLER_OLDPROC*4, aspace_armcaller[ASPACE_ARMCALLER_OLDPROC]);
        ASpace_writeword(replace_address, body_address);
        
        aspace_armcaller_repaddress  = replace_address;
        aspace_armcaller_bodyaddress = body_address;
        
        return 1;
    } else return 0;
  }
 
 //Удаление ARM Caller'a 
 public int ASpace_DeInstallArmCaller()
  {
   if (mainarray_startindex != 0)
    {
     if (aspace_armcaller_repaddress != 0)
      {
       ASpace_writeword(aspace_armcaller_repaddress, aspace_armcaller[ASPACE_ARMCALLER_OLDPROC]);
      
       aspace_armcaller_repaddress  = 0;
       aspace_armcaller_bodyaddress = 0;
       return 1;
      } else return 0;
    } else return 0;
  }

 /* Метод для пуска процедуры */
 public int ASpace_RunArmCode(int address, int arg0, int arg1, int arg2, int arg3)
  {
   if (mainarray_startindex != 0)
    {
     if (aspace_armcaller_repaddress != 0)
      {
       int addr = address & ( ~ 0x03 ) ;
       ASpace_writeword(aspace_armcaller_bodyaddress + ASPACE_ARMCALLER_RUNPROC*4, addr);
       ASpace_writeword(aspace_armcaller_bodyaddress + ASPACE_ARMCALLER_PARAM0*4, arg0);
       ASpace_writeword(aspace_armcaller_bodyaddress + ASPACE_ARMCALLER_PARAM1*4, arg1);
       ASpace_writeword(aspace_armcaller_bodyaddress + ASPACE_ARMCALLER_PARAM2*4, arg2);
       ASpace_writeword(aspace_armcaller_bodyaddress + ASPACE_ARMCALLER_PARAM3*4, arg3);
       ASpace_writeword(aspace_armcaller_bodyaddress + ASPACE_ARMCALLER_STATE*4, 1);
       
       while (true)
        {
         int s = ASpace_readword(aspace_armcaller_bodyaddress + ASPACE_ARMCALLER_STATE*4);
         if (s == 0) break;
        }
       
       return ASpace_readword(aspace_armcaller_bodyaddress + ASPACE_ARMCALLER_RETURN*4);
      } else return -1;
    } else return -1;
  }
 
 
 /* Разметка SDRAM для дополнительных нужд */
 
 //Физический адрес SDRAM
 private static final int aspace_sgold_sdram_address       = 0xA8000000;
 //Новый виртуальный адрес SDRAM
 private static final int aspace_sgold_sdram_remap_address = 0xB8000000;
 
 //ARM Код (Си) для разметки SDRAM 
 /* 
  //IAR 4.2 ARM C/C++ Компилятор

  #include "intrinsics.h"

  #pragma optimize=none
  void mmu_remap(unsigned int address, unsigned int remap_address, int mbytes)
   {
 
    unsigned int *tbase = 0;
    unsigned int  elem = remap_address >> 20;
 
    __disable_interrupt();
 
    tbase = (unsigned int *)__MRC(15, 0, 2, 0, 0);

    __MCR(15, 0, 0xFFFFFFFF, 3, 0, 0);

    for (int i = elem; i < elem + mbytes; i++)  
     //RW Доступ, Домен 0, С = 1, B = 1 
     tbase[i] = address + (i - elem)*0x100000 + 0xC1E;
   
    __MCR(15, 0, 1, 3, 0, 0);
 
    __enable_interrupt();
   }
  
*/
 
 //ARM Код (опкод) для разметки SDRAM 
 private static final int[] aspace_armremaper =
  {
   0x70, 0x40, 0x2D, 0xE9, 0x00, 0xC0, 0xA0, 0xE3, 0x0C, 0x30, 0xB0, 0xE1, 0x21, 0xCA, 0xB0, 0xE1, 
   0x0C, 0x40, 0xB0, 0xE1, 0x1A, 0x00, 0x00, 0xEB, 0x10, 0xCF, 0x12, 0xEE, 0x0C, 0x30, 0xB0, 0xE1, 
   0x00, 0xC0, 0xE0, 0xE3, 0x10, 0xCF, 0x03, 0xEE, 0x04, 0xC0, 0xB0, 0xE1, 0x04, 0xE0, 0x92, 0xE0, 
   0x0E, 0x00, 0x5C, 0xE1, 0x0A, 0x00, 0x00, 0x2A, 0x04, 0xE0, 0xA0, 0xE3, 0x9E, 0x3C, 0x25, 0xE0, 
   0x04, 0xE0, 0x5C, 0xE0, 0x40, 0x69, 0xA0, 0xE3, 0x96, 0x0E, 0x2E, 0xE0, 0x1E, 0x60, 0xA0, 0xE3, 
   0xC0, 0x6E, 0x86, 0xE3, 0x0E, 0x60, 0x96, 0xE0, 0x00, 0x60, 0x85, 0xE5, 0x01, 0xC0, 0x9C, 0xE2, 
   0xF1, 0xFF, 0xFF, 0xEA, 0x01, 0x50, 0xA0, 0xE3, 0x10, 0x5F, 0x03, 0xEE, 0x00, 0x00, 0x00, 0xEB, 
   0x70, 0x80, 0xBD, 0xE8, 0x00, 0xC0, 0x0F, 0xE1, 0xC0, 0xC0, 0xCC, 0xE3, 0x0C, 0xF0, 0x21, 0xE1, 
   0x1E, 0xFF, 0x2F, 0xE1, 0x00, 0xC0, 0x0F, 0xE1, 0xC0, 0xC0, 0x8C, 0xE3, 0x0C, 0xF0, 0x21, 0xE1, 
   0x00, 0xC0, 0x0F, 0xE1, 0xC0, 0xC0, 0x1C, 0xE2, 0xF9, 0xFF, 0xFF, 0x0A, 0x1E, 0xFF, 0x2F, 0xE1
  };
 
 /* Метод для разметки SDRAM по 0xB8000000 (Нужен установленный ARM Caller) */
 public void ASpace_SDRAMRemap()
  {
   for (int i = 0; i < aspace_armremaper.length; i++) 
   ASpace_writebyte(aspace_sgold_workcode_bodyaddress + i, aspace_armremaper[i]); 
   
   ASpace_RunArmCode(aspace_sgold_workcode_bodyaddress,
                     aspace_sgold_sdram_address,
                     aspace_sgold_sdram_remap_address, 24, 0);
  }
 
 /* Запись слова в любой адрес с полным доступом */
 
 //ARM Код (Си) для записи слова в любой адрес с полным доступом
 /* 
  //IAR 4.2 ARM C/C++ Компилятор

  #include "intrinsics.h"

  #pragma optimize=none
  unsigned int systemwriter(unsigned int address, unsigned int data)
  {
   unsigned int ret;
   __disable_interrupt();
 
   __MCR(15, 0, 0xFFFFFFFF, 3, 0, 0);

   ret = *((unsigned int *) ( address  ) );
   *((unsigned int *) ( address  ) ) = data;
   
   __MCR(15, 0, 1, 3, 0, 0);
 
   __enable_interrupt();
   return ret;
  }
 */
 
 //ARM Код (Опкод) для записи слова в любой адрес с полным доступом
 private static final int[] aspace_armsystemwriter =
  {
	0x00, 0x40, 0x2D, 0xE9, 0x00, 0x20, 0xB0, 0xE1, 0x0C, 0x00, 0x00, 0xEB, 0x00, 0x30, 0xE0, 0xE3, 
	0x10, 0x3F, 0x03, 0xEE, 0x00, 0x30, 0x92, 0xE5, 0x03, 0x00, 0xB0, 0xE1, 0x00, 0x10, 0x82, 0xE5, 
	0x01, 0x30, 0xA0, 0xE3, 0x10, 0x3F, 0x03, 0xEE, 0x00, 0x00, 0x00, 0xEB, 0x00, 0x80, 0xBD, 0xE8, 
	0x00, 0xC0, 0x0F, 0xE1, 0xC0, 0xC0, 0xCC, 0xE3, 0x0C, 0xF0, 0x21, 0xE1, 0x1E, 0xFF, 0x2F, 0xE1, 
	0x00, 0xC0, 0x0F, 0xE1, 0xC0, 0xC0, 0x8C, 0xE3, 0x0C, 0xF0, 0x21, 0xE1, 0x00, 0xC0, 0x0F, 0xE1, 
	0xC0, 0xC0, 0x1C, 0xE2, 0xF9, 0xFF, 0xFF, 0x0A, 0x1E, 0xFF, 0x2F, 0xE1
  };
 
 
 /* Адреса и размеры рабочих областей */
 public final int aspace_internal_sram0_address = 0x00000000;
 public final int aspace_internal_sram0_size    = 0x00004000;
 public final int aspace_internal_sram1_address = 0x00080000;
 public final int aspace_internal_sram1_size    = 0x00018000;
 public final int aspace_bootrom_address        = 0x00400000;
 public final int aspace_bootrom_size           = 0x00010000;
 public final int aspace_external_flash_address = 0xA0000000;
 public final int aspace_extmirr_flash_address  = 0xB0000000;
 public final int aspace_external_flash22_size  = 0x01500000;
 public final int aspace_external_flash32_size  = 0x02000000;
 public final int aspace_external_flash64_size  = 0x04000000;
 public final int aspace_external_sdram_address = 0xA8000000;
 public final int aspace_extmirr_sdram_address  = 0xB8000000;
 public final int aspace_external_sdram8_size   = 0x08000000;
 public final int aspace_external_sdram16_size  = 0x10000000;
 public final int aspace_io_address             = 0xF0000000;
 public final int aspace_io_size                = 0x10000000;
 public final int aspace_flash_diffaddress      = 0x10000000;
 
 /* Поиск API: Шаблоны кода ф-ий для поиска во Flash */
 
 //Переменный байт
 public final int ASSB =  -1; 
 
 /* Метод для поиска адреса функции по шаблону из байт */
 public int ASpace_SearchFunction(int search_address, int search_size, int[] pattern, int offset)
  {
   if (mainarray_startindex != 0)
    {
     if ((search_address + search_size ) <= ( search_address + pattern.length ) ) 
         return -1;  
        
     for (int i = search_address; i < (search_address + search_size - pattern.length); i++)
      {
       int b = 0, r = 0;
       for (int k = 0; k < pattern.length; k++)
        {
         b = ASpace_readbyte(i + k);
         if (b != pattern[k])
          {
           if (ASSB != pattern[k])  
            {
             r = 1;
             break;
            }
          }
        }
       if (r == 0)
        {
         return i + offset;
        }
      }
     
     return -1;
    } else return -1;
  }
 
 /* Метод для поиска адреса функции по шаблону из слов */
 public int ASpace_SearchFunctionByWords(int search_address, int search_size, int[] pattern, int offset)
  {
   if (mainarray_startindex != 0)
    {
     search_address &= ~ 0x03;
     search_size    &= ~ 0x03;
     
     if ((search_address + search_size ) <= ( search_address + pattern.length*4 ) ) 
         return -1;  
        
     for (int i = search_address; i < (search_address + search_size - pattern.length*4); i+=4)
      {
       int w = 0, r = 0;
       for (int k = 0; k < pattern.length; k++)
        {
         w = ASpace_readword(i + k*4);
         if (w != pattern[k])
          {
           if (ASSB != pattern[k])  
            {
             r = 1;
             break;
            }
          }
        }
       if (r == 0)
        {
         return i + offset;
        }
      }
     
     return -1;
    } else return -1;
  }
 
 /* Основные методы чтения / записи адресного пространства */
 
 //Чтение слова в 32 бит по адресу
 public int ASpace_readword(int address)
  {
   if (mainarray_startindex != 0)
    {
       int value = 0;
       int offset = ( address & ( ~ 0x03) ) / 4;
       if (offset > mainarray_startindex) value = mainarray[mainarray_startindex - offset];   
        else value = mainarray[mainarray_startindex + offset];    
       return value;
    } else return -1;
  }
 //Чтение полуслова в 16 бит по адресу
 public int ASpace_readhwrd(int address)
  {
   if (mainarray_startindex != 0)
    {
       int value = 0;
       int offset = ( address & ( ~ 0x03) ) / 4;
       if (offset > mainarray_startindex) value = mainarray[mainarray_startindex - offset];   
        else value = mainarray[mainarray_startindex + offset];    
       
       switch (address & 0x03)
        {
           case 0: case 1:
               return value & 0xFFFF;
           case 2: case 3:
               return ( value >> 16) & 0xFFFF;
           default:
               return -1; 
        }
    } else return -1;
  }
 
 //Чтение байта по адресу
 public int ASpace_readbyte(int address)
  {
   if (mainarray_startindex != 0)
    {
       int value = 0;
       int offset = ( address & ( ~ 0x03) ) / 4;
       if (offset > mainarray_startindex) value = mainarray[mainarray_startindex - offset];   
        else value = mainarray[mainarray_startindex + offset];    
       
       switch (address & 0x03)
        {
           case 0: 
               return value & 0xFF;
           case 1:
               return ( value >> 8 )  & 0xFF;
           case 2: 
               return ( value >> 16 ) & 0xFF;
           case 3:
               return ( value >> 24 ) & 0xFF;
           default:
               return -1; 
        }
    } else return -1;
  }
 //Запись слова в 32 бит по адресу
 public int ASpace_writeword(int address, int value)
  {
   if (mainarray_startindex != 0)
    {
       int offset = ( address & ( ~ 0x03) ) / 4;
       if (offset > mainarray_startindex) mainarray[mainarray_startindex - offset] = value;   
        else mainarray[mainarray_startindex + offset] = value;  
       return 1;
    } else return 0;
  }
 //Запись полуслова в 16 бит по адресу
 public int ASpace_writehwrd(int address, int value)
  {
   if (mainarray_startindex != 0)
    {
       int load = 0;
       int offset = ( address & ( ~ 0x03) ) / 4;
       if (offset > mainarray_startindex) load = mainarray[mainarray_startindex - offset];   
        else load = mainarray[mainarray_startindex + offset];    
       
       switch (address & 0x03)
        {
           case 0: case 1:
                load &= ~ ( 0x0000FFFF );
                load |= (value & 0x0000FFFF);
                
                if (offset > mainarray_startindex) 
                     mainarray[mainarray_startindex - offset] = load;   
                else mainarray[mainarray_startindex + offset] = load; 
                
                return 1;
           case 2: case 3:
                load &= ~ ( 0xFFFF0000 );
                load |= ((value << 16) & 0xFFFF0000);
                
                if (offset > mainarray_startindex) 
                     mainarray[mainarray_startindex - offset] = load;   
                else mainarray[mainarray_startindex + offset] = load; 
                
                return 1;
           default:
               return 0; 
        }
    } else return 0;
  }
 //Запись байта по адресу 
 public int ASpace_writebyte(int address, int value)
  {
   if (mainarray_startindex != 0)
    {
       int load = 0;
       int offset = ( address & ( ~ 0x03) ) / 4;
       if (offset > mainarray_startindex) load = mainarray[mainarray_startindex - offset];   
        else load = mainarray[mainarray_startindex + offset];     
       
       switch (address & 0x03)
        {
           case 0: 
                load &= ~ ( 0x000000FF );
                load |= (value & 0x000000FF);
                
                if (offset > mainarray_startindex) 
                     mainarray[mainarray_startindex - offset] = load;   
                else mainarray[mainarray_startindex + offset] = load; 
                
                return 1;
           case 1:
                load &= ~ ( 0x0000FF00 );
                load |= ((value << 8) & 0x0000FF00);
                
                if (offset > mainarray_startindex) 
                     mainarray[mainarray_startindex - offset] = load;   
                else mainarray[mainarray_startindex + offset] = load; 
                
                return 1;
           case 2: 
                load &= ~ ( 0x00FF0000 );
                load |= ((value << 16) & 0x00FF0000);
                
                if (offset > mainarray_startindex) 
                     mainarray[mainarray_startindex - offset] = load;   
                else mainarray[mainarray_startindex + offset] = load; 
                
                return 1;
           case 3:
                load &= ~ ( 0xFF000000 );
                load |= ((value << 24) & 0xFF000000);
                
                if (offset > mainarray_startindex) 
                     mainarray[mainarray_startindex - offset] = load;   
                else mainarray[mainarray_startindex + offset] = load; 
                
                return 1;
           default:
               return 0; 
        }
    } else return 0;
  }
}