#include "../../inc\swilib.h"
#include "../tbase\tbase.h"

#include "../jelfloader.h"

#include "../swihook.h"
#include "esi.h"

/*  ESI  */

unsigned int esi_patch_vrezka = 0;
unsigned int esi_patch_ret    = 0;

unsigned int char8to16(int c)
{
  if (c==0xA8) c=0x401;
  if (c==0xAA) c=0x404;
  if (c==0xAF) c=0x407;
  if (c==0xB8) c=0x451;
  if (c==0xBA) c=0x454;
  if (c==0xBF) c=0x457;
  if (c==0xB2) c=0x406;
  if (c==0xB3) c=0x456;
  if ((c>=0xC0)&&(c<0x100)) c+=0x350;
  return(c);
}

void ascii2ws(char *s, WSHDR *ws)
{
  int c;
  while((c=*s++))
  {
    wsAppendChar(ws,char8to16(c));
  }
}

__arm void esi_patch_continue(char *s, WSHDR *ws)
{
  if (((unsigned int)s>>28) == 0xA) //    RAM/FLASH
  {
    CutWSTR(ws,0); 
    ascii2ws(s,ws);
  } else wsprintf(ws,"|%d|",s);
}

void __jel_esipatch_init()
{
 if (jelfloader_ptcctrl_isESIEnable())
  {
   unsigned int esi_func_entry = __jel_swihook_getfunc(SWINUM_ESIPATCHFUNC);
   esi_func_entry &= ~ 1;

   esi_patch_vrezka = esi_func_entry + ESI_PATCH_VREZKA_OFFSET;
   esi_patch_ret    = esi_func_entry + ESI_PATCH_RET_OFFSET;
 
   unsigned char *ec = (unsigned char *)((int)&esi_vrezka_entry - 1);
 
   for (int i = 0; i < ESI_PATCH_VREZKA_SIZE; i++)
     ApplyPatch((void *)(esi_patch_vrezka + i), ec[i]);
  }
}

