#include "../inc/swilib.h"
#include "util/search_pattern.h"

#include "config/bcfg_loader.h"

#include "patches/png.h"
#include "patches/esi.h"
#include "patches/keyhook.h"


#include "jelfloader.h"
#include "swihook.h"
#include "helper.h"
#include "fs32.h"
#include "ext.h"
#include "daemons.h"

int patches_ena = 0;

void jelfloader_ptcctrl_init(unsigned int *swilib)
{
 patches_ena = swilib[0];
}

int jelfloader_ptcctrl_isESIEnable()
{
 if (((patches_ena&0x00F)>>0) == 1) return 1;
  else return 0;
}

int jelfloader_ptcctrl_isKeyHookEnable()
{
 if (((patches_ena&0x0F0)>>4) == 1) return 1;
  else return 0;
}

int jelfloader_ptcctrl_isPITPatchEnable()
{
 if (((patches_ena&0xF00)>>8) == 1) return 1;
  else return 0;
}

#pragma segment="ELFBEGIN"
int jelfloader(void *elf_base, unsigned int *swilib, void *(*jmalloc)(unsigned int size), void (*jfree)(void *ptr))
{
 jelfloader_ptcctrl_init(swilib);
  
 __jel_swihook_install(swilib);
 __jel_fs32_install();
 
 InitConfig();
 
 __jel_helper_install();

 __jel_esipatch_init();
 __jel_keyhookpatch_init();
 __jel_pitpatch_init();
 __jel_elfextreg();
 
 __jel_daemons_subrun();
 
 return 1;
}

