
#ifdef __SUDOKU__ 
#define __FILEMAN_SUDOKU__


int FILEMAN = 0, FILEMAN2 = 0;
char smffilepath[256];
char back[] = LG_FILEMAN_BACK;


char pt[]="%t";
char ps[]="%s";
char pc[]="%c";

typedef struct
{
  void *next;
  char *fullname;
  char *name;
  int is_folder;
}FLIST;

typedef struct
{
  void *gui;
  int type;
}FVIEW;

volatile FLIST *fltop;

void Free_FLIST(void)
{
  LockSched();
  FLIST *fl=(FLIST *)fltop;
  fltop=0;
  UnlockSched();
  while(fl)
  {
    FLIST *fl_prev;
    fl_prev=fl;
    fl=fl->next;
    mfree(fl_prev->fullname);
    mfree(fl_prev->name);
    mfree(fl_prev);
  }
}

#define IS_FOLDER 1
#define IS_FILE 0

        
int GetFListN()
{
  int i=0;
  FLIST *fl=(FLIST*)&fltop;
  while((fl=fl->next)) i++;
  return (i);
}

int GetFoldersLevel(char *name)
{
  int i=0;
  char *s=name;
  while(*s++)
  {
    if (*s=='\\' &&*(s+1)!=0) i++;    
  }
  return (i);
}

FLIST *AddToFList(const char* full_name, const char *name, int is_folder)
{
  FLIST *fl;
  FLIST *pr;
  FLIST *fn=malloc(sizeof(FLIST));
  fn->fullname=malloc(strlen(full_name)+1);
  strcpy(fn->fullname,full_name);
  
  fn->name=malloc(strlen(name)+1);
  strcpy(fn->name,name);
  
  fn->is_folder=is_folder;
  fn->next=0;
  fl=(FLIST *)fltop;
  if (fl)
  {
    pr=(FLIST *)&fltop;
    while(strcmp_nocase(fl->name,fn->name)<0)
    {
      pr=fl;
      fl=fl->next;
      if (!fl) break;
    }
    fn->next=fl;
    pr->next=fn;
  }
  else
  {
    fltop=fn;
  }
  return (fn);  
}

void FindFiles(char *str, int type)  // type == 0 SelectFolder, type == 1 SelectFile
{
#ifdef MULTISGOLD
DIR_ENTRY de;
DIR_ENTRY_SG de_sg;
#else
  DIR_ENTRY de;              
#endif
  
  unsigned int err;
  int i, c;
  char name[256]; 
  char fname[128];

  Free_FLIST();
  strcpy(name,str);
  strcat(name,"*");
  
  i=GetFoldersLevel(str);
  if (i==0)
  {
    AddToFList(LG_FILEMAN_SELDISK,back,IS_FOLDER);
  }
  else
  {
    char *s=str;
    char *d=fname;
    for (int k=0; k!=i && *s; )
    {
      c=*s++;
      *d++=c;
      if (c=='\\')  k++;
    }
    *d=0;
    AddToFList(fname,back,IS_FOLDER);
  }
#ifndef MULTISGOLD
  if (FindFirstFile(&de,name,&err))
  {
    do
    {
      strcpy(name,de.folder_name);
      strcat(name,"\\");
      strcat(name,de.file_name);
      if (de.file_attr&FA_DIRECTORY)
      {
        strcpy(fname,"\\");
        strcat(fname,de.file_name);
        strcat(name,"\\");
        AddToFList(name,fname,IS_FOLDER);
      }
      else
      {
        if (type!=0)
        {
          AddToFList(name,de.file_name,IS_FILE);
        }
      }
    }
    while(FindNextFile(&de,&err));
  }
  FindClose(&de,&err);
#else
if (!IF_SGOLD)
{
   if (FindFirstFile(&de,name,&err))
  {
    do
    {
      strcpy(name,de.folder_name);
      strcat(name,"\\");
      strcat(name,de.file_name);
      if (de.file_attr&FA_DIRECTORY)
      {
        strcpy(fname,"\\");
        strcat(fname,de.file_name);
        strcat(name,"\\");
        AddToFList(name,fname,IS_FOLDER);
      }
      else
      {
        if (type!=0)
        {
          AddToFList(name,de.file_name,IS_FILE);
        }
      }
    }
    while(FindNextFile(&de,&err));
  }
  FindClose(&de,&err);
} else
  if (FindFirstFile((DIR_ENTRY *)&de_sg,name,&err))
  {
    do
    {
      strcpy(name,de_sg.folder_name);
      strcat(name,"\\");
      strcat(name,de_sg.file_name);
      if (de_sg.file_attr&FA_DIRECTORY)
      {
        strcpy(fname,"\\");
        strcat(fname,de_sg.file_name);
        strcat(name,"\\");
        AddToFList(name,fname,IS_FOLDER);
      }
      else
      {
        if (type!=0)
        {
          AddToFList(name,de_sg.file_name,IS_FILE);
        }
      }
    }
    while(FindNextFile((DIR_ENTRY *)&de_sg,&err));
  }
  FindClose((DIR_ENTRY *)&de_sg,&err);
 
  
#endif
}



FLIST *FindFLISTtByNS(int *i, int si)
{
  FLIST *fl;
  fl=(FLIST *)fltop;
  while(fl)
  {
    if (fl->is_folder==si)
    {
      if (!(*i)) return (fl);
      (*i)--;
    }    
    fl=fl->next;
  }
  return fl;
}
  
FLIST *FindFLISTtByN(int n)
{
  FLIST *fl;
  fl=FindFLISTtByNS(&n,IS_FOLDER); if ((!n)&&(fl)) return(fl);
  fl=FindFLISTtByNS(&n,IS_FILE); if ((!n)&&(fl)) return(fl);
  return fl;
}


void SavePath(void *ed_gui, FLIST *fl)
{ 
  sprintf(smffilepath,fl->fullname);
#ifndef SMFEDITOR
  ClearSUDOKUMAP(sdm);
  MemFreeOfSUDOKUMAP(sdm);
  sdm = CreateSUDOKUMAPbySDKFILE(fl->fullname);
  if (sdm->error == 0x02)
   {
     ClearSUDOKUMAP(sdm);
     MemFreeOfSUDOKUMAP(sdm);
     sdm = CreateSUDOKUMAPbyEXTFILE(fl->fullname);
   }
  if (sdm->error > 0)
   {
    if (sdm->error == 0x01) ShowMessage(LG_LOGO_EXTFILE_E1, bcfg_msg_font, MSGERROR);
    if (sdm->error == 0x02) ShowMessage(LG_LOGO_EXTFILE_E2, bcfg_msg_font, MSGERROR);
    if (sdm->error == 0x03) ShowMessage(LG_LOGO_EXTFILE_E3, bcfg_msg_font, MSGERROR);
    if (sdm->error == 0x04) ShowMessage(LG_LOGO_EXTFILE_E4, bcfg_msg_font, MSGERROR);
    MemFreeOfSUDOKUMAP(sdm);
    sdm = CreateVoidSUDOKUMAP();
   }
#else
  extern int SAVEMENU;
  if (SAVEMENU == 0)
   { 
    ClearSUDOKUMAP(sdm);
    MemFreeOfSUDOKUMAP(sdm);
    sdm = CreateSUDOKUMAPbySDKFILE(fl->fullname);
    if (sdm->error == 0x02)
     {
      ClearSUDOKUMAP(sdm);
      MemFreeOfSUDOKUMAP(sdm);
      sdm = CreateSUDOKUMAPbyEXTFILE(fl->fullname);
     }
    if (sdm->error > 0)
     {
      if (sdm->error == 0x01) ShowMessage(LG_LOGO_EXTFILE_E1, bcfg_msg_font, MSGERROR);
      if (sdm->error == 0x02) ShowMessage(LG_LOGO_EXTFILE_E2, bcfg_msg_font, MSGERROR);
      if (sdm->error == 0x03) ShowMessage(LG_LOGO_EXTFILE_E3, bcfg_msg_font, MSGERROR);
      if (sdm->error == 0x04) ShowMessage(LG_LOGO_EXTFILE_E4, bcfg_msg_font, MSGERROR);
      MemFreeOfSUDOKUMAP(sdm);
      sdm = CreateVoidSUDOKUMAP();
     }
   } else
    {
      FILEMAN2 = 1;
    }
#endif
}

#ifndef MULTISGOLD
#pragma inline
void patch_header(const HEADER_DESC* head)
{
  ((HEADER_DESC*)head)->rc.x=0;
  ((HEADER_DESC*)head)->rc.y=YDISP;
  ((HEADER_DESC*)head)->rc.x2=ScreenW()-1;
  ((HEADER_DESC*)head)->rc.y2=HeaderH()+YDISP-1;
}
#pragma inline
void patch_input(const INPUTDIA_DESC* inp)
{
  ((INPUTDIA_DESC*)inp)->rc.x=0;
  ((INPUTDIA_DESC*)inp)->rc.y=HeaderH()+1+YDISP;
  ((INPUTDIA_DESC*)inp)->rc.x2=ScreenW()-1;
  ((INPUTDIA_DESC*)inp)->rc.y2=ScreenH()-SoftkeyH()-1;
}

#else
#pragma inline
void patch_header(const HEADER_DESC* head)
{
  ((HEADER_DESC*)head)->rc.x=0;
   if (IF_ELKA) ((HEADER_DESC*)head)->rc.y=ICONB; else ((HEADER_DESC*)head)->rc.y=0;
  ((HEADER_DESC*)head)->rc.x2=SCRW-1;
  if (IF_ELKA) ((HEADER_DESC*)head)->rc.y2=HEADH + ICONB -1; else ((HEADER_DESC*)head)->rc.y2=HEADH-1;
}

#pragma inline
void patch_input(const INPUTDIA_DESC* inp)
{
  ((INPUTDIA_DESC*)inp)->rc.x=0;
  if (IF_ELKA) ((INPUTDIA_DESC*)inp)->rc.y=HEADH+1+ICONB; else ((INPUTDIA_DESC*)inp)->rc.y=HEADH+1;
  ((INPUTDIA_DESC*)inp)->rc.x2=SCRH-1;
  ((INPUTDIA_DESC*)inp)->rc.y2=SCRH-SOFTH-1;
}
#endif
char header[];
int filelist_menu_onkey(void *data, GUI_MSG *msg)
{
  if (FILEMAN==1) {
  FVIEW *fview=MenuGetUserPointer(data);
  FLIST *fl;
  int i;
  i=GetCurMenuItem(data);
  fl=FindFLISTtByN(i);
  
  if (msg->keys==0x3D)
  {
    if (fl) 
    {
      if (fl->is_folder==IS_FOLDER)
      {
        int len;
        if (strcmp(fl->fullname,LG_FILEMAN_SELDISK))
        {
          strncpy(header,fl->fullname,127);
          len=strlen(fl->fullname);
          header[len>127?127:len]=0;
          FindFiles(fl->fullname,1);
        }
        else
        {
          void CreateRootMenu();
          CreateRootMenu();
        }         
        Menu_SetItemCountDyn(data,GetFListN());
        SetCursorToMenuItem(data, 0);
        RefreshGUI();
      }
      else
      {
        SavePath(fview->gui,fl);
        FILEMAN=0;
        return (1);
      }
    }
    //    GeneralFunc_F1(1);
    return(-1);
  }
  if (msg->keys==0x18)
  {
    if (fl)
    {
      if (strcmp(fl->name,back))
      {
        SavePath(fview->gui,fl);
        FILEMAN=0;
        return (1);
      }      
    }
    
    return (-1);
  }
  }
  return (0);

}

void filelist_menu_ghook(void *data, int cmd)
{
  FVIEW *fview=MenuGetUserPointer(data);
  if (cmd==3)
  {
    Free_FLIST();
    mfree(fview);    
  }
  DisableIDLETMR();
}

void filelist_menu_iconhndl(void *data, int curitem, void *user_pointer)
{
  FLIST *fl;
  WSHDR *ws;
  void *item=AllocMenuItem(data);
  int len;
  fl=FindFLISTtByN(curitem);
  if (fl)
  {
    len=strlen(fl->name);
    ws=AllocMenuWS(data,len+4);
    
    if (fl->is_folder)
    {
      str_2ws(ws,fl->name,len);
      wsInsertChar(ws,0x0002,1);
      wsInsertChar(ws,0xE008,1);
    }
    else
    {
      str_2ws(ws,fl->name,len);
    }
  }
  else
  {
    ws=AllocMenuWS(data,10);
    wsprintf(ws, LG_ERROR);
  }
  SetMenuItemText(data, item, ws, curitem);
}

int fmenusoftkeys[]={0,1,2};
SOFTKEY_DESC fmenu_sk[]=
{
  {0x0018,0x0000,(int)LG_FILEMAN_SELECT},
  {0x0001,0x0000,(int)LG_FILEMAN_CLOSE},
  {0x003D,0x0000,(int)LG_FILEMAN_X}
};

SOFTKEYSTAB fmenu_skt=
{
  fmenu_sk,1
};
char header[128];
HEADER_DESC filelist_HDR={0,0,0,0,NULL,(int)header,LGP_NULL};


//////////////////////    =(,  (void*)...

MENU_DESC filelist_STRUCT=
{
  8,filelist_menu_onkey,filelist_menu_ghook,NULL,
  fmenusoftkeys,
  &fmenu_skt,
  0x10,
  filelist_menu_iconhndl,
  NULL,   //Items
  NULL,   //Procs
  0 
};

void CreateRootMenu()
{
  Free_FLIST();
  AddToFList("0:\\","0:\\",IS_FOLDER);
  AddToFList("1:\\","1:\\",IS_FOLDER);
  AddToFList("2:\\","2:\\",IS_FOLDER);
  AddToFList("4:\\","4:\\",IS_FOLDER);
  strcpy(header,LG_FILEMAN_SELDISK);
}

void open_fm(char *pathfolder, int type)
{
  FVIEW *fview;
  char *s;
  WSHDR *ws_pf=AllocWS(256);
  wsprintf(ws_pf,pathfolder);
  fview=malloc(sizeof(FVIEW));
  if (ws_pf->wsbody[0]==0)
  {
    CreateRootMenu();
  }
  else
  {
    ws_2str(ws_pf,header,127);
    s=strrchr(header, '\\');
    if (s) *(s+1)=0;
    int len=strlen(header);
    header[len>127?127:len]=0;
    FindFiles(header,type);
  }    
  patch_header(&filelist_HDR);
  CreateMenu(0,0,&filelist_STRUCT,&filelist_HDR,0,GetFListN(),fview,0);
  if (ws_pf) FreeWS(ws_pf);
}

#endif
