//ExtTheme
//et_draw.c
//(c)Dimadze

#include "..\inc\swilib.h"

#ifdef  SCREEN_132_176
#define SCREEN_W 132
#define SCREEN_H 176
#else
#ifdef SCREEN_130_130
#define SCREEN_W 130
#define SCREEN_H 130
#else
#ifdef SCREEN_128_160
#define SCREEN_W 128
#define SCREEN_H 160
#else
#define SCREEN_W 240
#define SCREEN_H 320
#endif
#endif
#endif


extern void  InitConfig();

extern int patch_ena;
extern int bg_ena;

extern unsigned int hlimit;
extern unsigned int wlimit;

extern unsigned int hlim_pb;

extern char col_p[];
extern char col_b[];
extern char col_bg[];

extern char et_folder[];

#define INIT_MAGIC 0x12F33F21

int init_first = 0;

char *ic_sim = 0;
char *ic_top = 0;
char *ic_bot = 0;
char *ic_opt = 0;
char *ip_big = 0;
char *ip_sml = 0;

int   is_big_pb = 0;
short ip_corend = 0;
char  ip_col_fill[4];
char  ip_col_shadow[4];


__thumb CheckFirstConfigInit()
{
   if (init_first != INIT_MAGIC)
    {
      init_first = INIT_MAGIC;
      InitConfig();
      
      ic_sim = malloc(256);
      ic_top = malloc(256);
      ic_bot = malloc(256);
      ic_opt = malloc(256);
      ip_big = malloc(256);
      ip_sml = malloc(256);
      
      sprintf(ic_sim, "%sic_sim.png", et_folder);
      sprintf(ic_top, "%sic_top.png", et_folder);
      sprintf(ic_bot, "%sic_bot.png", et_folder);
      sprintf(ic_opt, "%sic_opt.png", et_folder);
      sprintf(ip_big, "%sip_big.png", et_folder);
      sprintf(ip_sml, "%sip_sml.png", et_folder);
    }
}


__arm void DrawImageCursor(int x1, int y1, int x2, int y2, int x_round, int y_round, int flags, const char *pen, const char *brush)
{

   CheckFirstConfigInit();
   if (patch_ena == 1)
    {
     int wc = 0;
     
     int w_sim =  GetImgWidth((int)ic_sim);
     int w_top =  GetImgWidth((int)ic_top);
     int w_bot =  GetImgWidth((int)ic_bot);
     int w_opt =  GetImgWidth((int)ic_opt);
     int h_bot =  GetImgHeight((int)ic_bot);
     
     int xd = x2 - x1;
     int yb = y2 - h_bot;
     int hc = y2 - y1;
     
     if (!w_top && !w_bot) wc = x2 - x1;
     else 
      {
       if (!w_top) wc = w_bot;
              else wc = w_top; 
       if (w_top && w_bot) 
        {
         if (w_top >= w_bot) wc = w_top;
                        else wc = w_bot;
        }
      }
  
     if (hc < hlimit)
      {
       if (xd > wlimit)
        {
         if (!w_sim) DrawRectangle(x1, y1, x2, y2, 0, col_p, col_b);
                else DrawImg(x1, y1, (int)ic_sim);
        } else
           {
            if (!w_opt) DrawRectangle(x1, y1, x2, y2, 0, col_p, col_b);
                  else  DrawImg(x1, y1, (int)ic_opt);
           }
      } else
         {
          DrawRectangle(x1, y1, x1 + wc - 1, y2 - 1, 0, col_p, col_b);
          if (w_bot) DrawImg(x1, yb, (int)ic_bot); 
          if (w_top) DrawImg(x1, y1, (int)ic_top);
         }
 
    } else DrawRoundedFrame(x1, y1, x2, y2, x_round, y_round, flags, pen, brush);
}



__arm void GetColorPB_Shadow(int x,int y,int x2,int y2,int type, char *pen)
{
 ip_col_shadow[0] = pen[0];
 ip_col_shadow[1] = pen[1];
 ip_col_shadow[2] = pen[2];
 ip_col_shadow[3] = pen[3];
}


__arm void DrawImageProgressBarBG(short x1, short y1, short x2, short y2, int flags,const char *pen,const char *brush)
{
 CheckFirstConfigInit();
 
 if (patch_ena == 1)
   {
    int w_pb, h_pb;
    
    if ((y2 - y1) > hlim_pb) is_big_pb = 1;
                        else is_big_pb = 0;
    
    if (is_big_pb) 
     {
      w_pb =  GetImgWidth((int)ip_big);
      h_pb =  GetImgHeight((int)ip_big);
     } else 
        {
         w_pb =  GetImgWidth((int)ip_sml);
         h_pb =  GetImgHeight((int)ip_sml);
        }
    
    if (w_pb || h_pb)
     {
       ip_corend = x2 - 1;
 
       ip_col_fill[0] = brush[0];
       ip_col_fill[1] = brush[1];
       ip_col_fill[2] = brush[2];
       ip_col_fill[3] = brush[3];

 
       short mod_x0 = (ScreenW() / 2) - (w_pb / 2);
       short mod_xe = mod_x0 + w_pb;
 
       DrawRectangle(mod_x0 - 1, y1, mod_xe, y1 + h_pb + 1, 0, pen, brush);
       DrawLine(mod_x0, y1 + h_pb + 2,  mod_xe + 1, y1 + h_pb + 2,0, ip_col_shadow);
       DrawLine(mod_xe + 1, y1 + 1,  mod_xe + 1, y1 + h_pb + 2,0, ip_col_shadow);
     } else 
        {
         DrawRectangle(x1, y1, x2, y2, flags, pen, brush);
         DrawLine(x1, y2 + 1,  x2 + 1, y2 + 1, 0, ip_col_shadow);
         DrawLine(x2 + 1, y1 + 1,  x2 + 1, y2 + 1, 0, ip_col_shadow);
        }
   } else 
      {
       DrawRectangle(x1, y1, x2, y2, flags, pen, brush);
       DrawLine(x1, y2 + 1,  x2 + 1, y2 + 1, 0, ip_col_shadow);
       DrawLine(x2 + 1, y1 + 1,  x2 + 1, y2 + 1, 0, ip_col_shadow);
      }
}

__arm void DrawImageProgressBar(short x1, short y1, short x2, short y2, int flags,const char *pen,const char *brush)
{
 if (patch_ena == 1)
   {
    int w_pb, h_pb;
     
    short def_x0 = x1 - 1;
    short def_xe = ip_corend;
    short def_xc = x2;
    
    if (is_big_pb) 
     {
      w_pb =  GetImgWidth((int)ip_big);
      h_pb =  GetImgHeight((int)ip_big);
     } else 
        {
         w_pb =  GetImgWidth((int)ip_sml);
         h_pb =  GetImgHeight((int)ip_sml);
        }
    
    if (w_pb || h_pb)
     {
       double c =  ((double)(def_xe - def_x0)) / ((double)( def_xc - def_x0));
 
       short  mod_x0 = (ScreenW() / 2) - (w_pb / 2);
       short  mod_xe = mod_x0 + w_pb;
       double mod_xc = ((c * (double)mod_x0) + (double)mod_xe - (double)mod_x0) / c;
 
      if (is_big_pb) DrawImg(mod_x0, y1, (int)ip_big);
                else DrawImg(mod_x0, y1, (int)ip_sml);
              
      if (mod_xc != mod_xe) DrawRectangle(mod_xc, y1, mod_xe - 1, y1 + h_pb - 1, 0, ip_col_fill, ip_col_fill);
     } else
       {
        DrawRectangle(x1, y1, x2, y2, flags, pen, brush);
       }
   } else 
     {
      DrawRectangle(x1, y1, x2, y2, flags, pen, brush);
     }
}
