
import java.io.*;

public class ElfLoader
 {
 public   String melfloader_location;
 public   int    melfloaderbody_address;
  
 private  ASpace aspace;
 private  int    malloc_address;
 private  int    free_address;
 
 /* 
   Получение адреса malloc через SWIHOOK

   ARM Код:
  
   SWI 0x8014
   BX  LR

 */
 private  int[]  get_malloc_address =
  {
   0x14, 0x80, 0x00, 0xEF, 0x1E, 0xFF, 0x2F, 0xE1
  };
 
 public ElfLoader(ASpace as, int malloc_addr, int free_addr, String melfloader_path)
  {
   aspace = as;
   malloc_address = malloc_addr;
   free_address   = free_addr;
   melfloader_location  = new String(melfloader_path);
   melfloaderbody_address = 0;
  }
       
 private byte[] LoadFileFromJar(String filename) 
  {
      try 
        {
            InputStream istream = this.getClass().getResourceAsStream(filename);
            ByteArrayOutputStream bout = null;

            bout = new ByteArrayOutputStream();
            int b;
            while ((b = istream.read()) >= 0) {
                bout.write(b);
            }
            return bout.toByteArray();
        } catch (Exception e) 
            {
             return null;
            }
    }
 
  /* Метода создания микро ELF загрузчика */
 public int CreateElfLoader() 
  {
   if (aspace.mainarray_startindex == 0) return 0;
      
   if (melfloaderbody_address != 0) return 0;
   byte[] melfloader_body = LoadFileFromJar(melfloader_location);
   if (melfloader_body == null) return 0;
   melfloaderbody_address = aspace.ASpace_RunArmCode(malloc_address, melfloader_body.length, 0, 0, 0);
   if (melfloaderbody_address == 0) return 0;
   melfloaderbody_address += aspace.aspace_flash_diffaddress;
   for (int i = 0; i < melfloader_body.length; i++)
       aspace.ASpace_writebyte(melfloaderbody_address + i, (int)melfloader_body[i]);
   melfloaderbody_address -= aspace.aspace_flash_diffaddress;
   return 1;
  }
 
   /* Метода уничтожения микро ELF загрузчика */
 public int KillElfLoader() 
  {
   if (aspace.mainarray_startindex == 0) return 0;
   if (melfloaderbody_address == 0) return 0;
   aspace.ASpace_RunArmCode(free_address, melfloaderbody_address, 0, 0, 0);
   melfloaderbody_address = 0;
   return 1;
  }
 
 /* Методы запуска эльфа с JAR архива */
 
 public int LaunchElf(String jpath) 
  {
   return LaunchElf(jpath, 0);
  }
 
 public int LaunchElf(String jpath, int arg) 
  {
   return LaunchElf(jpath, arg, false);
  }
 
 public int LaunchElf(String jpath, int arg, boolean free_after_execute) 
  {
   if (aspace.mainarray_startindex == 0) return 1;
   if (melfloaderbody_address == 0) return 1;
   byte[] elf_body = LoadFileFromJar(jpath);
   if (elf_body == null) return 1;
   int elf_body_address = aspace.ASpace_RunArmCode(malloc_address, elf_body.length, 0, 0, 0);
   if (elf_body_address == 0) return 1;
   elf_body_address += aspace.aspace_flash_diffaddress;
   for (int i = 0; i < elf_body.length; i++)
       aspace.ASpace_writebyte(elf_body_address + i, (int)elf_body[i]);
   elf_body_address -= aspace.aspace_flash_diffaddress;
   //long elfload(void *elf_base, void *arg, void *(*malloc)(unsigned int size), void (*free)(void *ptr))
   int ret = aspace.ASpace_RunArmCode(melfloaderbody_address, elf_body_address, arg, malloc_address, free_address);
   //Освобождаем RAM от файла
   if (free_after_execute == true)
   aspace.ASpace_RunArmCode(free_address, elf_body_address, 0, 0, 0);
   return ret;
  }
 
 public boolean CheckOnSWIHookLoaded() 
  {
   for (int i = 0; i < get_malloc_address.length; i++) 
   aspace.ASpace_writebyte(aspace.aspace_sgold_workcode_bodyaddress + i, get_malloc_address[i]); 
   
   int ma = aspace.ASpace_RunArmCode(aspace.aspace_sgold_workcode_bodyaddress,
                     0, 0, 0, 0);
   if (ma == malloc_address) return true;
    else return false;
  }
 
 
}