#include "../../inc/swilib.h"
#include "../tbase/tbase.h"
#include "../util/search_pattern.h"

#include "../jelfloader.h"
#include "../swihook.h"

#include "keyhook.h"

/*  */

int kh_patch_func_pattern_body[] = 
{
 0xB5FE,
 0x1C04,
 0x6800,
 0x1C0D,
 0x68C6,
 0x6D20,
 0xAA02,
 0x1C31,
 NULLINT,
 NULLINT,
 0x68E0,
 0x2800
};

int kh_patch_ret_pattern_body[] = 
{
 0x1C38,
 0x38FF,
 0x38C8,
 NULLINT,
 0x1C30,
 NULLINT,
 NULLINT,
 0x2800
};


PATTERN kh_patch_func_pattern = 
{
 kh_patch_func_pattern_body,
 NULLINT, 1, sizeof(kh_patch_func_pattern_body), 2
};

PATTERN kh_patch_ret_pattern = 
{
 kh_patch_ret_pattern_body,
 NULLINT, 1, sizeof(kh_patch_ret_pattern_body), 2
};

/*  KeyHook  */

unsigned int kh_patch_vrezka = 0;
unsigned int kh_patch_func   = 0;
unsigned int kh_patch_ret    = 0;

LLQ _plistq;


#pragma optimize=no_inline
static void LLaddToEnd(LLQ *ll, void *data)
{
  LLIST *d=data;
  d->next=NULL;
  d->prev=ll->last;
  if (ll->last)
  {
    ((LLIST *)ll->last)->next=d;
  }
  else
  {
    ll->first=d;
  }
  ll->last=d;
}

#pragma optimize=no_inline
static void LLaddToBegin(LLQ *ll, void *data)
{
  LLIST *d=data;
  d->next=ll->first;
  d->prev=0;
  if (!ll->last)
  {
    ll->last=d;
  }
  else
  {
    ((LLIST *)ll->first)->prev=d;
  }
  ll->first=d;
}

#pragma optimize=no_inline
static void LLremoveFromQ(LLQ *ll, void *data, int is_free)
{
  LLIST *d=data;
  if (d->prev)
  {
    ((LLIST *)d->prev)->next=d->next;
  }
  else
  {
    ll->first=d->next;
  }
  if (d->next)
  {
    ((LLIST *)d->next)->prev=d->prev;
  }
  else
  {
    ll->last=d->prev;
  }
  if (is_free)
  {
    ll->data_mfree(d);
  }
}

void AddKeybMsgHook_impl(int (*proc)(int submsg,int msg))
{
  LLQ *plistq=&_plistq;
  PLIST *newp;
  if (!plistq->data_mfree)
  {
    plistq->first=0;
    plistq->last=0;
    plistq->data_mfree=(void(*)(void *))mfree_adr();
  }
  newp=malloc(sizeof(PLIST));
  if (newp)
  {
    newp->proc=proc;
    newp->is_first=0;
    LLaddToEnd(plistq,newp);
  }
}


int AddKeybMsgHook_end_impl(int (*proc)(int submsg,int msg))
{
  LLQ *plistq=&_plistq;
  PLIST *newp, *pfirst;
  if (!plistq->data_mfree)
  {
    plistq->first=0;
    plistq->last=0;
    plistq->data_mfree=(void(*)(void *))mfree_adr();
  }
  if (pfirst=plistq->first)
  {
    if (pfirst->is_first==1) return 0;
  }
  newp=malloc(sizeof(PLIST));
  if (!newp) return 0;
  newp->proc=proc;
  newp->is_first=1;
  LLaddToBegin(plistq,newp);
  return 1;
}  


void RemoveKeybMsgHook_impl(int (*proc)(int submsg,int msg))
{
  LLQ *plistq=&_plistq;
  PLIST *plist=plistq->first;
  while(plist)
  {
    if (plist->proc==proc)
    {
      LLremoveFromQ(plistq,plist,1);
      return;      
    }  
    plist=plist->next;    
  }
}


__thumb int keyhook_patchmsg(int submsg, int msg)
{
  LLQ *plistq=&_plistq;
  PLIST *plist=plistq->first;
  int proc_ret;
  int is_no_gui=0;
  while(plist)
  {
    if (plist->proc)
    {
      proc_ret=plist->proc(submsg,msg);
      switch(proc_ret)
      {
      case KEYHOOK_NEXT:
        break;
      case KEYHOOK_NEXT_NOT2GUI:
        is_no_gui=1;
        break;
      case KEYHOOK_BREAK:
        return (2);
      case KEYHOOK_ENDQ:
        return is_no_gui==1?2:0;
      default:
        break;
      }      
    }
    plist=plist->next;
  }
  return is_no_gui;
}


int ee[] = 
{
 0x466C,
 0xC80F,
 0xC40F,
 0x485A,
 0xAB00,
 0x8018,
 0x4668,
 0xF230
};


PATTERN eee = 
{
 ee,
 NULLINT, 1, sizeof(ee), 2
};


void __jel_keyhookpatch_init()
{
 if (jelfloader_ptcctrl_isKeyHookEnable())
  {
   kh_patch_func   = SearchFunction(SEARCH_ADDRESS, SEARCH_SIZE, &kh_patch_func_pattern);
   kh_patch_ret    = SearchFunction(SEARCH_ADDRESS, SEARCH_SIZE, &kh_patch_ret_pattern);
   kh_patch_vrezka = kh_patch_ret - KEYHOOK_PATCH_VREZKA_RET_OFFSET;
 
   unsigned char *kc = (unsigned char *)((int)&keyhook_vrezka_entry - 1);
 
   for (int i = 0; i < KEYHOOK_PATCH_VREZKA_SIZE; i++)
     ApplyPatch((void *)(kh_patch_vrezka + i), kc[i]);
 
   __jel_swihook_setfunc(SWINUM_ADDKEYBMSGHOOK, (unsigned int)&AddKeybMsgHook_impl);
   __jel_swihook_setfunc(SWINUM_ADDKEYBMSGHOOKEND, (unsigned int)&AddKeybMsgHook_end_impl);
   __jel_swihook_setfunc(SWINUM_REMKEYBMSGHOOK, (unsigned int)&RemoveKeybMsgHook_impl);
  } else
     {
      __jel_swihook_clearfunc(SWINUM_ADDKEYBMSGHOOK);
      __jel_swihook_clearfunc(SWINUM_ADDKEYBMSGHOOKEND);
      __jel_swihook_clearfunc(SWINUM_REMKEYBMSGHOOK);
     }
  

}


