#include "../inc/swilib.h"
#include "intrinsics.h"
#include "swihook.h"

unsigned int *__jel_swilib = 0;

void __jel_swihook_bxlr(){};

void __jel_swihook_abort(unsigned short swinum, unsigned int swi_call_lr_address)
{
 char msg[256];
 sprintf(msg, "FUNC ABORT\nSWI 0x%04X\nLR: 0x%08X", swinum, swi_call_lr_address);
 ShowMSG(1, (int)msg);
}



int __jel_swihook_install(unsigned int *swilib)
{
 if (swilib)
  {
   __jel_swilib = swilib;
   
   system_mode();
   
    __disable_interrupt();
    __MCR(15, 0, 0xFFFFFFFF, 3, 0, 0);
   
    *( (unsigned int *) ( SWIHOOK_JUMPER_ADDRESS ) ) = SWIHOOK_JUMPER_OPCODE;
    *( (unsigned int *) ( SWIHOOK_LOCATE_ADDRESS ) ) = (unsigned int)&__jel_swihook_start;
   
    __MCR(15, 0, 1, 3, 0, 0);
    __enable_interrupt();
    
   __jel_swihook_setfunc(SWINUM_LIBTOP, (unsigned int)&__jel_swilib);
   
   return 1;
  } else return 0;
}

int __jel_swihook_setfunc(unsigned short swinum, unsigned int address)
{
 if (!__jel_swilib) return 0;
  
 system_mode();
 __disable_interrupt();
 __jel_swilib[swinum] = address;
 __enable_interrupt();
 return 1;
}

unsigned int  __jel_swihook_getfunc(unsigned short swinum)
{
 if (!__jel_swilib) return 0;
  
 unsigned int ret = 0;
 system_mode();
  __disable_interrupt();
 ret = __jel_swilib[swinum];
  __enable_interrupt();
 return ret;
}

int __jel_swihook_clearfunc(unsigned short swinum)
{
 if (!__jel_swilib) return 0;
  
 system_mode();
 __disable_interrupt();
 __jel_swilib[swinum] = (unsigned int)&__jel_swihook_bxlr;
 __enable_interrupt();
 return 1;
}

