//()Dimadze
//sudoku.h -   -, , ,    SuDoKu 2.0
//,   swilib.h

#ifdef  __SWILIB__
#define __SUDOKU__

typedef struct {    //  SuDoKu   
  char name[32];    //   
  char level;       //  , 'L' - , 'M' - , 'H' - , '?' -   ( '?'    )
  char x, y;        //  , ..   
  char gcell[9][9]; //    (   , ..  )
  char rcell[9][9]; //    (   )
  char preview;     // - ""
  char warn;        // 0x00 -  , 0x01 -   , 0x02 -   , 0x03 -   ,   
  char error;       // 0x00 -  , 0x01 -   , 0x02 -  ID , 0x03 -   , 0x04 -   / , 0x64 -     
  int  sec;         //       
}SUDOKUMAP;

// (!)
// SUDOKUMAP->gcell[][]:
// 0x01-0x09 -  ,    (Default)
// 0x11-0x19 -  ,  ,     (Default)
// 0x21-0x29 -  ,  ,   ,     (Default)
// 0x31-0x39 -  ,  ,   ,    (   ),     (Default) ( prold'  team-sc.ru)
//     -  ,      SUDOKUMAP   0x04


typedef struct {        // C  
  char png_file;        //  png - .   -
  char hlp_file;        //  hlp - 
  char sedit_file;      //    
  char ext_file;        //     SuDoKu, 0x64 -    !
}ERRORSTRUCT;

typedef struct {       //    (,   ?)
  char x;              // X   
  char y;              // Y   
  char dig;            // ,    
  char type;           //    : 0x00 -   , 0x01 -   , 0x02 -    ( )
  char numquad;        //     ,      
  char error;          // 0x00 -  , 0x02 -  , 0x04 -   
}ERROR_SDM;

typedef struct {       //    
char pattern[9][9];    //  
}PATTERN_SDM;

#include "patterns.h"

// ----------------------------------------------------------------------
SUDOKUMAP *CreateVoidSUDOKUMAP();
ERROR_SDM *CreateVoidERROR_SDM(); //SMF Editor

void ClearERROR_SDM(ERROR_SDM *esdm); //SMF Editor
void ClearSUDOKUMAP(SUDOKUMAP *sdm);

void CreatePATTERN_SDMbySUDOKUMAP(PATTERN_SDM *psdm, SUDOKUMAP *sdm);  //SMF Editor
char IsNoFullSUDOKUMAP(SUDOKUMAP *sdm); //SMF Editor
void AcceptPATTERN_SDMinSUDOKUMAP(SUDOKUMAP *sdm, PATTERN_SDM psdm); //SMF Editor

char CheckSUDOKUMAP(SUDOKUMAP *sdm);
ERROR_SDM *CheckSUDOKUMAP_ev(SUDOKUMAP *sdm, ERROR_SDM *esdm); //SMF Editor

void MemFreeOfSUDOKUMAP(SUDOKUMAP *sdm);
void MemFreeOfERROR_SDM(ERROR_SDM *esdm); //SMF Editor
void MemFreeOfERRORSTRUCT(ERRORSTRUCT *errs);
//------------------------------------------------------------------------------




SUDOKUMAP *CreateVoidSUDOKUMAP() //  SUDOKUMAP
{
 SUDOKUMAP *sdm=malloc(sizeof(SUDOKUMAP));
 for (int i=0;i<32;i++) sdm->name[i] = 0;
 sdm->level = '?';
 sdm->x = 4; sdm->y = 4;
 for (int i=0;i<9;i++) for (int j=0;j<9;j++) sdm->gcell[i][j] = 0;
 for (int i=0;i<9;i++) for (int j=0;j<9;j++) sdm->rcell[i][j] = 0; 
 sdm->preview = 0;
 sdm->warn    = 0;
 sdm->error   = 0x64;
 sdm->sec     = 0;
 return sdm;
}

ERROR_SDM *CreateVoidERROR_SDM() //  ERROR_SDM
{
 ERROR_SDM *esdm=malloc(sizeof(ERROR_SDM));
 esdm->x = 0;
 esdm->y = 0;
 esdm->dig = 0;
 esdm->type = 0;
 esdm->numquad = 0;
 esdm->error = 0x00;
 return esdm;
}

void ClearSUDOKUMAP(SUDOKUMAP *sdm) // (,   ) SUDOKUMAP
{
 for (int i=0;i<32;i++) sdm->name[i] = 0;
 sdm->level = '?';
 sdm->x = 4; sdm->y = 4;
 for (int i=0;i<9;i++) for (int j=0;j<9;j++) sdm->gcell[i][j] = 0;
 for (int i=0;i<9;i++) for (int j=0;j<9;j++) sdm->rcell[i][j] = 0; 
 sdm->preview = 0;
 sdm->warn    = 0;
 sdm->error   = 0x64;
 sdm->sec     = 0;
}

void ClearERROR_SDM(ERROR_SDM *esdm) // (,   ) ERROR_SDM
{
 esdm->x = 0;
 esdm->y = 0;
 esdm->dig = 0;
 esdm->type = 0;
 esdm->numquad = 0;
 esdm->error   = 0x00;
}


char conv(char cell) //    
{
  if (cell>0x20 && cell<0x2A) cell-=0x20;
  return cell;
}

void CreatePATTERN_SDMbySUDOKUMAP(PATTERN_SDM *psdm, SUDOKUMAP *sdm)//  PATTERN_SDM  SUDOKUMAP
{
 for (int i=0;i<9;i++) for (int j=0;j<9;j++) 
  {
   if (sdm->gcell[i][j] > 0x20) psdm->pattern[i][j] = 1;
                           else psdm->pattern[i][j] = 0;
  }
}

char IsNoFullSUDOKUMAP(SUDOKUMAP *sdm) // SUDOKUMAP   0x01
{
 char t = 0;
 for (char k=0;k<9;k++) for (char j=0;j<9;j++) if (sdm->gcell[k][j]==0x00) {t=1;goto ERROR;}
ERROR:
  return t;
}


void AcceptPATTERN_SDMinSUDOKUMAP(SUDOKUMAP *sdm, PATTERN_SDM psdm) //  PATTERN_SDM  SUDOKUMAP
{

 for (int i=0;i<9;i++) for (int j=0;j<9;j++) 
  {
   sdm->gcell[i][j] = conv(sdm->gcell[i][j]);
   if (psdm.pattern[i][j] == 1) sdm->gcell[i][j] += 0x20;
  }
}

char CheckSolvedSUDOKUMAP(SUDOKUMAP *sdm) // ""  SUDOKUMAP:  0 - !, 1 - !, 2 -  !
{
 int var, res = 1; 
 for (int i=0;i<9;i++) for (int j=0;j<9;j++)
  {
    if (sdm->gcell[i][j] > 0x30) var = sdm->gcell[i][j] - 0x30;
    if (sdm->gcell[i][j] > 0x20 && sdm->gcell[i][j] < 0x2A) var = sdm->gcell[i][j] - 0x20;
    if (sdm->gcell[i][j] > 0x10 && sdm->gcell[i][j] < 0x1A) var = sdm->gcell[i][j] - 0x10;
    if (sdm->gcell[i][j] < 0x0A) {res = 2; goto ENDFUNC;}
    if (sdm->rcell[i][j] != var) {res = 0; goto ENDFUNC;}
  }
 ENDFUNC:
 return res;
}


char CheckSUDOKUMAP(SUDOKUMAP *sdm) //    SuDoKu, 0x04 - , 0 -  !))
{ 
 char t=0;
 for (char i=1;i<10;i++) for (char k=0;k<9;k++) //   (); ,    .
  {
   char a=0;
   for (char j=0;j<9;j++) if (sdm->rcell[k][j]==i) a++;
   if  (a>1) {t=1; goto ERROR;} // !   0x04
  }
 
 for (char i=1;i<10;i++) for (char k=0;k<9;k++) //   (); ,    .
  {
   char a=0;
   for (char j=0;j<9;j++) if (sdm->rcell[j][k]==i) a++;
   if  (a>1) {t=1; goto ERROR;} // !   0x04
  }

 // #1#2#3
 // #4#5#6 -    
 // #7#8#9

//--------
 for (char i=1;i<10;i++) //  #1  ; ,    .
  {
    char a=0;
    for (char k=0;k<3;k++) for (char j=0;j<3;j++) if (sdm->rcell[k][j]==i) a++;
    if  (a>1) {t=1; goto ERROR;} // !   0x04
  }
 
 for (char i=1;i<10;i++) //  #2  ; ,    .
  {
    char a=0;
    for (char k=0;k<3;k++) for (char j=3;j<6;j++) if (sdm->rcell[k][j]==i) a++;
    if  (a>1) {t=1; goto ERROR;} // !   0x04
  }
 
 for (char i=1;i<10;i++) //  #3  ; ,    .
  {
    char a=0;
    for (char k=0;k<3;k++) for (char j=6;j<9;j++) if (sdm->rcell[k][j]==i) a++;
    if  (a>1) {t=1; goto ERROR;} // !   0x04
  }
//--------
 for (char i=1;i<10;i++) //  #4  ; ,    .
  {
    char a=0;
    for (char k=3;k<6;k++) for (char j=0;j<3;j++) if (sdm->rcell[k][j]==i) a++;
    if  (a>1) {t=1; goto ERROR;} // !   0x04
  }
 
 for (char i=1;i<10;i++) //  #5  ; ,    .
  {
    char a=0;
    for (char k=3;k<6;k++) for (char j=3;j<6;j++) if (sdm->rcell[k][j]==i) a++;
    if  (a>1) {t=1; goto ERROR;} // !   0x04
  }
 
 for (char i=1;i<10;i++) //  #6  ; ,    .
  {
    char a=0;
    for (char k=3;k<6;k++) for (char j=6;j<9;j++) if (sdm->rcell[k][j]==i) a++;
    if  (a>1) {t=1; goto ERROR;} // !   0x04
  }
//--------
 for (char i=1;i<10;i++) //  #7  ; ,    .
  {
    char a=0;
    for (char k=6;k<9;k++) for (char j=0;j<3;j++) if (sdm->rcell[k][j]==i) a++;
    if  (a>1) {t=1; goto ERROR;} // !   0x04
  }
 
 for (char i=1;i<10;i++) //  #8  ; ,    .
  {
    char a=0;
    for (char k=6;k<9;k++) for (char j=3;j<6;j++) if (sdm->rcell[k][j]==i) a++;
    if  (a>1) {t=1; goto ERROR;} // !   0x04
  }
 
 for (char i=1;i<10;i++) //  #9  ; ,    .
  {
    char a=0;
    for (char k=6;k<9;k++) for (char j=6;j<9;j++) if (sdm->rcell[k][j]==i) a++;
    if  (a>1) {t=1; goto ERROR;} // !   0x04
  }
//-------- 
 
ERROR: //  ,      ...
  
 if (t==1) return 0x04; else return 0;
}


ERROR_SDM *CheckSUDOKUMAP_ev(SUDOKUMAP *sdm, ERROR_SDM *esdm) //    SuDoKu, esdm->error: 0x00 -  , 0x02 -  , 0x04 -  (error->x, error->y:   )
{ 
 char t = 0, n = 0;
 
 for (char k=0;k<9;k++) for (char j=0;j<9;j++) if (sdm->gcell[k][j]==0x00) {n=1;goto ERROR;}
 
 for (char i=1;i<10;i++) for (char k=0;k<9;k++) //   (); ,    .
  {
   char a=0;
   for (char j=0;j<9;j++) if (conv(sdm->gcell[k][j])==i) {a++; esdm->x = j; esdm->y = k; esdm->dig = i; esdm->type = 0; esdm->numquad = 0;}
   if  (a>1) {t=1; goto ERROR;} // !   0x04
  }
 
 for (char i=1;i<10;i++) for (char k=0;k<9;k++) //   (); ,    .
  {
   char a=0;
   for (char j=0;j<9;j++) if (conv(sdm->gcell[j][k])==i) {a++; esdm->x = k; esdm->y = j; esdm->dig = i; esdm->type = 1; esdm->numquad = 0;}
   if  (a>1) {t=1; goto ERROR;} // !   0x04
  }

 // #1#2#3
 // #4#5#6 -    
 // #7#8#9

//--------
 for (char i=1;i<10;i++) //  #1  ; ,    .
  {
    char a=0;
    for (char k=0;k<3;k++) for (char j=0;j<3;j++) if (conv(sdm->gcell[k][j])==i) {a++; esdm->x = j; esdm->y = k; esdm->dig = i; esdm->type = 2; esdm->numquad = 1;}
    if  (a>1) {t=1; goto ERROR;} // !   0x04
  }
 
 for (char i=1;i<10;i++) //  #2  ; ,    .
  {
    char a=0;
    for (char k=0;k<3;k++) for (char j=3;j<6;j++) if (conv(sdm->gcell[k][j])==i) {a++; esdm->x = j; esdm->y = k; esdm->dig = i; esdm->type = 2; esdm->numquad = 2;}
    if  (a>1) {t=1; goto ERROR;} // !   0x04
  }
 
 for (char i=1;i<10;i++) //  #3  ; ,    .
  {
    char a=0;
    for (char k=0;k<3;k++) for (char j=6;j<9;j++) if (conv(sdm->gcell[k][j])==i) {a++; esdm->x = j; esdm->y = k; esdm->dig = i; esdm->type = 2; esdm->numquad = 3;}
    if  (a>1) {t=1; goto ERROR;} // !   0x04
  }
//--------
 for (char i=1;i<10;i++) //  #4  ; ,    .
  {
    char a=0;
    for (char k=3;k<6;k++) for (char j=0;j<3;j++) if (conv(sdm->gcell[k][j])==i) {a++; esdm->x = j; esdm->y = k; esdm->dig = i; esdm->type = 2; esdm->numquad = 4;}
    if  (a>1) {t=1; goto ERROR;} // !   0x04
  }
 
 for (char i=1;i<10;i++) //  #5  ; ,    .
  {
    char a=0;
    for (char k=3;k<6;k++) for (char j=3;j<6;j++) if (conv(sdm->gcell[k][j])==i) {a++; esdm->x = j; esdm->y = k; esdm->dig = i; esdm->type = 2; esdm->numquad = 5;}
    if  (a>1) {t=1; goto ERROR;} // !   0x04
  }
 
 for (char i=1;i<10;i++) //  #6  ; ,    .
  {
    char a=0;
    for (char k=3;k<6;k++) for (char j=6;j<9;j++) if (conv(sdm->gcell[k][j])==i) {a++; esdm->x = j; esdm->y = k; esdm->dig = i; esdm->type = 2; esdm->numquad = 6;}
    if  (a>1) {t=1; goto ERROR;} // !   0x04
  }
//--------
 for (char i=1;i<10;i++) //  #7  ; ,    .
  {
    char a=0;
    for (char k=6;k<9;k++) for (char j=0;j<3;j++) if (conv(sdm->gcell[k][j])==i) {a++; esdm->x = j; esdm->y = k; esdm->dig = i; esdm->type = 2; esdm->numquad = 7;}
    if  (a>1) {t=1; goto ERROR;} // !   0x04
  }
 
 for (char i=1;i<10;i++) //  #8  ; ,    .
  {
    char a=0;
    for (char k=6;k<9;k++) for (char j=3;j<6;j++) if (conv(sdm->gcell[k][j])==i) {a++; esdm->x = j; esdm->y = k; esdm->dig = i; esdm->type = 2; esdm->numquad = 8;}
    if  (a>1) {t=1; goto ERROR;} // !   0x04
  }
 
 for (char i=1;i<10;i++) //  #9  ; ,    .
  {
    char a=0;
    for (char k=6;k<9;k++) for (char j=6;j<9;j++) if (conv(sdm->gcell[k][j])==i) {a++; esdm->x = j; esdm->y = k; esdm->dig = i; esdm->type = 2; esdm->numquad = 9;}
    if  (a>1) {t=1; goto ERROR;} // !   0x04
  }
//-------- 
 
ERROR:
 if (n == 0) if (t == 1) esdm->error = 0x04; else esdm->error = 0x00;
 else esdm->error = 0x02;
 return esdm;
}



void MemFreeOfSUDOKUMAP(SUDOKUMAP *sdm) //    SUDOKUMAP
{
 if (sdm)
   {
     zeromem(sdm,sizeof(SUDOKUMAP));
     mfree(sdm);
     sdm = 0;
   }
}

void MemFreeOfERROR_SDM(ERROR_SDM *esdm) //    ERROR_SDM
{
 if (esdm)
   {
     zeromem(esdm,sizeof(ERROR_SDM));
     mfree(esdm);
     esdm = 0;
   }
}

void MemFreeOfERRORSTRUCT(ERRORSTRUCT *errs) //    ERRORSTRUCT
{
 if (errs)
   {
     zeromem(errs,sizeof(ERRORSTRUCT));
     mfree(errs);
     errs = 0;
   }
}

#endif

