#include "..\inc\swilib.h"
#include "../inc/cfg_items.h"
#include "conf_loader.h"
#include "..\inc\pnglist.h"
//#include "main.h"
//WSHDR *ews;
const char per_d[]="%d";
const char per_t[]="%t";
const char per_s[]="%s";
const char empty_str[]="";

unsigned int MAINCSM_ID = 0;
unsigned int MAINGUI_ID = 0;
const int minus11=-11;

unsigned short maincsm_name_body[140];

typedef struct
{
  CSM_RAM csm;
  int gui_id;
}MAIN_CSM;

typedef struct
{
  GUI gui;
  WSHDR *ws1;
  WSHDR *ws2;
  int i1;
}MAIN_GUI;

int my_csm_id=0;
//----------------------------------
//extern const int screen_mode;
extern const int size_font;
extern const int pen_font;
extern const int brush_font;
extern void InitConfig();
extern int codepage;//
extern const int illum_mode;//   ...
extern const int codepg;//  
extern void LoadINI();
//extern INIFILE ini[];
//----------------------------------
EDITCONTROL ec;
WSHDR *ws_edit = NULL;

int id_ed;//id editcontrol
int id_ed2;
int codepage;
//int curpos=1;// 
int Quit_Required;
int ReadOnly=1;
int file_size;
int level; //   :)
GBSTMR tmr;

char file_name[64];
char file[256];
char num[10];
char info[1024];

//----------------------------------
int f;
void ascii2ws(WSHDR *ws, const char *s);

void on_utf8ec(USR_MENU_ITEM *item);
void koi2ws(WSHDR *ws, const char *s);
void win1250_2ws(WSHDR *ws, const char *s);
void win1251_2ws(WSHDR *ws, const char *s);
void SaveINI();//save history
void QuitCallbackProc(int decision)
{
  if(!decision)Quit_Required = 1;
//  SaveINI();
}


#pragma inline
void patch_header(HEADER_DESC* head)
{
     head->rc.x=0;
     head->rc.y=0;
     head->rc.x2=0;
     head->rc.y2=0;
}
#pragma inline
void patch_input(INPUTDIA_DESC* inp)
{
  inp->rc.x=0;
  inp->rc.y=0;
  inp->rc.x2=ScreenW()-1;
  inp->rc.y2=ScreenH()-SoftkeyH()-1;

}

#pragma inline
void patch_rect(RECT*rc,int x,int y, int x2, int y2)
{
  rc->x=x;
  rc->y=y;
  rc->x2=x2;
  rc->y2=y2;
}

typedef struct
{
  DYNPNGICONLIST dpl;
  char *fname;
  int uni_n;
}DYNPNGILIST_MY;

CSM_DESC icsmd;
//----------------------------------
void illum()
{
 short light;
 char *ram=(char*)0xA8000000;
 long a;
 unsigned char *l=(unsigned char*)0xA0FD435C; //  BFL()  
 a=l[2]*0x10000+l[1]*0x100+l[0];
 light=ram[a];
 SetIllumination(0,1,light,256);
 GBS_StartTimerProc(&tmr,216,illum);
}
//----------------------------GO TO LINE----------------------------------------
HEADER_DESC pos_hdr={0,0,131,21,NULL,0,LGP_NULL};

int pos_onkey(GUI *data, GUI_MSG *msg)
{
  WSHDR *ws=AllocWS(64);
  if (msg->keys==0x0018)//0xFFF
  {
    EDITCONTROL ec;
    ExtractEditControl(data,1,&ec);	
    ws=ec.pWS;
    ws_2str(ws,num,9);
    curpos=atoi(num);
    curpos*=20;//      20 ...
    GeneralFunc_flag1(id_ed2,1);
    DrawText(file,codepage);    
  }
return(0);
}

void pos_ghook(GUI *gui, int cmd)
{ 
  static SOFTKEY_DESC sk={0x0018,0x0000,(int)"Go!"};
  if (cmd==7)
  {
    SetSoftKey(gui,&sk,1);
  }
  if(cmd==0xA)
  {
    DisableIDLETMR(); //     
  }
  if (cmd==0x0C)
  {
    EDIT_SetCursorPos(gui,1);
  }
  
    if(cmd==0x03)     // onDestroy
  {
//      FreeWS(ews);
  }

}
void pos_locret(void){}

SOFTKEY_DESC menu_sk[]=
{
  {0x0018,0x0000,(int)""},
  {0x0001,0x0000,(int)""},
  {0x003D,0x0000,(int)LGP_DOIT_PIC}
};

SOFTKEYSTAB menu_skt=
{
  menu_sk,0
};

INPUTDIA_DESC pos_desc=
{
  1,
  pos_onkey,
  pos_ghook,
  (void *)pos_locret,
  0,
  &menu_skt,
  {0,NULL,NULL,NULL},
  FONT_SMALL,
  100,
  101,
  0,
  0x00000000,
  0x40000000
};

//unsigned int poss;
void pos()
{
   char *ss=malloc(64);
   sprintf(ss,per_s,"Go to line");
   pos_hdr.lgp_id = (int)ss;
   EDITC_OPTIONS ec_options2;
   void *ma=malloc_adr();
   void *eq=AllocEQueue(ma, mfree_adr());
  // CutWSTR(ews,0);
  // wsAppendChar(ews,'0');
   PrepareEditControl(&ec);

   ConstructEditControl(&ec,ECT_NORMAL_NUM,ECF_APPEND_EOL|ECF_DISABLE_MINUS|ECF_DISABLE_POINT,ec.pWS,9);

   PrepareEditCOptions(&ec_options2);
   SetFontToEditCOptions(&ec_options2,1);//
   CopyOptionsToEditControl(&ec,&ec_options2);// 
   AddEditControlToEditQend(eq,&ec,ma);

   patch_header2(&pos_hdr);
   patch_input2(&pos_desc);      
 
   GeneralFuncF1(1);
   mfree_adr();
   mfree(ss);
   id_ed2=CreateInputTextDialog(&pos_desc,&pos_hdr,eq,1,0);//  
}
//----------------------------------DRAW && EDIT TEXT---------------------------

HEADER_DESC disk_prop_hdr={0,0,131,21,NULL,0,LGP_NULL};
int empty_onkey(GUI *data, GUI_MSG *msg)
{ 
  if(Quit_Required){ return 1;}//Exit
  if (msg->gbsmsg->msg==KEY_DOWN)
  { 
    int current_pos=EDIT_GetCursorPos(data)-1;
    curpos=EDIT_GetCursorPos(data);
    switch(msg->gbsmsg->submess)
    {
    
    case GREEN_BUTTON:
      {
         SaveINI();
//        ShowMSG(2,(int)info);
      } break;
    case RED_BUTTON:Quit_Required=1;/*MsgBoxYesNo(1,(int)" TextReader?",QuitCallbackProc);*/break;
    case 0x14:  current_pos-=50; EDIT_SetCursorPos(data,current_pos);DirectRedrawGUI(); break;
    case 0x15:  current_pos+=50; EDIT_SetCursorPos(data,current_pos);DirectRedrawGUI(); break;
    case RIGHT_SOFT: 
        ExtractEditControl(data,1,&ec);	
        wstrcpy(ws_edit,ec.pWS);//    ws_edit       :)
        level=2;
        ShowMenu();
        break;
    }
  }
  
  if (msg->gbsmsg->msg==LONG_PRESS)
  {  
    int current_pos=EDIT_GetCursorPos(data)-1;
    curpos=EDIT_GetCursorPos(data);
    switch(msg->gbsmsg->submess)
    {
      case UP_BUTTON:   case 0x14:  current_pos-=50; EDIT_SetCursorPos(data,current_pos);DirectRedrawGUI(); break;
      case DOWN_BUTTON: case 0x15:  current_pos+=50; EDIT_SetCursorPos(data,current_pos);DirectRedrawGUI(); break;
    }
  }
   
return(0);
}

SOFTKEY_DESC sk[]=
{
  {0x0018,0x0000,(int)""},
  {0x0001,0x0000,(int)""},
  {0x003D,0x0000,(int)LGP_DOIT_PIC}
};

SOFTKEYSTAB skt=
{
  sk,0
};
void empty_locret(void){}
void empty_ghook(GUI *gui, int cmd)
{ 
  static SOFTKEY_DESC sk2={0x0018, 0x0000,(int)"Menu"};
  if (cmd==7)
  {
    SetSoftKey(gui,&sk2,1);
  }

  if(cmd==0xA)
  {
    DisableIDLETMR();   //     
  }
  if (cmd==0x0C)
  {
  
    EDIT_SetCursorPos(gui,curpos);    
  }
  if(cmd==0x03)     // onDestroy
  {
   // SaveINI();
    GBS_DelTimer(&tmr);//timer illum
  }

};

INPUTDIA_DESC read_only_desc=// 
{
  1,
  empty_onkey,
  empty_ghook,
  (void *)empty_locret,
  0,
  &skt,
  {0,0,131,175},
  FONT_SMALL,
  100,
  101,
  0,
  0,
  0x40000002
};

INPUTDIA_DESC edit_desc=//
{
  1,
  empty_onkey,
  empty_ghook,
  (void *)empty_locret,
  0,
  &skt,
  {0,0,0,0},
  FONT_SMALL,
  100,
  101,
  0,
  0,
  0x40000000
};
 
//----------------------------------
void SaveFile(char *filename)
{
  unsigned int err;
  int f;
  char *s=malloc(wstrlen(ws_edit));
  ws_2str(ws_edit,s,wstrlen(ws_edit));
  char ff[64];
  strcpy(ff,file);
  strcat(ff,".test");
  if((f=fopen(ff,A_Create+A_ReadWrite/*+A_Append*/+A_BIN,P_WRITE,&err))!=-1)
   {
     fwrite32(f,s,strlen(s),&err);
     ShowMSG(1,(int)"File Save!!!");
   }
  else ShowMSG(1,(int)"Don't save!:(");
  fclose(f,&err);
  mfree(s);
}
//----------------------------------
int DrawText(char *filename,int cp)//C    :)
{  
   if(illum_mode==1)illum();//   
   else GBS_DelTimer(&tmr);
   
   EDITC_OPTIONS ec_options;
   PrepareEditControl(&ec);
   void *ma=malloc_adr();
   void *eq=AllocEQueue(ma, mfree_adr());
   DIR_ENTRY de;
   unsigned int err;
   char path[256];
   sprintf(path,per_s,filename);
   char *ptr=path+strlen(path)+1;
   unsigned int size=0;
   if (FindFirstFile(&de,path,&err))
      { 
        strcpy(file_name,de.file_name);  
        file_size = de.file_size;
      }FindClose(&de,&err);
        
   char *s=malloc(file_size);
   if((f=fopen(filename,A_ReadOnly+A_BIN,P_READ,&err))!=-1)
       size=fread32(f,s,file_size,&err);
       fclose(f,&err);
       ws_edit=AllocWS(size);
       switch(cp)// 
        {
          case 0: win1251_2ws(ws_edit,s);break;
          case 1: utf8_2ws(ws_edit,s,file_size); break;
          case 2: koi2ws(ws_edit,s); break;
          case 3: ascii2ws(ws_edit,s); break;
          case 4: win1250_2ws(ws_edit,s); break;
        }
  char *ss=malloc(64);
  sprintf(info,"%s%s %s%d kb","  :\n",filename,"\n:",file_size);
  ConstructEditControl(&ec,ECT_NORMAL_TEXT,ECF_NORMAL_STR,ws_edit, file_size*2);//ECF_NORMAL_STR
  
  SetFontToEditCOptions(&ec_options,size_font);
  SetPenColorToEditCOptions(&ec_options,pen_font);
  SetBrushColorToEditCOptions(&ec_options,brush_font);
  CopyOptionsToEditControl(&ec,&ec_options);
  AddEditControlToEditQend(eq,&ec,ma);
        
  patch_header(&disk_prop_hdr);
  patch_input(ReadOnly==0?&read_only_desc:&edit_desc);      

  mfree_adr();
  mfree(s);
  return id_ed=CreateInputTextDialog(ReadOnly==0?&read_only_desc:&edit_desc,&disk_prop_hdr,eq,1,0);
  //    )))
}
//==============================================================================
int maingui_id;
const RECT Canvas={0,0,131,172};
void maincsm_oncreate(CSM_RAM *data)
{
  //MAIN_CSM *csm=(MAIN_CSM*)data;  
  //csm->gui_id=ShowMenuCode();//DrawText(file,codepg);
}


extern void kill_data(void *p,void (*func_p)(void *));
void Killer(void)
{
  extern void *ELF_BEGIN;
  kill_data(&ELF_BEGIN,(void (*)(void *))mfree_adr());
}

void maincsm_onclose(CSM_RAM *csm)
{
  FreeWS(ws_edit);
  GBS_DelTimer(&tmr);
  FreeINI();
  //SaveINI();
  SUBPROC((void *)Killer);
}
#define idlegui_id(icsm) (((int *)icsm)[DISPLACE_OF_IDLEGUI_ID/4])

#pragma inline=forced
int toupper(int c)
{
  if ((c>='a')&&(c<='z')) c+='A'-'a';
  return(c);
}
#pragma inline
int strcmp_nocase(const char *s1,const char *s2)
{
  int i;
  int c;
  while(!(i=(c=toupper(*s1++))-toupper(*s2++))) if (!c) break;
  return(i);
}
int maincsm_onmessage(CSM_RAM *data, GBS_MSG *msg)
{
  MAIN_CSM *csm=(MAIN_CSM*)data;
  if (msg->msg==MSG_GUI_DESTROYED)
  {
    if ((int)msg->data0==csm->gui_id)
    {
      {
	csm->csm.state=-3;
      }
    }
  }
  if (msg->msg==MSG_RECONFIGURE_REQ)
  {
    extern const char *successed_config_filename;
    if (strcmp(successed_config_filename,(char *)msg->data0)==0)
    {
      ShowMSG(1,(int)"TextReader config updated!");
      InitConfig();
    }
  }
 
  return(1);
}

unsigned short maincsm_name_body[140];

const struct
{
  CSM_DESC maincsm;
  WSHDR maincsm_name;
}MAINCSM =
{
  {
  maincsm_onmessage,
  maincsm_oncreate,
#ifdef NEWSGOLD
  0,
  0,
  0,
  0,
#endif
  maincsm_onclose,
  sizeof(MAIN_CSM),
  1,
  &minus11
  },
  {
    maincsm_name_body,
    NAMECSM_MAGIC1,
    NAMECSM_MAGIC2,
    0x0,
    139
  }
};

void UpdateCSMname(void)
{ 
  WSHDR *ws=AllocWS(256);
  str_2ws(ws,file,126);
  wsprintf((WSHDR *)(&MAINCSM.maincsm_name),"TR: %w",ws);
  FreeWS(ws);
}

int main(char *exename, char *fname)
{
  InitConfig();
  if (fname)
  {
    if (strlen(fname)<128)
    {
      strcpy(file,fname);
    }
    ReadOnly=1;
//    LoadINI();
    ShowMenuCode();
//    DrawText(file,codepg);
  }
  else open_fm();

 /* char dummy[sizeof(MAIN_CSM)];
  LockSched();
  UpdateCSMname();
  CreateCSM(&MAINCSM.maincsm,dummy,0);
  UnlockSched();
  */
  return 0;
}
