//Release 17.12.2006
// S75/SL75,  Project/Options/C C++ Compiler/Preprocessor/Defined symbols: NEWSGOLD
//E EL71     ELKA

typedef unsigned int size_t;
typedef unsigned long time_t;
typedef int jmp_buf[11];

#ifndef _NULL
#define _NULL 0
#endif

#ifndef NULL
#define NULL   _NULL
#endif /* NULL */

#define __int16 short

#include "..\inc\png.h"
#include "..\inc\rsa.h"
#include "..\inc\sha.h"

#define LMAN_CONNECT_CNF 0x80
#define LMAN_CONNECT_REJ_IND 0x81
#define LMAN_DISCONNECT_IND 0x82
//#define 0x83
#define LMAN_DISCONNECT_CNF 0x84
//#define 0x85
//#define 0x86
//#define 0x87
//#define 0x88
#define LMAN_LINK_UP_IND 0x89
#define ENIP_BUFFER_FREE 0x8A
#define ENIP_BUFFER_FREE1 0x8B
#define ENIP_SOCK_DATA_READ 0x8C
#define ENIP_SOCK_CONNECTED 0x8D
#define ENIP_SOCK_CLOSED 0x8E
#define ENIP_SOCK_REMOTE_CLOSED 0x8F
#define ENIP_SOCK_ACCEPTED 0x90
#define ENIP_SOCK_ICMP_ERROR 0x91
#define ENIP_DNR_HOST_BY_NAME 0x94


#ifdef NEWSGOLD

#ifdef ELKA
#define DISPLACE_OF_EDGUI 0x90
#define DISPLACE_OF_USSDREQGUI_ID 0x44
#define DISPLACE_OF_EDGUI_ID 0x4C
#define DISPLACE_OF_IDLEGUI_ID 0x2C
#define DISPLACE_OF_IDLECANVAS 0x20

#else
#define DISPLACE_OF_EDGUI 0x88
#define DISPLACE_OF_USSDREQGUI_ID 0x44
#define DISPLACE_OF_EDGUI_ID 0x4C
#define DISPLACE_OF_IDLEGUI_ID 0x2C
#define DISPLACE_OF_IDLECANVAS 0x18

#endif

#define DISPLACE_OF_INCOMMINGGUI 0x34
#define DISPLACE_OF_OUTGOINGGUI 0x30
#define MSG_INCOMMING_CALL 0x6000
#define MSG_STATE_OF_CALL 0x6009
#define MSG_END_CALL 0x600B

#define MSG_HELPER_TRANSLATOR 0xDEAE
#define MSG_RECONFIGURE_REQ 0xDEAF
#define MSG_IPC 0xDEB0

#define MSG_SMS_RX 0x5803

#define MSG_USSD_RX 0x60E2
#define MSG_AUTOUSSD_RX 0x60E5
typedef struct{
  int pid_from;
  int msg; //MSG_USSD_RX
  void *pkt;
  char unk1;
  char encoding_type;
  char pkt_length;
  char unk2;
  void *data1;
} GBS_USSD_MSG;

#define MSG_PLAYFILE_REPORT 0x70BC
#define MSG_CSM_DESTROYED 0x6400
#define MSG_CSM_DESTROY_NOTIFY 0x6402
#define MSG_GUI_DESTROYED 0x640E
#define MSG_IDLETMR_EXPIRED 0x6401
#define MMI_CEPID 0x4209
#define LGP_NULL 0x7FFFFFFF
#define SET_SOFT_KEY_N 0
#define LGP_DOIT_PIC 0x7FFFC0FB
#else

#define DISPLACE_OF_EDGUI 0x50
#define DISPLACE_OF_USSDREQGUI_ID 0x40
#define DISPLACE_OF_EDGUI_ID 0x4C
#define DISPLACE_OF_IDLEGUI_ID 0x28
#define DISPLACE_OF_IDLECANVAS 0x14


#define DISPLACE_OF_INCOMMINGGUI 0x30
#define DISPLACE_OF_OUTGOINGGUI 0x2C
#define MSG_INCOMMING_CALL 0x08
#define MSG_STATE_OF_CALL 0x0B
#define MSG_END_CALL 0x0D

#define MSG_HELPER_TRANSLATOR 0x3F0
#define MSG_RECONFIGURE_REQ 0x3F1
#define MSG_IPC 0x3F2

#define MSG_SMS_RX 0xC2

#define MSG_USSD_RX 0x42
#define MSG_AUTOUSSD_RX 0x45

typedef struct{
  short pid_from;
  short msg; //MSG_USSD_RX
  void *pkt;
  char unk1;
  char encoding_type;
  char pkt_length;
  char unk2;
  void *data1;
} GBS_USSD_MSG;

#define MSG_CSM_DESTROYED 0x93
#define MSG_CSM_DESTROY_NOTIFY 0x92
#define MSG_GUI_DESTROYED 0x98
#define MSG_IDLETMR_EXPIRED 0x95
#define MMI_CEPID 0x4209
#define LGP_NULL 0x7FFF
#define SET_SOFT_KEY_N 1
#define LGP_DOIT_PIC 0x7FFFC0FB

#ifdef X75
#define MSG_PLAYFILE_REPORT 0x174
#else
#define MSG_PLAYFILE_REPORT 0x167
#endif

#endif

#define NAMECSM_MAGIC1 ((void *(*)(int))0x55AACCCC)
#define NAMECSM_MAGIC2 ((void (*)(void *))0x3333AA55)

typedef struct{
  unsigned long year;
  unsigned char month;
  unsigned char day;
} TDate;

typedef struct{
  unsigned char hour;
  unsigned char min;
  unsigned char sec;
  unsigned long millisec;
} TTime;

typedef struct{
  unsigned int type;
  unsigned int param2;
  unsigned short param3;
  unsigned short wstr[25];
}StructUSSDStr;

typedef struct{
  void *p1;
  void *p2;
  StructUSSDStr *pussdstr;
}StructUSSD;

typedef struct
{
  void *first;
  void *last;
  void (*data_mfree)(void *);
}LLQ;

typedef struct{
  int param0;
  int param1;
  int param2;
  int param3;
} GBSTMR;

typedef struct{
#ifdef NEWSGOLD
  int pid_from;
  int msg;
#else
  short pid_from;
  short msg;
#endif
  int submess;
  void *data0;
  void *data1;
} GBS_MSG;

typedef struct{
  void *p;
  int i;
}MUTEX;

typedef struct{
  void *next;
  void *prev;
  void /*CSM_DESC*/ *constr;
  int id;
  int state;
  int unk1;
  int unk2;
  LLQ gui_ll;
} CSM_RAM;

typedef struct{
  int (*onMessage)(CSM_RAM*,GBS_MSG*);
  void (*onCreate)(CSM_RAM*);
#ifdef NEWSGOLD
  int zero1;
  int zero2;
  int zero3;
  int zero4;
#endif
  void (*onClose)(CSM_RAM*);
  int datasize;
  int statesize;
  const int *states;
} CSM_DESC;

#ifdef NEWSGOLD
typedef struct{
  int id;
  CSM_RAM *current_msg_processing_csm;
  LLQ csm;
  LLQ cmd;
  LLQ csm_background;
} CSMQ;
#else
typedef struct{
  int id;
  CSM_RAM *current_msg_processing_csm;
  LLQ csm;
  LLQ cmd;
  int unk;
  int unk1;
  void *methods;
  int unk2;
  void *tmr;
  short cepid;
} CSMQ;
#endif

typedef struct{
#ifdef NEWSGOLD
  void *next;
  void *prev;
  int flag1;
  int parent_id;
  int prio;
  int (*proc)(CSMQ *, void *);
  CSMQ *csm_q;
  int id;
  int flag2;
#else
  void *next;
  void *prev;
  char flag1;
  int parent_id;
  int (*proc)(CSMQ *, void *);
  CSMQ *csm_q;
  CSM_RAM *cmd_csm;
#endif
}MMICMD;



typedef struct{
  int under_idle_id;
  int idle_id;
  CSMQ *csm_q;
} CSMROOT;

typedef struct{
  short x;
  short y;
  short x2;
  short y2;
} RECT;

typedef struct{
  char dummy[0x24];
} DRWOBJ;

typedef struct{
  unsigned short *wsbody;
  void *(*ws_malloc)(int);
  void (*ws_mfree)(void *);
  int unk;
  int maxlen;
} WSHDR;

typedef struct
{
  void *next;
  void *prev;
  void *data;
}EDITQ;

typedef struct
{
  void *next;
  void *prev;
}LLIST;

typedef struct
{
#ifdef NEWSGOLD
  const char *ext;
  int unical_id;
  char enabled_options;
  char obex_path_id;
  short menu_flag;
  const int *icon1;
  const int *icon2;
  int Open_lgpid;	//0x109
  int Options_lgpid;	//0x10A
  int Enter_lgpid;	//0x7FFFC0FB
  void *proc;
  void *altproc;
#else
  const char *ext;
  int unical_id;
  signed char enabled_options;
  unsigned char obex_path_id;   
  unsigned short menu_flag;
  const int *icon1;
  const int *icon2; //skip on reg
  void *proc;
  void *altproc;
#endif
}REGEXPLEXT;

typedef struct
{
  int zero;
  unsigned const int *icon1;
  int unical_id;
  char obex_path_id;
  char unk;
  unsigned short menu_flag;
  char enabled_options;
  char not_used[3];
  WSHDR* ext;
  void *proc;
  void *altproc;
  unsigned const int *icon2;
}REGEXPLEXT_ARM_NEW;

#ifdef NEWSGOLD
typedef struct
{
  RECT *canvas;
  void *methods;
  void *definition;
  char state;
  char unk2;
  char unk3;
  char unk4;
  int color1; // GeneralFunc  ?????
  int color2;
  LLQ item_ll;
  int unk5;
  char unk6;
  char unk7;
  char unk8;
  char unk9;
  int unk10;
  int flag30; //   ( |=0x02)
}GUI;
#else
typedef struct
{
  RECT *canvas;
  void *methods;
  void *definition;
  char state;
  char unk2;
  char unk3;
  char unk4;
  int color1; // GeneralFunc  ?????
//  int color2;
  LLQ item_ll;
  int unk5;
  char unk6;
  char unk7;
  char unk8;
  char unk9;
  int unk10;
  int flag30; //   ( |=0x02)
}GUI;
#endif


typedef struct
{
  char zero;
  char unk1;
  short keys;
  GBS_MSG *gbsmsg;
}GUI_MSG;


//Keyhook return codes
//Process key to next keyhook and to gui
#define KEYHOOK_NEXT (0)
//Process key only to next keyhook, not to gui
#define KEYHOOK_NEXT_NOT2GUI (1)
//Break process and exit without processing in gui
#define KEYHOOK_BREAK (2)
//Break process and exit with or not processing in gui (selected by prev values 0/1)
#define KEYHOOK_ENDQ (3)


//Constants
//Attributes
#define FA_READONLY 0x0001
#define FA_HIDDEN 0x0002
#define FA_SYSTEM 0x0004
#define FA_DIRECTORY 0x0010
#define FA_ARCHIVE 0x0020

//Seek
#define S_SET 0
#define S_CUR 1
#define S_END 2

//Permissions
#define P_WRITE 0x100
#define P_READ 0x80

//Access
#define A_ReadOnly 0
#define A_WriteOnly 1
#define A_ReadWrite 2
#define A_NoShare 4
#define A_Append 8
#define A_Exclusive 0x10
#define A_MMCStream 0x20
#define A_Create 0x100
#define A_Truncate 0x200
#define A_FailCreateOnExist 0x400
#define A_FailOnReopen 0x800

#define A_TXT 0x4000
#define A_BIN 0x8000

// kbd msg:
#define KEY_DOWN        0x193
#define KEY_UP          0x194
#define LONG_PRESS      0x195
// 196 - sent 1 second after last key release, but not always?
// 197 - ? unknown kbd msg
// 198 - ? unknown kbd msg

// For kbd msg:
// submsg - scan Code:
#ifdef NEWSGOLD
#define LEFT_SOFT       0x01
#define RIGHT_SOFT      0x04
#define GREEN_BUTTON    0x0B
#define RED_BUTTON      0x0C
#define VOL_UP_BUTTON   0x0D
#define VOL_DOWN_BUTTON 0x0E
#define UP_BUTTON       0x3B
#define DOWN_BUTTON     0x3C
#define LEFT_BUTTON     0x3D
#define RIGHT_BUTTON    0x3E
#define ENTER_BUTTON	0x1A
#ifdef ELKA
#define POC_BUTTON 0x15
#else
#define INTERNET_BUTTON 0x11
#endif
#define PLAY_BUTTON	0x15
#define CAMERA_BUTTON	0x14
#else
#define LEFT_SOFT       0x01
#define RIGHT_SOFT      0x04
#define GREEN_BUTTON    0x0B
#define RED_BUTTON      0x0C
#ifdef X75
#define VOL_UP_BUTTON   0x14
#define VOL_DOWN_BUTTON 0x15
#else
#define VOL_UP_BUTTON   0x0D
#define VOL_DOWN_BUTTON 0x0E
#endif
#define UP_BUTTON       0x3B
#define DOWN_BUTTON     0x3C
#define LEFT_BUTTON     0x3D
#define RIGHT_BUTTON    0x3E
#define ENTER_BUTTON	0x1A
#define INTERNET_BUTTON     0x11
#endif
// '*', '#', '0'-'9'

//Draw flags
#define TEXT_ALIGNLEFT 1
#define TEXT_ALIGNMIDDLE 2
#define TEXT_ALIGNRIGHT 4
#define TEXT_UNDERLINE 8
#define TEXT_INVERT 16
#define TEXT_OUTLINE 32
#define TEXT_PASSWORD 64
#define TEXT_NOFORMAT 128
#define TEXT_INVERT2 256

#define RECT_DOT_OUTLINE 1
#define RECT_FILL_WITH_PEN 2
#define RECT_DRAW_INVERT 4

#define LINE_DOTTED 1
#define LINE_DOTTED2 2

//Fonts

#ifdef NEWSGOLD

#ifdef ELKA

// E/EL71.    ,   .
// E/EL71. There are no numeric fonts, they are replaced with regular.

#define FONT_LARGE 0
#define FONT_LARGE_BOLD 1
#define FONT_LARGE_ITALIC 2
#define FONT_LARGE_ITALIC_BOLD 3
#define FONT_MEDIUM 4
#define FONT_MEDIUM_BOLD 5
#define FONT_MEDIUM_ITALIC 6
#define FONT_MEDIUM_ITALIC_BOLD 7
#define FONT_NUMERIC_SMALL 8
#define FONT_NUMERIC_SMALL_BOLD 9
#define FONT_NUMERIC_XSMALL 8
#define FONT_SMALL 8
#define FONT_SMALL_BOLD 9
#define FONT_SMALL_ITALIC 10
#define FONT_SMALL_ITALIC_BOLD 11
#define FONT_NUMERIC_LARGE 0
#define FONT_NUMERIC_MEDIUM 4

//#define SMALL_FONT 8
//#define MIDDLE_FONT 4

#else //#ifdef ELKA

#define FONT_LARGE 0
#define FONT_LARGE_BOLD 1
#define FONT_LARGE_ITALIC 2
#define FONT_LARGE_ITALIC_BOLD 3
#define FONT_MEDIUM 4
#define FONT_MEDIUM_BOLD 5
#define FONT_MEDIUM_ITALIC 6
#define FONT_MEDIUM_ITALIC_BOLD 7
#define FONT_NUMERIC_SMALL 8
#define FONT_NUMERIC_SMALL_BOLD 9
#define FONT_NUMERIC_XSMALL 10
#define FONT_SMALL 11
#define FONT_SMALL_BOLD 12
#define FONT_SMALL_ITALIC 13
#define FONT_SMALL_ITALIC_BOLD 14
#define FONT_NUMERIC_LARGE 15
#define FONT_NUMERIC_MEDIUM 16

//#define SMALL_FONT 11
//#define MIDDLE_FONT 4

#endif //#ifdef ELKA

#else //#ifdef NEWSGOLD

// SGOLD.      ,     .
// SGOLD. As there are initially no italic fonts in SGOLD series, they were replaced with corresponding regular fonts.

#define FONT_LARGE 0
#define FONT_LARGE_BOLD 1
#define FONT_LARGE_ITALIC 0
#define FONT_LARGE_ITALIC_BOLD 1
#define FONT_MEDIUM 2
#define FONT_MEDIUM_BOLD 3
#define FONT_MEDIUM_ITALIC 2
#define FONT_MEDIUM_ITALIC_BOLD 3
#define FONT_NUMERIC_SMALL 4
#define FONT_NUMERIC_SMALL_BOLD 5
#define FONT_NUMERIC_XSMALL 6
#define FONT_SMALL 7
#define FONT_SMALL_BOLD 8
#define FONT_SMALL_ITALIC 7
#define FONT_SMALL_ITALIC_BOLD 8
#define FONT_NUMERIC_LARGE 9
#define FONT_NUMERIC_MEDIUM 10

//#define MIDDLE_FONT 3
//#define SMALL_FONT 7

#endif //#ifdef NEWSGOLD

// Phone info IDs
#define PI_BASE_INFO1   0 // mch_x75idbi14
#define PI_BASE_INFO2   1 // m75i14#main_1.0_V79.27.1
#define PI_BASE_INFO3   2 // M_x75plat_MP_main_1.0
#define PI_BASE_INFO4   3 // M_minosemea_TH
#define PI_BUILD        4 // OFFICIAL
#define PI_DATETIME1	5	// -  
#define PI_DATETIME2    6
#define PI_SW_NUMBER    7 //  
#define PI_VENDOR       8 // = SIEMENS :)
#define PI_MODEL        9 //  
#define PI_LG           10 // = LangPack
#define PI_T9           11 // = T9


#ifdef NEWSGOLD
#define FIRST_UCS2_BITMAP 0xE12A
#else
#define FIRST_UCS2_BITMAP 0xE137
#endif

typedef struct
{
#ifdef ELKA
  unsigned short w;
  unsigned short h;
  int bpnum; //For BW=1, 8bit=5, 16bit=8, 0x80 - packed
#else
  char w;
  char h;
  unsigned short bpnum; //For BW=1, 8bit=5, 16bit=8, 0x80 - packed
#endif
  char *bitmap;
}IMGHDR;

typedef struct
{
  RECT rc;
  int *icon;
  int lgp_id;
  int lgp_null; //LGP_NULL
}HEADER_DESC;

typedef struct
{
  int *icon;
  int lgp_id_small;
  int lgp_id_large;
  int zero;
  const int *softkeys; //{6,0x22,0x1D}
  int flag1; //0
  int flag2; //0x59D
}MENUITEM_DESC;

typedef struct
{
  short key1;
  short key2;
  int lgp_id;
}SOFTKEY_DESC;

typedef struct
{
  const SOFTKEY_DESC *desc;
  int n;
}SOFTKEYSTAB;

typedef void (__interwork *MENUPROCS_DESC)(GUI *);

typedef struct
{
  int flag; //0,8 etc
  int (*onkey)(void *, GUI_MSG *);
  void (*ghook)(void *, int ); //GUI * gui, int cmd
  void *proc3;
  const int *softkeys; //{6,0x22,0x1D}, mb default for all items, if item.softkeys==NULL
  const SOFTKEYSTAB *softkeystab;
  int flags2; //2
//  0x00000001 //Icons presens
//  0x00000002 //
//  0x00000008 //
//  0x00000010 //Enable scroll text
//  0x00000020 //
//  0x00000040 //Disable scrollbar
//  0x00000080 //Enable "big letters" check
//  0x00000100 //Right align
//  0x00000200 //
//  0x00000400 //Disable breakline
//  0x00000800
//  0x00001000
//  0x00004000
//  0x00008000 //
//  0x00010000 //Enable search???
//  0x40000000
//  0x80000000

  void (*itemproc)(void *, int, void *); //Called when draw item
  const MENUITEM_DESC *items; //Table of items desc;
  const MENUPROCS_DESC *procs;//  void ** procs; //Table of procs when item selected
  int n_items; //Number of items
}MENU_DESC;

typedef struct
{
  int flag; //0,8 etc
  int (*onkey)(void *, GUI_MSG *);
  void (*ghook)(void *, int ); //GUI * gui, int cmd
  void *proc3;
  const int *softkeys; //{6,0x22,0x1D}, mb default for all items, if item.softkeys==NULL
  const SOFTKEYSTAB *softkeystab;
  int flags2; //2
  void (*itemproc)(void *, int, void *); //Called when draw item
  const MENUITEM_DESC *items; //Table of items desc;
  const MENUPROCS_DESC *procs;//  void ** procs; //Table of procs when item selected
  int n_items; //Number of items
  int n_lines; //Number of lines in selected item
}ML_MENU_DESC;

#pragma pack(1)
typedef struct{
#ifdef NEWSGOLD
  char unk0[40];
  unsigned int file_size;
  short file_attr;
  unsigned int create_date_time;
  char unk1[2];
  char folder_name[128];
  char unk2;
  char file_name[128];
  char unk3[11];
  short wsfolder_name[128+1];
  short wsfile_name[128+1];
#else
  char unk1[14];
  short file_attr;
  unsigned int create_date_time; 
  unsigned int file_size;
  char unk2[16];
  char folder_name[128];
  char unk3;
  char file_name[271];
#endif
}DIR_ENTRY;
#pragma pack()

typedef struct
{
  char unk1;
  char unk2;
  char unk3;
  char unk4;
  unsigned int size;
  char unk5[28];
  int file_attr;
}FSTATS;


typedef struct
{
  unsigned short ch_number;
  unsigned short ci;
  unsigned short lac;
  char power;
  char c1;
  char c2;
  char unk;
  unsigned short unk2;
}RAMNET;

//-----------------------------------------

typedef struct
{
  int one;
  int (*onKey)(GUI *gui, GUI_MSG *msg);
  void (*global_hook_proc)(GUI *gui, int cmd);
  void *locret;
  int zero1;
  const SOFTKEYSTAB *softkeystab;
  RECT rc;
  int font;
  int _100;
  int _101;
  int zero2;
//  0x00000001 -    
//  0x00000002 -   
//  0x00000004 -  
//  0x00000008 - UnderLine
//  0x00000020 -   
//  0x00000200 - bold
  int zero3;
//  0x00000002 - ReadOnly
//  0x00000004 -   
//  0x40000000 -   -
  int _0x40000000;
}INPUTDIA_DESC;

typedef struct
{
  char type;
  void *user_pointer;
  unsigned short cur_item;
  WSHDR *ws;  
}USR_MENU_ITEM;

typedef struct
{
  unsigned short invert;  // |1
  unsigned short bitmask;
  char font;              // |2
  char align;             // |4
  char pen[4];            // |8
  char brush[4];          // |0x10
}EDITC_OPTIONS;

#pragma pack(2)
typedef struct
{
  char type;
  char unk2[3];
  int flag;
  char zero_cbox;  // if text input field: lang 0 - default, 2 - english
  char unk5;
  EDITC_OPTIONS ed_options;
  short maxlen;
  short num_of_items_cbox;
  short start_item_cbox;
  short unk9;
  short unk10;
  short unk11;
  int unk12;
  WSHDR *pWS;
}EDITCONTROL;
#pragma pack()

//EditControlTypes
#define ECT_READ_ONLY 0
#define ECT_HEADER 1
#define ECT_NUMBER_TYPING 2
#define ECT_NORMAL_TEXT 3
#define ECT_CURSOR_STAY 4
#define ECT_FIXED_STR_NUM 5
#define ECT_NORMAL_NUM 6
#define ECT_COMBO_BOX 7
#define ECT_READ_ONLY_SELECTED 8
#define ECT_CALENDAR 10
#define ECT_TIME 11

//EditControlFlags
#define ECF_NORMAL_STR 0
#define ECF_SKIP 4
#define ECF_INVISIBLE_CURSOR 8
#define ECF_PASSW 0x10
#define ECF_DELSTR 0x20
#define ECF_APPEND_EOL 0x40
#define ECF_SET_CURSOR_END 0x80

#define ECF_DISABLE_NUM 0x100
#define ECF_DISABLE_SMALL_LETTERS 0x200
#define ECF_DISABLE_BIG_LETTERS 0x400

#define ECF_DEFAULT_BIG_LETTER 0x1000  // Enable big letter after ". "
#define ECF_DISABLE_T9 0x2000
#define ECF_DEFAULT_ITAP 0x4000
#define ECF_DEFAULT_DIGIT 0x8000

#define ECF_DISABLE_EOLCHAR 0x10000  // In chartable
#define ECF_DISABLE_MINUS 0x20000  // Also disable #
#define ECF_DISABLE_POINT 0x40000  // Also disable *
#define ECF_LONGDIEZ_EQ_QUESTION 0x80000
#define ECF_ENABLE_TEXT_FORMAT 0x800000
#define ECF_MARKED 0x2000000
#define ECF_GRAY 0x4000000

/*
!!!! DELETED !!!!
!!!! Use EDIT_GetCursorPos & EDIT_SetCursorPos
#ifdef NEWSGOLD
#ifdef ELKA
#define EDIT_CURSOR_POS(DATA) (((int ****)DATA)[0x90/4][0x8C/4][0x28/4][0x38/4])
#else
#define EDIT_CURSOR_POS(DATA) (((short ****)DATA)[0x88/4][0x84/4][0x28/4][0x34/2])
#endif
#else
#define EDIT_CURSOR_POS(DATA) (((short ****)DATA)[0x50/4][0x4C/4][0x28/4][0x30/2])
#endif
*/
//Menu flags and screen displace
#ifdef NEWSGOLD
#ifdef ELKA
#define MENU_FLAG3 3
#define MENU_FLAG2 0x5A2
#define YDISP (24)
#else
#define MENU_FLAG3 3
#define MENU_FLAG2 0x59D
#define YDISP (0)
#endif
#else
#define MENU_FLAG3 3
#define MENU_FLAG2 0x578
#define YDISP (0)
#endif


typedef struct
{
#ifdef NEWSGOLD
  short field_0;
  char no_data;
  char item_type;
  int field_4;
  void *data;
#else
  char field_0;
  char no_data;
  char field_2;
  char item_type;
  int field_4;
  void *data;
#endif
}AB_UNPRES_ITEM;

typedef struct{
#ifdef NEWSGOLD
  short NrOfFlds;
  short number_of_records;
  short NrAllocFlds;
  short field_6;
  short NrJ;
  char field_A;
  char field_B;
  AB_UNPRES_ITEM *record_list;
  char EntTp;
  char field_11;
  short EntId;
  int field_14;
  int field_18;
#else
  short field_0;
  short field_2;
  short field_4;
  short number_of_records;
  short field_8;
  short field_A;
  AB_UNPRES_ITEM *record_list;
  char field_10;
  char field_11;
  short field_12;
  int field_14;
  int field_18;
#endif
}AB_UNPRES;

#pragma pack(1)
typedef struct
{
  char _1D;
  char format;
  char data_size;
  char _0_1;
  char _0_2;
//  char _0_3;
  char data[128];
}PKT_NUM;
#pragma pack()

//================================
// Sockets
//================================
typedef struct
{
  unsigned short family; //1
  unsigned short port; //network order
  unsigned int ip; //network order
  unsigned int unk1;
  unsigned int unk2;
}SOCK_ADDR;

#pragma pack(2)
typedef struct
{
  unsigned short _0x0080;
  unsigned short _0xFFFF;
  unsigned short _0x0000;
}REGSOCKCEPID_DATA;
#pragma pack()

typedef struct
{
  char body[0x204];
}CTX_NAPDEF;

typedef struct
{
  unsigned int len;
  CTX_NAPDEF *ctx_napdef;
  unsigned int zero;
  CTX_NAPDEF napdef;
}NAP_PARAM_CONT;

typedef struct
{
#ifdef NEWSGOLD
  int zero;
  void *native_profile;
  char _1;
  char _4;
  unsigned short _0;
  NAP_PARAM_CONT *NapParameterContainer;
#else
  char unk1;
  char *unk;
  char one;
  char isactivated;  
#endif  
}LMAN_DATA;

#define IP_ADDR(A,B,C,D) (((unsigned long)A<<24)|((unsigned long)B<<16)|((unsigned long)C<<8)|((unsigned long)D<<0))

typedef struct{
#ifdef NEWSGOLD
  unsigned short repeat_num;  //0 - non limited
  unsigned short unk;
  int time_between_play;
  int play_first; // 0 - play all
  int volume;
  int unk5;
  int unk6;
  int unk7;
  int unk8;
  int unk9;
#else
#ifdef X75
  unsigned short repeat_num;  //0 - non limited
  unsigned short unk;
  int time_between_play;
  int play_first; // 0 - play all
  int volume;
  int unk4;     //0x80000000
  int unk5;     //1
  int unk6;     //0
  int unk7;
#else
  unsigned short repeat_num;  //0 - non limited
  unsigned short unk;
  int time_between_play;
  int play_first; // 0 - play all
  int volume;
  int unk5;
  int unk6;
#endif
#endif  
}PLAYFILE_OPT;


typedef struct
{
 char data[0xB2];
}PDU;

typedef struct
{
  const char *name_to;
  const char *name_from;
  void *data;
}IPC_REQ;

#pragma diag_suppress=Ta035

#pragma swi_number=0
__swi __arm void loopback0();
//arm
//pattern=1E,FF,2F,E1

#pragma swi_number=1
__swi __arm void loopback1();
//arm
//pattern=1E,FF,2F,E1

#pragma swi_number=2
__swi __arm void loopback2();
//arm
//pattern=1E,FF,2F,E1

#pragma swi_number=3
__swi __arm void loopback3();
//arm
//pattern=1E,FF,2F,E1

#pragma swi_number=4
__swi __arm void loopback4();
//arm
//pattern=1E,FF,2F,E1

#pragma swi_number=6
__swi __arm int GetAkku(int param1,int param2);
//arm
//pattern=1C,40,2D,E9,??,??,9F,E5,00,21,80,E0,82,20,83,E0,01,20,D2,E7,FF,00,52,E3,??,??,9F,05,??,00,00,0A,80,00,12,E3,??,??,9F,05,00,00,90,05,82,01,80,00,B2,00,D0,01,??,00,00,0A,00,30,A0,E3

#pragma swi_number=8
__swi __arm long SetIllumination(unsigned char dev,unsigned long param1,unsigned short bright,unsigned long delay);
//arm
//pattern=??,??,??,E9,??,??,??,E1,??,??,??,E5,??,??,??,E2,??,??,??,E5,??,??,??,E5,??,??,??,E3,??,??,??,E3,??,??,??,03,??,??,??,E1,??,??,??,E3,??,??,??,E1,??,??,??,0A,??,??,??,E3,??,??,??,2A,??,??,??,E3,??,??,??,E1,??,??,??,E5,??,??,??,E7,??,??,??,E3,??,??,??,1A,??,??,??,E3,??,??,??,E2,??,??,??,E8

#pragma swi_number=0x9
__swi __arm void SwitchPhoneOff();
//arm
//pattern=

#pragma swi_number=10
__swi __arm int fopen(const char * cFileName, unsigned int iFileFlags, unsigned int iFileMode, unsigned int *ErrorNumber);
//arm
//pattern=??,??,??,E9,??,??,??,E1,??,??,??,E1,??,??,??,E1,??,??,??,E1,??,??,??,??,??,??,??,E3,??,??,??,E5,??,??,??,E8,??,??,??,E5,??,??,??,E3,??,??,??,E1,??,??,??,E3,??,??,??,E1,??,??,??,E1,??,??,??,E8

#pragma swi_number=11
__swi __arm int fread(int FileHandler, void *cBuffer, int iByteCount, unsigned int *ErrorNumber);
//arm
//pattern=??,??,??,E9,??,??,??,E1,??,??,??,E1,??,??,??,E1,??,??,??,E1,??,??,??,??,??,??,??,E3,??,??,??,E5,??,??,??,E5,34,??,??,E5,??,??,??,E3,??,??,??,E1,??,??,??,E1,??,??,??,E1,??,??,??,E1,??,??,??,E8

#pragma swi_number=12
__swi __arm unsigned int fwrite(int FileHandler, void const * cBuffer, int iByteCount, unsigned int *ErrorNumber);
//arm
//pattern=??,??,??,E9,??,??,??,E1,??,??,??,E1,??,??,??,E1,??,??,??,E1,??,??,??,??,??,??,??,E3,??,??,??,E5,??,??,??,E5,68,??,??,E5,??,??,??,E3,??,??,??,E1,??,??,??,E1,??,??,??,E1,??,??,??,E1,??,??,??,E8

#pragma swi_number=13
__swi __arm void fclose(int FileHandler, unsigned int *ErrorNumber);
//arm
//pattern=??,??,??,E9,??,??,??,E1,??,??,??,E1,??,??,??,??,??,??,??,E5,??,??,??,E2,??,??,??,E1,??,??,??,E1,??,??,??,E8,??,??,??,E3,??,??,??,E3,??,??,??,E1

#pragma swi_number=15
__swi __arm unsigned int lseek(int FileHandler, unsigned int offset, unsigned int origin, unsigned int *ErrorNumber, unsigned int *ErrorNumber2);
//arm
//pattern=??,??,??,E9,??,??,??,E5,??,??,??,E1,??,??,??,E1,??,??,??,E1,??,??,??,E1,??,??,??,??,??,??,??,E3,??,??,??,E5,??,??,??,E5,??,??,??,E5,??,??,??,E5,??,??,??,E3,??,??,??,E1,??,??,??,E1,??,??,??,E1,??,??,??,E1,??,??,??,E2,??,??,??,E8

#pragma swi_number=16
__swi __arm int mkdir(const char * cFileName, unsigned int *ErrorNumber);
//arm
//pattern=38,40,2D,E9,01,50,A0,E1,00,40,A0,E1,??,??,??,??,00,30,E0,E3,??,??,??,??,28,C0,90,E5,00,00,A0,E3,05,30,A0,E1,00,20,A0,E3

#pragma swi_number=18
__swi __arm int GetFileAttrib(const char *cFileName, unsigned char *cAttribute, unsigned int *ErrorNumber);
//arm
//pattern=7C,40,2D,E9,02,60,A0,E1,01,50,A0,E1,00,40,A0,E1,??,??,??,EB,00,30,E0,E3,04,30,8D,E5,00,60,8D,E5,14,C0,90,E5,00,00,A0,E3,05,30,A0,E1,00,20,A0,E3,04,10,A0,E1,3C,FF,2F,E1,7C,80,BD,E8

#pragma swi_number=19
__swi __arm int SetFileAttrib(const char *cFileName, unsigned char cAttribute, unsigned int *ErrorNumber);
//arm
//pattern=7C,40,2D,E9,02,60,A0,E1,01,50,A0,E1,00,40,A0,E1,??,??,??,EB,00,30,E0,E3,04,30,8D,E5,00,60,8D,E5,44,C0,90,E5,00,00,A0,E3,05,30,A0,E1,00,20,A0,E3,04,10,A0,E1,3C,FF,2F,E1,7C,80,BD,E8

#pragma swi_number=20
__swi __arm void *malloc(unsigned int size);
//arm
//pattern=??,??,??,E1,02,??,??,E3,_blf(??,??,??,E9,??,??,??,E1,??,??,??,E3,??,??,??,E5,??,??,??,E3,??,??,??,E1,??,??,??,??,??,??,??,2A,??,??,??,??,??,??,??,E3,??,??,??,??,??,??,??,8A,??,??,??,E3,??,??,??,03,??,??,??,0A,??,??,??,E3,??,??,??,03,??,??,??,0A,??,??,??,E3,??,??,??,03,??,??,??,13,??,??,??,EA)

#pragma swi_number=0x8014
__swi __arm void *malloc_adr(void);

#pragma swi_number=21
__swi __arm void mfree(void *);
//arm
//pattern=??,??,??,E3,??,??,??,01,??,??,??,E9,??,??,??,E5,??,??,??,E2,??,??,??,??,??,??,??,??,??,??,??,E1,??,??,??,11,??,??,??,??,??,??,??,??,??,??,??,0A,??,??,??,E3,??,??,??,??,??,??,??,??,??,??,??,EF,??,??,??,E1,??,??,??,E3,??,??,??,E1,??,??,??,E3

#pragma swi_number=0x8015
__swi __arm void *mfree_adr(void);

#pragma swi_number=22
__swi __arm int sprintf(char *buf, const char *str, ...);
//thumb
//pattern=??,B4,??,B5,??,B0,??,90,??,48,??,A9,??,91,??,44,??,90,??,48,??,44,??,90,??,AD,??,1C,??,AB,??,AA,??,99,??,??,??,??,??,1C,??,1C,??,20,??,??,??,??,??,1C,??,B0,??,BC,??,BC,??,B0,??,47

#pragma swi_number=23
__swi	__arm	char * strcat (char *,const char *);
//thumb
//pattern=??,78,??,1C,??,2B,??,D0,??,32,??,78,??,2B,??,D1,??,78,??,31,??,70,??,32,??,2B,??,D1,??,47

#pragma swi_number=24
__swi	__arm	char * strchr (const char *,int);
//thumb
//pattern=??,06,??,0E,??,38,??,30,??,78,??,42,??,D0,??,29,??,D1,??,42,??,D0,??,20,??,47

#pragma swi_number=25
__swi	__arm	int  strcmp (const char *,const char *);
//arm
//pattern=??,??,??,E3,??,??,??,03,??,??,??,1A,??,??,??,E9,??,??,??,??,??,??,??,E4,??,??,??,E4,??,??,??,E0,??,??,??,E1,??,??,??,E0,??,??,??,01,??,??,??,0A,??,??,??,E8,??,??,??,E1,??,??,??,E0,??,??,??,03,??,??,??,1A,??,??,??,E1,??,??,??,E0,??,??,??,03,??,??,??,1A,??,??,??,E1,??,??,??,E0,??,??,??,03,??,??,??,00,??,??,??,11,??,??,??,E1,??,??,??,E4,??,??,??,E4,??,??,??,E3,??,??,??,21,??,??,??,1A,??,??,??,E4,??,??,??,E4,??,??,??,E3,??,??,??,21,??,??,??,0A,??,??,??,E0,??,??,??,E1

#pragma swi_number=26
__swi	__arm	char * strcpy (char *dest,const char *source);
//thumb
//pattern=??,1C,??,1C,??,43,??,07,??,B4,??,D1,??,??,??,01,??,E0,??,C2,??,C9,??,1B,??,43,??,40,??,D0,??,06,??,0E,??,70,??,32,??,29,??,D0,??,0A,??,E7,??,78,??,31,??,70,??,32,??,2B,??,D0,??,78,??,31,??,70,??,32,??,2B,??,D1,??,BC,??,47

#pragma swi_number=27
__swi __arm unsigned int strlen(const char *);
//thumb
//pattern=??,B4,??,1C,??,07,??,D0,??,78,??,30,??,29,??,D1,??,1B,??,BC,??,47,??,07,??,D1,??,??,??,01,??,C8,??,1A,??,43,??,40,??,D0,??,1B,??,06,??,D1,??,38,??,E7,??,04,??,0E,??,D1,??,38,??,E7,??,02,??,0E,??,D1,??,38,??,E7

#pragma swi_number=28
__swi	__arm	void  wsAppendChar(WSHDR *ws,int wchar);
//thumb
//pattern=??,B5,??,1C,??,D0,??,1C,??,??,??,??,??,68,??,88,??,42,??,D9,??,33,??,04,??,0C,??,80,??,68,??,00,??,52,??,BD

#pragma swi_number=29
__swi	__arm int wsInsertChar(WSHDR *ws,int wchar,int pos);
//thumb
//pattern=??,B5,??,1C,??,1C,??,28,??,D0,??,68,??,00,??,18,??,2A,??,D0,??,1C,??,??,??,??,??,1A,??,88,??,3A,??,04,??,1A,??,04,??,0C,??,0C,??,42,??,D9,??,1C,??,1C,??,1C

#pragma swi_number=30
__swi	__arm IMGHDR *GetPITaddr(int num);
//thumb
//pattern=??,B5,04,1C,??,??,??,??,A0,42,??,D9

#pragma swi_number=33
__swi __arm int GetImgHeight(int picture);
//thumb
//pattern=80,B5,??,??,??,F?,00,28,00,D1,80,BD,40,78,80,BD

#pragma swi_number=34
__swi __arm int GetImgWidth(int picture);
//thumb
//pattern=80,B5,??,??,??,F?,00,28,00,D1,80,BD,00,78,80,BD

#pragma swi_number=35
__swi __arm void DrawImg(unsigned int x, unsigned int y, unsigned int picture);
//thumb
//pattern=??,4B,??,B5,??,42,??,D0,??,??,??,??,??,BD

#pragma swi_number=37
__swi __arm void DrawCanvas(void *data, int x1, int y1, int x2, int y2, int flag_one);
//thumb
//pattern=??,B5,??,1C,??,1C,??,AB,??,98,??,9C,??,80,??,80,??,80,??,80,??,46,??,??,??,??,??,2D,??,D0,??,2C,??,D0,??,1C,??,46,??,47,??,BD

#pragma swi_number=38
__swi __arm void DrawImgBW(unsigned int x, unsigned int y, unsigned int picture, char *pen, char *brush);
//thumb
//pattern=??,B5,??,??,??,??,??,1C,??,1C,??,18,??,29,??,??,??,D8,??,29,??,D8,??,06,??,16,??,00,??,??,??,E0
//thumb
//pattern=??,B5,??,1C,??,1C,??,B0,??,21,??,43,??,91,??,9D,??,??,??,??,??,1C,??,28,??,??,??,D1,??,A0

#pragma swi_number=50
__swi __arm void PlaySound(long param1, long param2, long param3, long tone, long param5);
//arm
//pattern=??,??,??,E9,??,??,??,E2,??,??,??,E2,??,??,??,E2,??,??,??,E5,??,??,??,E1,??,??,??,E1,??,??,??,E1,??,??,??,??,??,??,??,1A,??,??,??,??,??,??,??,E3,??,??,??,E1,??,??,??,??,??,??,??,E3,??,??,??,0A,??,??,??,EF,??,??,??,E3,??,??,??,E3,??,??,??,E1,??,??,??,E3,??,??,??,??,??,??,??,EA

#pragma swi_number=42
__swi __arm int *GetEELiteBlockAddress(short blocknum);
//arm
//pattern=FE,40,2D,E9,??,??,??,E5,00,40,A0,E1,00,10,D6,E5,??,??,??,E5,B2,00,D0,E1,00,00,51,E3,??,??,??,0A,01,00,51,E3,??,??,??,0A,02,00,51,E3,??,??,??,1A,10,10,96,E5,04,11,91,E7,00,00,51,E3,??,??,??,1A,04,20,8D,E2,04,10,A0,E1,??,??,??,EB,00,00,50,E3,??,??,??,1A

#pragma swi_number=60
__swi __arm int setfilesize(int FileHandler, unsigned int iNewFileSize, unsigned int *ErrorNumber);
//arm
//pattern=7C,40,2D,E9,01,60,A0,E1,02,50,A0,E1,00,40,A0,E1,??,??,??,EB,00,30,E0,E3,00,30,8D,E5,48,C0,90,E5,00,00,A0,E3,05,30,A0,E1,06,20,A0,E1,04,10,A0,E1,3C,FF,2F,E1,7C,80,BD,E8

#pragma swi_number=0x0042
__swi __arm int IsScreenSaver(void);
//thumb
//pattern_SGOLD=??,B5,01,20,??,??,??,??,80,BD,80,B5,00,28,??,??,01,20,??,??,??,??,80,BD,01,20
//thumb
//pattern=

#pragma swi_number=67
__swi __arm int IsUnlocked(void);
//thumb
//pattern=??,48,??,B5,??,68,??,28,??,D0,??,??,??,FF,??,28,??,D1,??,20,??,BD,??,20,??,BD

#pragma swi_number=0x0046
__swi __arm int HasNewSMS(void);
//thumb
//pattern=

#pragma swi_number=0x4A
#ifdef X75
__swi __arm short PlayFile(int flags, WSHDR *foldername, WSHDR *filename, int zero, int CepId, int Msg, const PLAYFILE_OPT *sfo);
#else
__swi __arm short PlayFile(int flags, WSHDR *foldername, WSHDR *filename, int CepId, int Msg, const PLAYFILE_OPT *sfo);
#endif
//arm
//pattern_SGOLD=??,??,??,E9,??,??,??,E2,3C,??,??,E5,??,??,??,E5,??,??,??,E1,??,??,??,E1,??,??,??,E1,??,??,??,E3,??,??,??,DA,??,??,??,E3,??,??,??,AA,??,??,??,E3,??,??,??,0A,??,??,??,E1,??,??,??,??,??,??,??,E3,??,??,??,13,??,??,??,0A

#pragma swi_number=0x004C
__swi __arm int GetMissedCallsCount(void);
//thumb
//pattern=??,48,40,68,70,47,??,48,00,68,70,47,??,B5
//thumb
//pattern_SGOLD=??,B5,??,??,??,??,??,48,??,68,??,??,??,??,??,1C,??,BD,??,B5,??,??,??,??,??,48,??,68,??,??,??,??,??,1C,??,BD

#pragma swi_number=77
__swi __arm void GBS_StartTimerProc(void *htimer, long ms, void ptr());
//arm
//pattern_s75_32=??,??,??,E9,??,??,??,E1,??,??,??,E1,??,??,??,E1,??,??,??,1A,??,??,??,E3,??,??,??,E2,??,??,??,??,??,??,??,EF,??,??,??,E3,??,??,??,E3,??,??,??,??,??,??,??,??,??,??,??,??,??,??,??,E1,??,??,??,??,??,??,??,E3,??,??,??,E1,??,??,??,??,??,??,??,E5,??,??,??,E5,??,??,??,E5,??,??,??,E3,??,??,??,E1,??,??,??,??,??,??,??,E5,??,??,??,E1,??,??,??,E1,??,??,??,E1,??,??,??,??,??,??,??,E5,??,??,??,E1,??,??,??,E2,??,??,??,E1,??,??,??,E8
//thumb
//pattern_s75_24=??,B5,??,1C,??,1C,??,1C,??,D1,??,21,??,??,??,??,??,??,??,DF,??,22,??,20,??,??,??,??,??,??,??,??,??,1C,??,??,??,??,??,21,??,1C,??,??,??,??,??,68,??,65,??,20,??,68,??,02,??,31,??,82,??,??,??,??,??,68,??,31,??,82,??,1C,??,1C,??,??,??,??,??,68,??,30,??,88,??,31,??,80,??,BD

#pragma swi_number=0x4E
__swi __arm int MsgBoxError(int flag, int LgpId);
//thumb
//pattern=??,4A,70,32,??,07,??,D4,38,32,??,1C,??,21,??,E7
//thumb
//pattern_SGOLD=??,4A,C3,07,??,D4,38,3A,??,1C,??,21,??,E7
//thumb
//pattern_ELKA=??,4A,??,07,??,D4,70,3A,??,1C,??,21,??,E7

#pragma swi_number=0x4F
__swi __arm int MsgBoxYesNo(int flag, int LgpID, void CallBackProc(int));
//thumb
//pattern=??,1C,??,1C,??,4A,70,3A,??,E6
//thumb
//pattern_SGOLD=??,1C,??,1C,??,4A,70,32,??,E6
//thumb
//pattern_ELKA=??,1C,??,1C,??,4A,70,32,??,E6

#pragma swi_number=0x50
__swi __arm int MsgBoxOkCancel(int flag, int LgpID, void CallBackProc(int));
//thumb
//pattern=??,1C,??,1C,??,4A,38,3A,??,E6
//thumb
//pattern_SGOLD=??,1C,??,1C,7E,4A,A8,32,??,E6
//thumb
//pattern_ELKA=??,1C,??,1C,??,4A,A8,32,??,E6

#pragma swi_number=92
__swi __arm unsigned char GetCPUClock();
//arm
//pattern=??,??,??,E9,??,??,??,??,??,??,??,E2,??,??,??,E3,??,??,??,90,??,??,??,EA,??,??,??,EA,??,??,??,EA,??,??,??,EA,??,??,??,EA,??,??,??,EA,??,??,??,EA,??,??,??,EA,??,??,??,EA,??,??,??,EA,??,??,??,EA,??,??,??,EA,??,??,??,EA,??,??,??,EA,??,??,??,EA,??,??,??,EA,??,??,??,E3,??,??,??,E8,??,??,??,E3,??,??,??,EA,??,??,??,E3,??,??,??,EA,??,??,??,E3,??,??,??,EA,??,??,??,E3,??,??,??,EA,??,??,??,E3,??,??,??,EA,??,??,??,E3,??,??,??,EA,??,??,??,E3,??,??,??,EA,??,??,??,E3,??,??,??,EA,??,??,??,E3,??,??,??,EA,??,??,??,E3,??,??,??,EA,??,??,??,E3,??,??,??,EA

#pragma swi_number=93
__swi __arm unsigned char GetCPULoad();
//thumb
//pattern=??,B5,??,4C,??,68,??,28,??,D1,??,??,??,??,??,20,??,60,??,20,??,BD,??,??,??,??,??,BD
//thumb
//pattern=??,B5,??,??,??,68,??,28,??,D1,??,??,??,??,??,20,??,60,??,20,??,BD,??,??,??,??,??,BD

/// GetNonPermMemAvail  SGOLD
#pragma swi_number=95
__swi __arm int GetFreeRamAvail();
//arm
//pattern=04,E0,2D,E5,??,??,??,E5,??,??,??,EB,??,??,??,E5,??,20,91,E5,??,10,91,E5,01,10,42,E0,01,00,80,E0,20,00,40,E2,04,F0,9D,E4

#pragma swi_number=107
__swi	__arm	int  FindFirstFile (DIR_ENTRY *DIRENTRY,char *mask,unsigned int *ErrorNumber);
//arm
//pattern=??,??,??,E9,??,??,??,E1,??,??,??,E1,??,??,??,E1,??,??,??,E1,??,??,??,??,??,??,??,E3,??,??,??,E5,??,??,??,E5,??,??,??,E5,??,??,??,E3,??,??,??,E3,??,??,??,E1,??,??,??,E1,??,??,??,E1,??,??,??,E8

#pragma swi_number=108
__swi	__arm	int  FindNextFile (DIR_ENTRY *DIRENTRY,unsigned int *ErrorNumber);
//arm
//pattern=??,??,??,E9,??,??,??,E1,??,??,??,E1,??,??,??,0A,??,??,??,E1,??,??,??,??,??,??,??,EA,??,??,??,??,20,??,??,E5,??,??,??,E2,??,??,??,E1,??,??,??,E1,??,??,??,E8,??,??,??,E3,??,??,??,??,??,??,??,E1

#pragma swi_number=109
__swi	__arm	int  FindClose (DIR_ENTRY *DIRENTRY,unsigned int *ErrorNumber);
//arm
//pattern=??,??,??,E9,??,??,??,E1,??,??,??,E1,??,??,??,0A,??,??,??,E1,??,??,??,??,??,??,??,EA,??,??,??,??,10,??,??,E5,??,??,??,E2,??,??,??,E1,??,??,??,E1,??,??,??,E8,??,??,??,E3,??,??,??,??,??,??,??,E1

#pragma swi_number=0x06E
__swi	__arm int IsCalling(void);

#pragma swi_number=111
__swi __arm void RefreshGPRSTraffic();
//arm
//pattern=10,40,2D,E9,20,D0,4D,E2,04,00,8D,E2,??,??,??,EB,04,40,9D,E5,??,??,??,FA,04,00,80,E0,04,00,8D,E5,04,00,8D,E2,??,??,??,EB,20,D0,8D,E2,10,80,BD,E8

#pragma swi_number=112
__swi __arm int *GetGPRSTrafficPointer();
//arm
//pattern=??,??,??,E5,1E,FF,2F,E1,20,00,A0,E3,??,??,??,EA

#pragma swi_number=0x0073
__swi __arm int GetTypeOfCall();
//thumb
//pattern=??,B5,??,1C,??,??,??,??,42,21,??,1C,??,??,??,??,??,20,??,43,??,49,??,18,??,79,??,??,??,??,??,1C,??,BD

#pragma swi_number=116
__swi __arm void* GetFunctionPointer(char * _shortcut);

#pragma swi_number=124
__swi __arm unsigned int SetVibration(unsigned int power);
//thumb
//pattern=??,B5,??,??,??,1C,??,20,??,39,??,71,??,1C,??,68,??,??,??,27,??,26,??,42,??,??,??,68,??,DA,??,??,??,??,??,??,??,3C,??,78,??,28,??,D9,??,??,??,??,??,70,??,78,??,31,??,70,??,70,??,??,??,??,??,20,??,68,??,??,??,??,??,28,??,D1,??,DF,??,E0

#pragma swi_number=128
__swi __arm int ShowCallList(int list, int zero);
//thumb
//pattern=??,B5,??,B0,??,91,??,A9,??,72,??,A9,??,20,??,80,??,90,??,22,??,73,??,90,??,90,??,90,??,90,??,90,??,A9,??,62,??,63,??,61,??,21,??,AC,??,1C,??,??,??,??,??,20,??,72,??,??,??,22,??,46,??,??,??,??,??,B0,??,BD

#pragma swi_number=132
__swi __arm int GetFileStats(const char *cFileName, FSTATS * StatBuffer, unsigned int *errornumber);
//arm
//pattern=7C,40,2D,E9,02,60,A0,E1,01,50,A0,E1,00,40,A0,E1,??,??,??,EB,00,30,E0,E3,04,30,8D,E5,00,60,8D,E5,50,C0,90,E5,00,00,A0,E3,05,30,A0,E1,00,20,A0,E3,04,10,A0,E1,3C,FF,2F,E1,7C,80,BD,E8

#pragma swi_number=138
__swi __arm int GetFreeFlexSpace(int DriveNum, unsigned int *ErrorNumber);
//arm
//pattern=38,40,2D,E9,00,08,A0,E1,40,08,A0,E1,00,40,A0,E1,01,50,A0,E1,??,??,??,EB,18,C0,90,E5,04,D0,8D,E2,05,20,A0,E1,04,10,A0,E1,30,40,BD,E8

#pragma swi_number=139
__swi __arm int GetTotalFlexSpace(int DriveNum, unsigned int *ErrorNumber);
//arm
//pattern=10,40,2D,E9,00,40,A0,E1,??,??,??,EB,74,10,90,E5,04,00,A0,E1,10,40,BD,E8,11,FF,2F,E1

#pragma swi_number=140
__swi __arm void RegExplorerExt(REGEXPLEXT const *);
//thumb
//pattern=??,B5,??,68,??,1C,??,68,??,??,??,??,??,28,??,D1,??,??,??,3A,??,68,??,29,??,DA,??,20,??,43,??,1D,??,18,??,31,??,60,??,22,??,1C,??,??,??,??,??,BD

#pragma swi_number=142
__swi __arm int fmove(const char * SourceFileName, const char * DestFileName, unsigned int *ErrorNumber);
//arm
//pattern=7F,40,2D,E9,02,60,A0,E1,01,50,A0,E1,00,40,A0,E1,??,??,??,EB,00,10,A0,E3,42,00,8D,E8,00,30,E0,E3,08,30,8D,E5,38,C0,90,E5,00,00,A0,E3,05,30,A0,E1,04,10,A0,E1,00,20,A0,E3,3C,FF,2F,E1,10,D0,8D,E2,70,80,BD,E8

#pragma swi_number=143
__swi __arm int rmdir(const char * cDirectory, unsigned int *ErrorNumber);
//arm
//pattern=38,40,2D,E9,01,50,A0,E1,00,40,A0,E1,??,??,??,EB,00,30,E0,E3,00,30,8D,E5,3C,C0,90,E5,00,00,A0,E3,05,30,A0,E1,00,20,A0,E3,04,10,A0,E1,3C,FF,2F,E1,38,80,BD,E8

#pragma swi_number=144
__swi __arm int truncate(int FileHandler, int length, int *errornumber);
//arm
//pattern=7C,40,2D,E9,01,60,A0,E1,02,50,A0,E1,00,40,A0,E1,??,??,??,EB,00,30,E0,E3,00,30,8D,E5,54,C0,90,E5,00,00,A0,E3,05,30,A0,E1,06,20,A0,E1,04,10,A0,E1,3C,FF,2F,E1,7C,80,BD,E8

#pragma swi_number=145
__swi __arm int isdir(const char * cDirectory, unsigned int *ErrorNumber);
//arm
//pattern=38,40,2D,E9,01,50,A0,E1,00,40,A0,E1,??,??,??,EB,00,30,E0,E3,00,30,8D,E5,24,C0,90,E5,00,00,A0,E3,05,30,A0,E1,00,20,A0,E3,04,10,A0,E1,3C,FF,2F,E1,38,80,BD,E8

#pragma swi_number=146
__swi __arm void *calloc(size_t nelem, size_t elsize);
//arm
//pattern=91,00,00,E0,F4,FF,FF,EA

#pragma swi_number=148
__swi __arm int ExecuteFile (WSHDR *filepath, WSHDR *mimetype, void *param);
//thumb
//pattern=70,B5,16,1C,0D,1C,04,1C,00,28,18,D0,00,2D,03,D1,20,1C,??,??,??,??,07,E0,28,1C,??,??,??,??,00,28,02,D1,28,1C,??,??,??,??,??,??,??,??,00,28,06,D0,02,68,33,1C,21,1C,00,6A,??,??,??,??,70,BD,00,20,70,BD

#pragma swi_number=149
__swi __arm int UnRegExplorerExt(REGEXPLEXT const *);
//thumb
//pattern = F8,B5,??,4E,05,1C,00,24,37,1F,1D,E0,28,20,60,43,81,19,49,68,6A,68,91,42,15,D1,30,58,29,68,??,??,??,??,00,28,0F,D1,38,68,01,38,38,60,08,E0,28,20,60,43,80,19,01,1C,28,31,28,22,??,??,??,??,01,34,38,68,84,42,F3,DB,01,34,38,68,84,42,DE,DB,F8,BD

#pragma swi_number=154
__swi int ChangeVolume(unsigned char Volume);
//arm
//pattern_SGOLD=??,??,??,E9,??,??,??,E1,??,??,??,E5,??,??,??,E3,??,??,??,E5,??,??,??,EB,??,??,??,E5,??,??,??,E1,??,??,??,EB,??,??,??,E3,??,??,??,EB,??,??,??,??,??,??,??,??,??,??,??,??,??,??,??,EB
//arm
//pattern=

#pragma swi_number=163
__swi __arm void ws_2str(WSHDR *ws, char *str, unsigned int size);
//arm
//pattern=??,??,??,E9,??,??,??,E2,??,??,??,E1,??,??,??,E1,??,??,??,E2,??,??,??,E2,??,??,??,E3,??,??,??,E3,??,??,??,??,??,??,??,E1,??,??,??,E3,??,??,??,E5,??,??,??,E1,??,??,??,E3,??,??,??,??,??,??,??,E1,??,??,??,EA

#pragma swi_number=166
__swi __arm void ResetGPRSTraffic();
//arm
//pattern=08,40,2D,E9,??,??,??,EB,??,??,??,FA,00,00,A0,E3,08,40,BD,E8,??,??,??,EA

#pragma swi_number=170
__swi __arm char *GetCurrentLocale();
//thumb
//pattern=80,B5,??,??,??,??,??,??,2F,28,02,D9,2F,20,00,E0,08,31,0A,78,2F,2A,01,D0,82,42,F9,D1,48,68,80,BD


#pragma swi_number=171
__swi __arm void loopback171();
//arm
//pattern=1E,FF,2F,E1

#pragma swi_number=180
__swi __arm void GetDateTime(TDate *, TTime *);
//thumb
//pattern=??,B5,??,1C,??,1C,??,28,??,D1,??,AC,??,2D,??,D1,??,46,??,1C,??,??,??,??,??,1C,??,??,??,??,??,??,??,??,??,1C,??,1C,??,1C,??,??,??,??,??,22,??,43,??,23,??,1C,??,1C,??,??,??,??,??,BD
//pattern=??,B5,??,1C,??,1C,??,28,??,D1,??,AD,??,2C,??,D1,??,46,??,1C,??,??,??,??,??,1C,??,??,??,??,??,1C,??,1C,??,??,??,??,??,1C,??,??,??,??,??,1C,??,1C,??,1C,??,??,??,??,??,23,??,43,??,1C,??,19,??,1C,??,??,??,??,??,BD

#pragma swi_number=181
__swi __arm char GetWeek(TDate*);
//thumb
//pattern=??,B5,??,??,??,??,??,1D,??,20,??,??,??,??,??,06,??,0E,??,BD

#pragma swi_number=182
__swi __arm char GetProfile();
//thumb
//pattern=??,B5,??,22,??,21,??,46,??,??,??,??,??,??,??,28,??,D0,??,??,??,??,??,99,??,42,??,DD,??,1C,??,BD,??,21,??,??,??,??,??,??,??,??,??,3C,??,1C,??,20,??,??,??,??,??,25,??,28,??,D0,??,DF,??,1C,??,1C,??,22,??,20,??,??,??,??,??,E0,??,DF,??,1C,??,1C,??,22,??,20,??,??,??,??,??,??,??,38,??,68,??,E7

#pragma swi_number=183
__swi __arm char SetProfile(char);
//thumb
//pattern=??,B5,??,1C,??,??,??,??,??,??,??,??,??,??,??,1C,??,20,??,??,??,??,??,42,??,D0,??,20,??,??,??,??,??,42,??,D0,??,22,??,21,??,1C,??,??,??,??,??,??,??,1C,??,??,??,??,??,1C,??,1C,??,??,??,??,??,22,??,21,??,1C,??,??,??,??,??,??,??,BD

#pragma swi_number=184
__swi __arm int sdiv(int denom,int number);
//arm
//pattern=80,24,10,E2,00,00,60,42,41,30,32,E0,00,10,61,22,A1,C1,70,E0

#pragma swi_number=167
__swi __arm char IsGPRSEnabled();
//thumb
//pattern=??,48,??,68,70,47,F7,B5,??,49,06,1C,40,01,00,24,??,31

#pragma swi_number=168
__swi __arm char IsGPRSConnected();
//thumb
//pattern=80,B5,??,??,??,??,00,28,01,D0,01,20,80,BD,00,20,80,BD,80,B5,06,28,06,D2

#pragma swi_number=169
__swi __arm void KbdLock();
//thumb
//pattern=??,49,80,B5,01,20,??,39,??,60,01,21,03,20,??,??,??,??,80,BD

#pragma swi_number=185
__swi __arm void KbdUnlock();
//thumb
//pattern=??,49,80,B5,00,20,??,60,01,21,03,20,??,??,??,??,80,BD

#pragma swi_number=186
__swi __arm void *realloc(void *ptr, int size);
//arm
//pattern=70,40,2D,E9,00,40,A0,E1,02,00,A0,E3,01,60,A0,E1,??,??,??,EB,00,50,A0,E1,00,00,54,E3,00,00,55,13,08,00,00,0A,08,00,14,E5,04,10,A0,E1,00,00,56,E1,06,00,A0,31,00,20,A0,E1,05,00,A0,E1,??,??,??,EB,04,00,A0,E1,??,??,??,EB,05,00,A0,E1,70,80,BD,E8

#pragma swi_number=187
__swi __arm void *memset(void *s, int c, int n);
//arm
//pattern=FF,30,01,E2,02,10,A0,E1,03,24,83,E1,02,28,82,E1,??,??,??,EA,78,47

#pragma swi_number=188
__swi __arm int udiv(unsigned int denom,unsigned int number);
//arm
//pattern=00,20,A0,E3,A1,C1,70,E0,20,00,00,3A,21,C4,70,E0,0F,00,00,3A,00,04,A0,E1,FF,24,82,E3,21,C2,70,E0,17,00,00,3A,21,C4,70,E0,09,00,00,3A,00,04,A0,E1,FF,28,82,E3,21,C4,70,E0,00,04,A0,21,FF,2C,82,23,21,C2,70,E0,0E,00,00,3A,00,C0,70,E2,??,??,??,2A,20,04,A0,21,A1,C3,70,E0,80,13,41,20,02,20,A2,E0,21,C3,70,E0,00,13,41,20,02,20,A2,E0,A1,C2,70,E0,80,12,41,20,02,20,A2,E0,21,C2,70,E0,00,12,41,20,02,20,A2,E0,A1,C1,70,E0,80,11,41,20,02,20,A2,E0,21,C1,70,E0,00,11,41,20,02,20,A2,E0,A1,C0,70,E0,80,10,41,20,02,20,A2,E0,01,C0,70,E0,00,10,41,20,02,20,B2,E0,E5,FF,FF,2A,02,00,A0,E1,1E,FF,2F,E1

#pragma swi_number=189
__swi __arm  int DivBy10(int divident);
//arm
//pattern=00,30,B0,E1,00,00,60,42,0A,10,40,E2,20,01,40,E0,20,02,80,E0,20,04,80,E0,20,08,80,E0,A0,01,A0,E1,00,21,80,E0,82,10,51,E0,01,00,80,52,0A,10,81,42,03,30,B0,E1,00,00,60,42,00,10,61,42,1E,FF,2F,E1

/// RAMCAP,     
#pragma swi_number=198
__swi __arm  char GetAkkuCapacity();
//arm
//pattern=??,??,??,E5,??,??,??,E1,1E,FF,2F,E1,08,40,2D,E9,03,10,A0,E3,00,00,A0,E3,??,??,??,EB,C8,0E,50,E3,00,00,A0,93,01,00,A0,83,08,80,BD,E8


#pragma swi_number=0x088
__swi	__arm char GetAccessoryType(void);
//arm
//pattern=??,??,??,E5,??,??,??,E5,??,??,??,E3,??,??,??,01,??,??,??,E5,2E,??,??,E3,2D,??,??,13,??,??,??,0A,??,??,??,E1

#pragma swi_number=0x93
__swi __arm void RebootPhone();
//arm
//pattern=

#pragma swi_number=0x80C8
__swi __arm unsigned short *RamCap();
//thumb

#pragma swi_number=0x80C9
__swi __arm unsigned short *RamLS();

#pragma swi_number=0x80CA
__swi __arm  RAMNET * RamNet();
//thumb

#pragma swi_number=0x80CC 
__swi __arm char * RamMissedCalls(); 

#pragma swi_number=0x80CD 
__swi __arm char * RamMissedSMS();

#pragma swi_number=0x80D4 
__swi __arm char * RamMissedMessage();

#pragma swi_number=0x80DF
__swi __arm char *RamPressedKey();

#pragma swi_number=0x80E0
__swi __arm void * RamScreenBuffer();

#pragma swi_number=0x80E1
__swi	__arm	 unsigned int *RamMPlayer_CtrlCode();
//thumb
//pattern= &(F8,B5,01,27,0D,1C,04,1C,08,1C,??,??,??,??,??,??,80,88,31,88,88,42+0E) + 4

#pragma swi_number=0x80F1
__swi __arm void *BuildCanvas(void);

#pragma swi_number=0x80FF
__swi __arm unsigned int AddrLibrary();

#pragma swi_number=0x0100
__swi __arm void GBS_SendMessage(int cepid_to, int msg, ...); //int submess, void *data1, void *data2
//arm
//pattern=??,??,??,E9,??,??,??,E5,??,??,??,E1,??,??,??,E1,??,??,??,E1,??,??,??,E1,??,??,??,??,??,??,??,E1,??,??,??,E5,??,??,??,E1,??,??,??,E1,??,??,??,E2,??,??,??,E1,??,??,??,E1,??,??,??,??,??,??,??,E8,??,??,??,E5,??,??,??,E2,??,??,??,??,??,??,??,E8

#pragma swi_number=0x0101
__swi __arm int GBS_ReciveMessage(GBS_MSG *);
//arm
//pattern=??,??,??,E9,??,??,??,E1,??,??,??,??,??,??,??,E1,??,??,??,??,??,??,??,??,??,??,??,E3,??,??,??,1A,??,??,??,E3,??,??,??,??,??,??,??,??,??,??,??,EF,??,??,??,E1,??,??,??,E3,??,??,??,E1,??,??,??,E3,??,??,??,??,??,??,??,E3,??,??,??,1A,??,??,??,E3,??,??,??,??,??,??,??,??,??,??,??,EF,??,??,??,E1,??,??,??,E3,??,??,??,E1,??,??,??,E3,??,??,??,??,??,??,??,E5,??,??,??,E3,??,??,??,0A,??,??,??,E3,??,??,??,??,??,??,??,??,??,??,??,EF,??,??,??,E1,??,??,??,E3,??,??,??,E1,??,??,??,E3,??,??,??,??,??,??,??,E1,??,??,??,??,??,??,??,E2,??,??,??,??,??,??,??,E2,??,??,??,E1,??,??,??,??,??,??,??,E1,??,??,??,E1,??,??,??,E3,??,??,??,??,??,??,??,E1,??,??,??,??,??,??,??,E3,??,??,??,0A,??,??,??,E1,??,??,??,E1,??,??,??,??,??,??,??,E1,??,??,??,??,??,??,??,E3,??,??,??,E5,??,??,??,E5,??,??,??,E1,??,??,??,E8

#pragma swi_number=0x0102
__swi __arm void GBS_AcceptMessage(void);
//arm
//pattern=??,??,??,E9,??,??,??,??,??,??,??,E1,??,??,??,??,??,??,??,??,??,??,??,1A,??,??,??,E3,??,??,??,??,??,??,??,??,??,??,??,EF,??,??,??,E1,??,??,??,E3,??,??,??,E1,??,??,??,E3,??,??,??,??,??,??,??,E5,??,??,??,E3,??,??,??,0A,??,??,??,E3,??,??,??,??,??,??,??,??,??,??,??,EF,??,??,??,E1,??,??,??,E3,??,??,??,E1,??,??,??,E3,??,??,??,??,??,??,??,E5,??,??,??,E3,??,??,??,1A,??,??,??,E5,??,??,??,E3,??,??,??,1A,??,??,??,E3,??,??,??,??,??,??,??,??,??,??,??,EF,??,??,??,E1,??,??,??,E3,??,??,??,E1,??,??,??,E3,??,??,??,??,??,??,??,E5,??,??,??,E3,??,??,??,E5,??,??,??,E5,??,??,??,E1,??,??,??,??,??,??,??,E2,??,??,??,??,??,??,??,E2,??,??,??,E5,??,??,??,??,??,??,??,??,??,??,??,E5,??,??,??,E1,??,??,??,E3,??,??,??,92,??,??,??,??,??,??,??,E5,??,??,??,E8

#pragma swi_number=0x0103
__swi __arm void GBS_ClearMessage(void);
//arm
//pattern=??,??,??,E9,??,??,??,??,??,??,??,E1,??,??,??,??,??,??,??,??,??,??,??,1A,??,??,??,E3,??,??,??,??,??,??,??,??,??,??,??,EF,??,??,??,E1,??,??,??,E3,??,??,??,E1,??,??,??,E3,??,??,??,??,??,??,??,E5,??,??,??,E3,??,??,??,0A,??,??,??,E3,??,??,??,??,??,??,??,??,??,??,??,EF,??,??,??,E1,??,??,??,E3,??,??,??,E1,??,??,??,E3,??,??,??,??,??,??,??,E1,??,??,??,??,??,??,??,E2,??,??,??,??,??,??,??,E2,??,??,??,??,??,??,??,E8,??,??,??,??

#pragma swi_number=0x0104
__swi __arm void GBS_PendMessage(GBS_MSG *);
//arm
//pattern=??,??,??,E9,??,??,??,E1,??,??,??,??,??,??,??,E1,??,??,??,??,??,??,??,??,??,??,??,E3,??,??,??,1A,??,??,??,E3,??,??,??,??,??,??,??,??,??,??,??,EF,??,??,??,E1,??,??,??,E3,??,??,??,E1,??,??,??,E3,??,??,??,??,??,??,??,E3,??,??,??,1A,??,??,??,E3,??,??,??,??,??,??,??,??,??,??,??,EF,??,??,??,E1,??,??,??,E3,??,??,??,E1,??,??,??,E3,??,??,??,??,??,??,??,E5,??,??,??,E3,??,??,??,0A,??,??,??,E3,??,??,??,??,??,??,??,??,??,??,??,EF,??,??,??,E1,??,??,??,E3,??,??,??,E1,??,??,??,E3,??,??,??,??,??,??,??,E5,??,??,??,E1,??,??,??,E5,??,??,??,E1,??,??,??,E1,??,??,??,E1,??,??,??,E1,??,??,??,E2,??,??,??,??,??,??,??,E1,??,??,??,E5,??,??,??,E1,??,??,??,E5,??,??,??,E5,??,??,??,E5,??,??,??,E5,??,??,??,E9,??,??,??,E2,??,??,??,E2,??,??,??,??,??,??,??,E2,??,??,??,E5,??,??,??,??,??,??,??,E8

#pragma swi_number=0x0105
__swi __arm void CreateGBSproc(int cepid, const char *name, void (*onMsg)(void), int prio, int unk_zero);
//arm
//pattern=??,??,??,E9,??,??,??,E2,??,??,??,E5,??,??,??,E1,??,??,??,E1,??,??,??,E1,??,??,??,E3,??,??,??,??,??,??,??,E8

#pragma swi_number=0x8106
__swi __arm CSMROOT *CSM_root();
//
#pragma swi_number=0x0107
__swi __arm int CreateCSM(const CSM_DESC*,void *,int);
//thumb
//pattern=??,1C,??,1C,??,1C,??,??,??,B5,??,68,??,??,??,??,??,BD

#pragma swi_number=0x0108
__swi	__arm	CSM_RAM * FindCSMbyID (int id);
//thumb
//pattern=??,1C,??,??,??,B5,??,68,_blf(??,28,??,D1,??,47,??,68,??,E0,??,68,??,2A,??,D0,??,68,??,42,??,D1,??,E0,??,6A,??,E0,??,68,??,2A,??,D0,??,68,??,42,??,D1,??,1C,??,47),??,BD

#pragma swi_number=0x0109
__swi __arm void DoIDLE(void);
//thumb
//pattern=??,1C,??,??,??,B5,??,68,??,68,??,??,??,??,??,??,??,BD

#pragma swi_number=0x010A
__swi __arm void *GetConfig(unsigned int id); //BoBaPack

#pragma swi_number=0x810B
__swi __arm void *GetMinAdrScan(); //BoBaPack
//adr=0xA0030000

#pragma swi_number=0x810C
__swi __arm void *GetMaxAdrScan(); //BoBaPack
//adr=0xA0040000

#pragma swi_number=0x810D
__swi __arm unsigned short *GetCI();

#pragma swi_number=0x010E
__swi __arm void Vibration(unsigned int power, unsigned int duration); //BoBaPack

#pragma swi_number=0x010F
__swi __arm void freeUSSD();
//thumb
//pattern=??,B5,??,??,??,68,??,28,??,D0,??,78,??,28,??,D1,??,20,??,??,??,??,??,68,??,??,??,??,??,20,??,60,??,61,??,BD

#pragma swi_number=0x0110
__swi __arm char *wstrcopy(unsigned short *dst, const unsigned short *src);
//thumb
//pattern=??,B5,??,1C,??,88,??,00,??,19,??,32,??,1C,??,??,??,??,??,1C,??,BD

#pragma swi_number=0x0111
__swi __arm char GetTypeUSSD();
//thumb
//pattern=??,??,??,68,??,28,??,D1,??,20,??,47,??,78,??,47

#pragma swi_number=0x0112
__swi __arm unsigned int SetUSSD(StructUSSDStr *);
//thumb
//pattern=??,B5,??,1C,??,78,??,??,??,??,??,28,??,D1,??,BD,??,??,??,??,??,??,??,60,??,??,??,??,??,26,??,28,??,??,??,??,??,D1,??,1C,??,22,??,E0,??,??,??,??,??,28,??,D8,??,??,??,??,??,28,??,D1,??,1C,??,22,??,1C,??,1C,??,96,??,??,??,??,??,??,??,??,??,28,??,D8,??,??,??,??,??,28,??,D0,??,1C,??,22,??,93,??,E0,??,1C,??,1C,??,96,??,1C,??,1C,??,??,??,??,??,20,??,E7

#pragma swi_number=0x0113
__swi	__arm	char * strpbrk (const char *s1,const char *s2);
//thumb
//pattern=??,B4,??,1C,??,1C,??,78,??,2D,??,D1,??,1A,??,BC,??,47,??,78,??,1C,??,2A,??,D0,??,42,??,D1,??,1A,??,E7,??,78,??,33,??,2A,??,D1,??,34,??,E7

#pragma swi_number=0x0114
__swi	__arm	char * strncat (char *dest,const char *substr,int maxSubLen);
//thumb
//pattern=??,B4,??,78,??,1C,??,2C,??,D0,??,33,??,78,??,2C,??,D1,??,2A,??,D0,??,78,??,31,??,70,??,33,??,2C,??,D0,??,3A,??,D1,??,21,??,70,??,BC,??,47

#pragma swi_number=0x0115
__swi	__arm	int  strncmp (const char *s1,const char *s2,int n);
//thumb
//pattern=??,1C,??,43,??,07,??,B4,??,D1,??,??,??,01,??,E0,??,30,??,31,??,3A,??,2A,??,D3,??,68,??,68,??,42,??,D1,??,1B,??,43,??,40,??,D0,??,2A,??,D1,??,20,??,BC,??,47,??,78,??,78,??,31,??,30,??,2B,??,D3,??,42,??,D1,??,3A,??,D1,??,1B,??,E7

#pragma swi_number=0x0116
__swi	__arm	int  strncpy (char *dest,const char *source,int maxlen);
//thumb
//pattern=??,B4,??,1C,??,1C,??,43,??,07,??,D1,??,??,??,01,??,E0,??,31,??,3A,??,C3,??,2A,??,D3,??,68,??,1B,??,43,??,40,??,D0,??,2A,??,D0,??,78,??,31,??,70,??,33,??,2C,??,D0,??,3A,??,D1,??,BC,??,47,??,2A,??,D9,??,1E,??,22,??,70,??,33,??,39,??,D1,??,E7

#pragma swi_number=0x0117
__swi	__arm	char * strrchr (const char *s,int c);
//thumb
//pattern=??,22,??,06,??,0E,??,78,??,30,??,42,??,D1,??,1E,??,29,??,D1,??,1C,??,47

#pragma swi_number=0x0118
__swi	__arm	char * strstr (const char *s1,const char *s2);
//thumb
//pattern=??,B4,??,1C,??,1C,??,78,??,78,??,34,??,33,??,2A,??,D3,??,42,??,D0,??,2D,??,D0,??,2A,??,D1,??,1C,??,BC,??,47,??,30,??,E7

//DELETED!!! NOT REENTABLE!!!
//#pragma swi_number=0x0119
//__swi	__arm	int  strtol (const char *nptr,char **endptr,int base);
//thumb
//pattern=??,B5,??,B4,??,1C,??,1C,??,27,??,9C,??,??,??,??,??,78,??,34,??,29,??,D0,??,68,??,5C,??,07,??,D4,??,29,??,D0,??,29,??,D1,??,??,??,02,??,43,??,E0,??,3C,??,1C,??,1C,??,1C,??,??,??,??,??,1C,??,2D,??,D0,??,68,??,42,??,D1,??,98,??,60,??,05,??,25,??,??,??,??,??,1C,??,2C,??,DA,??,42,??,28,??,DD,??,60,??,07,??,B0,??,BC,??,BC,??,47,??,1C,??,2E,??,DA,??,60,??,??,??,E7

//DELETED!!! NOT REENTABLE!!!
#pragma swi_number=0x011A
__swi	__arm	int  strtoul (const char *nptr,char **endptr,int base);
//thumb
//pattern=??,B5,??,B4,??,B0,??,1C,??,27,??,9C,??,??,??,??,??,1C,??,68,??,90,??,??,??,??,??,78,??,34,??,29,??,D0,??,68,??,5C,??,07,??,D4,??,29,??,D0,??,29,??,D1,??,??,??,02,??,43,??,E0,??,3C,??,21,??,60,??,1C,??,1C,??,9A,??,??,??,??,??,1C,??,2D,??,D0,??,68,??,42,??,D1,??,98,??,60,??,68,??,28,??,D1,??,1C,??,B0,??,BC,??,BC,??,47,??,9A,??,60,??,42,??,05,??,D4,??,1C,??,E7

#pragma swi_number=0x011B
__swi	__arm	int snprintf (char *,int n,const char *format,...);
//thumb
//pattern=??,B4,??,B5,??,B0,??,1C,??,A9,??,91,??,90,??,D0,??,19,??,38,??,90,??,??,??,44,??,90,??,??,??,44,??,90,??,AE,??,1C,??,46,??,AA,??,99,??,??,??,??,??,1C,??,2C,??,D0,??,1C,??,20,??,??,??,??,??,1C,??,B0,??,BC,??,BC,??,B0,??,47

#pragma swi_number=0x011C
__swi	__arm	int  memcmp (void *m1,void *m2,int n);
//thumb
//pattern=??,B4,??,2A,??,D3,??,1C,??,43,??,07,??,D1,??,C8,??,C9,??,42,??,D1,??,3A,??,2A,??,D2,??,42,??,D0,??,38,??,39,??,2A,??,D1,??,20,??,BC,??,47,??,07,??,D5,??,32,??,E0,??,78,??,78,??,31,??,30,??,42,??,D1,??,78,??,78,??,31,??,30,??,42,??,D1,??,3A,??,D1,??,1B,??,E7

#pragma swi_number=0x011D
__swi	__arm	void  zeromem (void *dest,int n);
//arm
//pattern=??,??,??,E3,??,??,??,E3,??,??,??,3A,??,??,??,E2,??,??,??,0A,??,??,??,E2,??,??,??,E3,??,??,??,E4,??,??,??,A4,??,??,??,C4,??,??,??,E0,??,??,??,EA,??,??,??,E1,??,??,??,24,??,??,??,24,??,??,??,44,??,??,??,E1,??,??,??,??,??,??,??,E3,??,??,??,E9,??,??,??,E1,??,??,??,E1,??,??,??,E1,??,??,??,E2,??,??,??,28,??,??,??,28,??,??,??,22,??,??,??,2A,??,??,??,E1,??,??,??,28,??,??,??,48,??,??,??,E8,??,??,??,E1,??,??,??,24,??,??,??,01,??,??,??,44,??,??,??,44,??,??,??,E3,??,??,??,14,??,??,??,E1
//   ...

#pragma swi_number=0x011E
__swi	__arm	void * memcpy (void *dest,const void *source,int cnt);
//arm
//pattern=??,??,??,E3,??,??,??,9A,??,??,??,E2,??,??,??,0A,??,??,??,E4,??,??,??,E3,??,??,??,E0,??,??,??,94,??,??,??,E4,??,??,??,34,??,??,??,E2,??,??,??,94,??,??,??,34,??,??,??,E2,??,??,??,0A,??,??,??,E2,??,??,??,3A,??,??,??,E7,??,??,??,E3,??,??,??,0A,??,??,??,8A,??,??,??,E1,??,??,??,E5,??,??,??,E2,??,??,??,E1,??,??,??,E4,??,??,??,2A,??,??,??,E2,??,??,??,EA,??,??,??,E1,??,??,??,E5,??,??,??,E2,??,??,??,E1,??,??,??,E4,??,??,??,2A,??,??,??,E2,??,??,??,EA,??,??,??,E1,??,??,??,E5,??,??,??,E2,??,??,??,E1,??,??,??,E4,??,??,??,2A,??,??,??,E2,??,??,??,EA

#pragma swi_number=0x011F
__swi	__arm	WSHDR * wstrcpy (WSHDR *wshdr_d,WSHDR *wshdr_s);
//thumb
//pattern=??,B5,??,29,??,D0,??,28,??,D0,??,68,??,88,??,8A,??,42,??,D3,??,3A,??,??,??,??,??,BD,??,??,??,??,??,BD

#pragma swi_number=0x0120
__swi	__arm	WSHDR * wstrncpy (WSHDR *,WSHDR *,int);
//thumb
//pattern=??,B5,??,1C,??,D0,??,29,??,D0,??,1C,??,??,??,??,??,42,??,D2,??,1C,??,??,??,??,??,1C,??,1C,??,??,??,??,??,BD

#pragma swi_number=0x0121
__swi	__arm	WSHDR * wstrcat (WSHDR *wshdr_d,WSHDR *wshdr_s);
//thumb
//pattern=??,B5,??,1C,??,D0,??,29,??,D0,??,68,??,88,??,68,??,88,??,1C,??,??,??,??,??,18,??,42,??,D2,??,8A,??,38,??,1A,??,1C,??,??,??,??,??,BD,??,1C,??,??,??,??,??,BD

#pragma swi_number=0x0122
__swi	__arm	WSHDR * wstrncat (WSHDR *wshdr_d,WSHDR *wshdr_s,int n);
//thumb
//pattern=??,B5,??,1C,??,D0,??,29,??,D0,??,68,??,88,??,1C,??,??,??,??,??,19,??,42,??,D2,??,8A,??,38,??,1B,??,1C,??,??,??,??,??,BD

#pragma swi_number=0x0123
__swi	__arm	int  wstrlen (WSHDR *wshdr);
//thumb
//pattern=??,28,??,D1,??,47,??,68,??,88,??,47

#pragma swi_number=0x0124
__swi	__arm	int wsprintf (WSHDR *,const char *format,...);
//thumb
//pattern=??,B4,??,B5,??,B0,??,B0,??,1C,??,22,??,32,??,46,??,A9,??,??,??,??,??,1C,??,98,??,??,??,??,??,1C,??,1C,??,99,??,??,??,??,??,A8,??,90,??,1C,??,21,??,1C,??,AB,??,??,??,??,??,B0,??,B0,??,BC,??,BC,??,B0,??,47

#pragma swi_number=0x0125
__swi	__arm	WSHDR * AllocWS (int len);
//thumb
//pattern=02,04,80,B5,12,0C,??,48,??,49,??,??,??,ED,80,BD

#pragma swi_number=0x0126
__swi	__arm	void  CutWSTR (void *WSHDR,int len);
//thumb
//pattern=??,B5,??,28,??,D0,??,68,??,88,??,42,??,D2,??,??,??,??,??,BD

#pragma swi_number=0x0127
__swi	__arm	WSHDR * CreateLocalWS (WSHDR *wshdr,unsigned __int16 *wsbody,int len);
//thumb
//pattern=??,B5,??,1C,??,1C,??,1C,??,29,??,D0,??,00,??,1C,??,??,??,??,??,1C,??,1C,??,1C,??,??,??,??,??,BD

#pragma swi_number=0x0128
__swi	__arm	int  CreateWS (void *malloc,void *mfree,int len);
//thumb
//pattern=??,B5,??,1C,??,20,??,1C,??,1C,??,2D,??,D0,??,2E,??,D0,??,20,??,47,??,1C,??,D1,??,20,??,BD,??,00,??,30,??,47,??,60,??,28,??,D1,??,1C,??,47,??,E7,??,21,??,80,??,1C,??,1C,??,68,??,??,??,??,??,21,??,60,??,60,??,60,??,E7

#pragma swi_number=0x0129
__swi	__arm	void  FreeWS (WSHDR *wshdr);
//thumb
//pattern=??,B5,??,1C,??,D0,??,68,??,29,??,D0,??,68,??,28,??,D1,??,68,??,47,??,68,??,1C,??,47,??,20,??,BD,??,20,??,BD
// ...

#pragma swi_number=0x012A
__swi	__arm	void  DrawObject (DRWOBJ *);
//thumb
//pattern=??,B5,??,1C,_blf(??,B5,??,46,??,??,??,??,??,??,??,28,??,D0,??,AB,??,78,??,01,??,58,??,BD,??,??,??,??,??,6B,??,42,??,D1,??,??,??,??,??,E7,??,20,??,E7),??,28,??,D0,??,1C,??,??,??,??,??,BD

#pragma swi_number=0x012B
__swi	__arm	void  AddKeybMsgHook (void *proc);
//thumb
//pattern=??,B5,_blf(??,B5,??,??,??,1C,??,68,??,25,??,28,??,D1,??,??,??,60,??,60,??,60,??,20,??,??,??,??,??,28,??,D0,??,60,??,73,??,1C,??,1C,??,??,??,??,??,BD),??,BD

#pragma swi_number=0x012C
__swi	__arm	int  AddKeybMsgHook_end (void *proc);
//thumb
//pattern=??,B5,_blf(??,B5,??,??,??,1C,??,68,??,28,??,D1,??,60,??,60,??,48,??,60,??,20,??,??,??,??,??,68,??,29,??,D0,??,7B,??,29,??,D0,??,28,??,D1,??,20,??,BD,??,21,??,60,??,73,??,1C,??,1C,??,??,??,??,??,20,??,BD),??,BD

#pragma swi_number=0x012D
__swi	__arm	void  RemoveKeybMsgHook (void *proc);
//thumb
//pattern=??,B5,_blf(??,??,??,B5,??,68,??,E0,??,68,??,42,??,D1,??,1C,??,??,??,??,??,BD,??,68,??,29,??,D1,??,BD),??,BD

#pragma swi_number=0x012E
__swi	__arm	char *GetPaletteAdrByColorIndex (int ColorIndex);
//thumb
//pattern=??,??,??,28,??,D2,??,00,??,E0,??,??,??,31,??,28,??,D0,??,38,??,28,??,D2,??,??,??,00,??,18,??,47,??,1C,??,47

#pragma swi_number=0x012F
__swi	__arm	void  getRGBcolor (int ColorIndex,void *dest);
//thumb
//pattern=??,B5,??,1C,_blf(??,49,??,28,??,D2,??,00,??,E0,??,??,??,31,??,28,??,D0,??,38,??,28,??,D2,??,??,??,00,??,18,??,47,??,1C,??,47),??,1C,??,??,??,??,??,BD

#pragma swi_number=0x0130
__swi	__arm	void  getRGBbyPaletteAdr (int *paletteAdr,void *dest);
//thumb
//pattern=??,29,??,D0,??,28,??,D1,??,20,??,??,??,78,??,70,??,78,??,70,??,78,??,70,??,78,??,70,??,47

#pragma swi_number=0x0131
__swi	__arm	void  setColor (int a,int r,int g,int b,void *dest);
//thumb
//pattern=??,B5,??,9C,??,2C,??,D0,??,70,??,70,??,70,??,70,??,BD

#pragma swi_number=0x0132
__swi __arm void *memmove(void *dest,const void *source,int cnt);
//arm
//pattern=01,30,40,E0,02,00,53,E1,??,??,??,2A,03,00,10,E3,03,00,11,03,??,??,??,0A


#pragma swi_number=0x0133
__swi	__arm	void  StoreXYWHtoRECT (void *RECT,int x,int y,int w,int h);
//thumb
//pattern=??,B5,??,9C,??,80,??,18,??,39,??,80,??,80,??,19,??,39,??,80,??,BD

#pragma swi_number=0x0134
__swi	__arm	void  StoreXYXYtoRECT (void *RECT,int x,int y,int x2,int y2);
//thumb
//pattern=??,B5,??,9C,??,80,??,80,??,80,??,80,??,BD

#pragma swi_number=0x0135
__swi	__arm	int  IsGuiOnTop (int id);
//thumb
//pattern=??,1C,??,??,??,B5,??,68,_blf(??,68,??,1C,??,D0,??,68,??,20,??,42,??,D0,??,20,??,47),??,BD

#pragma swi_number=0x0136
__swi	__arm	int  CreateGUI_ID (void *gui,int id);
//thumb
//pattern=0A,1C,01,1C,??,??,80,B5,00,68,_blf(13,1C,00,22),80,BD

#pragma swi_number=0x0137
__swi	__arm	int  CreateGUI (void *gui);
//thumb
//pattern=01,1C,??,??,80,B5,00,68,_blf(00,23,00,22),80,BD

#pragma swi_number=0x0138
__swi	__arm	int  CreateGUI_30or2 (void *gui);
//thumb
//pattern=??,1C,??,??,??,B5,??,68,_blf(??,6B,??,23,??,43,??,63,??,23,??,22,??,11100???),??,BD

#pragma swi_number=0x0139
__swi	__arm	int  CreateGUIWithDummyCSM (void *gui,int flag);
//thumb
//pattern=??,1C,??,1C,??,??,??,B5,??,68,_blf(??,B5,??,B0,??,1C,??,1C,??,91,??,??,??,??,??,90,??,95,??,94,??,6F,??,23,??,46,??,??,??,??,??,??,??,98,??,B0,??,BD),??,BD

#pragma swi_number=0x013A
__swi	__arm	int  CreateGUIWithDummyCSM_30or2 (void *gui,int flag);
//thumb
//pattern=??,1C,??,1C,??,??,??,B5,??,68,_blf(??,B5,??,6B,??,24,??,43,??,63,??,??,??,??,??,BD),??,BD

#pragma swi_number=0x013B
__swi	__arm	void  GeneralFuncF1 (int cmd);
//thumb
//pattern=01,1C,??,??,80,B5,00,68,_blf(0A,1C,01,68,8B,68,00,2B,??,??,C9,68),80,BD

#pragma swi_number=0x013C
__swi	__arm	void  GeneralFuncF0 (int cmd);

#pragma swi_number=0x013D
__swi	__arm	void  GeneralFunc_flag1 (int id,int cmd);

#pragma swi_number=0x013E
__swi	__arm	void  GeneralFunc_flag0 (int id,int cmd);
//thumb
//pattern=??,1C,??,1C,??,??,??,B5,??,68,_blf(??,29,??,D0,??,23,??,11100???,??,47),??,BD

#pragma swi_number=0x013F
__swi	__arm	void DirectRedrawGUI (void);
//thumb
//pattern=??,??,??,B5,??,68,_blf(??,B5,??,1C,??,68,??,26,??,68,??,B0,??,28,??,D0,??,1C,??,69,??,35,??,28,??,D0,??,1C,??,??,??,??,??,20,??,61,??,61,??,20,??,C5,??,C5,??,3D,??,69,??,28,??,D0,??,68,??,68,??,6B,??,07,??,D5,??,21,??,??,??,??,??,28,??,D1,??,1C,??,??,??,??,??,61,??,6A,??,28,??,D0,??,??,??,??,??,A9,??,??,??,??,??,20,??,AB,??,74,??,20,??,??,??,??,??,1C,??,20,??,AA,??,92,??,90,??,91,??,23,??,5E,??,23,??,5E,??,23,??,5E,??,23,??,5E,??,1C,??,??,??,??,??,62,??,68,??,1C,??,68,??,??,??,??,??,68,??,21,??,68,??,??,??,??,??,28,??,D0,??,1C,??,31,??,??,??,??,??,68,??,21,??,68,??,??,??,??,??,28,??,D0,??,20,??,E0,??,20,??,61,??,68,??,68,??,68,??,68,??,47,??,61,??,B0,??,BD),??,BD

#pragma swi_number=0x0140
__swi	__arm	void  DirectRedrawGUI_ID (int id);
//thumb
//pattern=??,1C,??,??,??,B5,??,68,_blf(??,68,??,68,??,2B,??,D0,??,68,??,42,??,D1,??,??,??,47),??,BD

#pragma swi_number=0x0141
__swi	__arm	void PendedRedrawGUI (void);
//thumb
//pattern=??,??,80,B5,00,68,_blf(98,B5,04,1C,80,6E,01,68,24,20,88,47),80,BD


#pragma swi_number=0x0142
__swi	__arm	CSM_RAM * FindCSM (void *csm_q,int id);
//thumb
//pattern=??,28,??,D1,??,47,??,68,??,E0,??,68,??,2A,??,D0,??,68,??,42,??,D1,??,E0,??,6A,??,E0,??,68,??,2A,??,D0,??,68,??,42,??,D1,??,1C,??,47

#pragma swi_number=0x0143
__swi	__arm	void  GBS_StartTimer (GBSTMR *tmr,int time,int msg,int unk,int cepid);
//arm
//pattern=??,??,??,E9,??,??,??,E5,??,??,??,E1,??,??,??,E1,??,??,??,E1,??,??,??,E1,??,??,??,??,??,??,??,E3,??,??,??,E1,??,??,??,??,??,??,??,E5,??,??,??,E3,??,??,??,E5,??,??,??,E5,??,??,??,E1,??,??,??,E1,??,??,??,E5,??,??,??,E5,??,??,??,E5,??,??,??,E1,??,??,??,E1,??,??,??,??,??,??,??,E5,??,??,??,E1,??,??,??,E2,??,??,??,E1,??,??,??,E8

#pragma swi_number=0x0144
__swi	__arm	void  GBS_StopTimer (GBSTMR *tmr);
//arm
//pattern=??,??,??,E9,??,??,??,E1,??,??,??,E5,??,??,??,E3,??,??,??,E2,??,??,??,??,??,??,??,E3,??,??,??,0A,??,??,??,E5,??,??,??,E1,??,??,??,E1,??,??,??,E2,??,??,??,E2,??,??,??,??,??,??,??,E3,??,??,??,E1,??,??,??,??,??,??,??,EF,??,??,??,E3,??,??,??,E3,??,??,??,??,??,??,??,??,??,??,??,??,??,??,??,E5,??,??,??,E1,??,??,??,E2,??,??,??,E1,??,??,??,E5,??,??,??,E3,??,??,??,E1,??,??,??,E8

#pragma swi_number=0x0145
__swi	__arm	int GBS_GetCurCepid (void);
//arm
//pattern=??,??,??,E5,??,??,??,??,??,??,??,E3,??,??,??,0A,??,??,??,E5,??,??,??,E3,??,??,??,E2,??,??,??,E2,??,??,??,E2,??,??,??,E2,??,??,??,0A,??,??,??,E2,??,??,??,E2,??,??,??,E2,??,??,??,E2,??,??,??,0A,??,??,??,E2,??,??,??,E2,??,??,??,E2,??,??,??,E2,??,??,??,05,??,??,??,01,??,??,??,04,??,??,??,E2,??,??,??,E2,??,??,??,E2,??,??,??,E2,??,??,??,1A,??,??,??,E5,??,??,??,E1,??,??,??,E4,??,??,??,E5,??,??,??,E3,??,??,??,11,??,??,??,14,??,??,??,??,??,??,??,E4

#pragma swi_number=0x0146
__swi	__arm	void LockSched(void);
//arm
//pattern=??,??,??,E9,??,??,??,??,??,??,??,E3,??,??,??,1A,??,??,??,E3,??,??,??,??,??,??,??,??,??,??,??,??,??,??,??,E3,??,??,??,E1,??,??,??,??,??,??,??,??,??,??,??,E3,??,??,??,0A,??,??,??,EF,??,??,??,E1,??,??,??,E3,??,??,??,E1,??,??,??,E3,??,??,??,??,??,??,??,E8,??,??,??,EF,??,??,??,E1,??,??,??,E3,??,??,??,E1,??,??,??,E3,??,??,??,??,??,??,??,EA,??,??,??,E5,??,??,??,??,??,??,??,E1,??,??,??,1A,??,??,??,E2,??,??,??,E5,??,??,??,E2,??,??,??,E5,??,??,??,E1,??,??,??,E2,??,??,??,E1,??,??,??,E3,??,??,??,1A,??,??,??,E3,??,??,??,??,??,??,??,E5,??,??,??,E5,??,??,??,E2,??,??,??,E5,??,??,??,??,??,??,??,E5,??,??,??,E5,??,??,??,EA

#pragma swi_number=0x0147
__swi	__arm	void UnlockSched(void);
//arm
//pattern=??,??,??,E9,??,??,??,??,??,??,??,E3,??,??,??,1A,??,??,??,E3,??,??,??,??,??,??,??,??,??,??,??,??,??,??,??,E3,??,??,??,E1,??,??,??,??,??,??,??,??,??,??,??,E3,??,??,??,0A,??,??,??,EF,??,??,??,E1,??,??,??,E3,??,??,??,E1,??,??,??,E3,??,??,??,??,??,??,??,E8,??,??,??,EF,??,??,??,E1,??,??,??,E3,??,??,??,E1,??,??,??,E3,??,??,??,??,??,??,??,EA,??,??,??,E5,??,??,??,??,??,??,??,E1,??,??,??,1A,??,??,??,E2,??,??,??,E1,??,??,??,E3,??,??,??,0A,??,??,??,E2,??,??,??,E1,??,??,??,E1,??,??,??,E1,??,??,??,1A,??,??,??,??,??,??,??,E5,??,??,??,E5,??,??,??,E0,??,??,??,E0,??,??,??,E5,??,??,??,E5,??,??,??,E5,??,??,??,E1,??,??,??,85,??,??,??,E5,??,??,??,??,??,??,??,EA

#pragma swi_number=0x0148
__swi	__arm	extern int ShowMSG(int flag, int lgp_id);
//thumb
//pattern=??,4A,C3,07,00,D4,38,32,??,1C,00,21,78,E7
//thumb
//pattern_SGOLD=??,4A,??,07,??,D4,??,32,??,1C,??,21,??,E7
//thumb
//pattern_ELKA=??,4A,E0,32,??,07,??,D4,??,32,??,1C,??,21,68,E7

#pragma swi_number=0x0149
__swi	__arm	void SetPropTo_Obj1(DRWOBJ *drwobj,void *rect,int rect_flag,WSHDR *wshdr,int font,int text_flag);
//thumb
//pattern=??,B5,??,1C,??,20,??,9F,??,70,??,1C,??,1C,??,1C,??,30,??,22,??,??,??,??,??,70,??,20,??,70,??,06,??,D5,??,1C,??,??,??,??,??,1C,??,??,??,??,??,??,??,??,??,1C,??,1C,??,??,??,??,??,61,??,E0

#pragma swi_number=0x014A
__swi	__arm	void FreeDrawObject_subobj(DRWOBJ *drwobj);
//thumb
//pattern=??,B5,??,1C,??,78,??,28,??,D0,??,28,??,D0,??,28,??,D0,??,28,??,D1,??,69,??,??,??,??,??,69,??,??,??,??,??,21,??,1C,??,??,??,??,??,20,??,70,??,BD

#pragma swi_number=0x014B
__swi	__arm	void SetColor(DRWOBJ *drwobj, char *color1, char *color2);
//thumb
//pattern=??,B5,??,1C,??,1C,??,1C,??,1C,_blf(??,29,??,D0,??,28,??,D1,??,20,??,E7,??,78,??,70,??,78,??,70,??,78,??,70,??,78,??,70,??,47),??,1D,??,1C,??,??,??,??,??,78,??,21,??,43,??,70,??,BD

#pragma swi_number=0x014C
__swi	__arm	void DrawString(WSHDR *WSHDR,int x1,int y1,int x2,int y2,int font,int text_attribute,const char *Pen,const char *Brush);
//thumb
//pattern=??,B5,??,B0,??,9C,??,9F,??,9E,??,1C,??,D0,??,68,??,28,??,D1,??,A0,??,??,??,??,??,??,??,1C,??,20,??,??,??,??,??,28,??,D0,??,DF,??,22,??,1C,??,20,??,??,??,E0

#pragma swi_number=0x014D
__swi	__arm	GUI *GetTopGUI(void);
//thumb
//pattern=??,??,??,B5,??,68,??,28,??,D1,??,BD,??,??,??,??,??,BD

#pragma swi_number=0x014E
__swi	__arm	void *FindItemByID(GUI *gui,int id);
//thumb
//pattern=??,B5,??,28,??,D1,??,??,??,3C,??,1C,??,20,??,??,??,??,??,??,??,28,??,D0,??,DF,??,1C,??,1C,??,22,??,20,??,??,??,??,??,E0,??,DF,??,1C,??,1C,??,22,??,20,??,??,??,??,??,E0,??,69,??,E0,??,68,??,42,??,D0,??,68,??,28,??,D1,??,20,??,BD

#pragma swi_number=0x014F
__swi	__arm	void *GetDataOfItemByID(GUI *gui,int id);
//thumb
//pattern=??,B5,_blf(??,B5,??,28,??,D1,??,??,??,3C,??,1C,??,20,??,??,??,??,??,??,??,28,??,D0,??,DF,??,1C,??,1C,??,22,??,20,??,??,??,??,??,E0,??,DF,??,1C,??,1C,??,22,??,20,??,??,??,??,??,E0,??,69,??,E0,??,68,??,42,??,D0,??,68,??,28,??,D1,??,20,??,BD),??,28,??,D0,??,68,??,BD,??,20,??,BD

#pragma swi_number=0x0150
__swi	__arm	void DrawRoundedFrame(int x1,int y1,int x2,int y2,int x_round,int y_round,int flags,const char *pen,const char *brush);
//thumb
//pattern=??,B5,??,B0,??,1C,??,23,??,9C,??,20,??,1C,??,2C,??,90,??,93,??,9D,??,DA,??,24

#pragma swi_number=0x0151
__swi	__arm	void SetPropTo_Obj5(DRWOBJ *, RECT *, int zero, IMGHDR *Image);
//thumb
//pattern=??,B5,??,1C,??,20,??,70,??,70,??,1C,??,1C,??,25,??,30,??,22,??,70,??,??,??,??,??,20,??,61,??,76,??,76,??,76,??,61,??,1C,??,BD

#pragma swi_number=0x0152
__swi	__arm	int CreateMenu(int is_small,int zero1,const MENU_DESC *menu, const HEADER_DESC *hdr,int start_item,int n_items,void *user_pointer,int *to_remove);
//thumb
//pattern=??,B5,??,B0,??,1C,??,AA,??,1C,??,1C,??,CA,??,91,??,21,??,9F,??,91,??,92,??,1C,??,1C,??,90,??,1C,??,97,??,??,??,??,??,B0,??,BD

#pragma swi_number=0x0153
__swi	__arm	int GBS_RecActDstMessage(GBS_MSG *);
//arm
//pattern=??,??,??,E9,??,??,??,E1,??,??,??,??,??,??,??,E1,??,??,??,??,??,??,??,??,??,??,??,E3,??,??,??,1A,??,??,??,E3,??,??,??,??,??,??,??,??,??,??,??,EF,??,??,??,E1,??,??,??,E3,??,??,??,E1,??,??,??,E3,??,??,??,??,??,??,??,E3,??,??,??,1A,??,??,??,E3,??,??,??,??,??,??,??,??,??,??,??,EF,??,??,??,E1,??,??,??,E3,??,??,??,E1,??,??,??,E3,??,??,??,??,??,??,??,E5,??,??,??,E3,??,??,??,0A,??,??,??,E3,??,??,??,E2,??,??,??,??,??,??,??,EF,??,??,??,E1,??,??,??,E3,??,??,??,E1,??,??,??,E3,??,??,??,??,??,??,??,E1,??,??,??,??,??,??,??,E2,??,??,??,??,??,??,??,E2,??,??,??,E1,??,??,??,??,??,??,??,E1,??,??,??,E1,??,??,??,E3,??,??,??,??,??,??,??,E5,??,??,??,??,??,??,??,E5,??,??,??,E3,??,??,??,0A,??,??,??,E1,??,??,??,??,??,??,??,E5,??,??,??,??,??,??,??,E1,??,??,??,??,??,??,??,E3,??,??,??,01,??,??,??,??,??,??,??,E3,??,??,??,E5,??,??,??,E1,??,??,??,E8

#pragma swi_number=0x0154
__swi	__arm	void KillGBSproc(int cepid);
//arm
//pattern=??,??,??,E9,??,??,??,E1,??,??,??,??,??,??,??,E1,??,??,??,0A,??,??,??,E1,??,??,??,E3,??,??,??,1A,??,??,??,E3,??,??,??,??,??,??,??,??,??,??,??,EF,??,??,??,E3,??,??,??,E3,??,??,??,??,??,??,??,??,??,??,??,??,??,??,??,E5,??,??,??,E3,??,??,??,E1,??,??,??,1A,??,??,??,??,??,??,??,??,??,??,??,E8,??,??,??,??,??,??,??,??,??,??,??,EA


//===========================================
//pnglib
//===========================================

#pragma swi_number=0x0155
__swi __arm png_structp png_create_read_struct(png_const_charp user_png_ver, png_voidp error_ptr, png_error_ptr error_fn, png_error_ptr warn_fn);
//thumb
//pattern=??,B5,0D,1C,00,21,16,1C,00,22,??,??,??,??,??,??,29,1C

#pragma swi_number=0x0156
__swi __arm png_infop png_create_info_struct(png_structp png_ptr);
//thumb
//pattern=??,B5,00,28,??,D1,??,BD,01,21,49,02

#pragma swi_number=0x0157
__swi __arm void png_destroy_read_struct(png_structpp png_ptr_ptr, png_infopp info_ptr_ptr, png_infopp end_info_ptr_ptr);
//thumb
//pattern=??,B5,??,??,??,??,00,26,00,25,00,24,00,28,??,D0,??,??,??,??,??,??,00,29

#pragma swi_number=0x0158
__swi __arm void png_set_sig_bytes(png_structp png_ptr,int num_bytes);
//thumb
//pattern=??,B5,05,1C,0C,1C,08,29,??,DD

#pragma swi_number=0x0159
__swi __arm void png_read_info(png_structp png_ptr, png_infop info_ptr);
//thumb
//pattern=??,B5,0F,1C,01,1C,FF,31,61,31,??,??,??,??,??,??,E0,39,04,1C

#pragma swi_number=0x015A
__swi __arm png_uint_32 png_get_IHDR(png_structp png_ptr,png_infop info_ptr, png_uint_32 *width, png_uint_32 *height, int *bit_depth, int *color_type, int *interlace_method, int *compression_method, int *filter_method);
//thumb
//pattern=??,B5,??,??,16,1C,05,1C,0C,1C,00,28,??,??,??,D0,00,2C

#pragma swi_number=0x015B
__swi __arm png_voidp png_malloc(png_structp png_ptr, png_uint_32 size);
//thumb
//pattern=??,B5,04,1C,??,D0,00,29,??,D1,00,20,??,BD,01,20,40,02,20,18

#pragma swi_number=0x015C
__swi __arm void png_read_image(png_structp png_ptr, png_bytepp image);
//thumb
//pattern=??,B5,??,??,07,1C,??,??,??,??,??,??,38,1C,FF,30,01,30

#pragma swi_number=0x015D
__swi __arm void png_read_end(png_structp png_ptr, png_infop info_ptr);
//thumb
//pattern=??,B5,04,1C,0F,1C,00,21,??,??,??,??,??,??,26,1C,FF,36,5D,36

#pragma swi_number=0x015E
__swi __arm png_voidp png_get_io_ptr(png_structp png_ptr);
//thumb
//pattern=80,30,40,69,70,47

#pragma swi_number=0x015F
__swi __arm png_uint_32 png_get_rowbytes(png_structp png_ptr,png_infop info_ptr);
//thumb
//pattern=00,28,??,D0,00,29,??,D0,C8,68,70,47,00,20,70,47

#pragma swi_number=0x0160
__swi __arm void png_read_row(png_structp png_ptr,png_bytep row,png_bytep dsp_row);
//thumb
//pattern=??,B5,04,1C,??,??,??,??,05,22,??,??,??,??,??,??,??,??,1C,22,47,31

#pragma swi_number=0x0161
__swi __arm void png_init_io(png_structp png_ptr, int fp);
//arm
//pattern=94,10,80,e5,1e,ff,2f,e1

//===========================================
//===========================================


#pragma swi_number=0x0162
__swi __arm int setjmp(jmp_buf jmpbuf);
//arm
//pattern=??,??,??,E8,??,??,??,E8,??,??,??,E8,??,??,??,E9,??,??,??,EB,??,??,??,E8,??,??,??,E8,??,??,??,E3,??,??,??,E1



#pragma swi_number=0x0163
__swi __arm EDITQ *AllocEQueue(void *malloc_a, void *mfree_a);
//thumb
//pattern=??,B5,??,1C,??,1C,??,20,??,47,??,21,??,60,??,60,??,60,??,60,??,61,??,BD

#pragma swi_number=0x0164
__swi __arm EDITCONTROL *PrepareEditControl(EDITCONTROL *);
//thumb
//pattern=??,B5,??,1C,_blf(??,21,??,70,??,60,??,72,??,72,??,83,??,83,??,83,??,83,??,84,??,62,??,62,??,30,??,E7),??,1C,??,BD

#pragma swi_number=0x0165
__swi __arm void ConstructEditControl(EDITCONTROL *EditControl,int type,int flag,WSHDR *ws,int maxlen);
//thumb
//pattern=??,B5,??,B0,??,1C,??,1C,??,1C,??,29,??,9F,??,D0,??,2D,??,D1,??,2E,??,D0,??,DF,??,22,??,20,??,??,??,??,??,??,??,??,??,1C,??,??,??,??,??,70,??,98,??,60,??,62,??,83,??,B0,??,BD

#pragma swi_number=0x0166
__swi __arm int AddEditControlToEditQend(void *EditQ,EDITCONTROL *EditControl,void *malloc_a);
//thumb
//pattern=??,B5,??,1C,??,1C,??,1C,??,??,??,??,??,30,??,04,??,0C,??,1C,??,1C,??,1C,_blf(??,B5,??,1C,??,1C,??,B0,??,A8,??,22,??,6A,??,??,??,??,??,8B,??,68,??,69,??,??,??,??,??,1C,??,2E,??,68,??,D0,??,1C,??,1C,??,??,??,??,??,E0,??,21,??,1C,??,??,??,??,??,22,??,92,??,1C,??,1C,??,9A,??,95,??,A9,??,??,??,??,??,B0,??,BD),??,BD

#pragma swi_number=0x0167
__swi __arm int CreateInputTextDialog(const INPUTDIA_DESC *input_desc, const HEADER_DESC *header_desc,void *editq,int do_mfree,void *user_pointer);
//thumb
////pattern=F0,B5,85,B0,16,1C,0D,1C,??,??,??,??,0A,9F,04,1C,??,??,02,91,03,92,32,1C,29,1C,01,90,20,1C,00,97,??,??,??,??,05,B0,F0,BD


#pragma swi_number=0x0168
__swi __arm void SetSoftKey(void *gui,const SOFTKEY_DESC *,int n);
//thumb
//pattern=??,B5,??,1C,??,30,??,68,??,1C,??,30,??,1C,??,1C,??,68,??,??,??,??,??,28,??,D0,??,1C,??,1C,??,1C,_blf(??,B5,??,1C,??,1C,??,28,??,D1,??,??,??,1C,??,20,??,??,??,??,??,??,??,??,??,28,??,D0,??,DF,??,1C,??,1C,??,22,0D,20,??,??,??,??,??,BD,??,DF,??,1C,??,1C,??,22,??,20,??,??,??,??,??,BD,??,21,??,??,??,??,??,1C,??,1C,??,??,??,??,??,BD),??,BD

#pragma swi_number=0x0169
__swi __arm int ExtractEditControl(void *guidata,int n,EDITCONTROL *);


#pragma swi_number=0x016A
__swi __arm int StoreEditControl(void *guidata,int n,EDITCONTROL *);

#pragma swi_number=0x016B
__swi __arm int unlink(const char *cFileName,unsigned int *errornumber);
//arm
//pattern=??,??,??,E9,??,??,??,E1,??,??,??,E1,??,??,??,??,??,??,??,E3,??,??,??,E5,58,??,??,E5,??,??,??,E3,??,??,??,E1,??,??,??,E3,??,??,??,E1,??,??,??,E1,??,??,??,E8

#pragma swi_number=0x016C
__swi __arm int str_2ws(WSHDR *ws,const char *str,unsigned int size);
//arm
//pattern=??,??,??,E9,??,??,??,E2,??,??,??,E1,??,??,??,E1,??,??,??,E1,??,??,??,E2,??,??,??,E3,??,??,??,E3,??,??,??,??,??,??,??,E1,??,??,??,E1,??,??,??,E3,??,??,??,??,??,??,??,E5,??,??,??,E3,??,??,??,E2,??,??,??,E5,??,??,??,E3,??,??,??,E5,??,??,??,E1,??,??,??,AA,??,??,??,E7,??,??,??,E3,??,??,??,13,??,??,??,13,??,??,??,13,??,??,??,1A,??,??,??,E0,??,??,??,E2,??,??,??,E1,??,??,??,E1,??,??,??,E1,??,??,??,E0,??,??,??,??,??,??,??,E1,??,??,??,E1,??,??,??,E1,??,??,??,??,??,??,??,E2,??,??,??,E3,??,??,??,E5,??,??,??,E2,??,??,??,E1,??,??,??,2A,??,??,??,E7,??,??,??,E3,??,??,??,0A,??,??,??,E1,??,??,??,??,??,??,??,E1,??,??,??,E1,??,??,??,??,??,??,??,E1,??,??,??,??,??,??,??,E1,??,??,??,E1,??,??,??,E3,??,??,??,1A,??,??,??,E1,??,??,??,E2,??,??,??,E8

#pragma swi_number=0x016D
__swi __arm int UnpackABentry(AB_UNPRES *,void *abentry,int filesz,int flag);
//arm
//pattern=??,??,??,E9,??,??,??,E2,??,??,??,E3,??,??,??,E1,??,??,??,E1,??,??,??,E5,??,??,??,E2,??,??,??,E3,??,??,??,13,??,??,??,1A,??,??,??,E2,??,??,??,E5,??,??,??,E2,??,??,??,E3,??,??,??,03,??,??,??,E5,??,??,??,0A,??,??,??,??,??,??,??,E5,??,??,??,??,??,??,??,E5,??,??,??,E3,??,??,??,AA,??,??,??,E3,??,??,??,E3,??,??,??,??,??,??,??,EA,??,??,??,E3,??,??,??,??,??,??,??,E1,??,??,??,13,??,??,??,??,??,??,??,1A,??,??,??,??,??,??,??,E3,??,??,??,E1,??,??,??,??,??,??,??,E3,??,??,??,0A,??,??,??,EF,??,??,??,E1,??,??,??,E3,??,??,??,E1,??,??,??,E3,??,??,??,??,??,??,??,EA,??,??,??,EF,??,??,??,E1,??,??,??,E3,??,??,??,E1,??,??,??,E3,??,??,??,??,??,??,??,E3,??,??,??,E2,??,??,??,E8

#pragma swi_number=0x016E
__swi __arm int FreeUnpackABentry(AB_UNPRES *, void *mfree_adr);
//arm
//pattern=??,??,??,E9,??,??,??,E1,??,??,??,E5,??,??,??,E3,??,??,??,E1,??,??,??,E3,??,??,??,E3,??,??,??,0A,??,??,??,E1,??,??,??,E3,??,??,??,EA,??,??,??,E5,??,??,??,E0,??,??,??,E0,??,??,??,E5,??,??,??,E3,??,??,??,0A,??,??,??,E1,??,??,??,E5,??,??,??,??,??,??,??,E2,??,??,??,EA,??,??,??,E5,??,??,??,E0,??,??,??,E0,??,??,??,E5,??,??,??,E2,??,??,??,E1,??,??,??,05,??,??,??,05,??,??,??,E2,??,??,??,E1,??,??,??,3A,??,??,??,E2,??,??,??,E2,??,??,??,E1,??,??,??,3A,??,??,??,E5,??,??,??,E1,??,??,??,E5,??,??,??,E5,??,??,??,E3,??,??,??,E1,??,??,??,E5,??,??,??,E5,??,??,??,E3,??,??,??,E3,??,??,??,E3,??,??,??,E3,??,??,??,E3,??,??,??,E5,??,??,??,E1,??,??,??,E1,??,??,??,E1,??,??,??,E1,??,??,??,E3,??,??,??,E5,??,??,??,E1,??,??,??,E3,??,??,??,E8

#pragma swi_number=0x016F
__swi __arm int GetTypeOfAB_UNPRES_ITEM(int);
//arm
//pattern=??,??,??,E1,??,??,??,E3,??,??,??,E3,??,??,??,90,??,??,??,E1,??,??,??,EA,??,??,??,EA,??,??,??,EA,??,??,??,EA,??,??,??,EA,??,??,??,EA,??,??,??,EA,??,??,??,EA,??,??,??,E1,??,??,??,EA,??,??,??,EA,??,??,??,EA,??,??,??,EA,??,??,??,EA,??,??,??,EA,??,??,??,EA,??,??,??,EA,??,??,??,EA,??,??,??,EA,??,??,??,EA,??,??,??,EA,??,??,??,EA,??,??,??,EA,??,??,??,EA,??,??,??,EA,??,??,??,EA,??,??,??,EA,??,??,??,EA,??,??,??,EA,??,??,??,EA,??,??,??,EA,??,??,??,EA,??,??,??,EA,??,??,??,EA,??,??,??,E1,??,??,??,EA,??,??,??,EA,??,??,??,EA,??,??,??,EA,??,??,??,EA,??,??,??,EA,??,??,??,EA,??,??,??,EA,??,??,??,EA,??,??,??,EA,??,??,??,EA,??,??,??,EA,??,??,??,EA,??,??,??,EA,??,??,??,EA,??,??,??,EA,??,??,??,EA,??,??,??,EA,??,??,??,EA,??,??,??,EA,??,??,??,EA,??,??,??,EA,??,??,??,EA,??,??,??,EA,??,??,??,EA,??,??,??,EA,??,??,??,EA,??,??,??,EA,??,??,??,EA,??,??,??,EA,??,??,??,EA,??,??,??,EA,??,??,??,EA,??,??,??,EA,??,??,??,EA,??,??,??,EA,??,??,??,EA,??,??,??,EA,??,??,??,EA,??,??,??,EA,??,??,??,EA,??,??,??,EA,??,??,??,EA,??,??,??,EA

#pragma swi_number=0x0170
__swi __arm int MakeVoiceCall(const char *number,int _0x10, int _0x20C0);
//thumb
//pattern=??,B5,??,1C,??,22,??,92,??,04,??,0C,??,23,??,06,??,0E,??,??,??,??,??,BD

#pragma swi_number=0x0171
__swi __arm void SUBPROC(void *,...); //(void (*)(void *, int),void *, int);

#pragma swi_number=0x0172
__swi __arm void REDRAW(void);

//===========================================
//Sockets
//===========================================
#pragma swi_number=0x0173
__swi __arm int socket(int af,int type,int protocol);

#pragma swi_number=0x0174
__swi __arm int connect(int sock,SOCK_ADDR *,int name_length);

#pragma swi_number=0x0175
__swi __arm int bind(int sock,SOCK_ADDR *,int name_length);

#pragma swi_number=0x0176
__swi __arm int closesocket(int socket);

#pragma swi_number=0x0177
__swi __arm int shutdown(int socket,int how);

#pragma swi_number=0x0178
__swi __arm int recv(int socket,void *buf,int len,int flag);

#pragma swi_number=0x0179
__swi __arm int send(int socket,const void *buf,int len,int flag);

#pragma swi_number=0x017A
__swi __arm unsigned __int16 htons(unsigned __int16);

#pragma swi_number=0x017B
__swi __arm unsigned int htonl(unsigned int);

#pragma swi_number=0x817C
__swi __arm int *socklasterr(void);

//--------------------------------------------------
//IDLE timer
//--------------------------------------------------
#pragma swi_number=0x017D
__swi __arm void SetIDLETMR(int time_ms,int msg);
//thumb
//pattern=??,1C,??,1C,??,48,??,B5,??,68,_blf(??,B5,??,1C,??,30,??,1C,??,1C,??,1C,??,??,??,E8,??,2D,??,DB,??,63,??,63,??,1C,??,??,??,FF,??,1C,??,??,??,E8,??,BD),??,BD

#pragma swi_number=0x017E
__swi __arm void RestartIDLETMR(void);
//thumb
//pattern=??,48,??,B5,??,68,_blf(??,B5,??,1C,??,30,??,90,??,??,??,E8,??,1C,??,6B,??,37,??,28,??,D1,??,1C,??,??,??,ED,??,E0,??,26,??,1C,??,??,??,ED,??,90),??,BD

#pragma swi_number=0x017F
__swi __arm void DisableIDLETMR(void);
//thumb
//pattern=??,48,??,B5,??,68,_blf(00,22,00,21,??,E7),??,BD

#pragma swi_number=0x0180
__swi __arm int EDIT_GetItemNumInFocusedComboBox(void *gui);
//thumb
//pattern=

#pragma swi_number=0x0181
__swi __arm void EDIT_SetTextToFocused(void *gui,WSHDR *ws);
//thumb
//pattern=

#pragma swi_number=0x0182
__swi __arm int EDIT_GetFocus(void *gui);
//thumb
//pattern=

#pragma swi_number=0x0183
__swi __arm int EDIT_GetUnFocus(void *gui);
//thumb
//pattern=

#pragma swi_number=0x0184
__swi __arm void ConstructComboBox(EDITCONTROL *EditControl,int type,int attr,WSHDR*,int maxlen,int unk_zero,int num_of_items,int start_item);
//thumb
//pattern=F8,B5,04,1C,10,1C,06,AF,E4,CF,00,92,02,1C,20,1C,_blf(??,B5,??,B0,??,1C,??,1C,??,1C,??,29,??,9F,??,D0,??,2D,??,D1,??,2E,??,D0,??,DF,??,22,??,20,??,??,??,??,??,??,??,??,??,1C,??,??,??,??,??,70,??,98,??,60,??,62,??,83,??,B0,??,BD),25,72,66,83,A7,83,F8,BD

#pragma swi_number=0x0185
__swi __arm int GBS_WaitForMsg(const int *msg_list, int msgs_num, GBS_MSG*, int timeout);
//arm
//pattern=

#pragma swi_number=0x0186
__swi __arm int RegisterCepidForSocketWork(REGSOCKCEPID_DATA *);
//thumb
//pattern=

#pragma swi_number=0x0187
__swi __arm int RequestLMANConnect(LMAN_DATA *);
//thumb
//pattern=

#pragma swi_number=0x8188
__swi __arm int ScreenW(void);
//adr=132

#pragma swi_number=0x8189
__swi __arm int ScreenH(void);
//adr=176

#pragma swi_number=0x818A
__swi __arm int HeaderH(void);
//adr=22

#pragma swi_number=0x818B
__swi __arm int SoftkeyH(void);
//adr=22

#pragma swi_number=0x018C
__swi __arm void GBS_DelTimer(GBSTMR *);
//arm
//pattern=

#pragma swi_number=0x018D
__swi __arm int available0(int sock);
//arm
//pattern=

#pragma swi_number=0x018E
__swi __arm void GPRS_OnOff(int on, int _1);
//thumb
//pattern=

#pragma swi_number=0x018F
__swi __arm int GetCurMenuItem(void *gui);
//thumb
//pattern=

#pragma swi_number=0x0190
__swi __arm void MutexCreate(MUTEX *mtx);
//arm
//pattern=

#pragma swi_number=0x0191
__swi __arm void MutexDestroy(MUTEX *mtx);
//arm
//pattern=

#pragma swi_number=0x0192
__swi __arm void MutexLock(MUTEX *mtx);
//arm
//pattern=

#pragma swi_number=0x0193
__swi __arm void MutexLockEx(MUTEX *mtx, int flag);
//arm
//pattern=

#pragma swi_number=0x0194
__swi __arm void MutexUnlock(MUTEX *mtx);
//arm
//pattern=

#pragma swi_number=0x0195
__swi __arm void SetMenuItemIcon(void *gui,int item_n,int icon_n);
//thumb
//pattern=

#pragma swi_number=0x0196
__swi __arm void RefreshGUI(void);
//thumb
//pattern=

#pragma swi_number=0x0197
__swi __arm void *AllocMenuItem(void *gui);
//thumb
//pattern=

#pragma swi_number=0x0198
__swi __arm WSHDR *AllocMenuWS(void *gui, int len);
//thumb
//pattern=

#pragma swi_number=0x0199
__swi __arm void SetMenuItemIconArray(void *gui,void *item,const int *icons);
//thumb
//pattern=8A,62,70,47

#pragma swi_number=0x019A
__swi __arm void SetMenuItemText(void *gui,void *item,WSHDR *text,int item_n);
//thumb
//pattern=

#pragma swi_number=0x019B
__swi __arm void EDIT_SetFocus(void *gui, int item);
//thumb
//pattern=

#pragma swi_number=0x019C
__swi __arm void SEQKILLER(void *data, void(*next_in_seq)(void *), void *data_to_kill);
#pragma swi_number=0x819C
__swi __arm void *SEQKILLER_ADR();


#pragma swi_number=0x019D
__swi __arm long long getCpuUsedTime_if_ena(void);
//arm
//pattern=

#pragma swi_number=0x019E
__swi __arm void StartCpuUsageCount(void);
//arm
//pattern=


#pragma swi_number=0x019F
__swi __arm int inflateInit2_ (z_streamp strm, int windowBits,const char *version, int stream_size);
//thumb
//pattern=??,B5,0D,1C,04,1C,00,2A,??,D0,10,78,31,28

#pragma swi_number=0x01A0
__swi __arm int inflate (z_streamp strm, int flush);
//thumb
//pattern=??,B5,??,??,??,??,00,29,??,D0,??,??,??,??,00,2E,??,D0

#pragma swi_number=0x01A1
__swi __arm int inflateEnd (z_streamp strm);
//thumb
//pattern=10,B5,04,1C,??,D0,??,??,00,28,??,D0,??,??,00,2A,??,D1


#pragma swi_number=0x01A2
__swi __arm int ActivateDialUpProfile(unsigned int cep_id,int profile_num);
//thumb
//pattern=??,B5,??,B0,00,24,01,20,??,46,??,??,??,??,??,??,??,??,00,28,??,D0,01,21

#pragma swi_number=0x01A3
__swi __arm int GetCurrentGPRSProfile(void);
//arm
//pattern=??,40,2D,E9,??,??,??,E5,??,??,??,E1,19,00,50,E3,??,??,??,3A,01,00,A0,E3

#pragma swi_number=0x01A4
__swi __arm int GetDisconnectTime(void);
//arm
//pattern=??,??,??,E5,??,??,??,E1,FA,0F,50,E3,??,??,??,8A,0A,00,50,E3,??,??,??,2A

#pragma swi_number=0x01A5
__swi __arm void RegisterCepIdForCurProfile(unsigned int cep_id,int profile_num,unsigned int csd_or_gprs);
//thumb
//pattern=03,1C,??,??,03,60,02,71,C1,80,70,47

#pragma swi_number=0x01A6
__swi __arm int IsTimerProc(GBSTMR *);
//arm
//pattern=10,40,2D,E9,00,40,A0,E1,??,??,??,??,01,00,50,E3,??,??,??,1A,04,00,A0,E1,??,??,??,??,01,00,50,E3

#pragma swi_number=0x1A7
__swi __arm char* Get_CC_NC();
//thumb
//pattern=??,B5,??,??,??,??,??,4C,07,34,??,??,??,??,??,1C,??,BD


//===========================================
//pnglib part 2
//===========================================
#pragma swi_number=0x1A8
__swi __arm png_structp png_create_read_struct_2(png_const_charp user_png_ver, png_voidp error_ptr,
                                                 png_error_ptr error_fn, png_error_ptr warn_fn, png_voidp mem_ptr,
                                                 png_malloc_ptr malloc_fn, png_free_ptr free_fn);
//thumb
//pattern=??,B5,??,??,??,??,05,1C,32,1C,01,20,??,??,??,??,??,??,??,??,04,1C,??,D1,00,20,??,??,??,BD

#pragma swi_number=0x1A9
__swi __arm void png_set_read_fn(png_structp png_ptr, png_voidp io_ptr, png_rw_ptr read_data_fn);
//thumb
//pattern=??,B5,04,1C,80,30,41,61,02,61,C1,68,00,25,00,29

#pragma swi_number=0x1AA
__swi __arm void png_read_update_info(png_structp png_ptr,void *info_ptr);
//thumb
//pattern=??,B5,0D,1C,04,1C,80,30,C0,6A,40,06

#pragma swi_number=0x1AB
__swi __arm void png_set_palette_to_rgb(png_structp png_ptr);
//thumb
//pattern=80,30,01,6B,01,22,12,03,11,43,01,63,70,47

#pragma swi_number=0x1AC
__swi __arm png_uint_32 png_get_valid(png_structp png_ptr,png_infop info_ptr, png_uint_32 flag);
//thumb
//pattern=00,28,??,D0,00,29,??,D0,88,68,10,40,70,47

#pragma swi_number=0x1AD
__swi __arm void png_set_tRNS_to_alpha(png_structp png_ptr);
//thumb
//pattern=80,30,01,6B,01,22,12,03,11,43,01,63,70,47

#pragma swi_number=0x1AE
__swi __arm void png_set_filler(png_structp png_ptr,png_uint_32 filler, int flags);
//thumb
//pattern=??,B5,03,1C,80,33,1C,6B,01,25,ED,03,2C,43

#pragma swi_number=0x1AF
__swi __arm void png_set_strip_16(png_structp png_ptr);
//thumb
//pattern=80,30,01,6B,01,22,92,02,11,43,01,63,70,47

#pragma swi_number=0x1B0
__swi __arm void png_set_packing(png_structp png_ptr);
//thumb
//pattern=01,1C,FF,31,61,31,CA,79,08,2A,??,D2,80,30

#pragma swi_number=0x1B1
__swi __arm void png_set_gray_to_rgb(png_structp png_ptr);
//thumb
//pattern=80,30,01,6B,01,22,92,03,11,43,01,63,70,47

#pragma swi_number=0x1B2
__swi __arm int png_check_sig(png_bytep sig, int num);
//thumb
//pattern=??,B5,0A,1C,00,21,_blf(??,B5,06,1C,0D,1C,14,1C,08,22),00,28,??,D1,01,20,??,BD

//===========================================
//===========================================

#pragma swi_number=0x1B3
__swi __arm void DrawLine(int x,int y,int x2,int y2,int type,const char *pen);
//thumb
//pattern=??,B5,04,1C,01,20,??,??,??,??,FF,20

#pragma swi_number=0x1B4
__swi __arm void DrawRectangle(int x,int y,int x2,int y2,int flags,const char *pen,const char *brush);
//thumb
//pattern=??,B5,??,??,??,??,??,??,15,1C,1C,1C,38,43

#pragma swi_number=0x81B5
__swi int isnewSGold(void);
//adr=1

#pragma swi_number=0x1B6
__swi __arm int async_gethostbyname(const char *host_name,int ****DNR_RES,int *DNR_ID);
//thumb
//pattern=F7,B5,05,1C,14,1C,90,B0,09,A8,1C,21,??,??,??,??,??,??,00,95,01,94
//pattern_SGOLD=??,B5,??,B0,??,1C,??,1C,??,46,??,21,??,1C,??,18,??,??,??,??,??,??,??,??,??,AB,??,82,??,??,??,??,??,A9

#pragma swi_number=0x1B7
__swi __arm unsigned int str2ip(const char *);
//thumb
//pattern=F8,B5,00,21,00,91,C9,43,00,28,??,??,08,1C,F8,BD,00,27


#pragma swi_number=0x81B8
__swi __arm void *EXT_TOP(void);

#pragma swi_number=0x81B9
__swi __arm void *PNG_TOP(void);

#pragma swi_number=0x81BA
__swi __arm void *LIB_TOP(void);

#pragma swi_number=0x81BB
__swi __arm void *DATA_N_SFB(void);

//===========================================
//openssl_lib
//===========================================

#pragma swi_number=0x1BC
__swi __arm void SHA1_Init(SHA_CTX *c);
//thumb
//pattern=??,49,??,60,??,49,??,60,??,49,??,43,??,60,??,49,??,43,??,60,??,49,??,61,??,21,??,61,??,61,??,65,??,47
 
#pragma swi_number=0x1BD
__swi __arm void SHA1_Update(SHA_CTX *c, const void *data, unsigned long len);
//thumb
//pattern=??,B5,??,1C,??,1C,??,1C,??,D0,??,69,E8,00,08,18,81,42,??,D9,??,69,??,31,??,61,??,69,??,0F,??,18,??,61,??,61
 
#pragma swi_number=0x1BE
__swi __arm void SHA1_Final(char *md, SHA_CTX *c);
//thumb
//pattern=??,B5,C8,6D,0D,1C,0C,1C,EF,6D,81,07,00,26,82,10,BF,10,BF,00,??,1C,??,0F,??,34,??,29
 
#pragma swi_number=0x1BF
__swi __arm RSA * RSA_new_method(RSA_METHOD *method);
//thumb
//pattern=??,B5,??,??,??,1C,??,68,??,28,??,D1,??,??,??,??,??,60,??,20,??,??,??,??,??,1C,??,D1,??,23
 
#pragma swi_number=0x1C0
__swi __arm void RSA_free (RSA *r);
//thumb
//pattern=??,B5,??,1C,??,D0,??,22,??,92,??,21,??,43,??,22,??,1C,??,30
 
#pragma swi_number=0x1C1
__swi __arm int RSA_sign(int type, char *m, unsigned int m_len, char *sigret, unsigned int *siglen, RSA *rsa);
//thumb
//pattern=??,B5,??,B0,??,1C,??,20,??,9D,??,90,??,6B,??,1C,??,24,??,06,??,D5,??,99,??,95,??,91,??,68,??,1C,??,6A
 
#pragma swi_number=0x1C2
__swi __arm BIGNUM *BN_bin2bn(const char *s,int len,BIGNUM *ret);
//thumb
//pattern=??,B5,??,1C,??,1C,??,1C,??,D1,??,??,??,??,??,1C,??,D0,??,25,??,2E,??,D1,??,20,??,60,??,E0

//===========================================
//===========================================

#pragma swi_number=0x1C3
__swi __arm void SetMenuItemCount(void *gui,int n);
//thumb
//pattern=??,B5,??,1C,??,1C,??,34,??,69,??,61,??,??,??,FF,??,69,??,42,??,D0,??,1C,??,69,??,??,??,FF,??,BD
//pattern_SGOLD=??,B5,??,6D,??,65,??,1C,??,??,??,??,??,6D,??,42,??,D0,??,1C,??,6D,??,??,??,??,??,BD

#pragma swi_number=0x1C4
__swi __arm void SetCursorToMenuItem(void *gui,int n);
//thumb
//pattern=??,B5,??,1C,??,1C,??,??,??,??,??,1C,??,34,??,69,??,22,??,32,??,42,??,59
//pattern_SGOLD=??,B5,??,1C,??,30,??,30,??,22,??,59,??,68,??,1C,??,6D,??,42,??,D3,??,2A,??,D1,??,20,??,65,??,E0

#pragma swi_number=0x1C5
__swi __arm int GetFontYSIZE(int font);
//arm
//pattern=??,??,??,E3,??,??,??,AA,??,??,??,E3,??,??,??,A5,??,??,??,A0,??,??,??,A0,??,??,??,A1,??,??,??,A1,??,??,??,E3,??,??,??,E1
//pattern=??,??,??,E5,??,??,??,E1,??,??,??,E2,??,??,??,E2,??,??,??,13,??,??,??,11,??,??,??,E5,??,??,??,E5,??,??,??,E1,??,??,??,DA,??,??,??,E3,??,??,??,A5,??,??,??,A0,??,??,??,A0,??,??,??,A5,??,??,??,A1,??,??,??,E3,??,??,??,E1

#pragma swi_number=0x1C6
__swi __arm void EDIT_ExtractFocusedControl(void *gui,EDITCONTROL *ec);
//thumb
//pattern=

#pragma swi_number=0x1C7
__swi __arm int EDIT_StoreControlToFocused(void *gui,EDITCONTROL *ec);
//thumb
//pattern=

#pragma swi_number=0x1C8
__swi __arm EDITC_OPTIONS *PrepareEditCOptions(EDITC_OPTIONS *ec_options);
//thumb
//pattern=??,B5,??,1C,_blf(??,B5,??,22,??,92,??,92,??,25),??,1C,??,BD

#pragma swi_number=0x1C9
__swi __arm void SetInvertToEditCOptions(EDITC_OPTIONS *ec_options, int invert);
//thumb
//pattern=??,80,??,88,01,22,??,43,??,80,??,47

#pragma swi_number=0x1CA
__swi __arm void SetFontToEditCOptions(EDITC_OPTIONS *ec_options, int font);
//thumb
//pattern=??,71,??,88,02,22,??,43,??,80,??,47

#pragma swi_number=0x1CB
__swi __arm void SetAlignToEditCOptions(EDITC_OPTIONS *ec_options, int align);
//thumb
//pattern=??,71,??,88,04,22,??,43,??,80,??,47

#pragma swi_number=0x1CC
__swi __arm void SetPenColorToEditCOptions(EDITC_OPTIONS *ec_options, int pen);
//thumb
//pattern=??,B5,??,1C,??,1C,??,1D,??,??,??,??,??,88,08,21,??,43,??,80,??,BD

#pragma swi_number=0x1CD
__swi __arm void SetBrushColorToEditCOptions(EDITC_OPTIONS *ec_options, int brush);
//thumb
//pattern=??,B5,??,1C,??,1C,??,1C,??,31,??,??,??,??,??,88,10,21,??,43,??,80,??,BD

#pragma swi_number=0x1CE
__swi __arm void CopyOptionsToEditControl(EDITCONTROL *ec,EDITC_OPTIONS *ec_options);
//thumb
//pattern=??,B5,0E,22,0A,30,??,??,??,??,??,BD

#ifdef NEWSGOLD
  #define TREGEXPLEXT REGEXPLEXT
#else
  #define TREGEXPLEXT REGEXPLEXT_ARM_NEW 
#endif

#pragma swi_number=0x1CF
__swi __arm TREGEXPLEXT *get_regextpnt_by_uid(int uid);
//thumb
//pattern=??,B5,??,1C,??,??,??,??,??,??,??,21,??,1F,??,68,??,E0,??,23,??,43,??,19,??,68,??,42,??,D1,??,20,??,43,??,19,??,BD
//arm
//pattern_SGOLD=??,??,??,E9,??,??,??,E1,??,??,??,??,??,??,??,E5,??,??,??,E3,??,??,??,E5,??,??,??,E5,??,??,??,EA,??,??,??,E0,??,??,??,E5,??,??,??,E1,??,??,??,12,??,??,??,1A,??,??,??,E0,??,??,??,E8

#pragma swi_number=0x1D0
__swi __arm int GetExtUid_ws(WSHDR * ext);
//thumb
//pattern=??,B5,??,1C,??,24,??,28,??,B0,??,D0,??,1C,??,??,??,??,??,28,??,D0,??,23,??,1C,??,AA,??,A9,??,??,??,??,??,28,??,D0,??,??,??,??,??,90,??,25
//arm
//pattern=??,??,??,E9,??,??,??,E2,??,??,??,E1,??,??,??,E3,??,??,??,0A,??,??,??,E1,??,??,??,??,??,??,??,E3,??,??,??,0A,??,??,??,E3,??,??,??,E1,??,??,??,E2

#pragma swi_number=0x1D1
__swi __arm void EDIT_RemoveEditControl(void *gui,int n);
//thumb
//pattern=

#pragma swi_number=0x1D2
__swi __arm void EDIT_InsertEditControl(void *gui,int n,EDITCONTROL *);
//thumb
//pattern=

#pragma swi_number=0x1D3
__swi __arm int EDIT_GetCursorPos(void *gui);
//thumb
//pattern=

#pragma swi_number=0x1D4
__swi __arm void EDIT_SetCursorPos(void *gui, int pos);
//thumb
//pattern=

#pragma swi_number=0x1D5
__swi __arm char *Get_Phone_Info(int InfoIndex);
//arm
//pattern=??,??,??,E3,??,??,??,95,??,??,??,95,??,??,??,90,??,??,??,95,??,??,??,82,??,??,??,E1

#pragma swi_number=0x1D6
__swi __arm void png_set_gray_1_2_4_to_8(png_structp png_ptr);
//thumb
//pattern=80,30,01,6B,01,22,12,03,11,43,01,63,70,47

#pragma swi_number=0x1D7
__swi __arm void png_set_invert_mono(png_structp png_ptr);
//thumb
//pattern=80,30,01,6B,20,22,11,43,01,63,70,47

#pragma swi_number=0x1D8
__swi __arm int EDIT_IsMarkModeActive(void *gui);
//thumb
//pattern=

#pragma swi_number=0x1D9
__swi __arm int EDIT_GetMarkedText(void *gui,WSHDR *dest);
//thumb
//pattern=

#pragma swi_number=0x1DA
__swi __arm void SendSMS(WSHDR *ws,const char *num,int cepid,int msg,int flag);
//thumb
//pattern=??,B5,??,B0,??,1C,??,1C,??,24,??,29,??,9F,??,D0,??,20,??,??,??,??,??,1C,??,21,??,??,??,??,??,22,??,1C,??,1C,??,??,??,??

#pragma swi_number=0x81DB
__swi __arm PDU *IncommingPDU(void);
//adr=0xA8E87CFC

#pragma swi_number=0x1DC
__swi __arm short wstrchr(WSHDR *ws,unsigned int start_pos,unsigned int wchar);
//thumb
//pattern=??,1C,??,1C,??,B5,??,68,??,88,??,E0,??,00,??,5B,??,42,??,D0,??,30,??,04,??,0C,??,42,??,D2,??,48,??,BD

#pragma swi_number=0x1DD
__swi __arm short wstrrchr(WSHDR *ws,unsigned int max_pos,unsigned int wchar);
//thumb
//pattern=??,B5,??,E0,??,68,??,00,??,5B,??,42,??,D1,??,1C,??,BD,??,39,??,04,??,0C,??,29,??,D1,??,48,??,BD

#pragma swi_number=0x1DE
__swi __arm int EDIT_SetTextToEditControl(void *gui,int n,WSHDR *ws);
//thumb
//pattern=

#pragma swi_number=0x1DF
__swi __arm void *EDIT_GetUserPointer(void *gui);
//thumb
//pattern=80,30,40,68,70,47,80,B5
//thumb
//pattern_ELKA=80,30,C0,68,70,47,80,B5
//thumb
//pattern_SGOLD=C0,6C,70,47,80,B5

#pragma swi_number=0x1E0
__swi __arm void *MenuGetUserPointer(void *gui);
//thumb
//pattern=80,6B,70,47,80,B5
//thumb
//pattern_SGOLD=40,6B,70,47,80,B5

#pragma swi_number=0x1E1
__swi __arm int GetSymbolWidth(int wchar,int font);
//thumb
//pattern_SGOLD=??,B5,??,1C,??,1C,??,2C,??,D0,??,2C,??,D0,??,09,??,39,??,39,??,D1,??,20,??,BD,??,??,??,??,??,1C,??,1C,??,46,??,??,??,??,??,E7
//thumb
//pattern=??,B5,??,28,??,D0,??,28,??,D0,??,09,??,3A,??,3A,??,D1,??,20,??,BD,??,46,??,??,??,??,??,E7

#pragma swi_number=0x1E2
__swi __arm  int ws_2utf8( WSHDR *from, char *to , int *result_length, int max_len);
//thumb
//pattern=??,B5,??,22,??,46,??,68,??,25,??,88,??,24,??,46,??,E0,??,2A,??,D2,??,1C,??,42,??,D2,??,1C,??,55,??,1C,??,E0,??,??,??,02,??,42,??,D2,??,1C,??,42,??,D2,??,09,??,27,??,43,??,55,??,1C,??,E0

#pragma swi_number=0x1E3
__swi __arm int utf8_2ws(WSHDR *ws,const char *utf8_str, unsigned int maxLen);
//thumb
//pattern=??,B5,??,22,??,46,??,B0,??,9A,??,24,??,23,??,04,??,0C,??,46,??,E0,??,8A,??,3A,??,42,??,DD,??,1C,??,04,??,0C,??,1C,??,1C,??,5D,??,06,??,D4,??,34,??,04,??,0C,??,68,??,00,??,53,??,E0

#pragma swi_number=0x1E4
__swi __arm int GetPicNByUnicodeSymbol(int wchar);
//thumb
//pattern=??,06,??,B5,??,09,??,1C,??,3A,??,0E,??,3A,??,4E,??,4D,??,4C,??,4B,??,D1,??,29,??,D2,??,00,??,E0
//pattern=??,B5,??,06,??,09,??,1C,??,3A,??,0E,??,3A,??,4E,??,4D,??,4C,??,4B,??,D1,??,29,??,D2,??,00,??,E0

#pragma swi_number=0x1E5
__swi __arm int EDIT_OpenOptionMenuWithUserItems(void *gui, void (*itemhandler)(USR_MENU_ITEM *item), void *user_pointer, int to_add);
//thumb
//pattern=

#pragma swi_number=0x1E6
__swi __arm void Menu_SetItemCountDyn(void *gui, int n);
//thumb
//pattern_SGOLD=??,B5,??,1C,??,35,??,69,??,1C,??,6A,??,6A,??,6D,??,2A,??,D0,??,42,??,D9,??,38,??,42,??,D9,??,E0,??,42,??,D2,??,1C,??,??,??,??,??,E0,??,42,??,D9,??,1C,??,??,??,??,??,68,??,28,??,D0,??,??,??,??,??,1C,??,??,??,??,??,28,??,D0,??,6B,??,28,??,D0,??,21,??,66,??,68,??,1C,??,69,??,1C,??,47,??,68,??,1C,??,21,??,68,??,1C,??,47,??,??,??,??,??,1C,??,??,??,??,??,28,??,D0,??,6B,??,28,??,D0,??,21,??,66,??,68,??,68,??,1C,??,47,??,BD
//thumb
//pattern=??,B5,??,1C,??,36,??,36,??,1C,??,68,??,1C,??,90,??,68,??,1C,??,??,??,??,??,20,??,30,??,59,??,21,??,28,??,59,??,D0,??,42,??,D9,??,38,??,42,??,D9,??,E0,??,42,??,D2,??,1C,??,1C,??,??,??,??,??,E0,??,42,??,D9,??,1C,??,1C,??,??,??,??,??,68,??,28,??,D0,??,??,??,??,??,1C,??,1C

#pragma swi_number=0x1E7
__swi __arm char *GetLastJavaApplication();
//arm
//pattern=??,??,??,E5,??,??,??,E5,00,00,50,E3,00,??,??,15,00,??,??,03,1E,FF,2F,E1

#pragma swi_number=0x1E8
__swi __arm int IsNoJava();
//arm
//pattern_SGOLD=??,02,1F,E5,14,00,90,E5,1E,FF,2F,E1
//pattern=??,??,1F,E5,10,00,90,E5,1E,FF,2F,E1,??,??,1F,E5,14,00,90,E5

#pragma swi_number=0x1E9
__swi __arm IMGHDR *CreateIMGHDRFromPngFile(const char *fname, int type);

#pragma swi_number=0x1EA
__swi __arm int GetMaxDynIcon(void);
//thumb
//pattern_SGOLD=86,20,70,47
//thumb
//pattern=9C,20,70,47

#pragma swi_number=0x81EB
__swi __arm char *RAM_IMSI(void);
//adr=

#pragma swi_number=0x1EC
__swi __arm void FreeDynIcon(int picture);
//thumb
//pattern_SGOLD=??,??,??,B5,??,18,??,29,??,D8,??,23,??,43,??,??,??,20,??,18,??,60,??,BD,??,A0,??,??,??,??,??,DF,??,20,??,??,??,??,??,??,??,??,??,BD
//thumb
//pattern=??,??,??,B5,??,18,??,28,??,D8,??,??,??,01,??,18,??,68,??,28,??,D1,??,69,??,28,??,D1,??,68,??,28,??,D0,??,??,??,??,??,20,??,60,??,BD

#pragma swi_number=0x1ED
__swi __arm int IsDynIconBusy(int picture);
//thumb
//pattern_SGOLD=??,??,??,B5,??,18,??,28,??,D8,??,23,??,43,??,??,??,18,??,68,??,BD,??,A0,??,??,??,??,??,DF,??,20,??,??,??,??,??,??,??,??,??,20,??,BD
//thumb
//pattern=??,??,??,B5,??,18,??,28,??,D8,??,??,??,01,??,18,??,68,??,BD

#pragma swi_number=0x1EF
__swi __arm void SetDynIcon(int picture,IMGHDR *img,char *bitmap);
//thumb
//pattern_SGOLD=??,??,??,B5,??,18,??,2B,??,??,??,??,??,D8,??,??,??,26,??,18,??,23,??,43,??,??,??,18,??,29,??,D0,??,23,??,60,??,68,??,68,??,2A,??,60,??,60,??,D0,??,60
//thumb
//pattern=??,B5,??,1C,??,??,??,1C,??,18,??,29,??,B0,??,??,??,D8,??,??,??,??,??,18,??,01,??,18,??,2D,??,D0,??,69,??,29,??,D1,??,??,??,??,??,20,??,60,??,CD,??,3D,??,60,??,60,??,2E

#pragma swi_number=0x1F3
__swi __arm unsigned int GetSessionAge(void);
//arm
//pattern=(??????E5000081E51EFF2FE1??????E5000090E51EFF2FE1??????E5000090E51EFF2FE1)+0xC

#pragma swi_number=0x1F5
__swi __arm int sscanf(const char *, const char *, ...);
//thumb
//pattern=0F,B4,00,B5,89,B0,00,90

#pragma swi_number=0x1F6
__swi __arm IMGHDR* GetPitAdrBy0xE200Symbol(int uni_symbol);
//thumb
//pattern_SGOLD=??,B5,??,09,??,39,??,39,??,4D,??,??,??,D1,??,06,??,0E,??,28,??,D2,??,23,??,43,??,??,??,18,??,68,??,29,??,D1,??,30,??,BD
//thumb
//pattern=??,B5,??,09,??,39,??,39,??,??,??,??,??,D1,??,06,??,0E,??,28,??,D3,??,A0,??,??,??,??,??,1C,??,20,??,??,??,??,??,28,??,D0,??,DF,??,E0

#pragma swi_number=0x81FB
__swi __arm char *RamMediaIsPlaying();
//thumb
//pattern=

#pragma swi_number=0x1FC
__swi __arm void CloseCSM(int id);
//thumb
//pattern_SGOLD=??,B5,??,4D,??,1C,??,1C,??,68,??,??,??,??,??,68,??,20,??,42,??,D1,??,60,??,68,??,42,??,D1,??,60,??,BD
//thumb
//pattern_SGOLD_X75=??,B5,??,1C,??,??,??,??,??,4E,??,4D,??,42,??,D1,??,69,??,E0,??,68,??,1C,??,??,??,??,??,??,??,??,??,42,??,D1,??,69,??,E0

#pragma swi_number=0x201
__swi __arm void SetProp2ImageOrCanvas(DRWOBJ *, RECT *, int zero, IMGHDR *Image, int bleed_x, int bleed_y);
//thumb
//pattern=FF,B5,81,B0,04,1C,05,20

#pragma swi_number=0x202
__swi __arm void fillTriangle(int x1, int y1, int x2, int y2, int x3, int y3, int flag, char *pen, char *brush);
//thumb
//pattern=??,B5,??,B0,??,99,??,9C,??,AF,??,1C,??,43,??,CF,??,D0,??,29,??,D1,??,20

#pragma swi_number=0x203
__swi __arm void SetPixel(int x,int y,char *color);
//thumb
//pattern=??,B5,??,1C,??,78,??,1C,??,1C,??,28,??,B0,??,D0,??,1C,??,22,??,21,??,96,??,A8

#pragma swi_number=0x204
__swi __arm void drawArc(int x1,int y1,int x2,int y2,int a1,int a2,int flag,char *pen,char *brush);
//thumb
//pattern=??,B5,??,B0,??,9D,??,20,??,90,??,2D,??,9C,??,9E,??,9F,??,D0,??,20,??,30,??,42,??,DC

#pragma swi_number=0x205
__swi __arm void SetProp2Square_v1(void);
//thumb
//pattern=??,B5,04,1C,04,20,06,9D,20,70

#pragma swi_number=0x206
__swi __arm void srand(unsigned int seed);
//thumb
//pattern=30,B4,??,4A,17,21,11,60,36,21

#pragma swi_number=0x207
__swi __arm void DrawScrollString(WSHDR *WSHDR,int x1,int y1,int x2,int y2,int xdisp,int font,int text_attribute,const char *Pen,const char *Brush);
//thumb
//pattern=??,B5,??,B0,??,9C,??,9D,??,9F,??,1C,??,D0,??,68,??,28,??,D1,??,A0,??,??,??,??,??,4C,??,1C,??,20,??,??,??,??,??,28,??,D0,??,DF,??,22,??,1C,??,20,??,4B,??,E0,??,DF,??,22,??,1C,??,20,??,4B,??,E0,??,2D,??,DB,??,??,??,??,??,42,??,DC,??,A0

#pragma swi_number=0x208
__swi __arm int Get_WS_width(WSHDR *ws, int font);
//thumb
//pattern=??,B5,??,B0,??,1C,??,20,??,25,??,95,??,90,??,AB
//thumb
//pattern_SGOLD=??,B5,D3,B0,00,20,00,26,52,96

#pragma swi_number=0x209
__swi __arm void *FindGUIbyId(int id, CSM_RAM **csm);
//thumb
//pattern=??,1C,??,1C,??,48,??,B5,??,68,_blf(??,B5,??,1C,??,1C,??,1C,??,1C,??,68,??,??,??,??,??,28,??,D1,??,1C,??,1C,??,1C,??,6A,??,??,??,??,??,BD,30,B5),??,BD
//thumb
//pattern_SGOLD=0A,1C,01,1C,??,??,80,B5,80,68,_blf(70,B5,0E,1C,00,21,15,1C,00,28),80,BD
//thumb
//pattern_SGOLD_X75=??,B5,??,1C,??,1C,??,??,??,??,??,49,??,4A,??,42,??,D1,??,69,??,E0,??,68,??,1C,??,1C,_blf(70,B5,0E,1C,00,21,15,1C,00,28),??,BD

#pragma swi_number=0x20A
__swi __arm void EDIT_SetDate(void *gui,int n,TDate *dd);
//thumb
//pattern=
//smelter=??,B5,??,30,??,68,{??,B5,??,1C,??,1C,??,1C,??,??,??,??,??,28,??,D0,??,1C,{??,B5,??,1C,??,1C,??,78,??,20,0A,29},??,34,??,68,??,1C,??,??,??,??,??,BD},??,BD + 1

#pragma swi_number=0x20B
__swi __arm void EDIT_SetTime(void *gui,int n,TTime *tt);
//thumb
//pattern=??,B5,??,30,??,68,{??,B5,??,1C,??,1C,??,1C,??,??,??,??,??,28,??,D0,??,1C,{??,B5,??,1C,??,1C,??,78,??,20,0B,29},??,34,??,68,??,1C,??,??,??,??,??,BD},??,BD + 1

#pragma swi_number=0x20C
__swi __arm void EDIT_GetDate(void *gui,int n,TDate *dd);
//thumb
//pattern=
//smelter=??,B5,??,30,??,68,{??,B5,14,1C,??,??,??,??,??,28,??,D0,??,1C,{??,B5,??,1C,??,78,??,1C,??,25,0A,28},??,BD},??,BD + 1

#pragma swi_number=0x20D
__swi __arm void EDIT_GetTime(void *gui,int n,TTime *tt);
//thumb
//pattern=
//smelter=??,B5,??,30,??,68,{??,B5,14,1C,??,??,??,??,??,28,??,D0,??,1C,{??,B5,??,1C,??,78,??,1C,??,25,0B,28},??,BD},??,BD + 1

#pragma swi_number=0x20E
__swi __arm int ConstructEditTime(EDITCONTROL *EditControl,TTime *time);
//thumb
//pattern=??,B5,??,1C,??,1C,??,78,??,20,0B,29,??,D1,??,1C,??,??,??,??,??,90,??,1C,??,??,??,??,??,90,??,1C

#pragma swi_number=0x20F
__swi __arm int ConstructEditDate(EDITCONTROL *EditControl,TDate *date);
//thumb
//pattern=??,B5,??,1C,??,1C,??,78,??,20,0A,29,??,D1,??,1C,??,??,??,??,??,90,??,1C,??,??,??,??,??,90,??,1C

#pragma swi_number=0x212
__swi __arm int CardExplGetCurItem(void *csm);
//arm
//pattern=??,??,??,E9,??,??,??,E1,??,??,??,??,??,??,??,E3,??,??,??,0A,??,??,??,E5,??,??,??,E3,??,??,??,13,??,??,??,08,??,??,??,0A,??,??,??,E3,??,??,??,1A,??,??,??,E1,??,??,??,??,??,??,??,E1,??,??,??,E1,??,??,??,??,??,??,??,E2,??,??,??,E8,??,??,??,E3,??,??,??,EA

#pragma swi_number=0x213
__swi __arm void CardExplGetFName(void *csm, int cur_item, WSHDR *dest);
//arm
//pattern=??,??,??,E9,??,??,??,E1,??,??,??,E1,??,??,??,E0,??,??,??,E1,??,??,??,E1,??,??,??,E1,??,??,??,??,??,??,??,E3,??,??,??,11,??,??,??,18,??,??,??,1A,??,??,??,E8

#pragma swi_number=0x214
__swi __arm void wstrcpybypos(WSHDR *dest,WSHDR *src,int from,int len);
//thumb
//pattern_SGOLD=??,B5,??,1C,??,1C,??,??,??,??,??,42,??,D2,??,1C,??,??,??,??,??,1C,??,1C,??,1C,??,??,??,??,??,BD

#pragma swi_number=0x215
__swi __arm void wsRemoveChars(WSHDR *ws,int from,int to);
//thumb
//pattern=??,B5,??,28,??,D0,??,68,??,88,??,42,??,D3,??,2A,??,D0,??,29,??,D0,??,??,??,??,??,BD
//thumb
//pattern_SGOLD=??,B5,??,28,??,D0,??,68,??,88,??,42,??,D3,??,2A,??,D0,??,??,??,??,??,BD

#pragma swi_number=0x216
__swi __arm void wstrcatprintf(WSHDR *,const char *format,...);
//thumb
//pattern=??,B4,??,B5,??,B0,??,B0,??,1C,??,22,??,32,??,46,??,A9,??,??,??,??,??,1C,??,98,??,??,??,??,??,1C,??,1C,??,99,??,??,??,??,??,A8,??,90,??,1C,??,??,??,??,??,1C,??,1C,??,1C,??,AB,??,??,??,FC,??,B0,??,B0,??,BC,??,BC,??,B0,??,47

#pragma swi_number=0x217
__swi __arm int CreateMultiLinesMenu(int dummy,int dummy2,const ML_MENU_DESC *,const HEADER_DESC *,int to_item,int n);
//thumb
//pattern=??,B5,??,4E,??,B0,??,1C,??,1C,??,9F,??,49,??,??,??,??,??,1C,??,99,??,??,??,??,??,1C,??,1C,??,??,??,??,??,2D,??,D0,??,1C,??,1C,??,1C,??,??,??,??,??,1C,??,1C,??,4A,??,??,??,??,??,1C,??,99,??,??,??,??,??,1C,??,??,??,??,??,B0,??,BD
//thumb
//pattern_SGOLD=??,B5,??,??,??,B0,??,1C,??,1C,??,9F,??,??,??,??,??,??,??,1C,??,99,??,??,??,??,??,1C,??,1C,??,??,??,??,??,2D,??,D0,??,1C,??,1C,??,1C,??,??,??,??

#pragma swi_number=0x218
__swi __arm void SetMLMenuItemText(void *data,void *item,WSHDR *ws1,WSHDR *ws2,int n);
//thumb
//pattern=??,B5,??,B0,??,99,??,1C,??,??,??,??,??,28,??,D0,??,??,??,??,??,1C,??,22,??,99,??,??,??,??,??,1C,??,30,??,68,??,22,??,69,??,2B,??,D0,??,61
//thumb
//pattern_SGOLD=??,B5,??,1C,??,68,??,B0,??,69,??,29,??,D0,??,6A,??,28,??,D1,??,1C,??,??,??,??,??,28,??,D0,??,20,??,59

#pragma swi_number=0x219
__swi __arm void *AllocMLMenuItem(void *data);
//thumb
//pattern=??,B5,??,1C,_blf(F8,B5,05,1C,FF,30,81,30,01,68,48,20,88,47),??,1C
//thumb
//pattern_SGOLD=??,B5,??,1C,_blf(F8,B5,06,1C,05,1C,C0,36,31,6A,48,20,88,47),??,1C,C0,6B,FF,21

#pragma swi_number=0x21A
__swi __arm int EDIT_SetTextInvert(void *gui,int cursor_pos,int len);
//thumb
//pattern=
//thumb
//pattern_SGOLD=80,B5,00,6D,{80,B5,C0,6C,{80,B5,80,6A,01,23,??,??,??,??,80,BD},80,BD},80,BD+1

#pragma swi_number=0x21B
__swi __arm void EDIT_RemoveTextInvert(void *gui);
//thumb
//pattern=
//thumb
//pattern_SGOLD=??,B5,??,6D,{??,B5,??,6C,{??,B5,??,6A,{00,21,70,30,01,71,70,47},??,BD},??,BD},??,BD+1

#pragma swi_number=0x21C
__swi __arm int EDIT_IsBusy(void *gui);
//thumb
//pattern=??,B5,??,30,??,68,{??,B5,??,30,??,68,{00,68,40,05,C0,0F,70,47},??,BD},??,BD+1

#pragma swi_number=0x21D
__swi __arm int GSMTXT_Decode(WSHDR *dest,void *pkt,int len,int encoding_type, void *(*malloc_adr)(int), void (*mfree_adr)(void));
//thumb
//pattern=??,B5,??,1C,??,1C,??,1C,??,1C,??,AB,??,21,??,9D,??,71,??,21,??,91,??,A9,??,46

#pragma swi_number=0x21E
__swi __arm void FocusGUI(int id);
//thumb
//pattern=??,22,??,1C,??,48,??,B5,??,68,_blf(??,B5,??,1C,??,1C,??,1C,??,46,??,6F,??,??,??,??,??,28,??,D0,??,6E,??,68,??,20,??,47,??,1C),??,BD
//thumb
//pattern_SGOLD=??,1C,??,48,??,B5,??,68,_blf(??,B5,??,1C,??,6D,??,1C,??,46,??,??,??,??,??,28,??,D0,??,6C,??,68,??,20,??,47,??,28,??,D0,??,21,??,60,??,49,??,60,??,61,??,99,??,68,??,61,??,61,??,1C,??,1C,??,30,??,??,??,??),??,BD
//thumb
//pattern_SGOLD_X75=??,B5,??,1C,??,??,??,??,??,49,??,4A,??,42,??,D1,??,68,??,E0,??,68,??,1C,_blf(??,B5,??,1C,??,6D,??,1C,??,46,??,??,??,??,??,28,??,D0,??,6C,??,68,??,20,??,47,??,28,??,D0,??,21,??,60,??,49,??,60,??,61,??,99,??,68,??,61,??,61,??,1C,??,1C,??,30,??,??,??,??),??,BD

#pragma swi_number=0x21F
__swi __arm void UnfocusGUI(void);
//thumb
//pattern=??,48,??,B5,??,68,_blf(??,B5,??,1C,??,68,??,68,??,28,??,D0,??,68,??,29,??,D0,??,68,??,2A,??,D0,??,21,??,47),??,BD
//thumb
//pattern_SGOLD=??,48,??,B5,??,68,_blf(??,B5,??,1C,??,68,??,68,??,28,??,D0,??,68,??,29,??,D0,??,68,??,2A,??,D0,??,21,??,47,??,6C,??,68,??,68,??,68,??,68,??,69,??,47,??,1C,??,??,??,??,??,1C,??,??,??,??,??,68,??,20,??,60,??,BD),,??,BD
//thumb
//pattern_SGOLD_X75=??,B5,??,??,??,??,??,49,??,4A,??,42,??,D1,??,68,??,E0,??,68,_blf(??,B5,??,1C,??,68,??,68,??,28,??,D0,??,68,??,29,??,D0,??,68,??,2A,??,D0,??,21,??,47,??,6C,??,68,??,68,??,68,??,68,??,69,??,47,??,1C,??,??,??,??,??,1C,??,??,??,??,??,68,??,20,??,60,??,BD),??,BD

#pragma swi_number=0x225
__swi __arm int PlayMelody_ChangeVolume(int handle,int volume);
//arm
//pattern=??,??,??,E9,??,??,??,E2,??,??,??,E1,??,??,??,??,??,??,??,E3,??,??,??,0A,??,??,??,E2,??,??,??,??,??,??,??,E3,??,??,??,E5,??,??,??,E5,??,??,??,E1,??,??,??,??,??,??,??,E1,??,??,??,E1,??,??,??,??,??,??,??,E3,??,??,??,E2,??,??,??,E8
//arm
//pattern_SGOLD=??,??,??,E9,??,??,??,E1,??,??,??,E1,??,??,??,??,??,??,??,E3,??,??,??,0A,??,??,??,E1,??,??,??,??,??,??,??,E3,??,??,??,E2,??,??,??,??,??,??,??,E1,??,??,??,??,??,??,??,E1,??,??,??,E1,??,??,??,??,??,??,??,E3,??,??,??,E8

#pragma swi_number=0x226
__swi __arm int PlayMelody_StopPlayback(int handle);
//arm
//pattern=??,??,??,E9,??,??,??,E1,??,??,??,??,??,??,??,E3,??,??,??,0A,??,??,??,E1,??,??,??,??,??,??,??,E3,??,??,??,0A,??,??,??,E1,??,??,??,??,??,??,??,E3,??,??,??,13,??,??,??,18,??,??,??,E3,??,??,??,E8
//arm
//pattern_SGOLD=??,??,??,E9,??,??,??,E1,??,??,??,??,??,??,??,E3,??,??,??,0A,??,??,??,E1,??,??,??,??,??,??,??,E3,??,??,??,0A,??,??,??,E1,??,??,??,??,??,??,??,E3,??,??,??,13,??,??,??,18,??,??,??,E3,??,??,??,E8

#pragma swi_number=0x227
__swi __arm int PlayMelody_PausePlayback(int handle);
//arm
//pattern=??,??,??,E9,??,??,??,E1,??,??,??,??,??,??,??,E3,??,??,??,0A,??,??,??,E1,??,??,??,??,??,??,??,E3,??,??,??,13,??,??,??,18,??,??,??,E3,??,??,??,E8,10,40,2D,E9
//arm
//pattern_SGOLD=??,??,??,E9,??,??,??,??,??,??,??,E1,??,??,??,0A,??,??,??,E3,??,??,??,E5,??,??,??,E5,??,??,??,E1,??,??,??,??,??,??,??,E1,??,??,??,E1,??,??,??,??,??,??,??,E1,??,??,??,E1,??,??,??,??,??,??,??,E3,??,??,??,E8

#pragma swi_number=0x228
__swi __arm int PlayMelody_ResumePlayBack(int handle);
//arm
//pattern=??,??,??,E9,??,??,??,E1,??,??,??,??,??,??,??,E3,??,??,??,0A,??,??,??,E1,??,??,??,??,??,??,??,E3,??,??,??,13,??,??,??,18,??,??,??,E3,??,??,??,E8,38,40,2D,E9
//arm
//pattern_SGOLD=??,??,??,E9,??,??,??,??,??,??,??,E1,??,??,??,0A,??,??,??,E3,??,??,??,E1,??,??,??,E5,??,??,??,E1,??,??,??,??,??,??,??,E1,??,??,??,E1,??,??,??,??,??,??,??,E1,??,??,??,E1,??,??,??,??,??,??,??,E3,??,??,??,E8

#pragma swi_number=0x229
__swi __arm void longjmp(jmp_buf, int);
//arm
//pattern=??,??,??,E2,??,??,??,E1,??,??,??,E5,??,??,??,EB,??,??,??,E9,??,??,??,EB,??,??,??,E1,??,??,??,03,??,??,??,E9,??,??,??,E9,??,??,??,E1

#pragma swi_number=0x52
__swi __arm char *GetIlluminationDataTable();
//arm
//pattern_SGOLD=D8,00,9F,E5,1E,FF,2F,E1

#pragma swi_number=0x0035
__swi __arm void AlarmClockRing();
//thumb
//pattern_SGOLD=??,B5,??,49,??,24,??,48,??,60,??,80,??,??,??,??,??,28,??,D0,??,1C,??,22,??,21,??,94,??,48,??,??,??,??,??,20,??,BD

#pragma swi_number=0x22A
__swi __arm void FreeGSMTXTpkt(void *pkt);
//thumb
//pattern=70,47,??,B5,??,1C,??,1C,??,1C,??,1C,??,??,??,??,??,??,??,??,??,1C,??,20,??,??,??,??,??,28,??,D0,??,1C,??,1C,??,1C,??,1C,??,??,??,??,??,??,??,??,??,BD
//thumb
//pattern_SGOLD=??,B5,??,1C,??,??,??,??,??,??,??,20,??,35,??,00,??,58,??,42,??,D1,??,??,??,32,??,5C,??,31,??,06,??,0E,??,54,??,D1,??,00,??,59,??,??,??,??,??,20,??,51,??,E0,??,30,??,06,??,0E,??,28,??,D3,??,??,??,??,??,BD
