// RAM-Monitor (c) benj9
// for use with Log LR to RAM

#define M65v50

#include "..\shared\x65.h"

#ifdef M65v50
	#define _GetProfile_ (0xA08C9FE4+1)
	#define _Sprintf_ 0xA153E501
	
//	#define _VarRAM_   0xA8000200 // any free RAM for the patch
	#define _CheckRAM_ 0xA8000230 // the RAM to analyze

//	#define _Dec2Hex_ (0xA082BE20+1)
//	#define _PlaySoundLoop_ 0xA0935CF8 
#endif

#ifdef SL65v50
	#define _GetProfile_ (0xA08CBB4C+1)
	#define _Sprintf_ (0xA1548DEC+1)
	
	#define _VarRAM_   0xA8000200 // any free RAM for the patch
	#define _CheckRAM_ 0xA80FFF00 // the RAM to analyze 
#endif


#ifdef CX70v56
	#define _GetProfile_ (0xA08D1999)
	#define _Sprintf_ 0xA1610211
	
	#define _VarRAM_   0xA8000200 // any free RAM for the patch
	#define _CheckRAM_ 0xA80FFF00 // the RAM to analyze 
#endif


//struct VarRam{
//;	word w0; int profile, dist, offset;
//};

struct CheckRam {
	dword w0, w1; byte notfirstrun; 
};

//g_GetProfile GetProfile = (g_GetProfile)_GetProfile_;
//g_PlaySoundLoop PlaySoundLoop = (g_PlaySoundLoop) _PlaySoundLoop_;
f_sprintf sprintf = (f_sprintf) _Sprintf_;

void copystrtowstr(char *src, unsigned short *dest, unsigned int*count) {
	while(*src != 0) {
		*dest++ = *src++;
		*count += 1;
	}	
}


void Custom_Format(struct WString* pws) {

   //struct VarRam* varRam = (struct VarRam *) _VarRAM_;
   struct CheckRam* checkRam = (struct CheckRam *) _CheckRAM_;

	unsigned int count = 1; // int i=0; int j;
	unsigned short *p = pws->pstr; 
	char string[32];
	
	if (checkRam->w0==0) {
		if (checkRam->notfirstrun==0)
			sprintf(string,"[code not yet called]");
		else
			sprintf(string,"[patch ram corrupted!");
	} else {
		if (checkRam->notfirstrun==0) {
			checkRam->w1=checkRam->w0;
			checkRam->notfirstrun=1;
			sprintf(string, "First call:%x", checkRam->w1-0xA0000000);
		} else {
			sprintf(string, "F:%x L:%x", checkRam->w1-0xA0000000, checkRam->w0-0xA0000000);
		}
	}

	copystrtowstr(string, &p[count], &count);
	
	*p = count-1;
	return;
}

void entryMainscreen(struct WString* pws) {
	Custom_Format(pws);
	return;
}