// (c) benj9

// based on code of (c) 2005 ACiD[mrp]

#define M65v50

#include "..\shared\x65.h"

#ifdef M65v50
	#define _DrawImg_ (0xA16341BC+1)
	#define _GetSelectedProfile_ (0xA08C9FE4+1)
	#define _PlaySoundLoop_ 0xA0935CF8 
	#define _PlaySound_ 0xA09505FC
	#define _NetData_ 0xA867B0A0
	#define _Var_  0xA8000200 // 0xA16E00E4	
	#define _Dec2Hex_ (0xA082BE20+1)
	#define _DrawMainscreen_ (0xA163B09C+1)
	#define _GetImageWidth_ (0xA114E024+1)

#endif


#ifdef M65v43
	#define _DrawImg_ (0xA163AD10+1)
	#define _GetSelectedProfile_ (0xA08C93E0+1)
	#define _NetData_ 0xA867AF98
#endif

#ifdef S65v47
	#define _DrawImg_ (0xA169E998+1)
	#define _GetSelectedProfile_ (0xA08C88F4+1)
	#define _NetData_ 
#endif

#ifdef S65v50
	#define _DrawImg_ 
	#define _GetSelectedProfile_
	#define _NetData_  
#endif

struct Var{
	byte b0, b1, b2; 
};

typedef int (*g_GetSelectedProfile)(void);
g_GetSelectedProfile GetSelectedProfile = (g_GetSelectedProfile) _GetSelectedProfile_;

DrawImg DrawImage = (DrawImg) _DrawImg_;

GetImageWidth getimagewidth = (GetImageWidth) _GetImageWidth_;

typedef void (*g_PlaySoundLoop)(unsigned int iSoundID, unsigned int unknown1, unsigned int LoopCount);
g_PlaySoundLoop PlaySoundLoop = (g_PlaySoundLoop) _PlaySoundLoop_;

typedef void (*g_PlaySound)(int unknown1, int unknown2, int unknown3, int iSoundID);
g_PlaySound PlaySound = (g_PlaySound) _PlaySound_;

typedef void (*g_Dec2Hex)(unsigned int decnumber);
g_Dec2Hex Dec2Hex = (g_Dec2Hex) _Dec2Hex_;

typedef void (*g_DrawMainscreen)(void);
g_DrawMainscreen DrawMainscreen = (g_DrawMainscreen) _DrawMainscreen_;

	const  x_NetIndiNormal=0x00;
	const  y_NetIndiNormal=0x03;
	const  x_NetIndiImproved=0x65;
	const  y_NetIndiImproved=0x90;
	const  x_ProfileLogo=0x01;
	const  y_ProfileLogo=0x95;
	
	const FirstPic = 0 ; //1123
	const NumOfPics = 1160;
	
	const FirstNetPic=0; //808
	const LastNetPic=1100; //825




void Net_Display(int x, int y, int PictureIndex) 
{
	const struct NetData* net = (struct NetData *) _NetData_;
	struct Var* var = (struct Var *)_Var_;

	
	int i=0; byte m; int xo=0; int img;

	/* mode:
	0  NetNormal
	1  ProfileLogo
	2  NetNormal & ProfileLogo
	3  NetImproved
	4  NetNormal & NetImproved
	5  NetImproved & ProfileLogo
	6  NetNormal & NetImproved & ProfileLogo
	
	Dont forget to place mode in vkp at (0xA16E00D8)
	 */
		if ((GetSelectedProfile()>=5)&&(GetSelectedProfile()<=6)){

      	var->b0 += 1;
      	if (var->b0 > NumOfPics) var->b0=0;
      	if (var->b0<10) DrawImage(112,30,var->b0 + 1183);
      	img = var->b0 + FirstPic;
      	// if (var->b0 >10) i=getimagewidth(img);
      	DrawImage((132-getimagewidth(img))/2,65,img);
      	}

	    if (GetSelectedProfile()==6){
     	if (var->b1 > 0) { 
     		if (var->b1 > 1) { 
     			var->b2 +=1; var->b1=0;
     			if (var->b2 > 0xff) var->b2=0;
     			PlaySoundLoop(var->b2, 1, 5);
     		} else var->b1+=1;
     	} else var->b1+=1;
     	
     	}
     	
     	//PlaySoundLoop(3, 2, 10);
	    //PlaySound(0, 0, 0, 2); // Battery empty sound
     	// PlaySoundLoop(var->b1, 1, 7);
     	/* PlaySoundLoop(
     	  1 fiep
     	  3 akku
     	  4 piep, leer
     	  7 freizeichen
     	  11 besetzt
     	  12 kein Anschluss
     	  12 tut tuut
     	  18 hoher schneller sinus
     	  25 dtmf
     	  29 dtmf
     	  33 d
     	  
     	  */
      	
      	//m=var->b0;
      	
      	//var->b0=PictureIndex;
      	
      /*	if ((PictureIndex==808)&&(net->RX<50)){
      		PlaySoundLoop(3, 2, 10); 
      		PlaySoundLoop(0x2F, 1, 5);
      		PlaySound(0, 0, 0, 2); // Battery empty sound
      	} */
      	

//	if ((m==0)||(m==2)||(m==4)||(m==6))
      	DrawImage(x_NetIndiNormal, y_NetIndiNormal, PictureIndex); //normal Netlogo
//	if ((m==1)||(m==2)||(m==5)||(m==6))
       	DrawImage(x_ProfileLogo,y_ProfileLogo, GetSelectedProfile() + 1198); //profillogo 

        //Typ: M65: 225-284;
 //	if  ((m>=3)&&(m<=6)) {      
		xo -= 5;
		for (i=0; i<6; i++) {
			if (net->CH < 0xFF)
				PictureIndex = 0x303 + 434; 
			else
				PictureIndex = 0x30A+ 434;
			if (net->RX < 50)
				PictureIndex = 0x311+ 434;
			else if (net->RX < 62)
				PictureIndex += 6;
			else if (net->RX < 69)
				PictureIndex += 5;
			else if (net->RX < 76)
				PictureIndex += 4;
			else if (net->RX < 83)
				PictureIndex += 3;
			else if (net->RX < 90)
				PictureIndex += 2;
			else if (net->RX < 97)
				PictureIndex += 1;
			else if (net->RX < 104)
				PictureIndex += 0;
			else
				PictureIndex = 0x311+ 434;
			xo += 5;
			DrawImage(x_NetIndiImproved+xo,y_NetIndiImproved,PictureIndex);
		++net;
		}  // }
		
		
		i=getimagewidth(img);

}