; Key Sequencer Test
; prototype
; m65v50 (c) benj9 
   

		AREA benj9, CODE, READONLY  
            
		ENTRY
		GBLA	TYPE	;1 for M65v50, 2 for SL65v50

TYPE	SETA	1 						

 IF  TYPE = 1

;free_ram_dword			EQU 0xA8000204
;ram_basement			EQU	0xA8752F00
; ram usage: 
; [ram_basement+0] hotkey-mode
; [ram_basement+1]... sequence record buffers 

; _ram_keypress_buffer	EQU 0xA114CCF0

; internally functions addresses downstairs

; plug-in funtion addresses
PlaySoundLoop		EQU	0xA0935CF8
SwitchPhoneOff		EQU 0xA1240938
SetProfile			EQU	0xA08C9EB3
DevM_NativeMenu		EQU	0xA08E714B
DevM_Sexit			EQU 0xA0903FE1
DevM_Configuration	EQU 0xA0904301
Usr_Setup			EQU	0xA08E1AF1
Usr_FlashExplorer 	EQU 0xA08E1A35
Usr_AlarmClock		EQU 0xA08E19DF
Usr_Messages		EQU 0xA08E19BD 
Usr_New_Messages	EQU 0xA0A2C19B
Usr_Organizer       EQU 0xA08E19A9
Usr_Camera			EQU 0xA08E1A05
Usr_SMS_new			EQU 0xA08E19C9

; Usr_SoundRecorder	EQU 0xA08E219B
; Usr_StopWatch	 	EQU 0xA08E19F1
; Usr_MyMenu		EQU 0xA08E2131
; Usr_CountDown 	EQU 0xA08E19FB
; Usr_Downloads		EQU	0xA08E1A81
; Usr_Pictures		EQU 0xA08E1A8B
; Usr_DynamicLight 	EQU 0xA08E1BA3
; A08E1BB3             usr_Ringtones
; A08E1C7F             usr_ClockSetup_TimeDate
; A08E19E9             usr_Calc

; constants
number_of_sequence_records	EQU 0x21 ; !!!!!
profile_key				EQU 63 ; 0n00111111 

hotkey					EQU	"*" ; 
sp_param				EQU	0x14 ; 5 additional parameters needed. 4x4=0x10
sp_sub_1				EQU	0x1C ; 7 pushes
sp_sub_2				EQU 0x14 ; PUSH {R0-R3,R7}: 5 regs pushed, 5*4=0x14
sp_ActionPerformed		EQU 0    ; [SP,#0] ; SequAccepted&ActionPerformed(FF=False)
sp_Keylock_State		EQU 4    ; [SP,#4] ; KeyUnlock_State
sp_SequenceRecords 		EQU 8    ; [SP,#8] ; number of sequence records
sp_ScanKeySequencesMode	EQU 0xC  ; [SP,#0xC] ; scan_key_sequences - mode. 0=direct mode. 1=after hotkey mode.
sp_AnySequenceTouched	EQU 0x10 ; [SP,#0x10] ; is in ScanKeySequences the key in at least one sequence?
;[_ram_mainscreen_menu_state_,#2] ; Mainscreen_Menu_State. 0 on boot, FF on everything else then mainscreen 

FF					EQU 0xFF

 ENDIF
 
 
; ram_basemen+3t: count_key_in_sequence[0], ..., count_key_in_sequence[n-1]
; count_key_in_sequence=0: not entered. =n: n keys accepted.

; -----------------------------------------------------------------------------

 CODE16			
 				
	 				NOP 
	 				; B		start
					; DCB		"KeySeq1,benj9" 
				
m_start				PUSH	{R0-R7,LR}

					CMP		R0,#"*"
					BEQ		m_exit
					
					CMP		R0,#0x11
					BEQ		m_exit
					
					CMP		R0,#0x1
					BEQ		m_exit
					
					CMP		R0,#"#"
					BNE		m_normal
					MOV		R0,#12
					BL		_push_char
					B		m_exit
					
m_normal			LSL     R1,R0,#0x18 ; key_off=key_on+0x80
					BMI     m_off_exec ; is negative?	
					B		m_on_exec
m_on_exec			LDR		R1,Keypress_On_Store2Ram_
					B		m_exec
	
m_off_exec			LDR		R1,Keypress_Off_Store2Ram_

m_exec				BLX		R1

m_exit				POP		{R0-R7,PC}

_push_char			PUSH	{R0-R4,LR}
					MOV		R4,R0
					LDR		R1,Keypress_On_Store2Ram_
					BLX		R1
					MOV		R0,R4
					ADD		R0,#0x80
					LDR		R1,Keypress_Off_Store2Ram_
					BLX		R1
					POP		{R0-R4,PC}
					
 ; Keys: 0-9=0x30-0x39. *=0x2A. #=0x23
 ; left softkey=0x01. right softkey=0x04. red button=0x0C. green button=0x0B.
 ; joystick: up=0x3B. down=0x3C. left=0x3D. right=0x3E. click=0x1A.
  ; providerkey=0x11. sidekey: up=0xD. down=0xE. dictaphone=0x6
; -----------------------------------------------------------------------------
 IF  TYPE = 1
; m65v50 function addresses needed by patch core 
Keypress_On_Store2Ram_		DCD 0xA114C9D3
Keypress_Off_Store2Ram_		DCD 0xA114CA91
 ENDIF
 IF  TYPE = 2
; sl65v50 function addresses needed by patch core 
Keypress_On_Store2Ram_		DCD 0xA1150227
Keypress_Off_Store2Ram_		DCD 0xA11502E5
 ENDIF


 

; -----------------------------------------------------------------------------
 END
 				
