

		AREA data_keys, CODE, READONLY 

;free_ram_dword			EQU 0xA8000204
;ram_basement			EQU	0xA8752F00
; ram usage: 
; [ram_basement+0] hotkey-mode
; [ram_basement+1]... sequence record buffers 

; _ram_keypress_buffer	EQU 0xA114CCF0

; internally functions addresses downstairs

; plug-in funtion addresses
PlaySoundLoop		EQU	0xA0935CF8
SwitchPhoneOff		EQU 0xA1240938
SetProfile			EQU	0xA08C9EB3
DevM_NativeMenu		EQU	0xA08E714B
DevM_Sexit			EQU 0xA0903FE1
DevM_Configuration	EQU 0xA0904301
Usr_Setup			EQU	0xA08E1AF1
Usr_FlashExplorer 	EQU 0xA08E1A35
Usr_AlarmClock		EQU 0xA08E19DF
Usr_Messages		EQU 0xA08E19BD 
Usr_New_Messages	EQU 0xA0A2C19B
Usr_Organizer       EQU 0xA08E19A9
Usr_Camera			EQU 0xA08E1A05
Usr_SMS_new			EQU 0xA08E19C9

; Usr_SoundRecorder	EQU 0xA08E219B
; Usr_StopWatch	 	EQU 0xA08E19F1
; Usr_MyMenu		EQU 0xA08E2131
; Usr_CountDown 	EQU 0xA08E19FB
; Usr_Downloads		EQU	0xA08E1A81
; Usr_Pictures		EQU 0xA08E1A8B
; Usr_DynamicLight 	EQU 0xA08E1BA3
; A08E1BB3             usr_Ringtones
; A08E1C7F             usr_ClockSetup_TimeDate
; A08E19E9             usr_Calc

FF					EQU 0xFF

 
		
		EXPORT sequences

		ALIGN
			
; key sequence records
; sequences: set number of records in constant <number_of_sequence_records> !
; sequence order: if you have sequences, that are also part of other sequences, put the small after the long sequences!
; structure:

; one record has 16 bytes. 
; 0  1  2  3     4  5  6  7  8 9 A B C  D  E  F
; function/action R0 R1 R2 R3 KKKKKKKKKK MM SS LL
 
; meaning of the fields:
; function/action: execute  
; =0xFFFFFFFF midlet, 
; =0xFFFFFFFE keylock, 
; =0xFFFFFFFD device lock on,
; =0xFFFFFFFC device lock off,
; 0- func lib, 
; >A0000000 any function addresses

; R0-R3: when called as function address: registers R0-R3 as bytes.
;        when called as midlet: R0=string number of midlet filenames
; KK  elements of key sequences
 ; Keys: 0-9=0x30-0x39. *=0x2A. #=0x23
 ; left softkey=0x01. right softkey=0x04. red button=0x0C. green button=0x0B.
 ; joystick: up=0x3B. down=0x3C. left=0x3D. right=0x3E. click=0x1A.
 ; providerkey=0x11. sidekey: up=0xD. down=0xE. dictaphone=0x6

; SS,LL post-exit sound. SS=sound number, LL=number of loops. no sound: SS+LL=0


; MM mode bits:
; 7   6  5  4  3  2  1  0
; 128 64 32 16 8  4  2  1
; --------------------
; K1  K2  S1 S2 M1 M2 R H
; H: 1=hotkey or 0=direct.
; keylock: K1: 0=disabled. 1=filter on, K2: 0=only with keyunlock, 1=only with keyunlock
; mainscreen: M1: 0=disabled. 1=filter on, M2: 0=only at mainscreen, 1=everywhere but not at mainscreen
; R: =1send red key after action. 0=dont.

; MM Mode bits:
; mode bit 0: direct or hotkey access of the key sequence 
;   0 = direct access, but leaves keyprints on screen.
;   1 = hotkey access, one key is dedicated as first key, but keyprints on screen are supressed.

; mode bit 1: R: send red key after performed action (use with keylock)
;   0 =             ; no operation 
;   2 =  2          ; send red key after performed action

; mode bits 7-6: K1 K2: keylock
;   0 =             ; unconditional execution 
; 128 = 128         ; only if keylock is off
; 192 = 128 + 64    ; only if keylock is on


; mode bits 5-2; S1 S2 M1 M2: screensaver and mainscreen dependeny modes:
;   0 =             ; unconditional execution
;   8 =        8    ; only if not at mainscreen 
;  12 =        8+4  ; only if at mainscreen
;  32 = 32          ; only if no screensaver
;  40 = 32    +8    ; only if screensaver is off and if not at mainscreen
;  56 = 32+16 +8    ; only if screensaver is on and if not at mainscreen 
;  60 = 32+16 +8+4  ; only if screensaver is on or if at mainscreen  


; pick one number from each of the 4 blocks and add the 4 numbers. That is the MM byte.
; example: 0i169 = 1 + 128 + 0 + 40 = after hotkey, only if keylock is off, only if screensaver is off and if not at mainscreen.

sequences		DCD	09 ; Function Lib: SwitchPhoneOff
				DCD 0
				DCB "2",0x3B,0,0,0 ; 2, joystick_up
				DCB 0 ; execute everywhere & SequenceMode_Snap_Directly
				DCB 0x22,0x3 ; dtmf sound
				
				DCD	0xFFFFFFFC ; unlock device, set screensaver to off
				DCD 0 ; unused
				DCB "9","9","9","9","#" ; 9999 red
				DCB 2 ;  2=send red button
				DCB 0x22,0x1 ; dtmf sound 
				
				DCD	0xFFFFFFFD ; lock device, set screensaver to off
				DCD 0 ; unused
				DCB "9","9","#",0,0 ; ##, red
				DCB 2 ; 2=send red button
				DCB 0x22,0x1 ; dtmf sound
			
				
				DCD	DevM_NativeMenu
				DCD 0
				DCB "0","0",0,0,0 ; "00"
				DCB 1 ; SequenceMode_Snap_AfterHotkey
				DCB 0,0 ; no sound
				
				DCD	0xFFFFFFFF ; MIDlet
				DCB	0,0,0,0 ; MIDlet string number 0
				DCB "0","1",0,0,0 ; "01"
				DCB 1 ; by hotkey
				DCB 0x3a,3 
				
				DCD	0xFFFFFFFF ; action MIDlet
				DCB	1,0,0,0 ; MIDlet string number 1
				DCB "0","2",0,0,0
				DCB 1
				DCB 0x3a,3 
				
				DCD	DevM_Sexit
				DCD 0
				DCB "0","#",0,0,0 ;  
				DCB 1 ; hotkey
				DCB 0x3a,3 
				
				DCD	DevM_Configuration
				DCD 0
				DCB "0","9",0,0,0
				DCB	1 ; hotkey
				DCB 0x3a,3
				
				DCD	0xFFFFFFFE ; toggle Keylock
				DCD 0 ; unused
				DCB "#","#",0,0,0 ; ##
				DCB 192 +2 ; if keylock, 2=send red button
				DCB 0x23,0x4 ; dtmf sound 
				
				DCD	0xFFFFFFFE ; toggle Keylock
				DCD 0 ; unused
				DCB "#","#",0,0,0 ; ##
				DCB 128 + 60 +2 ; 2=send red button. only if nokeylock, [mainscreen] or [screensaver], direct
				DCB 0x23,0x4 ; dtmf sound 
				

				
				
				DCD	Usr_Camera	
				DCD 0
				DCB "5",0x3B,0,0,0 ; 5, joystick_up
				DCB 0
				DCB 0x3a,2
				
				DCD	Usr_New_Messages
				DCD 0
				DCB 0x0B,0x0B,0,0,0 ; read new messages with green key when keylock is on
				DCB (192) + 0 ; only when screen lock is on 
				DCB 0,0
;--1			
				DCD	Usr_New_Messages
				DCD 0
				DCB 0x0B,"1",0,0,0 ; read new messages with green key when keylock is on
				DCB 8+4 + 1 ; when mainscreen on
				DCB 0,0
;--X
				DCD	Usr_Camera	
				DCD 0
				DCB "0","5",0,0,0
				DCB 1
				DCB 0x3a,3
	
				DCD Usr_SMS_new
				DCD 0
				DCB 0x3D,0,0,0,0 ; joy_left
				DCB 1
				DCB 0,0 
				
				DCD	Usr_AlarmClock
				DCD 0
				DCB "0","7",0,0,0
				DCB 1
				DCB 0x3a,3
				; not: scrsav
				
				DCD	Usr_Organizer
				DCD 0
				DCB "0","8",0,0,0
				DCB 32+1
				DCB 0x3a,3
				
				;;;;;;
				
				
				DCD	Usr_Organizer
				DCD 0
				DCB "7","1",0,0,0
				DCB 8+1 ; only if no mainscreen (scrsav also no mainscr)
				DCB 0x3a,3
				; scrsav=1 OR !mainscr=1
				
				DCD	Usr_Organizer
				DCD 0
				DCB "7","2",0,0,0
				DCB 8+4+1 ; only if mainscreen, no screensaver
				DCB 0x3a,3
				; scrsav=0, !scrsav=1, mainscr=1, !mainscr=0
				
				DCD	Usr_Organizer
				DCD 0
				DCB "7","3",0,0,0
				DCB 32+1 ; only if scrsav off
				DCB 0x3a,3
				; scrsav=0, !scrsav=1
				
				DCD	Usr_Organizer
				DCD 0
				DCB "7","4",0,0,0
				DCB 32+16+1 ; !(only if scrsav on), but: always -- useless
				DCB 0x3a,3
				;
				
				DCD	Usr_Organizer
				DCD 0
				DCB "7","5",0,0,0
				DCB 32+8+1 ; only if no mainscreen and no screensaver
				DCB 0x3a,3
				; scrsav=0, !scrsav=0, mainscr=0, !mainscr=1
				
				DCD	Usr_Organizer
				DCD 0
				DCB "7","6",0,0,0 ; only if screensaver or no mainscreen 
				DCB 32+16 +8+1
				DCB 0x3a,3
				; scrsav=1, !scrsav=0, mainscr=0, !mainscr=1
				
				DCD	Usr_Organizer
				DCD 0
				DCB "7","7","7",0,0
				DCB 32+8+4+1 ;  only if mainscreen, no screensaver - double, useless!!
				DCB 0x3a,3
				; scrsav=0, !scrsav=1, mainscr=1, !mainscr=0
				
				DCD	Usr_Organizer
				DCD 0
				DCB "7","8",0,0,0
				DCB 32+16+8+4+1  ; only if  mainscreen or screensaver
				DCB 0x3a,3
 
				DCD	0xFFFFFFFD
				DCD 0
				DCB "1","2","3","4","5"
				DCB 0
				DCB 0x3a,3
		
				DCD	03 ; Function Lib: SetProfile
				DCB 0,0,0,0 ; r0-r3  set profile 1
				DCB "1",0,0,0,0  
				DCB 1+2 
				DCB 0,0 ; no sound

				DCD	03 ; Function Lib: SetProfile
				DCB 1,0,0,0 ; r0-r3  set profile 2
				DCB "2",0,0,0,0     
				DCB 1 
				DCB 0,0 ; no sound
				; not: scrsav

				DCD	03 ; Function Lib: SetProfile
				DCB 2,0,0,0 ; r0-r3  set profile 3
				DCB "3",0,0,0,0    
				DCB 1 
				DCB 0,0 ; no sound
				
				
				DCD	03 ; Function Lib: SetProfile
				DCB 3,0,0,0 ; r0-r3  set profile 4
				DCB "4",0,0,0,0  
				DCB 1 
				DCB 0,0 ; no sound
				; not: scrsav

				DCD	03 ; Function Lib: SetProfile
				DCB 4,0,0,0 ; r0-r3  set profile 5
				DCB "5",0,0,0,0     
				DCB 1 
				DCB 0,0 ; no sound
				; not: scrsav

				DCD	03 ; Function Lib: SetProfile
				DCB 5,0,0,0 ; r0-r3  set profile 6
				DCB "6",0,0,0,0     
				DCB 1 
				DCB 0,0 ; no sound

				DCD	03 ; Function Lib: SetProfile
				DCB 6,0,0,0 ; r0-r3  set profile 7
				DCB "7","0",0,0,0   
				DCB 1+2 
				DCB 0,0 ; no sound
				; not: scrsav
				
				DCD	03 ; Function Lib: SetProfile
				DCB 7,0,0,0 ; r0-r3  set profile 8
				DCB "8",0,0,0,0   
				DCB 1 
				DCB 0,0 ; no sound

				DCD	Usr_FlashExplorer 
				DCD 0
				DCB 0x3B,0,0,0,0 ; joy_up
				DCB	1
				DCB 0,0
				
				DCD	Usr_Setup
				DCD 0
				DCB 0x1A,0,0,0,0 ; joy_click
				DCB 1
				DCB 0,0
				

				


				
				; DCD PlaySoundLoop
				; DCB 0x3a,2,3,0 ; sfx. R0: sound: 3a. R1=2, R2=lenght, R3=0
				; DCB 0x01,0x31,0,0,0,0,0,0 ;  left-sk, 1
				
				; DCD PlaySoundLoop
				; DCB 0x5a,2,0x15,0 ; muuuh
				; DCB 0x01,0x32,0,0,0,0,0,0 ; left-sk,2
				
				; DCD PlaySoundLoop
				; DCB 0x5e,2,0xD,0 ; tadaa!
				; DCB 0x01,0x33,0,0,0,0,0,0 ; left-sk, 3
				
				; DCD PlaySoundLoop
				; DCB 0x22,2,3,0 ; dialtone
				; DCB 0x01,0x34,0,0,0,0,0,0 ; left-sk, 4
				


 END
 				
