;  blink test A0800900
; debugger and recorder :-)
; x65 M65v50 (c) benj9 

		AREA ARMex, CODE, READONLY  
            
		ENTRY
		GBLA	TYPE	;1 for M65v50, 2 for CX6C

TYPE	SETA	1 						

 IF  TYPE = 1


any_free_ram	EQU	0xA8250000
; any_free_ram1	EQU	0xA8250020
Illumination	EQU	0xA0BC78B8 
DrawCanvas		EQU	0xA1634197
DrawImage		EQU 0xA16341BD
wildcard		EQU	0x99999999
traveller		EQU	0xA8001748
_ram_illumination_data EQU 0xA12265F8 ; 


 ENDIF

; SET means: set in armdebugger ram value
;intern ;0=brightn , 4=funcnow, 8=recorder-offset, 
;SET   ;10 mode, 14=toggle-miss-loop-max (start 08)
;		20 functionfilter1, 24  functionfilter2, 28=functionfilter3 2c=filter4
;       30 ff. recorder-store

		CODE16

		
start		

		NOP
	
		PUSH {R0-R7,LR}

		;STMFD   SP!, {R0-R7,LR}
		
		LDR		R5,=any_free_ram

		LDR		R6,[R5,#0x10] ; SET: which mode 0=off, 1=light , 2=Ram Recorder of Functions
		CMP		R6,#0 ; mode
		BEQ		exit
		CMP		R6,#2 
		BEQ		recorder
		
manip	LDR		R6,[R5,#0x20] ; SET: exec only when this function is called
		CMP		R0,R6
		BEQ		tog12
		
		LDR		R6,[R5,#0x24] ; SET: exec only when this function is called
		CMP		R1,R6
		BEQ		tog12
		
		LDR		R6,[R5,#0x28] ; SET: exec only when this function is called
		CMP		R2,R6
		BEQ		tog12
		
		LDR		R6,[R5,#0x2C] ; SET: exec only when this function is called
		CMP		R3,R6
		BNE		exit
		
		
		
tog12	LDR		R2,[R5,#4] ; toggle-funcnow1
		LDR		R3,[R5,#0x14] ; toggle-miss-loop-max
		; MOV		R3,#1
		CMP		R2,R3 ; signal ausdnnen
		BEQ 	step		
		
		ADD		R2,R2,#1
		STR		R2,[R5,#4]  ; incr funcnow
		B 		exit
		
		
		
step	
		MOV		R2,#0
		STR		R2,[R5,#4]	; set toggle_funcnow (brightness)
		
		LDR		R2,[R5] ; toggle_on/off
		MOV 	R1,#0x64 
		SUB		R2,R1,R2
		STR		R2,[R5]


light	MOV		R0,#1   ; 1=fire keypad, 0=screen, 2=dl 
        MOV     R1, #1
        MOV		R3,#4 ; delay/smoothness
        LDR		R5,=Illumination
       	BLX     R5
       	B 	exit

exit	POP 	{R0-R7}
		BLX		R0 ; repatch
		POP 	{PC}
		;LDMFD   SP!, {PC}

recorder
		LDR		R4,=any_free_ram
		LDR		R5,[R4,#8] ; recorder-offset
		
		ADD		R5,R5,#0x30
		STR		R0,[R4,R5] ; store function address
		
		ADD		R5,R5,#0x4
		STR		R1,[R4,R5] ; store function address
		
		ADD		R5,R5,#0x4
		STR		R2,[R4,R5] ; store function address
		
		ADD		R5,R5,#0x4
		STR		R3,[R4,R5] ; store function address
		
		SUB		R5,R5,#0x2C

		STR		R5,[R4,#8] ; recorder-offset
		B		exit

 END
 
 
