; Blinker v2, (c) benj9, m65v50
; blink on events

; IlluminationByLaw & KeepScreenIllumAlive --> Umstellen Bootmetode auf aus, kurz, lang
; doppellicht conf 
; alles confbar machen 
; _get_net_access_, _get_illumination_data_table? funclibben
; 


				AREA Blinker, CODE, READONLY     
				
				EXPORT	illumi32

boot_blink_type					EQU	0x02  ; boot sfx: 0=no, 2=dynamic, 1=startbleep ##conf#
mainscreen_always_on_profile	EQU 4  ; mainscreen always on profile ##conf##	
mainscreen_always_on_brightness	EQU 30 ; ##conf##
brightness						EQU 60 ; conf only in ads

; simplified function: master_loop is running approx 1x/sec and checks for events.
; if events found, according blink engine is started. master_loop doest run meanwhile,
; last call of blink module restarts master_loop

; entry blinker_start starts dynamic_blink_module for boot effects, that starts after ending the master_loop.
		
	
; NOTE: cause the functions call each other by "CallAfterTimer", they cannot communicate by Registers, only by RAM
				
; free_ram usage:
; 0-7:	timer data 
; 8-9:	illumination toggler internal
; A:	DynamicBlinker polarity
; B:	SequenceBlinker internal position
; C:	SequenceBlinker Sequence-Pattern#. 0=netlost, 1-3 missed events 1-3
; D: 	MissedEventsResult (FF if not set)
; E: 	DynamicBlinker Parameter: lo value (time, 1sec=ca-225)
; F: 	DynamicBlinker Parameter: hi value (time, 1sec=ca-225)
; 10:	DynamicBlinker Parameter: step-divide-by
; 11:	DynamicBlinker Parameter: blink type
; 12:	Lock after running entryp first time
; 13:	NetBlinker wait time for next blink call. 
; 14:	IlluminationToggler:  if 1, blinker blinks only when fw thinks that illumination is on. else zero
; 15:	SetIllumination-Is-Called-By-Blinker message (0=false)
; 16:	Illumination State by Law (what the firmware thinks about illumination on or off)
; 17:	permit for _set_illumination which illumination output (0=off, 1=screen only, 2=kpl only, 3=both) is generatet
; 18-19: current profile codes
; 1A:   Illumination-Toggler Illu-Hi-Value
; -----------------------------------------------------------------------------

				DCB	"Blinker2  benj9"


; ========================================================================================	
; SetIllumination Patch
; ========================================================================================	

; Called by SetIllumination Entrypoint
				CODE32
				ENTRY

illumi32		STMFD	SP!,{R3,R6,LR} ; return is at: "illumi16_x  POP {R3,R6,PC}"
				LDR		R7, _illumi16
				BX		R7 ; switch to thumb
		
; -----------------------------------------------------------------------------

; R0 output					; R1 allowance	->R6
; R2 brightness	->R4		; R3 delay
; R4 = R2 brightness		; R5 used
; R6 = R1 allowance			; R7 addr	

				CODE16
	
illumi16		LDR		R6,free_ram
				LDRB	R3,[R6,#0x12] 
				CMP		R3,#0 ; first time run resp. phone off?
				BNE		illumi16_1
							
illu16_first	MOV		R3,#0xFF
				STRB	R3,[R6,#0x12] ; first time run/phone off flag
				
				MOV		R3,#boot_blink_type ; boot sfx: 0=off, 2=dynamic, 1=startbleep ##conf## 
				CMP		R3,#0 ; no entry start
				BNE		illu16_first_2
				
illu16_first_0	LDR		R2,_master
				MOV		R1,#0x9C
				LSL		R1,#5 ; R1=ca. 2500 = ca.22seconds after boot master starts
				BL		_call_after_timer
				B		illumi16_x
				
illu16_first_2	BL		master
				
				CMP		R3,#1 ; 1=startbleep -> finished
				BEQ		illumi16_1 

illu16_first_1	MOV		R3,#0x1F ; make the beginning a bit before fast climax. long: 0x20, short:0x10
				STRB	R3,[R6,#9] ; illumination toggle counter DynamicBlinker
				
				MOV		R3,#2 ; keypadlight at boot . ##conf##
				STRB	R3,[R6,#0x17] ; permit for _set_illumination which illumination output (0=screen, 1=kpl, 2=both) is generatet
				BL		dynamic_blinker ; starts after being finished booting master :)
	
illu16_first_x	MOV		R1,#0 ; (supress first screen turn on)

illumi16_1		CMP		R0,#0 ; illumination output device 0 = screen
				BNE		illumi16_x ; SetIllumination-Call is "output not screen"

				CMP		R1,#0 ; SetIllumination-Call is "no allowance"
				BEQ		illumi16_x
				
				; set ram byte with brightness content of FW calls, not of Blinker calls.
				BL		_get_mem_ptr
				LDRB	R3,[R6,#0x15] ; SetIllumination-Is-Called-By-Blinker message (set by Blinker-internal SetIllumination calls)
				CMP		R3,#0 
				BNE		illumi16_2 ; ;  called by Blinker
				STRB	R4,[R6,#0x16] ; Illumination State by Law (what the firmware thinks about illumination on or off)
				
illumi16_2		CMP		R4,#0 ; brightness. 0=off.
				BNE		illumi16_x ; SetIllumination-Call is "screen illumi on"
				
illumi16__KeepScreenIllumAlive		
				PUSH	{R0-R2} ;  GetProfile destroys them :/
				MOV		R7,#2 ; GetProfile
				BL		_funclib
				MOV		R3,R0
				POP		{R0-R2}
				
				CMP		R3,#mainscreen_always_on_profile
				BNE		illumi16_x

				MOV		R4,#mainscreen_always_on_brightness

illumi16_x		MOV		R7,R0 ; repatch

				;LDRB	R3,[R6,#0x12] ; first time run?
				;CMP		R3,#0 ; first time run?
				;BNE		illumi16_1
				;POP		{R3}
				;MOV		R3,#128
				POP	{R3,R6,PC} ; repatch & return of "illumi32  STMFD SP!,{R3,R6,LR}"			

; ========================================================================================	
; master loop
; ========================================================================================	
;dcb "_master_"
master			PUSH	{R0-R7,LR} ; PUSH	{LR}
				BL		_get_mem_ptr
				
				BL		_get_profile_codes_prep
ma_precheck		BL		_get_blink_events_number	

				MOV		R3,R0 ; R0=calculated_missed-events-result
				BL		_get_evaluated_netmode
				MOV		R1,R0 ; R1=net-access-traffic evaluated to timer-data. 0=idle, 1,2=other channels. >2=timer data
				
ma_precheck3	BL		_get_net_online
				MOV		R2,R0 ; R2=net online (1=true)
				
				BL		_get_accu_icon ; R0=boot state (0=true)
	
ma_check		CMP		R0,#0 ; booting				
				BEQ		ma_bli_net_traf

ma_boot_no		CMP		R3,#0 ; no events
				BEQ		ma_event_no 

ma_event_y		CMP		R2,#1 ; netonline
				BNE		ma_bli_event	

ma_net_online_y	CMP		R1,#0 ; netaccess_idle
				BNE		ma_bli_net_traf
				B		ma_bli_event
				
ma_event_no		CMP		R2,#1 ; netonline
				BNE		ma_bli_net_lost
				
				CMP		R1,#0 ; netaccess_idle
				BEQ		master_patrol
				
				B		ma_bli_net_traf
				
; ----------------------------------------------
		
ma_bli_event	CMP		R3,#4 ; 1 & 2 & 3 events 
				BGE		ma_bli_event1
				
				MOV		R0,R3 ; mevent type for sequence_blinker=event_blinker (R3=number of events=1v2v3)
				B		ma_bli_net_lc1
				
ma_bli_event1	MOV		R1,#1
				STRB	R1,[R6,#0x11] ; blink type
				BL		dynamic_blinker 
				B		master_x				
								
ma_bli_net_traf	MOV		R0,#brightness
				STRB	R0,[R6,#0x1A] ; Illumination-Toggler Illu-Hi-Value
				BL		net_blinker
				B		master_x

ma_bli_net_lost	MOV		R0,#0 ; ; R0=event type for sequence_blinker=netlost
			
ma_bli_net_lc1	BL		sequence_blinker 
				B		master_x		
	
master_patrol	MOV		R1,#255 ; approx. 1.2 seconds
				LDR		R2,_master
				BL		_call_after_timer		
					
master_x		POP		{R0-R7,PC} ; POP		{PC}


; ========================================================================================	
; dynamic sweeping blinker module
; ========================================================================================	

; E: DynamicBlinker lo value (time, 1sec=ca-225)
; F: DynamicBlinker hi value (time, 1sec=ca-225)
; 10:DynamicBlinker step-divide-by
; 11:DynamicBlinker Parameter: blink type

dynamic_blinker ; input ram+0x11: blink type
				PUSH 	{R0-R7,LR} ; PUSH	{LR}
				BL		_get_mem_ptr
				MOV		R0,#100 ; start brightest brightness 
				STRB	R0,[R6,#0x1A] ; Illumination-Toggler Illu-Hi-Value
				BL		_get_profile_codes_prep
				MOV		R0,#0 ; mevent info
				BL		_get_profile_codes
				BL		_set_profile_illu
				LDRB	R0,[R6,#0x11] ; blink type
				CMP		R0,#0 
				BEQ		dyn_blinker_0

dyn_blinker_1	MOV		R0,#5
				MOV		R1,#0x48
				MOV		R2,#3
				B		dyn_blinker_exe

dyn_blinker_0	MOV		R0,#4
				MOV		R1,#0x60
				MOV		R2,#4
				
dyn_blinker_exe	STRB	R0,[R6,#0xE] ; lo value
				STRB	R1,[R6,#0xF] ; hi value
				STRB	R2,[R6,#0x10] ; lsr value
				BL		dynamic_blinker_loop
				POP		{R0-R7,PC} ; POP		{PC}

; -----------------------------------------------------------------

dynamic_blinker_loop
				PUSH	{R0-R7,LR}
				MOV		R5,#0 ; zero dynamic_loop_x flag
				BL		_get_profile_codes_prep
				MOV		R0,#0 ; input R0: info for 0=missed events, 1=netlost/weak, 2=netblinker
				BL		_get_profile_codes
				BL		_set_profile_illu
				BL		_illumination_toggler
 		
dyn_on			LDRB	R1,[R6,#9] ; gespeicherter nchster Zeitwert
				LDRB	R2,[R6,#0xE] ; low value
				CMP		R1,R2
				BGE		dyn_on1 ; wenn kleiner als 4, Richtung umpolen

dyn_pol_pos		MOV		R2,#1
 				B		dyn_pol_str

dyn_on1			LDRB	R2,[R6,#0xF] ; hi value
				CMP		R1,R2 
				BLE		dyn_on2 ; wenn grer als startvalue, Richtung umpolen
		
dyn_pol_neg		MOV		R2,#0
				MOV		R5,#1 ; set dynamix_loop_x flag
dyn_pol_str 	STRB	R2,[R6,#0xA] ; polarity speichern
			
dyn_on2			LDRB	R2,[R6,#0x10] ; LSR-Val
				MOV		R7,R1
				LSR		R7,R2  
				ADD		R7,#1
				LDRB	R2,[R6,#0xA] ; polaritaet
				CMP		R2,#0 
				BNE		dyn_on_pos
		
dyn_on_neg		SUB		R1,R7
				B		dyn_on3
		
dyn_on_pos		ADD		R1,R7

dyn_on3			STRB	R1,[R6,#9]	; store current timeval

dyn_start_what	CMP		R5,#1 ; loop finished?
				BEQ		dyn_master
				
dyn_inner_ret	LDR     R2,=dynamic_blinker_loop ; loop not finished, go on
				B		dyn_exec3	
				
dyn_master		LDRB	R0,[R6,#0x17] ;  output: 0=off, 1=screen only, 2=kpl only, 3=both
				CMP		R0,#0 ; off? 
				BEQ		dyn_law
				
				BL		_get_blink_events_number
				CMP		R0,#0
				BNE		dyn_master_ret

dyn_law			BL		_set_illumination_state_to_law
			
dyn_master_ret	LDR     R2,_master
				
dyn_exec3		; brightness
				MOV		R0,#5
				MUL		R0,R1
				LSR		R0,#2
				ADD		R0,#6
				MOV		R5,#100
				SUB		R0,R5,R0
				STRB	R0,[R6,#0x1A] ; Illumination-Toggler Illu-Hi-Value
				
				BL		_call_after_timer
				
dynamic_loop_x	POP		{R0-R7,PC}	


				
; ========================================================================================	
; net-blinker module
; ========================================================================================	
 dcb "__NETBLI___"
net_blinker		PUSH	{LR} 
				BL		_get_mem_ptr
				BL		_get_profile_codes_prep
				MOV		R0,#2 ; input R0: info for 0=missed events, 1=netlost/weak, 2=netblinker
				BL		_get_profile_codes
				BL		_set_profile_illu
				BL		_get_evaluated_netmode	
				CMP		R0,#1 ; 0=net idle
				BLE		net_bli_mastr_r
				
net_bli_what	STRB	R0,[R6,#0x13] ; TimedBlinker wait time for next blink call. if zero, blinker blinks not when illu is on
				CMP		R0,#0 ;idle value
				BEQ		net_bli_mastr_r
		
				PUSH	{R0}
				BL		_get_net_online
				MOV		R1,R0 ; R1=net online (1=true)
				BL		_get_accu_icon ; R0=boot state (0=true)
				MOV		R3,R0 ; R3=booting (0=true)               
				POP		{R0}
				
				LDRB	R2,[R6,#0x17] ;  output: 0=off, 1=screen only, 2=kpl only, 3=both
				CMP		R2,#0 ; off?
				BEQ		net_bli_mastr_r	
				
				CMP		R3,#0 ; if bootin, go                 
				BEQ		net_bli_inner_r
				
				CMP		R1,#0 ; netlost, not booting: no
				BEQ		net_bli_mastr_r
				
net_bli_inner_r	BL		_illumination_toggler

				LDR		R2,=net_blinker
				B		net_bli_go

net_bli_mastr_r	BL		_set_illumination_state_to_law
				LDR		R2,_master

net_bli_go						 NOP ; POP		{PC}	

				LDRB	R1,[R6,#0x13] ; TimedBlinker wait time for next blink call. 
				
					CMP		R1,#4
					BGE		Xcall_after_timer_x
					MOV		R1,#4
Xcall_after_timer_x	MOV		R0,R6
					MOV     R7,#77 ; CallAfterTimer
					NOP ;POP		{PC}
					BL		_funclib
				
				
				;BL		_call_after_timer		
				POP		{PC}


; ========================================================================================	
; Blink Sequencer
; ========================================================================================
 DCB "___SEQ___"

sequence_blinker PUSH	{R0-R7,LR} ; input:
				; R0=SeqBlinker sequence number (0=netlost, 1-3=missed_events, 4=net weak blinker)

				BL		_get_mem_ptr
				STRB	R0,[R6,#0xC] ; SeqBlinker sequence number 
				
				MOV		R0,#100 ; start brightest brightness 
				STRB	R0,[R6,#0x1A] ; Illumination-Toggler Illu-Hi-Value
				
				BL		sequence_blinker_start
				
				POP		{R0-R7,PC}


; -----------------------------------------------------------------
sequence_blinker_start
				PUSH	{LR}
				BL		_get_mem_ptr

				MOV		R1,#0 ;
				STRB	R1,[R6,#0xB] ; SeqBlinkerPosition - internally used

				MOV		R1,#0xFF
				STRB	R1,[R6,#8] ; 8-9: illumination toggler
				BL		sequence_blinker_loop
				
sequence_blinker_start_brightness_slide
				LDRB	R0,[R6,#0x1A] ; Illumination-Toggler Illu-Hi-Value
				SUB		R0,#2
				CMP		R0,#4 ; 96 steps
				BGE		sequence_blinker_start_brightness_slide_1
				MOV		R0,#100
				
sequence_blinker_start_brightness_slide_1
				STRB	R0,[R6,#0x1A] ; Illumination-Toggler Illu-Hi-Value
							
				
				POP	{PC}
				
; -----------------------------------------------------------------


sequence_blinker_loop
				PUSH	{LR}
				BL		_get_mem_ptr
				BL		_get_profile_codes_prep

				LDRB	R1,[R6,#0xC] ; SeqBlinker Sequence#
				MOV		R3,#8 ; length of sequence record
				MUL		R3,R1
				CMP		R1,#0
				BEQ		sequence_blinker_loop_select_netlost
				

sequence_blinker_loop_select_mevents
				MOV		R0,#0	; mevents			
				B		sequence_blinker_loop_select_x
				
sequence_blinker_loop_select_netlost
				MOV		R0,#1 ; netlost
							
sequence_blinker_loop_select_x

				BL		_get_profile_codes
				BL		_set_profile_illu
				BL		_illumination_toggler
				
				LDRB	R0,[R6,#0xB] ; SeqBlinkerPosition
				ADR		R2,sequence_blinker_data
				ADD		R3,R2
				
				CMP		R0,#5 ; max_sequence_elements ; sequence ended cause max number of elements reached
				BGE		sequence_blinker_loop_outer_return
				
				ADD		R2,R0,#2
				
				LDRB	R1,[R3,R2] ; R2=(R0+1)th element of sequence address R3
				CMP		R1,#0 ; element zero -> sequence finished
				BEQ		sequence_blinker_loop_outer_return
				
sequence_blinker_loop_inner_return
				ADD		R0,#1 ; increase element counter
				STRB	R0,[R6,#0xB] ; NumberBlinker Remainder/SeqBlinkerPosition
				LDR		R2,=sequence_blinker_loop
				BL		_call_after_timer 
				B		sequence_blinker_loop_x

sequence_blinker_loop_outer_return
				BL		sequence_blinker_decision
				CMP		R0,#1 ; situation changed
				BEQ		sequence_blinker_loop_outer_return_master
				
				LDR		R2,=sequence_blinker_start
				B		sequence_blinker_loop_outer_return_exe
				
sequence_blinker_loop_outer_return_master
				BL		_set_illumination_state_to_law
				LDR		R2,_master	

sequence_blinker_loop_outer_return_exe
				; LDRH	R1,[R3]
				
				; start_timer_after_slide
				LDRB	R0,[R6,#0x1A] ; Illumination-Toggler Illu-Hi-Value
				SUB		R0,#4
				MOV		R1,#96
				SUB		R0,R1,R0
				MOV		R1,#9
				MUL		R0,R1
				MOV 	R1,#1
				LSL		R1,#8 ; low value
				ADD		R1,R0
				
				BL		_call_after_timer 
						
sequence_blinker_loop_x
				POP		{PC}

; -----------------------------------------------------------------
 DCB "__DECISION__"
sequence_blinker_decision		PUSH	{R1-R5,LR}
								LDRB	R1,[R6,#0x0C] ; R1=sequence# (to decide which event type causes the call of this func)
								LDRB	R0,[R6,#0x17] ;  output: 0=off, 1=screen only, 2=kpl only, 3=both
								CMP		R0,#0 ; off?
								BEQ		sequence_blinker_decision_y
							
								CMP		R1,#0 ; seq 0 (net lost caused)
								BEQ		sequence_blinker_decision_0
								
								; else seq 1-3 (number of events 1-3 caused)
								
sequence_blinker_decision_1_3 	BL		_get_evaluated_netmode
								CMP		R0,#2 ; 0=net traffic idle, 1=net traffic weak but idle (only available if netmode2-method used, otherwise event ignored)
								BGE		sequence_blinker_decision_y
								
								BL		_get_blink_events_number
								STRB	R0,[R6,#0xC] ; SeqBlinker sequence number 
								CMP		R0,#0
								BEQ		sequence_blinker_decision_y
								CMP		R0,#4
								BGE		sequence_blinker_decision_y
								B		sequence_blinker_decision_n
; ------				
sequence_blinker_decision_0		BL		_get_blink_events_number 
								CMP		R0,#0
								BNE		sequence_blinker_decision_y
								
								BL		_get_net_online
								CMP		R0,#0
								BEQ		sequence_blinker_decision_n
								B		sequence_blinker_decision_y		
	
sequence_blinker_decision_y		MOV		R0,#1
								B		sequence_blinker_decision_x
								
sequence_blinker_decision_n		MOV		R0,#0
				
sequence_blinker_decision_x		POP		{R1-R5,PC} ; output: R0=0: no reason to leave. 1=situation changed, leave.


; ========================================================================================	
; auxiliary functions
; ========================================================================================	


_funclib			PUSH	{R6-R7,LR} ; input: R7  = func#
					LDR		R6,FunctionLibrary
					LSL		R7,#3
					ADD		R7,R6
					LDR		R7,[R7,#4]
					BLX		R7
					POP		{R6-R7,PC}
	
; ----------------------------------------------------------------------	
; DCB "___CAT___"
_call_after_timer	PUSH	{LR}
					CMP		R1,#4
					BGE		_call_after_timer_x
					MOV		R1,#4
_call_after_timer_x	MOV		R0,R6
					MOV     R7,#77 ; CallAfterTimer
					BL		_funclib
					POP		{PC}
; ----------------------------------------------------------------------	

_get_blink_events_number
					PUSH	{R1-R3,LR}
					MOV		R0,#0 ; missed events info
					BL		_get_profile_codes
					CMP		R0,#0
					BEQ		_get_blink_events_number_no
					BL		__get_blink_events_number
					B		_get_blink_events_number_x

_get_blink_events_number_no
					MOV		R0,#0 ; events zero, blinker disengaged
_get_blink_events_number_x
					POP		{R1-R3,PC}
; ----------------------------------------------------------------------	

__get_blink_events_number
					LDR		R0,_ram_inbox
					LDRB	R0,[R0]
					BX		LR

; ----------------------------------------------------------------------

_get_mem_ptr		LDR		R6,free_ram
					; LDR		R6,[R6]
					BX		LR
					
; -----------------------------------------------------------------------------

free_ram								DCD	0xA8000230 ; in this area in all firmwares are free spaces
_master									DCD master

; ----------------------------------------------------------------------

_set_illumination ; input: R2=brightness. [R6,#0x17]: 0=off, 1=screen only, 2=kpl only, 3=both
					PUSH	{R2,R4,LR}
					LDRB	R4,[R6,#0x17] ; permit for _set_illumination which illumination output (0=screen, 1=kpl, 2=both) is generatet
										
					CMP		R4,#0 ; off
					BEQ		_set_illum_x1
					
					CMP		R4,#1 ; screen only
					BEQ		_set_illum_1
					
					MOV		R0,#1 ; keypadlight
					BL		__set_illumination
									
					CMP		R4,#2
					BNE		_set_illum_1
				
_set_illum_x1		POP		{R2,R4,PC}
				
_set_illum_1		POP		{R2,R4}
					MOV		R0,#0 ; screen illumination
					BL		__set_illumination
_set_illum_x		POP		{PC}


; ----------------------------------------------------------------------

 ;dcb "---###---"
__set_illumination
				PUSH	{R1,R4,R7,LR}
				MOV		R1,#1
				STRB	R1,[R6,#0x15] ;	SetIllumination-Is-Called-By-Blinker message (0=false)
				MOV		R3,#0x08 ; delay/smoothness ##conf##
				MOV		R7,#8 ; SetIllumination
				BL		_funclib
				MOV		R1,#0
				STRB	R1,[R6,#0x15] ;	SetIllumination-Is-Called-By-Blinker message (0=false)

				POP		{R1,R4,R7,PC}

; ----------------------------------------------------------------------	

_get_illumination_state_by_law
				LDRB	R0,[R6,#0x16] ; Illumination State by Law (what the firmware thinks about illumination on or off)
				BX		LR

; ----------------------------------------------------------------------	

_set_illumination_state_to_law 
				PUSH	{R0-R7,LR}			
			 	BL		_get_illumination_state_by_law 
		   	    MOV		R7,R0
		   	    MOV		R2,R7
		   	    MOV		R0,#0 ; screen
		   	    BL		__set_illumination
		   	    MOV		R2,R7
		   	    MOV		R0,#1 ; kpl
		   	    BL		__set_illumination
		   	    POP		{R0-R7,PC}
		   	    
; ----------------------------------------------------------------------	
 dcb "__ILLTOGG__"
_illumination_toggler
					PUSH	{R0-R3,LR}
					BL		_get_mem_ptr
					
					LDRB	R0,[R6,#0x14] ;  if 1, blinker blinks only when fw thinks that illumination is on. else zero
					CMP		R0,#0 
					BEQ		_illu_toggler_ok
				
_illu_toggler_1		BL		_get_illumination_state_by_law
					CMP		R0,#0
					BEQ		_illu_toggler_ok
				
					BL		_get_accu_icon
					CMP		R0,#0 ; booting?
					BNE		_illu_toggler_x
							
_illu_toggler_ok	LDRB	R2,[R6,#8] 
					MOV		R1,#0xFF

					SUB		R0,R1,R2
					STRB	R0,[R6,#8]
					
					LDRB	R0,[R6,#0x1A] ; Illumination-Toggler Illu-Hi-Value
					AND		R2,R0
					
					BL		_set_illumination
_illu_toggler_x		POP		{R0-R3,PC}
		
; -----------------------------------------------------------
_get_net_online
					PUSH	{R1-R3,LR}
					MOV		R0,#1 
					BL		_get_profile_codes
					; input R0: info for 0=missed events, 1=netlost/weak, 2=netblinker								
					; returns: R0=illumination code(0=off,1=screen,2=kpl,3=both). R1=1: blinks only when fw thinks that illumination is off
					; returns if info is for netblinker R2=netblinker behaviour (0=diplomatic, 1=intelligence).

					CMP		R0,#0
					BEQ		_get_net_online_no
					BL		__get_net_online
					B		_get_net_online_x
					
_get_net_online_no	MOV		R0,#1 ; always online, blinker disengaged

_get_net_online_x	POP		{R1-R3,PC}
; -----------------------------------------------------------


__get_net_online	LDR		R0,_ram_net_online
					LDRB	R0,[R0]
				
					;LDRB	R0,[R6,#0x19] ; for testing
					BX		LR
				
; -----------------------------------------------------------------------------

_get_accu_icon	LDR		R0,_ram_mainscreen_accu_icon_ 
				;LDR		R0,[R0] ; base address mainscreen state
				LDRH	R0,[R0]
				BX		LR

; -----------------------------------------------------------------------------

_get_evaluated_netmode1				PUSH	{LR}
									BL		_get_net_access_mode1
									CMP		R0,#0x0F ; idle low value
									BLE		_get_evaluated_netmode1_1
									
									CMP		R0,#0x14 ; idle hi value
									BLE		_get_evaluated_netmode1_idle
								
_get_evaluated_netmode1_1 ; 		method with direct netaccess_mode byte
									CMP		R0,#5
									BLE		_get_evaluated_netmode1_2
									SUB		R0,#6
									LSL		R0,#2
									ADD		R0,#0xA
									B		_get_evaluated_netmode1_x	
_get_evaluated_netmode1_2			ADD		R0,#3
									CMP		R0,#6
									BGE		_get_evaluated_netmode1_x	
									ADD		R0,#7
									B		_get_evaluated_netmode1_x
				
_get_evaluated_netmode1_idle		MOV		R0,#0
				
_get_evaluated_netmode1_x			POP		{PC}
				
; -----------------------------------------------------------------------------

_get_net_access_mode1	

; phone 13-0E-05-06. sms: 13-09-06-13
; 0,3,5,6,7,8,9,A  : 6=phoning, 9=sms. block supposed: activity
; D,E,F
; (11),12,13,14 ; 0x13=idle. block supposed somehow idle
; 19, 1A,1B

				PUSH	{LR}
				;MOV		R7,#81 ; _get_net_access_
				; BL		_funclib
				LDR		R7,_get_net_access_
				BLX		R7
				POP		{PC}
				

; -----------------------------------------------------------------------------

;_get_net_access_mode2
; sms: 4-0-1-0-2,  phone 0,1,2
;				LDR		R0,ram_netaccess_mode2
;				LDRB	R0,[R0]
;				BX		LR	
									
; -----------------------------------------------------------------------------

 dcb "__NETMOD___"
_get_evaluated_netmode				PUSH	{R1-R3,LR}
									MOV		R0,#2
									BL		_get_profile_codes 
									; input R0: info for 0=missed events, 1=netlost/weak, 2=netblinker
									; returns: R0=illumination code(0=off,1=screen,2=kpl,3=both). R1=1: blinks only when fw thinks that illumination is off
									; returns if info is for netblinker R2=netblinker behaviour (0=diplomatic, 1=intelligence).
															
									CMP		R0,#0 ; netblinker disengaged
									BEQ		_get_evaluated_netmode_x

_get_evaluated_netmode_diplomatic	BL		_get_evaluated_netmode1

		
_get_evaluated_netmode_x			POP		{R1-R3,PC}

; -----------------------------------------------------------------------------
 DCB "__PCPREP__"
_get_profile_codes_prep			PUSH	{R0-R4,LR}						
								MOV		R4,R0
								MOV     R7,#2 ; GetProfile
								BL		_funclib
								LSL		R0,#1
								ADR		R1,profile_codes
								ADD		R1,R0 ; address of profile codes for current profile
								LDRH	R0,[R1] ; profile codes
								STRH	R0,[R6,#0x18] ; 18-19: currect profile codes
								POP		{R0-R4,PC}

; -----------------------------------------------------------------------------
						
_get_profile_codes				PUSH	{R3,R4,LR}
; input R0: info for 0=missed events, 1=netlost, 2=netblinker
								MOV		R4,R0
								CMP		R4,#2
								BEQ		_get_profile_code_netblinker
								
								LDRB	R3,[R6,#0x18] ; 18-19: current profile codes
								CMP		R4,#1
								BEQ		_get_profile_code_netblinker1 ; for treatment netlost
 
_get_profile_code_meventsblink	MOV		R0,#48 ; illumination bits
								AND		R0,R3
								LSR		R0,#4 ; result in R0

								MOV		R1,#8 ; blinks only when fw thinks that illumination is off - bit
								AND		R1,R3 
								LSR		R1,#3 ; result in R1

								B		_get_profile_code_x	
								
_get_profile_code_netblinker	LDRB	R3,[R6,#0x19] ; 18-19: current profile codes

_get_profile_code_netblinker1	MOV		R0,#6 ; illumination bits
								AND		R0,R3
								LSR		R0,#1 ; result in R0
								
								MOV		R1,#1 ; blinks only when fw thinks that illumination is off - bit
								AND		R1,R3
		

; returns: R0=illumination code(0=off,1=screen,2=kpl,3=both). R1=1: blinks only when fw thinks that illumination is off
_get_profile_code_x				POP		{R3,R4,PC}
; -----------------------------------------------------------------------------

_set_profile_illu				STRB	R0,[R6,#0x17] ; permit for _set_illumination which illumination output (0=screen, 1=kpl, 2=both) is generated
								STRB	R1,[R6,#0x14] ; if zero, blinker blinks not when illu is on
								BX		LR

; -----------------------------------------------------------------------------

FunctionLibrary							DCD	0xA0FC0000	   	    
_illumi16								DCD	illumi16

; -----------------------------------------------------------------------------

; firmware addresses

;Get_MainscreenNumberOfMissedEventTypes		DCD 0xA163A08F  ; s65v58: A169F14B. sl65v50:  A16486B3
;(00AB19780120022900D0002098BDF8B5)+0xF
 
;ram_Mainscreen_NumberOfMissedEventTypes	DCD 0xA867C860 ; s65v58: A86D0670 , sl65v50: A867633C
; A1634030 2E 48                       LDR     R0, =ramram_Mainscreen_NumberOfMissedEventTypes
; (0136A642EED39999006803) + 6, there you find the address loaded.

_ram_inbox 									DCD 0xA83FF444

_ram_mainscreen_accu_icon_					DCD 0xA863A544 ; s65v58: A868C4E4, sl65v50: A863A3D0
; A1633BF2 46 49 LDR     R1, =ram_mainscreen_states    + 4
; (7047B0B599999999006899990028)+0xA there you find an address loaded. add 4 to address.

; _get_illumination_data_table				DCD	0xA1226518 ; s65v58: A1241448  , sl65v50: A122DE48
; (00B0CAE571FFFFEA999999991EFF2FE1F04D) + 8. (internally done in Blinker: adds 0x94 to address returned by function)

_ram_net_online								DCD	0xA863D124  ; s65v58: A8690BF0, sl65v50: A863CFB0
; A1634130 27 48 LDR     R0, =ram_Net_Online
; (70B59999999900680028) + 2

_get_net_access_						DCD	0xA132D75D ; s65v58: A136D5B4, sl65v50:A1339034
;(9999021C09780120914200D000207047999900787047)+0x10 you find a LDR loading the address or you can start the function.

ram_netaccess_mode2						DCD 0xA8752560
; -----------------------------------------------------------------------------
; -----------------------------------------------------------------
_get_evaluated_netmode2_data		DCB		7, 18,12,0xFF
				ALIGN
sequence_blinker_data		
 				; word 6thtimer_Off,
 				; bytes 1stTimer_On, 2ndTimer_Off, 3rdTimer_On, 4thTimer_Off,5thTimer_On
 				DCW		0x330
 				DCB 	0x10,0xC,0x3E,0xC,0x12,    0x99 ; DCB		4,0,0,0,0,    0x99 ; seq 0 = net lost
				
				DCW		0x1C2
				DCB		0x44,0,0,0,0,     0x99; seq 1 =1 event
 				
 				DCW		0x220
 				DCB		0x20,0x1C,0x24,0,0,    0x99 ; seq 2 = 2 events
 				
 				DCW 	0x1E0
 				DCB		0x20,0x1C,0x20,0x1C,0x24,      0x99 ; seq 3 = 3 events
 				
 				; DCW 	0x2C0
 				; DCB		0x28,0xC,7,0xC,0x12     , 0x99 ; seq 4 ; netmode2=03
 				
 				; DCW 	0x2C0
 				; DCB		0x10,0xC,0x3E,0xC,0x12     , 0x99 ; seq 5 ; netmode2=08
 				
 				
; 0B 08 05 0B 43
; DCB		0x12, 0x0C, 0x0E, 0x0C0---------------------------------------------	

; profile codes0
; dcb A1,B1, ,A2,B2, A3,B3, A4,B4, A5,B5, A6,B6, A7,B7

; for each profile there are 2 bytes, a word
; define for each profile a word which is calculated like this:


; A -----

; missed events blinker
;  32 : keypadlight  
;  16 : screen 
;  8 : blinker blinks only when fw thinks that illumination is on. else zero
; if 32 amd 16 are unused, missed events blinker is completly disengaged

; net_lost blinker 
;  4 : keypadlight   
;  2 : screen 
;  1 : blinker blinks only when fw thinks that illumination is on. else zero

; if 4 amd 2 are unused, netlostblinker is completly disengaged

; add the numbers above as you like to get profile code A. (maximum: 32+16+8+4+2+1)

; B -----

; netblinker output
;   4 : keypadlight   
;   2 : screen 
;   1 : blinker blinks only when fw thinks that illumination is on. else zero
;   0 : netblinker completly disengaged
  
; add the numbers above as you like to get profile code B. (maximum: 4+2+1)

; example: profile codes for one profile: 56,24 means:
; A = 61 = 32 + 16 + 8 + 4 + 1 : missed events blinker: 32=keypadlight, 16=screen. net_lost&net_instable*blinker: 4=keypadlight. 8 and 1 = [both]<-blinks only when fw thinks that illumination is off
; B = 14 = 8 + 4  = netblinker: 8=intelligence mode. 4=keypadlight output
  ALIGN

profile_codes
	DCB	 32+16+8 + 4+1, 4 ; profile 1   
	DCB	 32+8, 0 ; profile 2 
	DCB	 32+16+8+ 4+1, 4+2; profile 3   
	DCB	 32+8 +4+1, 0  ;  profile 4
	DCB	 32+8, 4+2+1  ; profile 5 
	DCB	 32+16+8 + 4+2+1, 4+2 ; profile 6  
	DCB	 0,0 ; profile 7   
; -----------------------------------------------------------------------------	
	
 END  
 DCB	32+8 +4+1, 4 ; profile 1   
	DCB	2, 4+2+1  ; profile 2   ;
	DCB	32, 4+1  ; profile 3   
	DCB	32+16+8 +4+2, 0  ;  profile 4
	DCB	0,0  ; profile 5 
	DCB	32+16+8 +4+2+1, 4+2 ; profile 6  
	DCB	32+16+8 +4+1, 4+1      ; profile 7



