; blink module dynamic
; x65 M65v50 (c) benj9 

		AREA ARMex, CODE, READONLY  
            
		ENTRY
		GBLA	TYPE	;1 for M65v50, 2 for CX6C

TYPE	SETA	1 						

 IF  TYPE = 1
 ENDIF

		; IMPORT ram
		IMPORT  _funclib
		IMPORT _set_illumination_state_to_law
		IMPORT	master_entry
		IMPORT	_get_number_missed_events
		EXPORT	dynamic_blinker, _illumination_toggler
		
		CODE16

dynamic_blinker
		PUSH	{R0-R7,LR}

		MOV		R5,#0 ; zero exit flag

		BL		_illumination_toggler
 		
 			
on		LDR		R6,ram
		LDRB	R1,[R6,#9] ; gespeicherter nchster Zeitwert
		; LDRB	R2,[R6,#0x10] ; low value
		CMP		R1,#0x8 ; R2
		BGE		on1 ; wenn kleiner als 4, Richtung umpolen

pol_pos	MOV		R2,#1
 		B		pol_str

on1		; LDRB	R2,[R6,#0x11] ; hi value
		CMP		R1,#0x40 ; R2 
		BLE		on2 ; wenn grer als startvalue, Richtung umpolen
		
pol_neg	MOV		R2,#0
		MOV		R5,#1 ; set exit flag
pol_str STRB	R2,[R6,#0xA] ; polarity speichern
		
		
on2		MOV		R2,#3 ; LDRB	R2,[R6,#0x12] ; LSR-Val
		MOV		R7,R1
		LSR		R7,R2  
		ADD		R7,#1
		LDRB	R2,[R6,#0xA] ; polaritaet
		CMP		R2,#0 
		BNE		on_pos
		
on_neg	SUB		R1,R7
		B		on3
		
on_pos	ADD		R1,R7

on3		STRB	R1,[R6,#9]	; store current timeval
			
exec	CMP		R5,#1
		BEQ		dynamic_blinker_return
		
		LDR     R2,=dynamic_blinker
		B		exec2
		
dynamic_blinker_return
		BL		_get_number_missed_events
		CMP		R0,#0
		BNE		exec1
		BL		_set_illumination_state_to_law
		
exec1	LDR     R2,=master_entry

		NOP
exec2	MOV		R0,R6
		MOV     R7,#77 ; CallAfterTimer
		BL		_funclib
		
exit	POP		{R0-R7,PC}	

; -----------------------------------------------------------

_illumination_toggler
		PUSH	{LR}
		LDR		R6,ram
		LDRB	R2,[R6,#8] ; Brightness-Toggler, msste man boolsch machen, falls Profilwechsel/Brightnesswechsel
		MOV		R1,#60 ; brightness
		SUB		R0,R1,R2
		STRB	R0,[R6,#8]
		MOV		R0,#1
		MOV		R1,#1
		MOV		R3,#0x28
		MOV		R7,#8 ; SetIllumination
		BL		_funclib
		POP		{PC}
		


ram				DCD	0xA8240000 


 END        
   