; blink on events
; x65 M65v50 (c) benj9 

		AREA ARMex, CODE, READONLY  
            
		ENTRY
		GBLA	TYPE	;1 for M65v50, 2 for CX6C

TYPE	SETA	1 						

 IF  TYPE = 1

GetNumberOfNotCommittedMissedEvents	EQU 0xA163A08F
_Mainscreen_NumberOfMissedEvents	EQU 0xA867C860
_ram_illumination_data				EQU 0xA12265F8
_ram_net_online						EQU	0xA863D124
 ENDIF

		EXPORT	ram, _funclib, _set_illumination_state_to_law, master_entry_blinker
		IMPORT	dynamic_blinker
		IMPORT	number_blinker
		
		CODE16
		
; ram usage:
; 0-7: timer data
; 8-9: illumination toggler, resides in DynamicBlinker
; A. DynamicBlinker polarity
; B: NumberBlinker Start
; C: Numberblinker Step 
		
master_entry	PUSH	{LR}
				MOV		R4,#0x99 ; marker for master_entry
				B		master_entry_
				
master_entry_blinker
				PUSH	{LR}
				MOV		R4,#0 ; marker for master_entry_blinker (is destroyed by StartAfterTimer)

master_entry_	LDR		R6,ram
				MOV R0,#4 ; BL		_get_number_missed_events
				CMP		R0,#0 ; no event
				BEQ		master_no_event
				
				CMP		R0,#4
				BGE		master_dynamic
				
master_number	BL		number_blinker 
				B		master_x	
				
master_dynamic	BL		dynamic_blinker 
				B		master_x
				
master_no_event	CMP		R4,#0x99 ; if master_entry called
				BEQ		master_patrol

master_reset	BL		_set_illumination_state_to_law
	
master_patrol	MOV		R0,R6
				; MOV		R4,#0
				MOV		R1,#110 ; approx. 1/2 sec
				LDR		R2,=master_entry
				MOV     R7,#77 ; CallAfterTimer
				BL		_funclib		
					
master_x		POP		{PC}
		
; ----------------------------------------------------------------------	
	
	
; ======================================================================
	
_funclib		PUSH	{R7,LR} ; input: R7  = func#
				BL		__funclib
				
				BLX		R7		
				POP		{R7,PC}

__funclib		PUSH	{R5-R6,LR} ; input: R7  = func#
				LSL		R7,#3
				LDR		R6,FunctionLibrary
				ADD		R7,R6
				
				LDR		R5,[R7]
				CMP		R5,#0
				BMI		__funclib_err ; func lib entry not present
				
				ADD		R7,#1			
				BLX		R7
				B		__funclib_x
				
__funclib_err	MOV		SP,R4 ; release whole sub stack
				MOV		R0,#0
				MOV		R1,#0
				;LDR		R7,Shutdown_chunk
				;BLX		R7
				POP		{PC} ; escape patch immediatly
			
__funclib_x		POP		{R5-R6,PC}

; ----------------------------------------------------------------------	

_get_number_missed_events
				PUSH	{R7,LR}
				MOV		R0,#0 ; otherwise crash
				LDR		R7,=GetNumberOfNotCommittedMissedEvents
				BLX		R7
				LDR		R7,=_Mainscreen_NumberOfMissedEvents
				LDR		R0,[R7]
				
				;LDR		R6,ram
				;LDR		R0,[R6]
				POP		{R7,PC}

; ----------------------------------------------------------------------	

_set_illumination
				PUSH	{R1,R7,LR}
				MOV		R1,#1
				MOV		R7,#8 ; SetIllumination
				BL		_funclib
				POP		{R1,R7,PC}


; ----------------------------------------------------------------------	


_set_illumination_state_to_law
				PUSH	{R0-R3,R7,LR}

			 	LDR		R0,=_ram_illumination_data
				LDR		R0,[R0]
				ADD		R0,#0x94  ; +94: What OS thinks is state of Illumination On/Off
				LDRB	R0,[R0] 
		   	    
		   	    MOV		R7,R0
		   	    MOV		R2,R7
		   	    MOV		R0,#0 ; screen
		   	    BL		_set_illumination
		   	    MOV		R2,R7
		   	    MOV		R0,#1 ; kpl
		   	    BL		_set_illumination
		   	    POP		{R0-R3,R7,PC}
		   	    
; ----------------------------------------------------------------------	

FunctionLibrary	DCD	0xA0FC0000	   	    
ram				DCD	0xA8240000 

 END


A876DA58 A80080C4

A867BF30
A867BF40
A867BF54
A867BF60
A867BF6C
A867BF88
A867BFB4
A867BFBC
A867BFC8









start	PUSH	{R4,LR}
		;B		xxx

		LDR		R6,=ram
		LDRB	R2,[R6] ; Brightness-Toggler, msste man boolsch machen, falls Profilwechsel/Brightnesswechsel
		MOV		R1,#60
		SUB		R4,R1,R2
		STRB	R4,[R6]
		MOV		R0,#1
		MOV		R1,#1
		MOV		R3,#0x28
		LDR		R7,=Illumination
		BLX		R7
 		

		
on		LDR		R6,=ram
		LDRB	R1,[R6,#1] ; gespeicherter nchster Zeitwert
		LDRB	R2,[R6,#0x10] ; low value
		CMP		R1,R2
		BGE		on1 ; wenn kleiner als 4, Richtung umpolen

pol_pos	MOV		R2,#1
 		B		pol_str

on1		LDRB	R2,[R6,#0x11] ; hi value
		CMP		R1,R2 
		BLE		on2 ; wenn grer als startvalue, Richtung umpolen
		
pol_neg	MOV		R2,#0
pol_str STRB	R2,[R6,#2] ; speichern
		
on2		LDRB	R2,[R6,#0x12] ; LSR-Val
		MOV		R7,R1
		LSR		R7,R2  
		ADD		R7,#1
		LDRB	R2,[R6,#2] ; polaritaet
		CMP		R2,#0 
		BNE		on_pos
		
on_neg	SUB		R1,R7
		B		on3
		
on_pos	ADD		R1,R7

on3		STRB	R1,[R6,#1]	; store current timeval
			
exec	CMP		R1,#0
;		BEQ		exit

		LDR     R0,=0xA876DA58
		LDR     R2,=start
		LDR     R7,=CallAfterTimer
		BLX		R7
		NOP

exit	POP		{R4,PC}	




 END        
   